//go:build !fips

package fips

import "golang.org/x/crypto/ssh"

func Check() bool {
	return false
}

func Enabled() bool {
	return false
}

func SupportedAlgorithms() ssh.Algorithms {
	return ssh.SupportedAlgorithms()
}

func DefaultAlgorithms() ssh.Algorithms {
	config := &ssh.ServerConfig{}
	config.SetDefaults()

	return ssh.Algorithms{
		Ciphers:        config.Ciphers,
		MACs:           config.MACs,
		KeyExchanges:   config.KeyExchanges,
		HostKeys:       nil, // Leave HostKeys empty because that is set at SSH handshake time
		PublicKeyAuths: config.PublicKeyAuthAlgorithms,
	}
}
