/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_as extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "নাউৰু";
        final String metaValue_TV = "টুভালু";
        final String metaValue_ar = "আৰবী";
        final String metaValue_hy = "আৰ্মেনীয়";
        final String metaValue_bn = "বাংলা";
        final String metaValue_ka = "জৰ্জিয়ান";
        final String metaValue_el = "গ্ৰীক";
        final String metaValue_gu = "গুজৰাটী";
        final String metaValue_he = "হিব্ৰু";
        final String metaValue_ja = "জাপানী";
        final String metaValue_km = "খমেৰ";
        final String metaValue_kn = "কানাড়া";
        final String metaValue_ko = "কোৰিয়ান";
        final String metaValue_lo = "লাও";
        final String metaValue_la = "লেটিন";
        final String metaValue_ml = "মালায়ালম";
        final String metaValue_or = "ওড়িয়া";
        final String metaValue_ta = "তামিল";
        final String metaValue_te = "তেলুগু";
        final String metaValue_th = "থাই";
        final String metaValue_bo = "তিব্বতী";
        final String metaValue_vai = "ভাই";
        final Object[][] data = new Object[][] {
            { "001", "বিশ্ব" },
            { "002", "আফ্ৰিকা" },
            { "003", "উত্তৰ আমেৰিকা" },
            { "005", "দক্ষিণ আমেৰিকা" },
            { "009", "অ’চেনীয়া" },
            { "011", "পাশ্চাত্য আফ্ৰিকা" },
            { "013", "মধ্য আমেৰিকা" },
            { "014", "প্ৰাচ্য আফ্ৰিকা" },
            { "015", "উদীচ্য আফ্ৰিকা" },
            { "017", "মধ্য আফ্ৰিকা" },
            { "018", "দাক্ষিণাত্য আফ্ৰিকা" },
            { "019", "আমেৰিকাছ্" },
            { "021", "উদীচ্য আমেৰিকা" },
            { "029", "কেৰিবিয়ান" },
            { "030", "প্ৰাচ্য এছিয়া" },
            { "034", "দাক্ষিণাত্য এছিয়া" },
            { "035", "দক্ষিণ-পূব এছিয়া" },
            { "039", "দাক্ষিণাত্য ইউৰোপ" },
            { "053", "অষ্ট্ৰেলেছিয়া" },
            { "054", "মেলানেছিয়া" },
            { "057", "মাইক্ৰোনেচিয় ক্ষেত্ৰ" },
            { "061", "পলিনেচিয়া" },
            { "142", "এছিয়া" },
            { "143", "মধ্য এছিয়া" },
            { "145", "পাশ্চাত্য এছিয়া" },
            { "150", "ইউৰোপ" },
            { "151", "প্ৰাচ্য ইউৰোপ" },
            { "154", "উদীচ্য ইউৰোপ" },
            { "155", "পাশ্চাত্য ইউৰোপ" },
            { "202", "উপ-ছাহাৰান আফ্ৰিকা" },
            { "419", "লেটিন আমেৰিকা" },
            { "AC", "এচেনচিয়ন দ্বীপ" },
            { "AD", "আন্দোৰা" },
            { "AE", "সংযুক্ত আৰব আমিৰাত" },
            { "AF", "আফগানিস্তান" },
            { "AG", "এণ্টিগুৱা আৰু বাৰ্বুডা" },
            { "AI", "এনগুইলা" },
            { "AL", "আলবেনিয়া" },
            { "AM", "আৰ্মেনিয়া" },
            { "AO", "এংগোলা" },
            { "AQ", "এণ্টাৰ্কটিকা" },
            { "AR", "আৰ্জেণ্টিনা" },
            { "AS", "আমেৰিকান চামোৱা" },
            { "AT", "অষ্ট্ৰিয়া" },
            { "AU", "অষ্ট্ৰেলিয়া" },
            { "AW", "আৰুবা" },
            { "AX", "আলণ্ড দ্বীপপুঞ্জ" },
            { "AZ", "আজাৰবেইজান" },
            { "BA", "ব’ছনিয়া আৰু হাৰ্জেগ’ভিনা" },
            { "BB", "বাৰ্বাডোচ" },
            { "BD", "বাংলাদেশ" },
            { "BE", "বেলজিয়াম" },
            { "BF", "বুৰকিনা ফাচো" },
            { "BG", "বুলগেৰিয়া" },
            { "BH", "বাহৰেইন" },
            { "BI", "বুৰুণ্ডি" },
            { "BJ", "বেনিন" },
            { "BL", "ছেইণ্ট বাৰ্থলেমে" },
            { "BM", "বাৰ্মুডা" },
            { "BN", "ব্ৰুনেই" },
            { "BO", "বলিভিয়া" },
            { "BQ", "কেৰিবিয়ান নেদাৰলেণ্ডছ" },
            { "BR", "ব্ৰাজিল" },
            { "BS", "বাহামাছ" },
            { "BT", "ভুটান" },
            { "BV", "বুভে দ্বীপ" },
            { "BW", "ব’টচোৱানা" },
            { "BY", "বেলাৰুছ" },
            { "BZ", "বেলিজ" },
            { "CA", "কানাডা" },
            { "CC", "কোকোচ (কীলিং) দ্বীপপুঞ্জ" },
            { "CD", "কঙ্গো - কিনচাছা" },
            { "CF", "মধ্য আফ্রিকান প্রজাতন্ত্র" },
            { "CG", "কঙ্গো - ব্রাজাভিল" },
            { "CH", "চুইজাৰলেণ্ড" },
            { "CI", "কোটে ডি আইভৰ" },
            { "CK", "কুক দ্বীপপুঞ্জ" },
            { "CL", "চিলি" },
            { "CM", "কেমেৰুণ" },
            { "CN", "চীন" },
            { "CO", "কলম্বিয়া" },
            { "CP", "ক্লিপাৰটোন দ্বীপ" },
            { "CQ", "চাৰ্ক" },
            { "CR", "কোষ্টা ৰিকা" },
            { "CU", "কিউবা" },
            { "CV", "কেপ ভার্দে" },
            { "CW", "কুৰাকাও" },
            { "CX", "খ্ৰীষ্টমাছ দ্বীপ" },
            { "CY", "চাইপ্ৰাছ" },
            { "CZ", "চিজেচিয়া" },
            { "DE", "জাৰ্মানী" },
            { "DG", "ডিয়েগো গাৰ্চিয়া" },
            { "DJ", "জিবুটি" },
            { "DK", "ডেনমাৰ্ক" },
            { "DM", "ড’মিনিকা" },
            { "DO", "ড’মিনিকান ৰিপাব্লিক" },
            { "DZ", "আলজেৰিয়া" },
            { "EA", "চেউটা আৰু মেলিলা" },
            { "EC", "ইকুৱেডৰ" },
            { "EE", "ইষ্টোনিয়া" },
            { "EG", "ইজিপ্ত" },
            { "EH", "পশ্চিমীয় ছাহাৰা" },
            { "ER", "এৰিত্ৰিয়া" },
            { "ES", "স্পেইন" },
            { "ET", "ইথিঅ’পিয়া" },
            { "EU", "ইউৰোপীয় সংঘ" },
            { "EZ", "ইউৰোজ’ন" },
            { "FI", "ফিনলেণ্ড" },
            { "FJ", "ফিজি" },
            { "FK", "ফকলেণ্ড দ্বীপপুঞ্জ" },
            { "FM", "মাইক্ৰোনেচিয়া" },
            { "FO", "ফাৰো দ্বীপপুঞ্জ" },
            { "FR", "ফ্ৰান্স" },
            { "GA", "গেবন" },
            { "GB", "সংযুক্ত ৰাজ্য" },
            { "GD", "গ্ৰেনাডা" },
            { "GE", "জৰ্জিয়া" },
            { "GF", "ফ্ৰান্স গয়ানা" },
            { "GG", "গোৰেনচি" },
            { "GH", "ঘানা" },
            { "GI", "জিব্ৰাল্টৰ" },
            { "GL", "গ্ৰীণলেণ্ড" },
            { "GM", "গাম্বিয়া" },
            { "GN", "গিনি" },
            { "GP", "গুৱাডেলুপ" },
            { "GQ", "ইকুৱেটৰিয়েল গিনি" },
            { "GR", "গ্ৰীচ" },
            { "GS", "দক্ষিণ জৰ্জিয়া আৰু দক্ষিণ চেণ্ডৱিচ দ্বীপপুঞ্জ" },
            { "GT", "গুৱাটেমালা" },
            { "GU", "গুৱাম" },
            { "GW", "গিনি-বিছাও" },
            { "GY", "গায়ানা" },
            { "HK", "হং কং এছ. এ. আৰ. চীন" },
            { "HM", "হাৰ্ড দ্বীপ আৰু মেকডোনাল্ড দ্বীপপুঞ্জ" },
            { "HN", "হন্দুৰাছ" },
            { "HR", "ক্ৰোৱেছিয়া" },
            { "HT", "হাইটি" },
            { "HU", "হাংগেৰী" },
            { "IC", "কেনেৰী দ্বীপপুঞ্জ" },
            { "ID", "ইণ্ডোনেচিয়া" },
            { "IE", "আয়াৰলেণ্ড" },
            { "IL", "ইজৰাইল" },
            { "IM", "আইল অফ মেন" },
            { "IN", "ভাৰত" },
            { "IO", "ব্ৰিটিছ ইণ্ডিয়ান অ’চন টেৰিট’ৰি" },
            { "IQ", "ইৰাক" },
            { "IR", "ইৰান" },
            { "IS", "আইচলেণ্ড" },
            { "IT", "ইটালি" },
            { "JE", "জাৰ্চি" },
            { "JM", "জামাইকা" },
            { "JO", "জৰ্ডান" },
            { "JP", "জাপান" },
            { "KE", "কেনিয়া" },
            { "KG", "কিৰ্গিজস্তান" },
            { "KH", "কম্বোডিয়া" },
            { "KI", "কিৰিবাটি" },
            { "KM", "কোমোৰোজ" },
            { "KN", "ছেইণ্ট কিটছ আৰু নেভিছ" },
            { "KP", "উত্তৰ কোৰিয়া" },
            { "KR", "দক্ষিণ কোৰিয়া" },
            { "KW", "কুৱেইট" },
            { "KY", "কেইমেন দ্বীপপুঞ্জ" },
            { "KZ", "কাজাখাস্তান" },
            { "LA", "লাওচ" },
            { "LB", "লেবানন" },
            { "LC", "ছেইণ্ট লুচিয়া" },
            { "LI", "লিচটেনষ্টেইন" },
            { "LK", "শ্রীলংকা" },
            { "LR", "লিবেৰিয়া" },
            { "LS", "লেছ’থ’" },
            { "LT", "লিথুৱানিয়া" },
            { "LU", "লাক্সেমবাৰ্গ" },
            { "LV", "লাটভিয়া" },
            { "LY", "লিবিয়া" },
            { "MA", "মৰক্কো" },
            { "MC", "মোনাকো" },
            { "MD", "মোলডোভা" },
            { "ME", "মণ্টেনেগ্ৰু" },
            { "MF", "ছেইণ্ট মাৰ্টিন" },
            { "MG", "মাদাগাস্কাৰ" },
            { "MH", "মাৰ্শ্বাল দ্বীপপুঞ্জ" },
            { "MK", "উত্তৰ মেচিডোনীয়া" },
            { "ML", "মালি" },
            { "MM", "ম্যানমাৰ (বাৰ্মা)" },
            { "MN", "মঙ্গোলিয়া" },
            { "MO", "মাকাও এছ. এ. আৰ. চীন" },
            { "MP", "উত্তৰ মাৰিয়ানা দ্বীপপুঞ্জ" },
            { "MQ", "মাৰ্টিনিক" },
            { "MR", "মাউৰিটানিয়া" },
            { "MS", "ম’ণ্টছেৰাট" },
            { "MT", "মাল্টা" },
            { "MU", "মৰিছাছ" },
            { "MV", "মালদ্বীপ" },
            { "MW", "মালাৱি" },
            { "MX", "মেক্সিকো" },
            { "MY", "মালয়েচিয়া" },
            { "MZ", "ম’জামবিক" },
            { "NA", "নামিবিয়া" },
            { "NC", "নিউ কেলিডোনিয়া" },
            { "NE", "নাইজাৰ" },
            { "NF", "ন’ৰফ’ক দ্বীপ" },
            { "NG", "নাইজেৰিয়া" },
            { "NI", "নিকাৰাগুৱা" },
            { "NL", "নেডাৰলেণ্ড" },
            { "NO", "নৰৱে" },
            { "NP", "নেপাল" },
            { "NR", metaValue_NR },
            { "NU", "নিউ" },
            { "NZ", "নিউজিলেণ্ড" },
            { "OM", "ওমান" },
            { "PA", "পানামা" },
            { "PE", "পেৰু" },
            { "PF", "ফ্ৰান্স পোলেনচিয়া" },
            { "PG", "পাপুৱা নিউ গিনি" },
            { "PH", "ফিলিপাইনছ" },
            { "PK", "পাকিস্তান" },
            { "PL", "পোলেণ্ড" },
            { "PM", "ছেইণ্ট পিয়েৰে আৰু মিকিউৱেলন" },
            { "PN", "পিটকেইৰ্ণ দ্বীপপুঞ্জ" },
            { "PR", "পুৱেৰ্টো ৰিকো" },
            { "PS", "ফিলিস্তিন অঞ্চল" },
            { "PT", "পৰ্তুগাল" },
            { "PW", "পালাউ" },
            { "PY", "পাৰাগুৱে" },
            { "QA", "কাটাৰ" },
            { "QO", "আউটলায়িং অ’চিয়ানিয়া" },
            { "RE", "ৰিইউনিয়ন" },
            { "RO", "ৰোমানিয়া" },
            { "RS", "ছাৰ্বিয়া" },
            { "RU", "ৰাছিয়া" },
            { "RW", "ৰোৱাণ্ডা" },
            { "SA", "চৌডি আৰবিয়া" },
            { "SB", "চোলোমোন দ্বীপপুঞ্জ" },
            { "SC", "ছিচিলিছ" },
            { "SD", "চুডান" },
            { "SE", "চুইডেন" },
            { "SG", "ছিংগাপুৰ" },
            { "SH", "ছেইণ্ট হেলেনা" },
            { "SI", "শ্লোভেনিয়া" },
            { "SJ", "চাভালবাৰ্ড আৰু জন মেয়ন" },
            { "SK", "শ্লোভাকিয়া" },
            { "SL", "চিয়েৰা লিঅ’ন" },
            { "SM", "চান মাৰিনো" },
            { "SN", "চেনেগাল" },
            { "SO", "চোমালিয়া" },
            { "SR", "ছুৰিনাম" },
            { "SS", "দক্ষিণ চুডান" },
            { "ST", "চাও টোমে আৰু প্ৰিনচিপে" },
            { "SV", "এল ছেলভেড’ৰ" },
            { "SX", "চিণ্ট মাৰ্টেন" },
            { "SY", "চিৰিয়া" },
            { "SZ", "ইচ্চুটিনি" },
            { "TA", "ত্ৰিস্তান দ্যা কুনহা" },
            { "TC", "টাৰ্কছ অৰু কেইক’ছ দ্বীপপুঞ্জ" },
            { "TD", "চাড" },
            { "TF", "দক্ষিণ ফ্ৰান্সৰ অঞ্চল" },
            { "TG", "টোগো" },
            { "TH", "থাইলেণ্ড" },
            { "TJ", "তাজিকিস্তান" },
            { "TK", "টোকেলাউ" },
            { "TL", "টিমোৰ-লেচটে" },
            { "TM", "তুৰ্কমেনিস্তান" },
            { "TN", "টুনিচিয়া" },
            { "TO", "টংগা" },
            { "TR", "তুৰ্কিয়ে" },
            { "TT", "ট্ৰিনিডাড আৰু টোবাগো" },
            { "TV", metaValue_TV },
            { "TW", "টাইৱান" },
            { "TZ", "তাঞ্জানিয়া" },
            { "UA", "ইউক্ৰেইন" },
            { "UG", "উগাণ্ডা" },
            { "UM", "ইউ. এছ. আউটলায়িং দ্বীপপুঞ্জ" },
            { "UN", "ৰাষ্ট্ৰসংঘ" },
            { "US", "মাৰ্কিন যুক্তৰাষ্ট্ৰ" },
            { "UY", "উৰুগুৱে" },
            { "UZ", "উজবেকিস্তান" },
            { "VA", "ভেটিকান চিটি" },
            { "VC", "ছেইণ্ট ভিনচেণ্ট আৰু গ্ৰীণাডাইনছ" },
            { "VE", "ভেনিজুৱেলা" },
            { "VG", "ব্ৰিটিছ ভাৰ্জিন দ্বীপপুঞ্জ" },
            { "VI", "ইউ. এছ. ভাৰ্জিন দ্বীপপুঞ্জ" },
            { "VN", "ভিয়েটনাম" },
            { "VU", "ভানাটু" },
            { "WF", "ৱালিছ আৰু ফুটুনা" },
            { "WS", "চামোৱা" },
            { "XA", "ছুডু-একচেণ্ট" },
            { "XB", "ছুডু-বিডি" },
            { "XK", "কচ’ভ’" },
            { "YE", "য়েমেন" },
            { "YT", "মায়োট্টে" },
            { "ZA", "দক্ষিণ আফ্রিকা" },
            { "ZM", "জাম্বিয়া" },
            { "ZW", "জিম্বাবৱে" },
            { "ZZ", "অজ্ঞাত ক্ষেত্ৰ" },
            { "aa", "আফাৰ" },
            { "ab", "আবখাজিয়ান" },
            { "af", "আফ্ৰিকানছ্" },
            { "ak", "আকান" },
            { "am", "আমহাৰিক" },
            { "an", "আৰ্গোনিজ" },
            { "ar", metaValue_ar },
            { "as", "অসমীয়া" },
            { "av", "আভেৰিক" },
            { "ay", "আয়মাৰা" },
            { "az", "আজেৰবাইজানী" },
            { "ba", "বাছখিৰ" },
            { "be", "বেলাৰুছীয়" },
            { "bg", "বুলগেৰীয়" },
            { "bi", "বিছলামা" },
            { "bm", "বামবাৰা" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "ব্ৰেটন" },
            { "bs", "বছনীয়" },
            { "ca", "কাতালান" },
            { "ce", "চেচেন" },
            { "ch", "চামোৰো" },
            { "co", "কোৰ্ছিকান" },
            { "cs", "চেক" },
            { "cu", "চাৰ্চ শ্লেভিক" },
            { "cv", "চুভাচ" },
            { "cy", "ৱেলচ" },
            { "da", "ডেনিচ" },
            { "de", "জাৰ্মান" },
            { "dv", "দিবেহি" },
            { "dz", "জোংখা" },
            { "ee", "ইৱে" },
            { "el", metaValue_el },
            { "en", "ইংৰাজী" },
            { "eo", "এস্পেৰান্তো" },
            { "es", "স্পেনিচ" },
            { "et", "এষ্টোনিয়" },
            { "eu", "বাস্ক" },
            { "fa", "ফাৰ্ছী" },
            { "ff", "ফুলাহ" },
            { "fi", "ফিনিচ" },
            { "fj", "ফিজিয়ান" },
            { "fo", "ফাৰোইজ" },
            { "fr", "ফ্ৰেন্স" },
            { "fy", "ৱেষ্টাৰ্ণ ফ্ৰিছিয়ান" },
            { "ga", "আইৰিচ" },
            { "gd", "স্কটিচ গেইলিক" },
            { "gl", "গেলিচিয়ান" },
            { "gn", "গুৱাৰাণী" },
            { "gu", metaValue_gu },
            { "gv", "মেংক্স" },
            { "ha", "হাউছা" },
            { "he", metaValue_he },
            { "hi", "হিন্দী" },
            { "hr", "ক্ৰোৱেচিয়ান" },
            { "ht", "হেইটিয়ান ক্ৰিয়ল" },
            { "hu", "হাঙ্গেৰিয়ান" },
            { "hy", metaValue_hy },
            { "hz", "হেৰেৰো" },
            { "ia", "ইণ্টাৰলিংগুৱা" },
            { "id", "ইণ্ডোনেচিয়" },
            { "ie", "ইণ্টাৰলিংগুৱে" },
            { "ig", "ইগ্বো" },
            { "ii", "ছিচুৱান ই" },
            { "io", "ইডো" },
            { "is", "আইচলেণ্ডিক" },
            { "it", "ইটালিয়ান" },
            { "iu", "ইনুক্টিটুট" },
            { "ja", metaValue_ja },
            { "jv", "জাভানী" },
            { "ka", metaValue_ka },
            { "ki", "কিকুয়ু" },
            { "kj", "কুয়ানিয়ামা" },
            { "kk", "কাজাখ" },
            { "kl", "কালালিছুট" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "কানুৰি" },
            { "ks", "কাশ্মিৰী" },
            { "ku", "কুৰ্ডিশ্ব" },
            { "kv", "কোমি" },
            { "kw", "কোৰ্নিচ" },
            { "ky", "কিৰ্গিজ" },
            { "la", metaValue_la },
            { "lb", "লাক্সেমবাৰ্গিচ" },
            { "lg", "গান্দা" },
            { "li", "লিম্বুৰ্গিচ" },
            { "ln", "লিংগালা" },
            { "lo", metaValue_lo },
            { "lt", "লিথুৱানিয়ান" },
            { "lu", "লুবা-কাটাংগা" },
            { "lv", "লাটভিয়ান" },
            { "mg", "মালাগাছী" },
            { "mh", "মাৰ্চলিজ" },
            { "mi", "মাওৰি" },
            { "mk", "মেচিডোনীয়" },
            { "ml", metaValue_ml },
            { "mn", "মংগোলীয়" },
            { "mr", "মাৰাঠী" },
            { "ms", "মালয়" },
            { "mt", "মাল্টিজ" },
            { "my", "বাৰ্মীজ" },
            { "na", metaValue_NR },
            { "nb", "নৰৱেজিয়ান বোকমাল" },
            { "nd", "উত্তৰ নিবেবেলে" },
            { "ne", "নেপালী" },
            { "ng", "এন্দোঙ্গা" },
            { "nl", "ডাচ" },
            { "nn", "নৰৱেজিয়ান নায়নোৰ্স্ক" },
            { "no", "নৰৱেজিয়ান" },
            { "nr", "দক্ষিণ দেবেল" },
            { "nv", "নাভাজো" },
            { "ny", "ন্যাঞ্জা" },
            { "oc", "অ’চিটান" },
            { "om", "ওৰোমো" },
            { "or", metaValue_or },
            { "os", "ওছেটিক" },
            { "pa", "পাঞ্জাবী" },
            { "pl", "প’লিচ" },
            { "ps", "পুস্ত" },
            { "pt", "পৰ্তুগীজ" },
            { "qu", "কুৱেচুৱা" },
            { "rm", "ৰোমানচ" },
            { "rn", "ৰুন্দি" },
            { "ro", "ৰোমানীয়" },
            { "ru", "ৰাছিয়ান" },
            { "rw", "কিনয়াৰোৱাণ্ডা" },
            { "sa", "সংস্কৃত" },
            { "sc", "ছাৰ্ডিনিয়ান" },
            { "sd", "সিন্ধী" },
            { "se", "উদীচ্য ছামি" },
            { "sg", "ছাঙ্গো" },
            { "si", "সিংহলা" },
            { "sk", "শ্লোভাক" },
            { "sl", "শ্লোভেনিয়ান" },
            { "sm", "ছামোন" },
            { "sn", "চোনা" },
            { "so", "ছোমালি" },
            { "sq", "আলবেনীয়" },
            { "sr", "ছাৰ্বিয়ান" },
            { "ss", "স্বাতি" },
            { "st", "দাক্ষিণাত্য ছোথো" },
            { "su", "ছুণ্ডানীজ" },
            { "sv", "ছুইডিচ" },
            { "sw", "স্বাহিলি" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "তাজিক" },
            { "th", metaValue_th },
            { "ti", "টিগৰিনিয়া" },
            { "tk", "তুৰ্কমেন" },
            { "tn", "ছোৱানা" },
            { "to", "টোঙ্গান" },
            { "tr", "তুৰ্কী" },
            { "ts", "ছোঙ্গা" },
            { "tt", "তাতাৰ" },
            { "ty", "তাহিতিয়ান" },
            { "ug", "উইঘুৰ" },
            { "uk", "ইউক্ৰেইনীয়" },
            { "ur", "উৰ্দু" },
            { "uz", "উজবেক" },
            { "ve", "ভেণ্ডা" },
            { "vi", "ভিয়েটনামী" },
            { "vo", "ভোলাপুক" },
            { "wa", "ৱালুন" },
            { "wo", "ৱোলাফ" },
            { "xh", "হোছা" },
            { "yi", "ইদ্দিছ" },
            { "yo", "ইউৰুবা" },
            { "za", "ঝুৱাং" },
            { "zh", "চীনা" },
            { "zu", "ঝুলু" },
            { "ace", "আচিনিজ" },
            { "ada", "আদাংমে" },
            { "ady", "আদিগে" },
            { "agq", "আঘেম" },
            { "ain", "আইনু" },
            { "ale", "আলেউট" },
            { "alt", "দাক্ষিণাত্য আল্টাই" },
            { "ann", "অ’ব’ল’" },
            { "anp", "আঙ্গিকা" },
            { "arn", "মাপুচে" },
            { "arp", "আৰাপাহো" },
            { "ars", "নাজডি আৰবী" },
            { "asa", "আছু" },
            { "ast", "এষ্টুৰীয়" },
            { "atj", "আতিকামেক" },
            { "awa", "অৱধী" },
            { "bal", "বালুচী" },
            { "ban", "বালিনীজ" },
            { "bas", "বাছা" },
            { "bem", "বেম্বা" },
            { "bez", "বেনা" },
            { "bgc", "হাৰয়ানভি" },
            { "bho", "ভোজপুৰী" },
            { "bin", "বিনি" },
            { "bla", "ছিক্সিকা" },
            { "blo", "আনি" },
            { "brx", "বড়ো" },
            { "bug", "বগিনীজ" },
            { "byn", "ব্লিন" },
            { "cay", "কায়ুগা" },
            { "ccp", "চাক্‌মা" },
            { "ceb", "চিবুৱানো" },
            { "cgg", "চিগা" },
            { "chk", "চুকিজ" },
            { "chm", "মাৰি" },
            { "cho", "চোক্টাউ" },
            { "chp", "চিপেউয়ান" },
            { "chr", "চেৰোকি" },
            { "chy", "চাইয়েন" },
            { "ckb", "চেণ্ট্ৰেল কুৰ্ডিচ" },
            { "clc", "চিলক’টিন" },
            { "crg", "মিচিফ" },
            { "crj", "দাক্ষিণাত্য ইষ্ট ক্ৰী" },
            { "crk", "প্লেইনছ ক্ৰী" },
            { "crl", "নৰ্দাৰ্ন ইষ্ট ক্ৰী" },
            { "crm", "মুজ ক্ৰী" },
            { "crr", "কেৰ’লিনা আলগংকিয়ান" },
            { "crs", "ছেছেলৱা ক্ৰিওল ফ্ৰেন্স" },
            { "csw", "স্বাম্পী ক্ৰী" },
            { "dak", "ডাকোটা" },
            { "dar", "দাৰ্গৱা" },
            { "dav", "তেইতা" },
            { "dgr", "ডোগ্ৰিব" },
            { "dje", "ঝাৰ্মা" },
            { "doi", "ডোগ্ৰী" },
            { "dsb", "ল’ৱাৰ ছোৰ্বিয়ান" },
            { "dua", "ডুৱালা" },
            { "dyo", "জোলা-ফ’নি" },
            { "dzg", "দাজাগা" },
            { "ebu", "এম্বু" },
            { "efi", "এফিক" },
            { "eka", "একাজুক" },
            { "ewo", "ইওন্দো" },
            { "fil", "ফিলিপিনো" },
            { "fon", "ফ’ন" },
            { "frc", "কেজ’ন ফৰাছী" },
            { "frr", "নৰ্দাৰ্ন ফ্ৰিছিয়ান" },
            { "fur", "ফ্ৰিউলিয়ান" },
            { "gaa", "গা" },
            { "gez", "গীজ" },
            { "gil", "গিলবাৰ্টিছ" },
            { "gor", "গোৰোন্তালো" },
            { "gsw", "ছুইচ জাৰ্মান" },
            { "guz", "গুছি" },
            { "gwi", "জিউইচিন" },
            { "hai", "হেইডা" },
            { "haw", "হাৱাই" },
            { "hax", "দাক্ষিণাত্যৰ হাইডা" },
            { "hil", "হিলিগায়নোন" },
            { "hmn", "হমং" },
            { "hsb", "আপাৰ ছোৰ্বিয়ান" },
            { "hup", "হুপা" },
            { "hur", "হেলকোমেলেম" },
            { "iba", "ইবান" },
            { "ibb", "ইবিবিও" },
            { "ikt", "ৱেষ্টাৰ্ণ কানাডিয়ান ইনক্টিটুট" },
            { "ilo", "ইলোকো" },
            { "inh", "ইংগুচ" },
            { "jbo", "লোজ্বান" },
            { "jgo", "নগোম্বা" },
            { "jmc", "মেকহেম" },
            { "kab", "কাবাইল" },
            { "kac", "কাচিন" },
            { "kaj", "জজু" },
            { "kam", "কাম্বা" },
            { "kbd", "কাবাৰ্ডিয়ান" },
            { "kcg", "ত্যাপ" },
            { "kde", "মাকোণ্ড" },
            { "kea", "কাবুভেৰ্ডিয়ানু" },
            { "kfo", "কোৰো" },
            { "kgp", "কেইংগাং" },
            { "kha", "খাচি" },
            { "khq", "কোয়াৰ চিনি" },
            { "kkj", "কাকো" },
            { "kln", "কালেনজিন" },
            { "kmb", "কিম্বুন্দু" },
            { "kok", "কোংকণী" },
            { "kpe", "কেপেল" },
            { "krc", "কাৰাচে-বাল্কাৰ" },
            { "krl", "কেৰেলিয়ান" },
            { "kru", "কুৰুখ" },
            { "ksb", "চাম্বালা" },
            { "ksf", "বাফিয়া" },
            { "ksh", "কোলোগনিয়ান" },
            { "kum", "কুমিক" },
            { "kwk", "ক্বাকৱালা" },
            { "kxv", "কুভি" },
            { "lad", "লাডিনো" },
            { "lag", "লাংগি" },
            { "lez", "লেজঘিয়ান" },
            { "lij", "লিংগুৰিয়ান" },
            { "lil", "লিল্লোৱেট" },
            { "lkt", "লাকোটা" },
            { "lmo", "ল’ম্বাৰ্ড" },
            { "lou", "লুইজিয়ানা কেৰ’ল" },
            { "loz", "লোজি" },
            { "lrc", "উদীচ্য লুৰি" },
            { "lsm", "চামিয়া" },
            { "lua", "লুবা-লুলুৱা" },
            { "lun", "লুণ্ডা" },
            { "luo", "লুও" },
            { "lus", "মিজো" },
            { "luy", "লুইয়া" },
            { "mad", "মাদুৰেছে" },
            { "mag", "মাগাহি" },
            { "mai", "মৈথিলী" },
            { "mak", "মাকাছাৰ" },
            { "mas", "মাছাই" },
            { "mdf", "মোক্সা" },
            { "men", "মেণ্ডে" },
            { "mer", "মেৰু" },
            { "mfe", "মৰিছিয়ান" },
            { "mgh", "মাখুৱা-মিট্টো" },
            { "mgo", "মেটা" },
            { "mic", "মিকমেক" },
            { "min", "মিনাংকাবাউ" },
            { "mni", "মণিপুৰী" },
            { "moe", "ইন্নু-আইমুন" },
            { "moh", "মোহোক" },
            { "mos", "মোছি" },
            { "mua", "মুণ্ডাং" },
            { "mul", "একাধিক ভাষা" },
            { "mus", "ক্ৰীক" },
            { "mwl", "মিৰাণ্ডিজ" },
            { "myv", "এৰজিয়া" },
            { "mzn", "মাজেন্দাৰানি" },
            { "nap", "নিয়াপোলিটেন" },
            { "naq", "নামা" },
            { "nds", "ল’ জাৰ্মান" },
            { "new", "নেৱাৰি" },
            { "nia", "নিয়াছ" },
            { "niu", "নিয়ুৱান" },
            { "nmg", "কোৱাছিঅ’" },
            { "nnh", "নিয়েম্বোন" },
            { "nog", "নোগাই" },
            { "nqo", "এন্কো" },
            { "nso", "উদীচ্য ছোথো" },
            { "nus", "নুয়েৰ" },
            { "nyn", "ন্যানকোল" },
            { "ojb", "নৰ্থ-ৱেষ্টাৰ্ণ অজিবৱা" },
            { "ojc", "চেন্ট্ৰেক অজিবৱা" },
            { "ojs", "অ’জি-ক্ৰী" },
            { "ojw", "ৱেষ্টাৰ্ণ অজিবৱা" },
            { "oka", "অ’কানাগান" },
            { "pag", "পংগাছিনান" },
            { "pam", "পাম্পান্গা" },
            { "pap", "পাপিয়ামেণ্টো" },
            { "pau", "পালাউৱান" },
            { "pcm", "নাইজেৰিয়ান পিজিন" },
            { "pis", "পিজিন" },
            { "pqm", "মালিছীট-পাছামাকু’ডী" },
            { "prg", "প্ৰুছিয়ান" },
            { "quc", "কিচিয়ে" },
            { "raj", "ৰাজস্থানী" },
            { "rap", "ৰাপানুই" },
            { "rar", "ৰাৰোতোঙ্গন" },
            { "rhg", "ৰোহিঙ্গিয়া" },
            { "rof", "ৰোম্বো" },
            { "rup", "আৰোমানীয়" },
            { "rwk", "ৰৱা" },
            { "sad", "ছান্দাৱে" },
            { "sah", "ছাখা" },
            { "saq", "ছাম্বুৰু" },
            { "sat", "চাওতালি" },
            { "sba", "নাংম্বে" },
            { "sbp", "ছাঙ্গু" },
            { "scn", "ছিচিলিয়ান" },
            { "sco", "স্কটছ" },
            { "seh", "ছেনা" },
            { "ses", "কোইৰাবোৰো চেন্নি" },
            { "shi", "তাচেলহিট" },
            { "shn", "চান" },
            { "slh", "দাক্ষিণাত্যৰ লুছুটচীড" },
            { "sma", "দাক্ষিণাত্য ছামি" },
            { "smj", "লুলে ছামি" },
            { "smn", "ইনাৰি ছামি" },
            { "sms", "স্কোল্ট ছামি" },
            { "snk", "ছোনিনকে" },
            { "srn", "স্ৰানান টোঙ্গো" },
            { "ssy", "ছাহো" },
            { "str", "ষ্ট্ৰেইটছ ছেলিশ্ব" },
            { "suk", "ছুকুমা" },
            { "swb", "কোমোৰিয়ান" },
            { "syr", "চিৰিয়াক" },
            { "szl", "ছাইলেছিয়ান" },
            { "tce", "দাক্ষিণাত্যৰ টুটচ’ন" },
            { "tem", "টিম্নে" },
            { "teo", "তেছো" },
            { "tet", "তেতুম" },
            { "tgx", "টেগিশ্ব" },
            { "tht", "টাহলটান" },
            { "tig", "তাইগ্ৰে" },
            { "tlh", "ক্লিংগন" },
            { "tli", "লিংগিট" },
            { "tok", "ট’কি প’না" },
            { "tpi", "টোক পিছিন" },
            { "trv", "তাৰোকো" },
            { "ttm", "নৰ্দাৰ্ন টুটচ’ন" },
            { "tum", "তুম্বুকা" },
            { "tvl", metaValue_TV },
            { "twq", "টাছাৱাক" },
            { "tyv", "তুভিনিয়ান" },
            { "tzm", "চেণ্ট্ৰেল এটলাছ টামাজাইট" },
            { "udm", "উদমুৰ্ত" },
            { "umb", "উম্বুন্দু" },
            { "und", "অজ্ঞাত ভাষা" },
            { "vai", metaValue_vai },
            { "vec", "ভেনেছিয়ান" },
            { "vmw", "মাখুৱা" },
            { "vun", "ভুঞ্জু" },
            { "wae", "ৱালছেৰ" },
            { "wal", "ওলেইটা" },
            { "war", "ৱাৰে" },
            { "wuu", "ৱু চাইনিজ" },
            { "xal", "কাল্মিক" },
            { "xnr", "কাংগৰি" },
            { "xog", "ছোগা" },
            { "yav", "য়াংবেন" },
            { "ybb", "য়েম্বা" },
            { "yrl", "হিংগাটো" },
            { "yue", "কেণ্টোনীজ" },
            { "zgh", "ষ্টেণ্ডাৰ্ড মোৰোক্কান তামাজাইট" },
            { "zun", "ঝুনি" },
            { "zxx", "কোনো ভাষা সমল নাই" },
            { "zza", "ঝাঝা" },
            { "Adlm", "এডলাম" },
            { "Arab", metaValue_ar },
            { "Aran", "নাষ্টালিক" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "বোপোমোফো" },
            { "Brai", "ব্ৰেইল" },
            { "Cakm", "চাকমা" },
            { "Cans", "ইউনিফাইড কানাডিয়ান এব’ৰিজিনেল ছিলেবিকছ" },
            { "Cher", "চেৰ’কী" },
            { "Cyrl", "চিৰিলিক" },
            { "Deva", "দেৱনাগৰী" },
            { "Ethi", "ইথিঅ’পিক" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "গুৰুমুখী" },
            { "Hanb", "বোপোমোফোৰ সৈতে হান" },
            { "Hang", "হেঙ্গুল" },
            { "Hani", "হান" },
            { "Hans", "সৰলীকৃত" },
            { "Hant", "পৰম্পৰাগত" },
            { "Hebr", metaValue_he },
            { "Hira", "হিৰাগানা" },
            { "Hrkt", "জাপানী ছিলেবেৰিজ" },
            { "Jamo", "জামো" },
            { "Jpan", metaValue_ja },
            { "Kana", "কাটাকানা" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", "মঙ্গোলিয়" },
            { "Mtei", "মেইতেই মায়েক" },
            { "Mymr", "ম্যানমাৰ" },
            { "Nkoo", "এন্‍ক’" },
            { "Olck", "অ’ল চিকি" },
            { "Orya", metaValue_or },
            { "Rohg", "হানিফি" },
            { "Sinh", "সিংহলী" },
            { "Sund", "ছাণ্ডানিজ" },
            { "Syrc", "ছিৰিয়াক" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "টিফিনাঘ" },
            { "Thaa", "থানা" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "য়ি" },
            { "Zmth", "গাণিতিক চিহ্ন" },
            { "Zsye", "ইম’জি" },
            { "Zsym", "প্ৰতীক" },
            { "Zxxx", "অলিখিত" },
            { "Zyyy", "কোমোন" },
            { "Zzzz", "অজ্ঞাত লিপি" },
            { "de_AT", "অষ্ট্ৰেলিয়ান জাৰ্মান" },
            { "de_CH", "ছুইচ হাই জাৰ্মান" },
            { "en_AU", "অষ্ট্ৰেলিয়ান ইংৰাজী" },
            { "en_CA", "কানাডিয়ান ইংৰাজী" },
            { "en_GB", "ব্ৰিটিছ ইংৰাজী" },
            { "en_US", "আমেৰিকান ইংৰাজী" },
            { "es_ES", "ইউৰোপীয়ান স্পেনিচ" },
            { "es_MX", "মেক্সিকান স্পেনিচ" },
            { "fa_AF", "দাৰি" },
            { "fr_CA", "কানাডিয়ান ফ্ৰেন্স" },
            { "fr_CH", "ছুইচ ফ্ৰেন্স" },
            { "nl_BE", "ফ্লেমিচ" },
            { "pt_BR", "ব্ৰাজিলিয়ান পৰ্তুগীজ" },
            { "pt_PT", "ইউৰোপীয়ান পৰ্তুগীজ" },
            { "ro_MD", "মোল্ডাভিয়ান" },
            { "sw_CD", "কঙ্গো স্বাহিলি" },
            { "ar_001", "আধুনিক মানক আৰবী" },
            { "es_419", "লেটিন আমেৰিকান স্পেনিচ" },
            { "key.ca", "কেলেণ্ডাৰ" },
            { "key.cf", "মুদ্ৰা সজ্জা" },
            { "key.co", "সজোৱা ক্ৰম" },
            { "key.cu", "মুদ্ৰা" },
            { "key.em", "ইম’জীৰ উপস্থাপনা" },
            { "key.hc", "ঘণ্টীয়া চক্ৰ (১২ বনাম ২৪)" },
            { "key.lb", "পংক্তি বিচ্ছেদ শৈলী" },
            { "key.lw", "শব্দৰ মাজত শাৰীৰ বিভাজন" },
            { "key.ms", "জোখ-মাখৰ প্ৰণালী" },
            { "key.nu", "সংখ্যা" },
            { "key.ss", "ঃ" },
            { "zh_Hans", "সৰলীকৃত চীনা" },
            { "zh_Hant", "পৰম্পৰাগত চীনা" },
            { "type.ca.roc", "চীনা প্ৰজাতন্ত্ৰৰ কেলেণ্ডাৰ" },
            { "type.hc.h11", "১২ ঘণ্টীয়া প্ৰণালী (০–১১)" },
            { "type.hc.h12", "১২ ঘণ্টীয়া প্ৰণালী (১–১২)" },
            { "type.hc.h23", "২৪ ঘণ্টীয়া প্ৰণালী (০–২৩)" },
            { "type.hc.h24", "২৪ ঘণ্টীয়া প্ৰণালী (১–২৪)" },
            { "type.nu.arab", "আৰবী-ভাৰতীয় অংক" },
            { "type.nu.armn", "আৰ্মেনীয় সংখ্যা" },
            { "type.nu.beng", "বাংলা অংক" },
            { "type.nu.cakm", "চাকমা অংক" },
            { "type.nu.deva", "দেৱনাগৰী অংক" },
            { "type.nu.ethi", "ইথিঅ’পিক সংখ্যা" },
            { "type.nu.geor", "জৰ্জীয়ান সংখ্যা" },
            { "type.nu.grek", "গ্ৰীক সংখ্যা" },
            { "type.nu.gujr", "গুজৰাটী অংক" },
            { "type.nu.guru", "গুৰুমুখী অংক" },
            { "type.nu.hans", "সৰলীকৃত চীনা সংখ্যা" },
            { "type.nu.hant", "পৰম্পৰাগত চীনা সংখ্যা" },
            { "type.nu.hebr", "হিব্ৰু সংখ্যা" },
            { "type.nu.java", "জাভানীজ অংক" },
            { "type.nu.jpan", "জাপানী সংখ্যা" },
            { "type.nu.khmr", "খমেৰ অংক" },
            { "type.nu.knda", "কানাড়া অংক" },
            { "type.nu.laoo", "লাও অংক" },
            { "type.nu.latn", "পশ্চিমীয়া অংক" },
            { "type.nu.mlym", "মালায়ালম অংক" },
            { "type.nu.mtei", "মেইতেই মায়েক সংখ্যা" },
            { "type.nu.mymr", "ম্যানমাৰ অংক" },
            { "type.nu.olck", "অ’ল চিকি সংখ্যা" },
            { "type.nu.orya", "ওড়িয়া অংক" },
            { "type.nu.taml", "পৰম্পৰাগত তামিল সংখ্যা" },
            { "type.nu.telu", "তেলুগু অংক" },
            { "type.nu.thai", "থাই অংক" },
            { "type.nu.tibt", "তিব্বতী অংক" },
            { "type.nu.vaii", "ভেই সংখ্যা" },
            { "type.ca.dangi", "দাংগি কেলেণ্ডাৰ" },
            { "type.co.ducet", "ডিফ’ল্ট ইউনিকোড সজোৱা ক্ৰম" },
            { "type.lb.loose", "ঢিলা পংক্তি বিচ্ছেদ শৈলী" },
            { "type.nu.roman", "ৰোমান সংখ্যা" },
            { "type.ca.coptic", "ক’প্টিক কেলেণ্ডাৰ" },
            { "type.ca.hebrew", "হিব্ৰু কেলেণ্ডাৰ" },
            { "type.ca.indian", "ভাৰতীয় ৰাষ্ট্ৰীয় পঞ্জিকা" },
            { "type.co.pinyin", "পিন্‌য়িন শৃঙ্খলাবদ্ধ কৰাৰ ক্ৰম" },
            { "type.co.search", "সাধাৰণ উদ্দেশ্যে সন্ধান" },
            { "type.co.stroke", "স্ট্ৰোক শৃঙ্খলাবদ্ধ কৰাৰ ক্ৰম" },
            { "type.lb.normal", "সাধাৰণ পংক্তি বিচ্ছেদ শৈলী" },
            { "type.lb.strict", "কঠোৰ পংক্তি বিচ্ছেদ শৈলী" },
            { "type.ms.metric", "মেট্ৰিক প্ৰণালী" },
            { "type.ca.chinese", "চীনা কেলেণ্ডাৰ" },
            { "type.ca.islamic", "হিজৰি কেলেণ্ডাৰ" },
            { "type.ca.iso8601", "আই. এছ. অ’.-৮৬০১ কেলেণ্ডাৰ" },
            { "type.ca.persian", "ফাৰ্চী কেলেণ্ডাৰ" },
            { "type.cf.account", "গাণনিক মুদ্ৰা সজ্জা" },
            { "type.nu.arabext", "বিস্তাৰিত আৰবী-ভাৰতীয় অংক" },
            { "type.nu.armnlow", "আৰ্মেনীয় সৰুফলা সংখ্যা" },
            { "type.nu.greklow", "গ্ৰীক সৰুফলা সংখ্যা" },
            { "type.nu.hanidec", "চীনা দশমিক সংখ্যা" },
            { "type.nu.hansfin", "সৰলীকৃত চীনা বিত্তীয় সংখ্যা" },
            { "type.nu.hantfin", "পৰম্পৰাগত চীনা বিত্তীয় সংখ্যা" },
            { "type.nu.jpanfin", "জাপানী বিত্তীয় সংখ্যা" },
            { "type.nu.tamldec", "তামিল অংক" },
            { "type.ca.buddhist", "বৌদ্ধ কেলেণ্ডাৰ" },
            { "type.ca.ethiopic", "ইথিঅ’পিক কেলেণ্ডাৰ" },
            { "type.ca.japanese", "জাপানী কেলেণ্ডাৰ" },
            { "type.cf.standard", "মান্য মুদ্ৰা সজ্জা" },
            { "type.co.standard", "মান্য সজোৱা ক্ৰম" },
            { "type.ms.uksystem", "ইম্পেৰিয়েল জোখ-মাখৰ প্ৰণালী" },
            { "type.ms.ussystem", "মাৰ্কিন যুক্তৰাষ্ট্ৰৰ জোখ-মাখৰ প্ৰণালী" },
            { "type.nu.fullwide", "পূৰ্ণ-প্ৰস্থৰ অংক" },
            { "type.nu.romanlow", "ৰোমান সৰুফলা সংখ্যা" },
            { "type.ca.gregorian", "গ্ৰেগোৰিয়ান কেলেণ্ডাৰ" },
            { "type.co.phonebook", "টেলিফোন বহিৰ মতেশৃঙ্খলাবদ্ধ কৰাৰ ক্ৰম" },
            { "type.co.traditional", "পৰম্পৰাগতভাবে শৃঙ্খলাবদ্ধ কৰাৰ ক্ৰম" },
            { "type.ca.islamic-civil", "হিজৰি কেলেণ্ডাৰ (টেবুলাৰ, নাগৰিক যুগ)" },
            { "type.ca.islamic-umalqura", "হিজৰি কেলেণ্ডাৰ (উম অল-কুৰা)" },
            { "type.ca.ethiopic-amete-alem", "ইথিঅ’পিক এমিটি এলেম কেলেণ্ডাৰ" },
        };
        return data;
    }
}
