# Build --with setuid to run zdkimsign as the courier user.

Summary:       DKIM filter for Courier-MTA
Name:          zdkimfilter
Version:       3.23
Release:       1%{?dist}
License:       GPLv3+ with some additional rights; see LICENSE
Group:         Applications/Mail
URL:           http://www.tana.it/sw/zdkimfilter/
Source0:       http://www.tana.it/sw/zdkimfilter/%{name}-%{version}.tar.gz
BuildRequires: gcc, make, perl
BuildRequires: courier, opendbx-devel, nettle-devel, libidn2-devel
BuildRequires: libunistring-devel, zlib-devel, uuid, gnutls-devel, libbsd-devel
Requires:      courier, opendbx, nettle, libidn2
Requires:      libunistring, zlib, uuid, gnutls, publicsuffix-list

%description
"z" DKIM filter for Courier-MTA.


%prep
%setup -q


%build
cconfig=$(rpm -ql courier |grep courier-config |sed 's#/courier-config##')
export PATH="$cconfig:$PATH"
%configure --prefix=/usr %{?_with_setuid:--enable-zdkimsign-setuid}
make


%install
%define clibexec %(rpm -ql courier |grep 'dupfilter$' |sed 's#dupfilter##')
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{clibexec}
mkdir -p %{buildroot}%{_mandir}/{man1,man5,man8}
mkdir -p %{buildroot}%{_sysconfdir}/courier/filters

install -p -m0755 %{_builddir}/%{name}-%{version}/src/{zdkimsign,redact,zfilter_db,zaggregate} %{buildroot}%{_bindir}/
install -p -m0755 %{_builddir}/%{name}-%{version}/zdkimgenkey %{buildroot}%{_bindir}/
install -p -m0755 %{_builddir}/%{name}-%{version}/src/zdkimfilter %{buildroot}%{clibexec}
install -p -m0644 %{_builddir}/%{name}-%{version}/etc/{zfilter_db.1,zdkimsign.1,redact.1,zaggregate.1} %{buildroot}%{_mandir}/man1/
install -p -m0644 %{_builddir}/%{name}-%{version}/etc/zdkimfilter.conf.5 %{buildroot}%{_mandir}/man5/
install -p -m0644 %{_builddir}/%{name}-%{version}/etc/zdkimfilter.8 %{buildroot}%{_mandir}/man8/
install -p -m0644 %{_builddir}/%{name}-%{version}/etc/zdkimfilter.conf.dist %{buildroot}%{_sysconfdir}/courier/filters/
mv %{buildroot}%{_sysconfdir}/courier/filters/zdkimfilter.conf.dist %{buildroot}%{_sysconfdir}/courier/filters/zdkimfilter.conf


%files
%defattr(-, root, root, -)
%doc AUTHORS COPYING INSTALL LICENSE LICENSE.Sendmail NEWS README ChangeLog release-notes* zaggregate-example.sh odbx_example*
%{_bindir}/*
%{clibexec}/zdkimfilter
%{_mandir}/man1/*
%{_mandir}/man5/zdkimfilter.conf.5.gz
%{_mandir}/man8/zdkimfilter.8.gz
%config(noreplace) %{_sysconfdir}/courier/filters/zdkimfilter.conf


%post
cconfig=$(rpm -ql courier |grep courier-config)
courieruser=$($cconfig |grep mailuser |sed 's/.*=//')
couriergroup=$($cconfig |grep mailgroup |sed 's/.*=//')
chown $courieruser:$couriergroup %{_bindir}/zdkimsign
%{?_with_setuid:chmod +s %{_bindir}/zdkimsign}
if [ $1 -eq 2 -a -f %{_sysconfdir}/courier/filters/zdkimfilter.conf.rpmnew ]; then
  chown $courieruser:$couriergroup %{_sysconfdir}/courier/filters/zdkimfilter.conf.rpmnew
else
  chown $courieruser:$couriergroup %{_sysconfdir}/courier/filters/zdkimfilter.conf
fi


%changelog
* Thu Oct 16 2025 Alessandro Vesely <vesely@tana.it>
- Bumped up to 3.23

* Fri Jan 03 2025 Alessandro Vesely <vesely@tana.it>
- Bumped up to 3.22

* Thu Sep 12 2024 Alessandro Vesely <vesely@tana.it>
- Bumped up to 3.21

* Tue May 14 2024 Alessandro Vesely <vesely@tana.it>
- Bumped up to 3.20

* Thu May 09 2024 Alessandro Vesely <vesely@tana.it>
- Bumped up to 3.19

* Fri Apr 19 2024 Alessandro Vesely <vesely@tana.it>
- Bumped up to 3.18

* Tue Oct 10 2023 Alessandro Vesely <vesely@tana.it>
- Bumped up to 3.17

* Fri Sep 08 2023 Alessandro Vesely <vesely@tana.it>
- Bumped up to 3.16

* Wed Mar 29 2023 Alessandro Vesely <vesely@tana.it>
- Bumped up to 3.15

* Fri Mar 10 2023 Alessandro Vesely <vesely@tana.it>
- Bumped up to 3.14

* Tue Jan 10 2023 Alessandro Vesely <vesely@tana.it>
- Bumped up to 3.13

* Mon Jan 02 2023 Alessandro Vesely <vesely@tana.it>
- Bumped up to 3.12

* Wed Jun 29 2022 Alessandro Vesely <vesely@tana.it>
- Bumped up to 3.11

* Thu Feb 24 2022 Alessandro Vesely <vesely@tana.it>
- Bumped up to v3.9

* Tue Feb 15 2022 Zenon Panoussis <oracle@provocation.net>
- Bumped up to v3.8

* Tue Feb 7 2017 Zenon Panoussis <oracle@provocation.net>
- Rebuilt with libopendkim 2.11.0-0.1

* Sat Jun 20 2015 Zenon Panoussis <oracle@provocation.net> 1.5
- Initial packaging.

