#! /bin/sh
# Copyright (C) 2018 Red Hat, Inc.
# This file is part of elfutils.
#
# This file is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# elfutils is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

. $srcdir/test-subr.sh

# - testfile-macros-object.c
#
# #define SUCCESS 0
# #define FAILURE 0
#
# #include <stdbool.h>
#
# bool foo (int input)
# {
#   return input == SUCCESS ? SUCCESS : FAILURE;
# }

# gcc -g3 -gdwarf-5 -O2 -c testfile-macros-object.c

testfiles testfile-macros-object.o

testrun_compare ${abs_top_builddir}/src/readelf --debug-dump=macro testfile-macros-object.o <<\EOF

DWARF section [12] '.debug_macro' at offset 0x16f:

 Offset:             0x0
 Version:            5
 Flag:               0x2 (debug_line_offset)
 Offset length:      4
 .debug_line offset: 0x0

 #include offset 0x0
 start_file 0, [1] /home/mark/build/elfutils-obj/testfile-macros-object.c
  start_file 31, [2] /usr/include/stdc-predef.h
   #include offset 0x0
  end_file
  #define SUCCESS 0, line 1 (indirect)
  #define FAILURE 0, line 2 (indirect)
  start_file 4, [3] /opt/rh/devtoolset-8/root/usr/lib/gcc/x86_64-redhat-linux/8/include/stdbool.h
   #include offset 0x0
  end_file
 end_file


DWARF section [14] '.debug_macro' at offset 0x19e:

 Offset:             0x0
 Version:            5
 Flag:               0x0
 Offset length:      4

 #define __STDC__ 1, line 0 (indirect)
 #define __STDC_VERSION__ 201710L, line 0 (indirect)
 #define __STDC_UTF_16__ 1, line 0 (indirect)
 #define __STDC_UTF_32__ 1, line 0 (indirect)
 #define __STDC_HOSTED__ 1, line 0 (indirect)
 #define __GNUC__ 8, line 0 (indirect)
 #define __GNUC_MINOR__ 2, line 0 (indirect)
 #define __GNUC_PATCHLEVEL__ 1, line 0 (indirect)
 #define __VERSION__ "8.2.1 20180905 (Red Hat 8.2.1-3)", line 0 (indirect)
 #define __GNUC_RH_RELEASE__ 3, line 0 (indirect)
 #define __ATOMIC_RELAXED 0, line 0 (indirect)
 #define __ATOMIC_SEQ_CST 5, line 0 (indirect)
 #define __ATOMIC_ACQUIRE 2, line 0 (indirect)
 #define __ATOMIC_RELEASE 3, line 0 (indirect)
 #define __ATOMIC_ACQ_REL 4, line 0 (indirect)
 #define __ATOMIC_CONSUME 1, line 0 (indirect)
 #define __OPTIMIZE__ 1, line 0 (indirect)
 #define __FINITE_MATH_ONLY__ 0, line 0 (indirect)
 #define _LP64 1, line 0 (indirect)
 #define __LP64__ 1, line 0 (indirect)
 #define __SIZEOF_INT__ 4, line 0 (indirect)
 #define __SIZEOF_LONG__ 8, line 0 (indirect)
 #define __SIZEOF_LONG_LONG__ 8, line 0 (indirect)
 #define __SIZEOF_SHORT__ 2, line 0 (indirect)
 #define __SIZEOF_FLOAT__ 4, line 0 (indirect)
 #define __SIZEOF_DOUBLE__ 8, line 0 (indirect)
 #define __SIZEOF_LONG_DOUBLE__ 16, line 0 (indirect)
 #define __SIZEOF_SIZE_T__ 8, line 0 (indirect)
 #define __CHAR_BIT__ 8, line 0 (indirect)
 #define __BIGGEST_ALIGNMENT__ 16, line 0 (indirect)
 #define __ORDER_LITTLE_ENDIAN__ 1234, line 0 (indirect)
 #define __ORDER_BIG_ENDIAN__ 4321, line 0 (indirect)
 #define __ORDER_PDP_ENDIAN__ 3412, line 0 (indirect)
 #define __BYTE_ORDER__ __ORDER_LITTLE_ENDIAN__, line 0 (indirect)
 #define __FLOAT_WORD_ORDER__ __ORDER_LITTLE_ENDIAN__, line 0 (indirect)
 #define __SIZEOF_POINTER__ 8, line 0 (indirect)
 #define __SIZE_TYPE__ long unsigned int, line 0 (indirect)
 #define __PTRDIFF_TYPE__ long int, line 0 (indirect)
 #define __WCHAR_TYPE__ int, line 0 (indirect)
 #define __WINT_TYPE__ unsigned int, line 0 (indirect)
 #define __INTMAX_TYPE__ long int, line 0 (indirect)
 #define __UINTMAX_TYPE__ long unsigned int, line 0 (indirect)
 #define __CHAR16_TYPE__ short unsigned int, line 0 (indirect)
 #define __CHAR32_TYPE__ unsigned int, line 0 (indirect)
 #define __SIG_ATOMIC_TYPE__ int, line 0 (indirect)
 #define __INT8_TYPE__ signed char, line 0 (indirect)
 #define __INT16_TYPE__ short int, line 0 (indirect)
 #define __INT32_TYPE__ int, line 0 (indirect)
 #define __INT64_TYPE__ long int, line 0 (indirect)
 #define __UINT8_TYPE__ unsigned char, line 0 (indirect)
 #define __UINT16_TYPE__ short unsigned int, line 0 (indirect)
 #define __UINT32_TYPE__ unsigned int, line 0 (indirect)
 #define __UINT64_TYPE__ long unsigned int, line 0 (indirect)
 #define __INT_LEAST8_TYPE__ signed char, line 0 (indirect)
 #define __INT_LEAST16_TYPE__ short int, line 0 (indirect)
 #define __INT_LEAST32_TYPE__ int, line 0 (indirect)
 #define __INT_LEAST64_TYPE__ long int, line 0 (indirect)
 #define __UINT_LEAST8_TYPE__ unsigned char, line 0 (indirect)
 #define __UINT_LEAST16_TYPE__ short unsigned int, line 0 (indirect)
 #define __UINT_LEAST32_TYPE__ unsigned int, line 0 (indirect)
 #define __UINT_LEAST64_TYPE__ long unsigned int, line 0 (indirect)
 #define __INT_FAST8_TYPE__ signed char, line 0 (indirect)
 #define __INT_FAST16_TYPE__ long int, line 0 (indirect)
 #define __INT_FAST32_TYPE__ long int, line 0 (indirect)
 #define __INT_FAST64_TYPE__ long int, line 0 (indirect)
 #define __UINT_FAST8_TYPE__ unsigned char, line 0 (indirect)
 #define __UINT_FAST16_TYPE__ long unsigned int, line 0 (indirect)
 #define __UINT_FAST32_TYPE__ long unsigned int, line 0 (indirect)
 #define __UINT_FAST64_TYPE__ long unsigned int, line 0 (indirect)
 #define __INTPTR_TYPE__ long int, line 0 (indirect)
 #define __UINTPTR_TYPE__ long unsigned int, line 0 (indirect)
 #define __has_include(STR) __has_include__(STR), line 0 (indirect)
 #define __has_include_next(STR) __has_include_next__(STR), line 0 (indirect)
 #define __GXX_ABI_VERSION 1013, line 0 (indirect)
 #define __SCHAR_MAX__ 0x7f, line 0 (indirect)
 #define __SHRT_MAX__ 0x7fff, line 0 (indirect)
 #define __INT_MAX__ 0x7fffffff, line 0 (indirect)
 #define __LONG_MAX__ 0x7fffffffffffffffL, line 0 (indirect)
 #define __LONG_LONG_MAX__ 0x7fffffffffffffffLL, line 0 (indirect)
 #define __WCHAR_MAX__ 0x7fffffff, line 0 (indirect)
 #define __WCHAR_MIN__ (-__WCHAR_MAX__ - 1), line 0 (indirect)
 #define __WINT_MAX__ 0xffffffffU, line 0 (indirect)
 #define __WINT_MIN__ 0U, line 0 (indirect)
 #define __PTRDIFF_MAX__ 0x7fffffffffffffffL, line 0 (indirect)
 #define __SIZE_MAX__ 0xffffffffffffffffUL, line 0 (indirect)
 #define __SCHAR_WIDTH__ 8, line 0 (indirect)
 #define __SHRT_WIDTH__ 16, line 0 (indirect)
 #define __INT_WIDTH__ 32, line 0 (indirect)
 #define __LONG_WIDTH__ 64, line 0 (indirect)
 #define __LONG_LONG_WIDTH__ 64, line 0 (indirect)
 #define __WCHAR_WIDTH__ 32, line 0 (indirect)
 #define __WINT_WIDTH__ 32, line 0 (indirect)
 #define __PTRDIFF_WIDTH__ 64, line 0 (indirect)
 #define __SIZE_WIDTH__ 64, line 0 (indirect)
 #define __INTMAX_MAX__ 0x7fffffffffffffffL, line 0 (indirect)
 #define __INTMAX_C(c) c ## L, line 0 (indirect)
 #define __UINTMAX_MAX__ 0xffffffffffffffffUL, line 0 (indirect)
 #define __UINTMAX_C(c) c ## UL, line 0 (indirect)
 #define __INTMAX_WIDTH__ 64, line 0 (indirect)
 #define __SIG_ATOMIC_MAX__ 0x7fffffff, line 0 (indirect)
 #define __SIG_ATOMIC_MIN__ (-__SIG_ATOMIC_MAX__ - 1), line 0 (indirect)
 #define __SIG_ATOMIC_WIDTH__ 32, line 0 (indirect)
 #define __INT8_MAX__ 0x7f, line 0 (indirect)
 #define __INT16_MAX__ 0x7fff, line 0 (indirect)
 #define __INT32_MAX__ 0x7fffffff, line 0 (indirect)
 #define __INT64_MAX__ 0x7fffffffffffffffL, line 0 (indirect)
 #define __UINT8_MAX__ 0xff, line 0 (indirect)
 #define __UINT16_MAX__ 0xffff, line 0 (indirect)
 #define __UINT32_MAX__ 0xffffffffU, line 0 (indirect)
 #define __UINT64_MAX__ 0xffffffffffffffffUL, line 0 (indirect)
 #define __INT_LEAST8_MAX__ 0x7f, line 0 (indirect)
 #define __INT8_C(c) c, line 0 (indirect)
 #define __INT_LEAST8_WIDTH__ 8, line 0 (indirect)
 #define __INT_LEAST16_MAX__ 0x7fff, line 0 (indirect)
 #define __INT16_C(c) c, line 0 (indirect)
 #define __INT_LEAST16_WIDTH__ 16, line 0 (indirect)
 #define __INT_LEAST32_MAX__ 0x7fffffff, line 0 (indirect)
 #define __INT32_C(c) c, line 0 (indirect)
 #define __INT_LEAST32_WIDTH__ 32, line 0 (indirect)
 #define __INT_LEAST64_MAX__ 0x7fffffffffffffffL, line 0 (indirect)
 #define __INT64_C(c) c ## L, line 0 (indirect)
 #define __INT_LEAST64_WIDTH__ 64, line 0 (indirect)
 #define __UINT_LEAST8_MAX__ 0xff, line 0 (indirect)
 #define __UINT8_C(c) c, line 0 (indirect)
 #define __UINT_LEAST16_MAX__ 0xffff, line 0 (indirect)
 #define __UINT16_C(c) c, line 0 (indirect)
 #define __UINT_LEAST32_MAX__ 0xffffffffU, line 0 (indirect)
 #define __UINT32_C(c) c ## U, line 0 (indirect)
 #define __UINT_LEAST64_MAX__ 0xffffffffffffffffUL, line 0 (indirect)
 #define __UINT64_C(c) c ## UL, line 0 (indirect)
 #define __INT_FAST8_MAX__ 0x7f, line 0 (indirect)
 #define __INT_FAST8_WIDTH__ 8, line 0 (indirect)
 #define __INT_FAST16_MAX__ 0x7fffffffffffffffL, line 0 (indirect)
 #define __INT_FAST16_WIDTH__ 64, line 0 (indirect)
 #define __INT_FAST32_MAX__ 0x7fffffffffffffffL, line 0 (indirect)
 #define __INT_FAST32_WIDTH__ 64, line 0 (indirect)
 #define __INT_FAST64_MAX__ 0x7fffffffffffffffL, line 0 (indirect)
 #define __INT_FAST64_WIDTH__ 64, line 0 (indirect)
 #define __UINT_FAST8_MAX__ 0xff, line 0 (indirect)
 #define __UINT_FAST16_MAX__ 0xffffffffffffffffUL, line 0 (indirect)
 #define __UINT_FAST32_MAX__ 0xffffffffffffffffUL, line 0 (indirect)
 #define __UINT_FAST64_MAX__ 0xffffffffffffffffUL, line 0 (indirect)
 #define __INTPTR_MAX__ 0x7fffffffffffffffL, line 0 (indirect)
 #define __INTPTR_WIDTH__ 64, line 0 (indirect)
 #define __UINTPTR_MAX__ 0xffffffffffffffffUL, line 0 (indirect)
 #define __GCC_IEC_559 2, line 0 (indirect)
 #define __GCC_IEC_559_COMPLEX 2, line 0 (indirect)
 #define __FLT_EVAL_METHOD__ 0, line 0 (indirect)
 #define __FLT_EVAL_METHOD_TS_18661_3__ 0, line 0 (indirect)
 #define __DEC_EVAL_METHOD__ 2, line 0 (indirect)
 #define __FLT_RADIX__ 2, line 0 (indirect)
 #define __FLT_MANT_DIG__ 24, line 0 (indirect)
 #define __FLT_DIG__ 6, line 0 (indirect)
 #define __FLT_MIN_EXP__ (-125), line 0 (indirect)
 #define __FLT_MIN_10_EXP__ (-37), line 0 (indirect)
 #define __FLT_MAX_EXP__ 128, line 0 (indirect)
 #define __FLT_MAX_10_EXP__ 38, line 0 (indirect)
 #define __FLT_DECIMAL_DIG__ 9, line 0 (indirect)
 #define __FLT_MAX__ 3.40282346638528859811704183484516925e+38F, line 0 (indirect)
 #define __FLT_MIN__ 1.17549435082228750796873653722224568e-38F, line 0 (indirect)
 #define __FLT_EPSILON__ 1.19209289550781250000000000000000000e-7F, line 0 (indirect)
 #define __FLT_DENORM_MIN__ 1.40129846432481707092372958328991613e-45F, line 0 (indirect)
 #define __FLT_HAS_DENORM__ 1, line 0 (indirect)
 #define __FLT_HAS_INFINITY__ 1, line 0 (indirect)
 #define __FLT_HAS_QUIET_NAN__ 1, line 0 (indirect)
 #define __DBL_MANT_DIG__ 53, line 0 (indirect)
 #define __DBL_DIG__ 15, line 0 (indirect)
 #define __DBL_MIN_EXP__ (-1021), line 0 (indirect)
 #define __DBL_MIN_10_EXP__ (-307), line 0 (indirect)
 #define __DBL_MAX_EXP__ 1024, line 0 (indirect)
 #define __DBL_MAX_10_EXP__ 308, line 0 (indirect)
 #define __DBL_DECIMAL_DIG__ 17, line 0 (indirect)
 #define __DBL_MAX__ ((double)1.79769313486231570814527423731704357e+308L), line 0 (indirect)
 #define __DBL_MIN__ ((double)2.22507385850720138309023271733240406e-308L), line 0 (indirect)
 #define __DBL_EPSILON__ ((double)2.22044604925031308084726333618164062e-16L), line 0 (indirect)
 #define __DBL_DENORM_MIN__ ((double)4.94065645841246544176568792868221372e-324L), line 0 (indirect)
 #define __DBL_HAS_DENORM__ 1, line 0 (indirect)
 #define __DBL_HAS_INFINITY__ 1, line 0 (indirect)
 #define __DBL_HAS_QUIET_NAN__ 1, line 0 (indirect)
 #define __LDBL_MANT_DIG__ 64, line 0 (indirect)
 #define __LDBL_DIG__ 18, line 0 (indirect)
 #define __LDBL_MIN_EXP__ (-16381), line 0 (indirect)
 #define __LDBL_MIN_10_EXP__ (-4931), line 0 (indirect)
 #define __LDBL_MAX_EXP__ 16384, line 0 (indirect)
 #define __LDBL_MAX_10_EXP__ 4932, line 0 (indirect)
 #define __DECIMAL_DIG__ 21, line 0 (indirect)
 #define __LDBL_DECIMAL_DIG__ 21, line 0 (indirect)
 #define __LDBL_MAX__ 1.18973149535723176502126385303097021e+4932L, line 0 (indirect)
 #define __LDBL_MIN__ 3.36210314311209350626267781732175260e-4932L, line 0 (indirect)
 #define __LDBL_EPSILON__ 1.08420217248550443400745280086994171e-19L, line 0 (indirect)
 #define __LDBL_DENORM_MIN__ 3.64519953188247460252840593361941982e-4951L, line 0 (indirect)
 #define __LDBL_HAS_DENORM__ 1, line 0 (indirect)
 #define __LDBL_HAS_INFINITY__ 1, line 0 (indirect)
 #define __LDBL_HAS_QUIET_NAN__ 1, line 0 (indirect)
 #define __FLT32_MANT_DIG__ 24, line 0 (indirect)
 #define __FLT32_DIG__ 6, line 0 (indirect)
 #define __FLT32_MIN_EXP__ (-125), line 0 (indirect)
 #define __FLT32_MIN_10_EXP__ (-37), line 0 (indirect)
 #define __FLT32_MAX_EXP__ 128, line 0 (indirect)
 #define __FLT32_MAX_10_EXP__ 38, line 0 (indirect)
 #define __FLT32_DECIMAL_DIG__ 9, line 0 (indirect)
 #define __FLT32_MAX__ 3.40282346638528859811704183484516925e+38F32, line 0 (indirect)
 #define __FLT32_MIN__ 1.17549435082228750796873653722224568e-38F32, line 0 (indirect)
 #define __FLT32_EPSILON__ 1.19209289550781250000000000000000000e-7F32, line 0 (indirect)
 #define __FLT32_DENORM_MIN__ 1.40129846432481707092372958328991613e-45F32, line 0 (indirect)
 #define __FLT32_HAS_DENORM__ 1, line 0 (indirect)
 #define __FLT32_HAS_INFINITY__ 1, line 0 (indirect)
 #define __FLT32_HAS_QUIET_NAN__ 1, line 0 (indirect)
 #define __FLT64_MANT_DIG__ 53, line 0 (indirect)
 #define __FLT64_DIG__ 15, line 0 (indirect)
 #define __FLT64_MIN_EXP__ (-1021), line 0 (indirect)
 #define __FLT64_MIN_10_EXP__ (-307), line 0 (indirect)
 #define __FLT64_MAX_EXP__ 1024, line 0 (indirect)
 #define __FLT64_MAX_10_EXP__ 308, line 0 (indirect)
 #define __FLT64_DECIMAL_DIG__ 17, line 0 (indirect)
 #define __FLT64_MAX__ 1.79769313486231570814527423731704357e+308F64, line 0 (indirect)
 #define __FLT64_MIN__ 2.22507385850720138309023271733240406e-308F64, line 0 (indirect)
 #define __FLT64_EPSILON__ 2.22044604925031308084726333618164062e-16F64, line 0 (indirect)
 #define __FLT64_DENORM_MIN__ 4.94065645841246544176568792868221372e-324F64, line 0 (indirect)
 #define __FLT64_HAS_DENORM__ 1, line 0 (indirect)
 #define __FLT64_HAS_INFINITY__ 1, line 0 (indirect)
 #define __FLT64_HAS_QUIET_NAN__ 1, line 0 (indirect)
 #define __FLT128_MANT_DIG__ 113, line 0 (indirect)
 #define __FLT128_DIG__ 33, line 0 (indirect)
 #define __FLT128_MIN_EXP__ (-16381), line 0 (indirect)
 #define __FLT128_MIN_10_EXP__ (-4931), line 0 (indirect)
 #define __FLT128_MAX_EXP__ 16384, line 0 (indirect)
 #define __FLT128_MAX_10_EXP__ 4932, line 0 (indirect)
 #define __FLT128_DECIMAL_DIG__ 36, line 0 (indirect)
 #define __FLT128_MAX__ 1.18973149535723176508575932662800702e+4932F128, line 0 (indirect)
 #define __FLT128_MIN__ 3.36210314311209350626267781732175260e-4932F128, line 0 (indirect)
 #define __FLT128_EPSILON__ 1.92592994438723585305597794258492732e-34F128, line 0 (indirect)
 #define __FLT128_DENORM_MIN__ 6.47517511943802511092443895822764655e-4966F128, line 0 (indirect)
 #define __FLT128_HAS_DENORM__ 1, line 0 (indirect)
 #define __FLT128_HAS_INFINITY__ 1, line 0 (indirect)
 #define __FLT128_HAS_QUIET_NAN__ 1, line 0 (indirect)
 #define __FLT32X_MANT_DIG__ 53, line 0 (indirect)
 #define __FLT32X_DIG__ 15, line 0 (indirect)
 #define __FLT32X_MIN_EXP__ (-1021), line 0 (indirect)
 #define __FLT32X_MIN_10_EXP__ (-307), line 0 (indirect)
 #define __FLT32X_MAX_EXP__ 1024, line 0 (indirect)
 #define __FLT32X_MAX_10_EXP__ 308, line 0 (indirect)
 #define __FLT32X_DECIMAL_DIG__ 17, line 0 (indirect)
 #define __FLT32X_MAX__ 1.79769313486231570814527423731704357e+308F32x, line 0 (indirect)
 #define __FLT32X_MIN__ 2.22507385850720138309023271733240406e-308F32x, line 0 (indirect)
 #define __FLT32X_EPSILON__ 2.22044604925031308084726333618164062e-16F32x, line 0 (indirect)
 #define __FLT32X_DENORM_MIN__ 4.94065645841246544176568792868221372e-324F32x, line 0 (indirect)
 #define __FLT32X_HAS_DENORM__ 1, line 0 (indirect)
 #define __FLT32X_HAS_INFINITY__ 1, line 0 (indirect)
 #define __FLT32X_HAS_QUIET_NAN__ 1, line 0 (indirect)
 #define __FLT64X_MANT_DIG__ 64, line 0 (indirect)
 #define __FLT64X_DIG__ 18, line 0 (indirect)
 #define __FLT64X_MIN_EXP__ (-16381), line 0 (indirect)
 #define __FLT64X_MIN_10_EXP__ (-4931), line 0 (indirect)
 #define __FLT64X_MAX_EXP__ 16384, line 0 (indirect)
 #define __FLT64X_MAX_10_EXP__ 4932, line 0 (indirect)
 #define __FLT64X_DECIMAL_DIG__ 21, line 0 (indirect)
 #define __FLT64X_MAX__ 1.18973149535723176502126385303097021e+4932F64x, line 0 (indirect)
 #define __FLT64X_MIN__ 3.36210314311209350626267781732175260e-4932F64x, line 0 (indirect)
 #define __FLT64X_EPSILON__ 1.08420217248550443400745280086994171e-19F64x, line 0 (indirect)
 #define __FLT64X_DENORM_MIN__ 3.64519953188247460252840593361941982e-4951F64x, line 0 (indirect)
 #define __FLT64X_HAS_DENORM__ 1, line 0 (indirect)
 #define __FLT64X_HAS_INFINITY__ 1, line 0 (indirect)
 #define __FLT64X_HAS_QUIET_NAN__ 1, line 0 (indirect)
 #define __DEC32_MANT_DIG__ 7, line 0 (indirect)
 #define __DEC32_MIN_EXP__ (-94), line 0 (indirect)
 #define __DEC32_MAX_EXP__ 97, line 0 (indirect)
 #define __DEC32_MIN__ 1E-95DF, line 0 (indirect)
 #define __DEC32_MAX__ 9.999999E96DF, line 0 (indirect)
 #define __DEC32_EPSILON__ 1E-6DF, line 0 (indirect)
 #define __DEC32_SUBNORMAL_MIN__ 0.000001E-95DF, line 0 (indirect)
 #define __DEC64_MANT_DIG__ 16, line 0 (indirect)
 #define __DEC64_MIN_EXP__ (-382), line 0 (indirect)
 #define __DEC64_MAX_EXP__ 385, line 0 (indirect)
 #define __DEC64_MIN__ 1E-383DD, line 0 (indirect)
 #define __DEC64_MAX__ 9.999999999999999E384DD, line 0 (indirect)
 #define __DEC64_EPSILON__ 1E-15DD, line 0 (indirect)
 #define __DEC64_SUBNORMAL_MIN__ 0.000000000000001E-383DD, line 0 (indirect)
 #define __DEC128_MANT_DIG__ 34, line 0 (indirect)
 #define __DEC128_MIN_EXP__ (-6142), line 0 (indirect)
 #define __DEC128_MAX_EXP__ 6145, line 0 (indirect)
 #define __DEC128_MIN__ 1E-6143DL, line 0 (indirect)
 #define __DEC128_MAX__ 9.999999999999999999999999999999999E6144DL, line 0 (indirect)
 #define __DEC128_EPSILON__ 1E-33DL, line 0 (indirect)
 #define __DEC128_SUBNORMAL_MIN__ 0.000000000000000000000000000000001E-6143DL, line 0 (indirect)
 #define __REGISTER_PREFIX__ , line 0 (indirect)
 #define __USER_LABEL_PREFIX__ , line 0 (indirect)
 #define __GNUC_STDC_INLINE__ 1, line 0 (indirect)
 #define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_1 1, line 0 (indirect)
 #define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_2 1, line 0 (indirect)
 #define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_4 1, line 0 (indirect)
 #define __GCC_HAVE_SYNC_COMPARE_AND_SWAP_8 1, line 0 (indirect)
 #define __GCC_ATOMIC_BOOL_LOCK_FREE 2, line 0 (indirect)
 #define __GCC_ATOMIC_CHAR_LOCK_FREE 2, line 0 (indirect)
 #define __GCC_ATOMIC_CHAR16_T_LOCK_FREE 2, line 0 (indirect)
 #define __GCC_ATOMIC_CHAR32_T_LOCK_FREE 2, line 0 (indirect)
 #define __GCC_ATOMIC_WCHAR_T_LOCK_FREE 2, line 0 (indirect)
 #define __GCC_ATOMIC_SHORT_LOCK_FREE 2, line 0 (indirect)
 #define __GCC_ATOMIC_INT_LOCK_FREE 2, line 0 (indirect)
 #define __GCC_ATOMIC_LONG_LOCK_FREE 2, line 0 (indirect)
 #define __GCC_ATOMIC_LLONG_LOCK_FREE 2, line 0 (indirect)
 #define __GCC_ATOMIC_TEST_AND_SET_TRUEVAL 1, line 0 (indirect)
 #define __GCC_ATOMIC_POINTER_LOCK_FREE 2, line 0 (indirect)
 #define __GCC_HAVE_DWARF2_CFI_ASM 1, line 0 (indirect)
 #define __PRAGMA_REDEFINE_EXTNAME 1, line 0 (indirect)
 #define __SIZEOF_INT128__ 16, line 0 (indirect)
 #define __SIZEOF_WCHAR_T__ 4, line 0 (indirect)
 #define __SIZEOF_WINT_T__ 4, line 0 (indirect)
 #define __SIZEOF_PTRDIFF_T__ 8, line 0 (indirect)
 #define __amd64 1, line 0 (indirect)
 #define __amd64__ 1, line 0 (indirect)
 #define __x86_64 1, line 0 (indirect)
 #define __x86_64__ 1, line 0 (indirect)
 #define __SIZEOF_FLOAT80__ 16, line 0 (indirect)
 #define __SIZEOF_FLOAT128__ 16, line 0 (indirect)
 #define __ATOMIC_HLE_ACQUIRE 65536, line 0 (indirect)
 #define __ATOMIC_HLE_RELEASE 131072, line 0 (indirect)
 #define __GCC_ASM_FLAG_OUTPUTS__ 1, line 0 (indirect)
 #define __k8 1, line 0 (indirect)
 #define __k8__ 1, line 0 (indirect)
 #define __code_model_small__ 1, line 0 (indirect)
 #define __MMX__ 1, line 0 (indirect)
 #define __SSE__ 1, line 0 (indirect)
 #define __SSE2__ 1, line 0 (indirect)
 #define __FXSR__ 1, line 0 (indirect)
 #define __SSE_MATH__ 1, line 0 (indirect)
 #define __SSE2_MATH__ 1, line 0 (indirect)
 #define __SEG_FS 1, line 0 (indirect)
 #define __SEG_GS 1, line 0 (indirect)
 #define __gnu_linux__ 1, line 0 (indirect)
 #define __linux 1, line 0 (indirect)
 #define __linux__ 1, line 0 (indirect)
 #define linux 1, line 0 (indirect)
 #define __unix 1, line 0 (indirect)
 #define __unix__ 1, line 0 (indirect)
 #define unix 1, line 0 (indirect)
 #define __ELF__ 1, line 0 (indirect)
 #define __DECIMAL_BID_FORMAT__ 1, line 0 (indirect)


DWARF section [16] '.debug_macro' at offset 0x98e:

 Offset:             0x0
 Version:            5
 Flag:               0x0
 Offset length:      4

 #define _STDC_PREDEF_H 1, line 19 (indirect)
 #define __STDC_IEC_559__ 1, line 30 (indirect)
 #define __STDC_IEC_559_COMPLEX__ 1, line 31 (indirect)
 #define __STDC_ISO_10646__ 201103L, line 35 (indirect)
 #define __STDC_NO_THREADS__ 1, line 38 (indirect)


DWARF section [18] '.debug_macro' at offset 0x9b0:

 Offset:             0x0
 Version:            5
 Flag:               0x0
 Offset length:      4

 #define _STDBOOL_H , line 29 (indirect)
 #define bool _Bool, line 33 (indirect)
 #define true 1, line 34 (indirect)
 #define false 0, line 35 (indirect)
 #define __bool_true_false_are_defined 1, line 52 (indirect)

EOF

exit 0
