//===----------------------------------------------------------------------===//
//                         DuckDB
//
// core_functions/scalar/string_functions.hpp
//
//
//===----------------------------------------------------------------------===//
// This file is automatically generated by scripts/generate_functions.py
// Do not edit this file manually, your changes will be overwritten
//===----------------------------------------------------------------------===//

#pragma once

#include "duckdb/function/function_set.hpp"

namespace duckdb {

struct StartsWithOperatorFun {
	static constexpr const char *Name = "^@";
	static constexpr const char *Parameters = "string,search_string";
	static constexpr const char *Description = "Returns `true` if `string` begins with `search_string`.";
	static constexpr const char *Example = "starts_with('abc', 'a')";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct StartsWithFun {
	using ALIAS = StartsWithOperatorFun;

	static constexpr const char *Name = "starts_with";
};

struct ASCIIFun {
	static constexpr const char *Name = "ascii";
	static constexpr const char *Parameters = "string";
	static constexpr const char *Description = "Returns an integer that represents the Unicode code point of the first character of the `string`.";
	static constexpr const char *Example = "ascii('Ω')";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct BarFun {
	static constexpr const char *Name = "bar";
	static constexpr const char *Parameters = "x,min,max,width";
	static constexpr const char *Description = "Draws a band whose width is proportional to (`x - min`) and equal to `width` characters when `x` = `max`. `width` defaults to 80.";
	static constexpr const char *Example = "bar(5, 0, 20, 10)";
	static constexpr const char *Categories = "string";

	static ScalarFunctionSet GetFunctions();
};

struct BinFun {
	static constexpr const char *Name = "bin";
	static constexpr const char *Parameters = "string::VARCHAR\001value::ANY";
	static constexpr const char *Description = "Converts the `string` to binary representation.\001Converts the `value` to binary representation.";
	static constexpr const char *Example = "bin('Aa')\001bin(42)";
	static constexpr const char *Categories = "string\001numeric";

	static ScalarFunctionSet GetFunctions();
};

struct ToBinaryFun {
	using ALIAS = BinFun;

	static constexpr const char *Name = "to_binary";
};

struct ChrFun {
	static constexpr const char *Name = "chr";
	static constexpr const char *Parameters = "code_point";
	static constexpr const char *Description = "Returns a character which is corresponding the ASCII code value or Unicode code point.";
	static constexpr const char *Example = "chr(65)";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct DamerauLevenshteinFun {
	static constexpr const char *Name = "damerau_levenshtein";
	static constexpr const char *Parameters = "s1,s2";
	static constexpr const char *Description = "Extension of Levenshtein distance to also include transposition of adjacent characters as an allowed edit operation. In other words, the minimum number of edit operations (insertions, deletions, substitutions or transpositions) required to change one string to another. Characters of different cases (e.g., `a` and `A`) are considered different.";
	static constexpr const char *Example = "damerau_levenshtein('duckdb', 'udckbd')";
	static constexpr const char *Categories = "text_similarity";

	static ScalarFunction GetFunction();
};

struct FormatFun {
	static constexpr const char *Name = "format";
	static constexpr const char *Parameters = "format,parameters...";
	static constexpr const char *Description = "Formats a string using the fmt syntax.";
	static constexpr const char *Example = "format('Benchmark \"{}\" took {} seconds', 'CSV', 42)";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct FormatBytesFun {
	static constexpr const char *Name = "format_bytes";
	static constexpr const char *Parameters = "integer";
	static constexpr const char *Description = "Converts `integer` to a human-readable representation using units based on powers of 2 (KiB, MiB, GiB, etc.).";
	static constexpr const char *Example = "format_bytes(16_000)";
	static constexpr const char *Categories = "string,numeric";

	static ScalarFunction GetFunction();
};

struct FormatreadablesizeFun {
	using ALIAS = FormatBytesFun;

	static constexpr const char *Name = "formatReadableSize";
};

struct FormatreadabledecimalsizeFun {
	static constexpr const char *Name = "formatReadableDecimalSize";
	static constexpr const char *Parameters = "integer";
	static constexpr const char *Description = "Converts `integer` to a human-readable representation using units based on powers of 10 (KB, MB, GB, etc.).";
	static constexpr const char *Example = "formatReadableDecimalSize(16_000)";
	static constexpr const char *Categories = "string,numeric";

	static ScalarFunction GetFunction();
};

struct HammingFun {
	static constexpr const char *Name = "hamming";
	static constexpr const char *Parameters = "s1,s2";
	static constexpr const char *Description = "The Hamming distance between to strings, i.e., the number of positions with different characters for two strings of equal length. Strings must be of equal length. Characters of different cases (e.g., `a` and `A`) are considered different.";
	static constexpr const char *Example = "hamming('duck', 'luck')";
	static constexpr const char *Categories = "text_similarity";

	static ScalarFunction GetFunction();
};

struct MismatchesFun {
	using ALIAS = HammingFun;

	static constexpr const char *Name = "mismatches";
};

struct HexFun {
	static constexpr const char *Name = "hex";
	static constexpr const char *Parameters = "string::VARCHAR\001blob::BLOB\001value::ANY";
	static constexpr const char *Description = "Converts the `string` to hexadecimal representation.\001Converts `blob` to `VARCHAR` using hexadecimal encoding.\001Converts the `value` to `VARCHAR` using hexadecimal representation.";
	static constexpr const char *Example = "hex('Hello')\001hex('\\xAA\\xBB'::BLOB)\001hex(42)";
	static constexpr const char *Categories = "string\001blob\001numeric";

	static ScalarFunctionSet GetFunctions();
};

struct ToHexFun {
	using ALIAS = HexFun;

	static constexpr const char *Name = "to_hex";
};

struct InstrFun {
	static constexpr const char *Name = "instr";
	static constexpr const char *Parameters = "string,search_string";
	static constexpr const char *Description = "Returns location of first occurrence of `search_string` in `string`, counting from 1. Returns 0 if no match found.";
	static constexpr const char *Example = "instr('test test', 'es')\002position('b' IN 'abc')";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct StrposFun {
	using ALIAS = InstrFun;

	static constexpr const char *Name = "strpos";
};

struct PositionFun {
	using ALIAS = InstrFun;

	static constexpr const char *Name = "position";
};

struct JaccardFun {
	static constexpr const char *Name = "jaccard";
	static constexpr const char *Parameters = "s1,s2";
	static constexpr const char *Description = "The Jaccard similarity between two strings. Characters of different cases (e.g., `a` and `A`) are considered different. Returns a number between 0 and 1.";
	static constexpr const char *Example = "jaccard('duck', 'luck')";
	static constexpr const char *Categories = "text_similarity";

	static ScalarFunction GetFunction();
};

struct JaroSimilarityFun {
	static constexpr const char *Name = "jaro_similarity";
	static constexpr const char *Parameters = "s1,s2,score_cutoff";
	static constexpr const char *Description = "The Jaro similarity between two strings. Characters of different cases (e.g., `a` and `A`) are considered different. Returns a number between 0 and 1. For similarity < `score_cutoff`, 0 is returned instead. `score_cutoff` defaults to 0.";
	static constexpr const char *Example = "jaro_similarity('duck', 'duckdb')";
	static constexpr const char *Categories = "text_similarity";

	static ScalarFunctionSet GetFunctions();
};

struct JaroWinklerSimilarityFun {
	static constexpr const char *Name = "jaro_winkler_similarity";
	static constexpr const char *Parameters = "s1,s2,score_cutoff";
	static constexpr const char *Description = "The Jaro-Winkler similarity between two strings. Characters of different cases (e.g., `a` and `A`) are considered different. Returns a number between 0 and 1. For similarity < `score_cutoff`, 0 is returned instead. `score_cutoff` defaults to 0.";
	static constexpr const char *Example = "jaro_winkler_similarity('duck', 'duckdb')";
	static constexpr const char *Categories = "text_similarity";

	static ScalarFunctionSet GetFunctions();
};

struct LeftFun {
	static constexpr const char *Name = "left";
	static constexpr const char *Parameters = "string,count";
	static constexpr const char *Description = "Extracts the left-most count characters.";
	static constexpr const char *Example = "left('Hello🦆', 2)";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct LeftGraphemeFun {
	static constexpr const char *Name = "left_grapheme";
	static constexpr const char *Parameters = "string,count";
	static constexpr const char *Description = "Extracts the left-most count grapheme clusters.";
	static constexpr const char *Example = "left_grapheme('🤦🏼‍♂️🤦🏽‍♀️', 1)";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct LevenshteinFun {
	static constexpr const char *Name = "levenshtein";
	static constexpr const char *Parameters = "s1,s2";
	static constexpr const char *Description = "The minimum number of single-character edits (insertions, deletions or substitutions) required to change one string to the other. Characters of different cases (e.g., `a` and `A`) are considered different.";
	static constexpr const char *Example = "levenshtein('duck', 'db')";
	static constexpr const char *Categories = "text_similarity";

	static ScalarFunction GetFunction();
};

struct Editdist3Fun {
	using ALIAS = LevenshteinFun;

	static constexpr const char *Name = "editdist3";
};

struct LpadFun {
	static constexpr const char *Name = "lpad";
	static constexpr const char *Parameters = "string,count,character";
	static constexpr const char *Description = "Pads the `string` with the `character` on the left until it has `count` characters. Truncates the `string` on the right if it has more than `count` characters.";
	static constexpr const char *Example = "lpad('hello', 8, '>')";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct LtrimFun {
	static constexpr const char *Name = "ltrim";
	static constexpr const char *Parameters = "string,characters";
	static constexpr const char *Description = "Removes any occurrences of any of the `characters` from the left side of the `string`. `characters` defaults to `space`.";
	static constexpr const char *Example = "ltrim('    test  ')\002ltrim('>>>>test<<', '><')";
	static constexpr const char *Categories = "string";

	static ScalarFunctionSet GetFunctions();
};

struct ParseDirnameFun {
	static constexpr const char *Name = "parse_dirname";
	static constexpr const char *Parameters = "path,separator";
	static constexpr const char *Description = "Returns the top-level directory name from the given `path`. `separator` options: `system`, `both_slash` (default), `forward_slash`, `backslash`.";
	static constexpr const char *Example = "parse_dirname('path/to/file.csv', 'system')";
	static constexpr const char *Categories = "string";

	static ScalarFunctionSet GetFunctions();
};

struct ParseDirpathFun {
	static constexpr const char *Name = "parse_dirpath";
	static constexpr const char *Parameters = "path,separator";
	static constexpr const char *Description = "Returns the head of the `path` (the pathname until the last slash) similarly to Python's `os.path.dirname`. `separator` options: `system`, `both_slash` (default), `forward_slash`, `backslash`.";
	static constexpr const char *Example = "parse_dirpath('path/to/file.csv', 'forward_slash')";
	static constexpr const char *Categories = "string";

	static ScalarFunctionSet GetFunctions();
};

struct ParseFilenameFun {
	static constexpr const char *Name = "parse_filename";
	static constexpr const char *Parameters = "string,trim_extension,separator";
	static constexpr const char *Description = "Returns the last component of the `path` similarly to Python's `os.path.basename` function. If `trim_extension` is `true`, the file extension will be removed (defaults to `false`). `separator` options: `system`, `both_slash` (default), `forward_slash`, `backslash`.";
	static constexpr const char *Example = "parse_filename('path/to/file.csv', true, 'forward_slash')";
	static constexpr const char *Categories = "string";

	static ScalarFunctionSet GetFunctions();
};

struct ParsePathFun {
	static constexpr const char *Name = "parse_path";
	static constexpr const char *Parameters = "path,separator";
	static constexpr const char *Description = "Returns a list of the components (directories and filename) in the `path` similarly to Python's `pathlib.parts` function. `separator` options: `system`, `both_slash` (default), `forward_slash`, `backslash`.";
	static constexpr const char *Example = "parse_path('path/to/file.csv', 'system')";
	static constexpr const char *Categories = "string";

	static ScalarFunctionSet GetFunctions();
};

struct PrintfFun {
	static constexpr const char *Name = "printf";
	static constexpr const char *Parameters = "format,parameters...";
	static constexpr const char *Description = "Formats a `string` using printf syntax.";
	static constexpr const char *Example = "printf('Benchmark \"%s\" took %d seconds', 'CSV', 42)";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct RepeatFun {
	static constexpr const char *Name = "repeat";
	static constexpr const char *Parameters = "string::VARCHAR,count::BIGINT\001list::ANY[],count::BIGINT\001blob::BLOB,count::BIGINT";
	static constexpr const char *Description = "Repeats the `string` `count` number of times.\001Repeats the `list` `count` number of times.\001Repeats the `blob` `count` number of times.";
	static constexpr const char *Example = "repeat('A', 5)\001repeat([1, 2, 3], 5)\001repeat('\\xAA\\xBB'::BLOB, 5)";
	static constexpr const char *Categories = "string\001list\001blob";

	static ScalarFunctionSet GetFunctions();
};

struct ReplaceFun {
	static constexpr const char *Name = "replace";
	static constexpr const char *Parameters = "string,source,target";
	static constexpr const char *Description = "Replaces any occurrences of the `source` with `target` in `string`.";
	static constexpr const char *Example = "replace('hello', 'l', '-')";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct ReverseFun {
	static constexpr const char *Name = "reverse";
	static constexpr const char *Parameters = "string";
	static constexpr const char *Description = "Reverses the `string`.";
	static constexpr const char *Example = "reverse('hello')";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct RightFun {
	static constexpr const char *Name = "right";
	static constexpr const char *Parameters = "string,count";
	static constexpr const char *Description = "Extract the right-most `count` characters.";
	static constexpr const char *Example = "right('Hello🦆', 3)";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct RightGraphemeFun {
	static constexpr const char *Name = "right_grapheme";
	static constexpr const char *Parameters = "string,count";
	static constexpr const char *Description = "Extracts the right-most `count` grapheme clusters.";
	static constexpr const char *Example = "right_grapheme('🤦🏼‍♂️🤦🏽‍♀️', 1)";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct RpadFun {
	static constexpr const char *Name = "rpad";
	static constexpr const char *Parameters = "string,count,character";
	static constexpr const char *Description = "Pads the `string` with the `character` on the right until it has `count` characters. Truncates the `string` on the right if it has more than `count` characters.";
	static constexpr const char *Example = "rpad('hello', 10, '<')";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct RtrimFun {
	static constexpr const char *Name = "rtrim";
	static constexpr const char *Parameters = "string,characters";
	static constexpr const char *Description = "Removes any occurrences of any of the `characters` from the right side of the `string`. `characters` defaults to `space`.";
	static constexpr const char *Example = "rtrim('    test  ')\002rtrim('>>>>test<<', '><')";
	static constexpr const char *Categories = "string";

	static ScalarFunctionSet GetFunctions();
};

struct TranslateFun {
	static constexpr const char *Name = "translate";
	static constexpr const char *Parameters = "string,from,to";
	static constexpr const char *Description = "Replaces each character in `string` that matches a character in the `from` set with the corresponding character in the `to` set. If `from` is longer than `to`, occurrences of the extra characters in `from` are deleted.";
	static constexpr const char *Example = "translate('12345', '143', 'ax')";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct TrimFun {
	static constexpr const char *Name = "trim";
	static constexpr const char *Parameters = "string,characters";
	static constexpr const char *Description = "Removes any occurrences of any of the `characters` from either side of the `string`. `characters` defaults to `space`.";
	static constexpr const char *Example = "trim('    test  ')\002trim('>>>>test<<', '><')";
	static constexpr const char *Categories = "string";

	static ScalarFunctionSet GetFunctions();
};

struct UnbinFun {
	static constexpr const char *Name = "unbin";
	static constexpr const char *Parameters = "value";
	static constexpr const char *Description = "Converts a `value` from binary representation to a blob.";
	static constexpr const char *Example = "unbin('0110')";
	static constexpr const char *Categories = "string,blob";

	static ScalarFunction GetFunction();
};

struct FromBinaryFun {
	using ALIAS = UnbinFun;

	static constexpr const char *Name = "from_binary";
};

struct UnhexFun {
	static constexpr const char *Name = "unhex";
	static constexpr const char *Parameters = "value";
	static constexpr const char *Description = "Converts a `value` from hexadecimal representation to a blob.";
	static constexpr const char *Example = "unhex('2A')";
	static constexpr const char *Categories = "string,blob";

	static ScalarFunction GetFunction();
};

struct FromHexFun {
	using ALIAS = UnhexFun;

	static constexpr const char *Name = "from_hex";
};

struct UnicodeFun {
	static constexpr const char *Name = "unicode";
	static constexpr const char *Parameters = "string";
	static constexpr const char *Description = "Returns an `INTEGER` representing the `unicode` codepoint of the first character in the `string`.";
	static constexpr const char *Example = "[unicode('âbcd'), unicode('â'), unicode(''), unicode(NULL)]";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct OrdFun {
	using ALIAS = UnicodeFun;

	static constexpr const char *Name = "ord";
};

struct ToBaseFun {
	static constexpr const char *Name = "to_base";
	static constexpr const char *Parameters = "number,radix,min_length";
	static constexpr const char *Description = "Converts `number` to a string in the given base `radix`, optionally padding with leading zeros to `min_length`.";
	static constexpr const char *Example = "to_base(42, 16, 5)";
	static constexpr const char *Categories = "string,numeric";

	static ScalarFunctionSet GetFunctions();
};

struct UrlEncodeFun {
	static constexpr const char *Name = "url_encode";
	static constexpr const char *Parameters = "string";
	static constexpr const char *Description = "Encodes a URL to a representation using Percent-Encoding.";
	static constexpr const char *Example = "url_encode('this string has/ special+ characters>')";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

struct UrlDecodeFun {
	static constexpr const char *Name = "url_decode";
	static constexpr const char *Parameters = "string";
	static constexpr const char *Description = "Decodes a URL from a representation using Percent-Encoding.";
	static constexpr const char *Example = "url_decode('https%3A%2F%2Fduckdb.org%2Fwhy_duckdb%23portable')";
	static constexpr const char *Categories = "string";

	static ScalarFunction GetFunction();
};

} // namespace duckdb
