// DO NOT EDIT! This test has been generated by /html/canvas/tools/gentest.py.
// OffscreenCanvas test in a worker:2d.path.isPointInStroke.scaleddashes
// Description:isPointInStroke() should return correct results on dashed paths at high scale factors
// Note:

importScripts("/resources/testharness.js");
importScripts("/html/canvas/resources/canvas-tests.js");

var t = async_test("isPointInStroke() should return correct results on dashed paths at high scale factors");
var t_pass = t.done.bind(t);
var t_fail = t.step_func(function(reason) {
    throw reason;
});
t.step(function() {

  var canvas = new OffscreenCanvas(100, 50);
  var ctx = canvas.getContext('2d');

  var scale = 20;
  ctx.setLineDash([10, 21.4159]); // dash from t=0 to t=10 along the circle
  ctx.scale(scale, scale);
  ctx.ellipse(6, 10, 5, 5, 0, 2*Math.PI, false);
  ctx.stroke();

  // hit-test the beginning of the dash (t=0)
  _assertSame(ctx.isPointInStroke(11*scale, 10*scale), true, "ctx.isPointInStroke(11*scale, 10*scale)", "true");
  // hit-test the middle of the dash (t=5)
  _assertSame(ctx.isPointInStroke(8.70*scale, 14.21*scale), true, "ctx.isPointInStroke(8.70*scale, 14.21*scale)", "true");
  // hit-test the end of the dash (t=9.8)
  _assertSame(ctx.isPointInStroke(4.10*scale, 14.63*scale), true, "ctx.isPointInStroke(4.10*scale, 14.63*scale)", "true");
  // hit-test past the end of the dash (t=10.2)
  _assertSame(ctx.isPointInStroke(3.74*scale, 14.46*scale), false, "ctx.isPointInStroke(3.74*scale, 14.46*scale)", "false");
  t.done();
});
done();
