/*****************************************************************************
 * @file    ble_core.h
 * @author  MCD Application Team
 * @brief   This file contains the definitions for BLE stack
 *****************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2019 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software component is licensed by ST under Ultimate Liberty license
 * SLA0044, the "License"; You may not use this file except in compliance with
 * the License. You may obtain a copy of the License at:
 *                             www.st.com/SLA0044
 *
 ******************************************************************************
 */

#ifndef BLE_CORE_H__
#define BLE_CORE_H__


/* BLE standard definitions */
#include "ble_std.h"

/* BLE API definitions */
#include "ble_defs.h"
#include "auto/ble_gap_aci.h"
#include "auto/ble_gatt_aci.h"
#include "auto/ble_hal_aci.h"
#include "auto/ble_hci_le.h"
#include "auto/ble_l2cap_aci.h"
#include "auto/ble_events.h"

/* BLE stack buffer size definitions */
#include "ble_bufsize.h"

/* BLE legacy definitions */
#include "ble_legacy.h"


#endif /* ! BLE_CORE_H__ */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE***/
