// Code generated by openapi-cli-generator. DO NOT EDIT.
// See https://github.com/exoscale/openapi-cli-generator

package x

import (
	"fmt"
	"strings"

	"github.com/exoscale/openapi-cli-generator/cli"
	"github.com/pkg/errors"
	"github.com/rs/zerolog/log"
	"github.com/spf13/cobra"
	"github.com/spf13/viper"
	"gopkg.in/h2non/gentleman.v2"
)

var xSubcommand bool

func xServers() []map[string]string {
	return []map[string]string{

		map[string]string{
			"description": "",
			"url":         "https://api-{zone}.exoscale.com/v2",
		},
	}
}

// XCreateAntiAffinityGroup Create an Anti-affinity Group
func XCreateAntiAffinityGroup(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-anti-affinity-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/anti-affinity-group"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListAntiAffinityGroups List Anti-affinity Groups
func XListAntiAffinityGroups(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-anti-affinity-groups"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/anti-affinity-group"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteAntiAffinityGroup Delete an Anti-affinity Group
func XDeleteAntiAffinityGroup(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-anti-affinity-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/anti-affinity-group/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetAntiAffinityGroup Retrieve Anti-affinity Group details
func XGetAntiAffinityGroup(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-anti-affinity-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/anti-affinity-group/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateApiKey Create a new API key
func XCreateApiKey(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-api-key"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/api-key"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListApiKeys List API keys
func XListApiKeys(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-api-keys"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/api-key"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteApiKey Delete an API key
func XDeleteApiKey(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-api-key"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/api-key/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetApiKey Get API key
func XGetApiKey(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-api-key"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/api-key/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateBlockStorageVolume Create a block storage volume
func XCreateBlockStorageVolume(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-block-storage-volume"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/block-storage"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListBlockStorageVolumes List block storage volumes
func XListBlockStorageVolumes(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-block-storage-volumes"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/block-storage"

	req := cli.Client.Get().URL(url)

	paramInstanceId := params.GetString("instance-id")
	if paramInstanceId != "" {
		req = req.AddQuery("instance-id", fmt.Sprintf("%v", paramInstanceId))
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListBlockStorageSnapshots List block storage snapshots
func XListBlockStorageSnapshots(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-block-storage-snapshots"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/block-storage-snapshot"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteBlockStorageSnapshot Delete a block storage snapshot, data will be unrecoverable
func XDeleteBlockStorageSnapshot(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-block-storage-snapshot"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/block-storage-snapshot/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetBlockStorageSnapshot Retrieve block storage snapshot details
func XGetBlockStorageSnapshot(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-block-storage-snapshot"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/block-storage-snapshot/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateBlockStorageSnapshot Update block storage volume snapshot
func XUpdateBlockStorageSnapshot(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-block-storage-snapshot"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/block-storage-snapshot/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteBlockStorageVolume Delete a block storage volume, data will be unrecoverable
func XDeleteBlockStorageVolume(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-block-storage-volume"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/block-storage/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetBlockStorageVolume Retrieve block storage volume details
func XGetBlockStorageVolume(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-block-storage-volume"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/block-storage/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateBlockStorageVolume Update block storage volume
func XUpdateBlockStorageVolume(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-block-storage-volume"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/block-storage/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XAttachBlockStorageVolumeToInstance Attach block storage volume to an instance
func XAttachBlockStorageVolumeToInstance(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "attach-block-storage-volume-to-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/block-storage/{id}:attach"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateBlockStorageSnapshot Create a block storage snapshot
func XCreateBlockStorageSnapshot(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-block-storage-snapshot"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/block-storage/{id}:create-snapshot"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDetachBlockStorageVolume Detach block storage volume
func XDetachBlockStorageVolume(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "detach-block-storage-volume"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/block-storage/{id}:detach"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResizeBlockStorageVolume Resize a block storage volume
func XResizeBlockStorageVolume(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "resize-block-storage-volume"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/block-storage/{id}:resize-volume"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetConsoleProxyUrl Retrieve signed url valid for 60 seconds to connect via console-proxy websocket to VM VNC console.
func XGetConsoleProxyUrl(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-console-proxy-url"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/console/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasCaCertificate Get DBaaS CA Certificate
func XGetDbaasCaCertificate(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-ca-certificate"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-ca-certificate"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasExternalEndpointDatadog delete-dbaas-external-endpoint-datadog
func XDeleteDbaasExternalEndpointDatadog(paramEndpointId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-external-endpoint-datadog"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-datadog/{endpoint-id}"
	url = strings.Replace(url, "{endpoint-id}", paramEndpointId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasExternalEndpointDatadog get-dbaas-external-endpoint-datadog
func XGetDbaasExternalEndpointDatadog(paramEndpointId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-external-endpoint-datadog"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-datadog/{endpoint-id}"
	url = strings.Replace(url, "{endpoint-id}", paramEndpointId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasExternalEndpointDatadog update-dbaas-external-endpoint-datadog
func XUpdateDbaasExternalEndpointDatadog(paramEndpointId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-external-endpoint-datadog"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-datadog/{endpoint-id}"
	url = strings.Replace(url, "{endpoint-id}", paramEndpointId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasExternalEndpointDatadog create-dbaas-external-endpoint-datadog
func XCreateDbaasExternalEndpointDatadog(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-external-endpoint-datadog"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-datadog/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasExternalEndpointElasticsearch delete-dbaas-external-endpoint-elasticsearch
func XDeleteDbaasExternalEndpointElasticsearch(paramEndpointId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-external-endpoint-elasticsearch"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-elasticsearch/{endpoint-id}"
	url = strings.Replace(url, "{endpoint-id}", paramEndpointId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasExternalEndpointElasticsearch get-dbaas-external-endpoint-elasticsearch
func XGetDbaasExternalEndpointElasticsearch(paramEndpointId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-external-endpoint-elasticsearch"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-elasticsearch/{endpoint-id}"
	url = strings.Replace(url, "{endpoint-id}", paramEndpointId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasExternalEndpointElasticsearch update-dbaas-external-endpoint-elasticsearch
func XUpdateDbaasExternalEndpointElasticsearch(paramEndpointId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-external-endpoint-elasticsearch"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-elasticsearch/{endpoint-id}"
	url = strings.Replace(url, "{endpoint-id}", paramEndpointId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasExternalEndpointElasticsearch create-dbaas-external-endpoint-elasticsearch
func XCreateDbaasExternalEndpointElasticsearch(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-external-endpoint-elasticsearch"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-elasticsearch/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasExternalEndpointOpensearch delete-dbaas-external-endpoint-opensearch
func XDeleteDbaasExternalEndpointOpensearch(paramEndpointId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-external-endpoint-opensearch"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-opensearch/{endpoint-id}"
	url = strings.Replace(url, "{endpoint-id}", paramEndpointId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasExternalEndpointOpensearch get-dbaas-external-endpoint-opensearch
func XGetDbaasExternalEndpointOpensearch(paramEndpointId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-external-endpoint-opensearch"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-opensearch/{endpoint-id}"
	url = strings.Replace(url, "{endpoint-id}", paramEndpointId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasExternalEndpointOpensearch update-dbaas-external-endpoint-opensearch
func XUpdateDbaasExternalEndpointOpensearch(paramEndpointId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-external-endpoint-opensearch"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-opensearch/{endpoint-id}"
	url = strings.Replace(url, "{endpoint-id}", paramEndpointId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasExternalEndpointOpensearch create-dbaas-external-endpoint-opensearch
func XCreateDbaasExternalEndpointOpensearch(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-external-endpoint-opensearch"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-opensearch/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasExternalEndpointPrometheus delete-dbaas-external-endpoint-prometheus
func XDeleteDbaasExternalEndpointPrometheus(paramEndpointId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-external-endpoint-prometheus"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-prometheus/{endpoint-id}"
	url = strings.Replace(url, "{endpoint-id}", paramEndpointId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasExternalEndpointPrometheus get-dbaas-external-endpoint-prometheus
func XGetDbaasExternalEndpointPrometheus(paramEndpointId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-external-endpoint-prometheus"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-prometheus/{endpoint-id}"
	url = strings.Replace(url, "{endpoint-id}", paramEndpointId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasExternalEndpointPrometheus update-dbaas-external-endpoint-prometheus
func XUpdateDbaasExternalEndpointPrometheus(paramEndpointId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-external-endpoint-prometheus"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-prometheus/{endpoint-id}"
	url = strings.Replace(url, "{endpoint-id}", paramEndpointId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasExternalEndpointPrometheus create-dbaas-external-endpoint-prometheus
func XCreateDbaasExternalEndpointPrometheus(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-external-endpoint-prometheus"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-prometheus/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasExternalEndpointRsyslog delete-dbaas-external-endpoint-rsyslog
func XDeleteDbaasExternalEndpointRsyslog(paramEndpointId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-external-endpoint-rsyslog"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-rsyslog/{endpoint-id}"
	url = strings.Replace(url, "{endpoint-id}", paramEndpointId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasExternalEndpointRsyslog get-dbaas-external-endpoint-rsyslog
func XGetDbaasExternalEndpointRsyslog(paramEndpointId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-external-endpoint-rsyslog"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-rsyslog/{endpoint-id}"
	url = strings.Replace(url, "{endpoint-id}", paramEndpointId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasExternalEndpointRsyslog update-dbaas-external-endpoint-rsyslog
func XUpdateDbaasExternalEndpointRsyslog(paramEndpointId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-external-endpoint-rsyslog"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-rsyslog/{endpoint-id}"
	url = strings.Replace(url, "{endpoint-id}", paramEndpointId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasExternalEndpointRsyslog create-dbaas-external-endpoint-rsyslog
func XCreateDbaasExternalEndpointRsyslog(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-external-endpoint-rsyslog"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-rsyslog/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListDbaasExternalEndpointTypes list-dbaas-external-endpoint-types
func XListDbaasExternalEndpointTypes(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-dbaas-external-endpoint-types"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint-types"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XAttachDbaasServiceToEndpoint attach-dbaas-service-to-endpoint
func XAttachDbaasServiceToEndpoint(paramSourceServiceName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "attach-dbaas-service-to-endpoint"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint/{source-service-name}/attach"
	url = strings.Replace(url, "{source-service-name}", paramSourceServiceName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDetachDbaasServiceFromEndpoint detach-dbaas-service-from-endpoint
func XDetachDbaasServiceFromEndpoint(paramSourceServiceName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "detach-dbaas-service-from-endpoint"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoint/{source-service-name}/detach"
	url = strings.Replace(url, "{source-service-name}", paramSourceServiceName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListDbaasExternalEndpoints list-dbaas-external-endpoints
func XListDbaasExternalEndpoints(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-dbaas-external-endpoints"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-endpoints"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasExternalIntegrationSettingsDatadog get-dbaas-external-integration-settings-datadog
func XGetDbaasExternalIntegrationSettingsDatadog(paramIntegrationId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-external-integration-settings-datadog"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-integration-settings-datadog/{integration-id}"
	url = strings.Replace(url, "{integration-id}", paramIntegrationId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasExternalIntegrationSettingsDatadog update-dbaas-external-integration-settings-datadog
func XUpdateDbaasExternalIntegrationSettingsDatadog(paramIntegrationId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-external-integration-settings-datadog"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-integration-settings-datadog/{integration-id}"
	url = strings.Replace(url, "{integration-id}", paramIntegrationId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasExternalIntegration get-dbaas-external-integration
func XGetDbaasExternalIntegration(paramIntegrationId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-external-integration"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-integration/{integration-id}"
	url = strings.Replace(url, "{integration-id}", paramIntegrationId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListDbaasExternalIntegrations list-dbaas-external-integrations
func XListDbaasExternalIntegrations(paramServiceName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-dbaas-external-integrations"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-external-integrations/{service-name}"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasServiceGrafana create-dbaas-service-grafana
func XCreateDbaasServiceGrafana(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-service-grafana"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-grafana/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasServiceGrafana Delete a Grafana service
func XDeleteDbaasServiceGrafana(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-service-grafana"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-grafana/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasServiceGrafana Get a DBaaS Grafana service
func XGetDbaasServiceGrafana(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-service-grafana"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-grafana/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasServiceGrafana Update a DBaaS Grafana service
func XUpdateDbaasServiceGrafana(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-service-grafana"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-grafana/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XStartDbaasGrafanaMaintenance Initiate Grafana maintenance update
func XStartDbaasGrafanaMaintenance(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "start-dbaas-grafana-maintenance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-grafana/{name}/maintenance/start"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetDbaasGrafanaUserPassword Reset the credentials of a DBaaS Grafana user
func XResetDbaasGrafanaUserPassword(paramServiceName string, paramUsername string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-dbaas-grafana-user-password"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-grafana/{service-name}/user/{username}/password/reset"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRevealDbaasGrafanaUserPassword Reveal the secrets of a DBaaS Grafana user
func XRevealDbaasGrafanaUserPassword(paramServiceName string, paramUsername string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reveal-dbaas-grafana-user-password"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-grafana/{service-name}/user/{username}/password/reveal"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasIntegration create-dbaas-integration
func XCreateDbaasIntegration(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-integration"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-integration"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListDbaasIntegrationSettings list-dbaas-integration-settings
func XListDbaasIntegrationSettings(paramIntegrationType string, paramSourceType string, paramDestType string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-dbaas-integration-settings"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-integration-settings/{integration-type}/{source-type}/{dest-type}"
	url = strings.Replace(url, "{integration-type}", paramIntegrationType, 1)
	url = strings.Replace(url, "{source-type}", paramSourceType, 1)
	url = strings.Replace(url, "{dest-type}", paramDestType, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListDbaasIntegrationTypes list-dbaas-integration-types
func XListDbaasIntegrationTypes(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-dbaas-integration-types"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-integration-types"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasIntegration delete-dbaas-integration
func XDeleteDbaasIntegration(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-integration"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-integration/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasIntegration get-dbaas-integration
func XGetDbaasIntegration(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-integration"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-integration/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasIntegration update-dbaas-integration
func XUpdateDbaasIntegration(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-integration"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-integration/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasServiceKafka Create a DBaaS Kafka service
func XCreateDbaasServiceKafka(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-service-kafka"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasServiceKafka Delete a Kafka service
func XDeleteDbaasServiceKafka(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-service-kafka"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasServiceKafka Get a DBaaS Kafka service
func XGetDbaasServiceKafka(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-service-kafka"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasServiceKafka Update a DBaaS Kafka service
func XUpdateDbaasServiceKafka(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-service-kafka"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasKafkaAclConfig Get DBaaS kafka ACL configuration
func XGetDbaasKafkaAclConfig(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-kafka-acl-config"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{name}/acl-config"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XStartDbaasKafkaMaintenance Initiate Kafka maintenance update
func XStartDbaasKafkaMaintenance(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "start-dbaas-kafka-maintenance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{name}/maintenance/start"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasKafkaSchemaRegistryAclConfig Add a Kafka Schema Registry ACL entry
func XCreateDbaasKafkaSchemaRegistryAclConfig(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-kafka-schema-registry-acl-config"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{name}/schema-registry/acl-config"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasKafkaSchemaRegistryAclConfig Delete a Kafka ACL entry
func XDeleteDbaasKafkaSchemaRegistryAclConfig(paramName string, paramAclId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-kafka-schema-registry-acl-config"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{name}/schema-registry/acl-config/{acl-id}"
	url = strings.Replace(url, "{name}", paramName, 1)
	url = strings.Replace(url, "{acl-id}", paramAclId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasKafkaTopicAclConfig Add a Kafka topic ACL entry
func XCreateDbaasKafkaTopicAclConfig(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-kafka-topic-acl-config"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{name}/topic/acl-config"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasKafkaTopicAclConfig Delete a Kafka ACL entry
func XDeleteDbaasKafkaTopicAclConfig(paramName string, paramAclId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-kafka-topic-acl-config"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{name}/topic/acl-config/{acl-id}"
	url = strings.Replace(url, "{name}", paramName, 1)
	url = strings.Replace(url, "{acl-id}", paramAclId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRevealDbaasKafkaConnectPassword Reveal the secrets for DBaaS Kafka Connect
func XRevealDbaasKafkaConnectPassword(paramServiceName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reveal-dbaas-kafka-connect-password"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{service-name}/connect/password/reveal"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasKafkaUser Create a DBaaS Kafka user
func XCreateDbaasKafkaUser(paramServiceName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-kafka-user"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{service-name}/user"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasKafkaUser Delete a DBaaS kafka user
func XDeleteDbaasKafkaUser(paramServiceName string, paramUsername string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-kafka-user"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{service-name}/user/{username}"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetDbaasKafkaUserPassword Reset the credentials of a DBaaS Kafka user
func XResetDbaasKafkaUserPassword(paramServiceName string, paramUsername string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-dbaas-kafka-user-password"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{service-name}/user/{username}/password/reset"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRevealDbaasKafkaUserPassword Reveal the secrets of a DBaaS Kafka user
func XRevealDbaasKafkaUserPassword(paramServiceName string, paramUsername string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reveal-dbaas-kafka-user-password"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-kafka/{service-name}/user/{username}/password/reveal"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasMigrationStatus Get a DBaaS migration status
func XGetDbaasMigrationStatus(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-migration-status"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-migration-status/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasServiceMysql Create a DBaaS MySQL service
func XCreateDbaasServiceMysql(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-service-mysql"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-mysql/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasServiceMysql Delete a MySQL service
func XDeleteDbaasServiceMysql(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-service-mysql"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-mysql/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasServiceMysql Get a DBaaS MySQL service
func XGetDbaasServiceMysql(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-service-mysql"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-mysql/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasServiceMysql Update a DBaaS MySQL service
func XUpdateDbaasServiceMysql(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-service-mysql"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-mysql/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XEnableDbaasMysqlWrites Temporarily enable writes for MySQL services in read-only mode due to filled up storage
func XEnableDbaasMysqlWrites(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "enable-dbaas-mysql-writes"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-mysql/{name}/enable/writes"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XStartDbaasMysqlMaintenance Initiate MySQL maintenance update
func XStartDbaasMysqlMaintenance(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "start-dbaas-mysql-maintenance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-mysql/{name}/maintenance/start"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XStopDbaasMysqlMigration Stop a DBaaS MySQL migration
func XStopDbaasMysqlMigration(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "stop-dbaas-mysql-migration"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-mysql/{name}/migration/stop"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasMysqlDatabase Create a DBaaS MySQL database
func XCreateDbaasMysqlDatabase(paramServiceName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-mysql-database"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-mysql/{service-name}/database"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasMysqlDatabase Delete a DBaaS MySQL database
func XDeleteDbaasMysqlDatabase(paramServiceName string, paramDatabaseName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-mysql-database"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-mysql/{service-name}/database/{database-name}"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{database-name}", paramDatabaseName, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasMysqlUser Create a DBaaS MySQL user
func XCreateDbaasMysqlUser(paramServiceName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-mysql-user"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-mysql/{service-name}/user"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasMysqlUser Delete a DBaaS MySQL user
func XDeleteDbaasMysqlUser(paramServiceName string, paramUsername string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-mysql-user"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-mysql/{service-name}/user/{username}"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetDbaasMysqlUserPassword Reset the credentials of a DBaaS mysql user
func XResetDbaasMysqlUserPassword(paramServiceName string, paramUsername string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-dbaas-mysql-user-password"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-mysql/{service-name}/user/{username}/password/reset"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRevealDbaasMysqlUserPassword Reveal the secrets of a DBaaS MySQL user
func XRevealDbaasMysqlUserPassword(paramServiceName string, paramUsername string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reveal-dbaas-mysql-user-password"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-mysql/{service-name}/user/{username}/password/reveal"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasServiceOpensearch Create a DBaaS OpenSearch service
func XCreateDbaasServiceOpensearch(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-service-opensearch"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-opensearch/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasServiceOpensearch Delete a OpenSearch service
func XDeleteDbaasServiceOpensearch(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-service-opensearch"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-opensearch/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasServiceOpensearch Get a DBaaS OpenSearch service
func XGetDbaasServiceOpensearch(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-service-opensearch"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-opensearch/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasServiceOpensearch Update a DBaaS OpenSearch service
func XUpdateDbaasServiceOpensearch(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-service-opensearch"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-opensearch/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasOpensearchAclConfig Get DBaaS OpenSearch ACL configuration
func XGetDbaasOpensearchAclConfig(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-opensearch-acl-config"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-opensearch/{name}/acl-config"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasOpensearchAclConfig Create a DBaaS OpenSearch ACL configuration
func XUpdateDbaasOpensearchAclConfig(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-opensearch-acl-config"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-opensearch/{name}/acl-config"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XStartDbaasOpensearchMaintenance Initiate OpenSearch maintenance update
func XStartDbaasOpensearchMaintenance(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "start-dbaas-opensearch-maintenance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-opensearch/{name}/maintenance/start"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasOpensearchUser Create a DBaaS OpenSearch user
func XCreateDbaasOpensearchUser(paramServiceName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-opensearch-user"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-opensearch/{service-name}/user"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasOpensearchUser Delete a DBaaS OpenSearch user
func XDeleteDbaasOpensearchUser(paramServiceName string, paramUsername string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-opensearch-user"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-opensearch/{service-name}/user/{username}"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetDbaasOpensearchUserPassword Reset the credentials of a DBaaS OpenSearch user
func XResetDbaasOpensearchUserPassword(paramServiceName string, paramUsername string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-dbaas-opensearch-user-password"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-opensearch/{service-name}/user/{username}/password/reset"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRevealDbaasOpensearchUserPassword Reveal the secrets of a DBaaS OpenSearch user
func XRevealDbaasOpensearchUserPassword(paramServiceName string, paramUsername string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reveal-dbaas-opensearch-user-password"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-opensearch/{service-name}/user/{username}/password/reveal"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasServicePg Create a DBaaS PostgreSQL service
func XCreateDbaasServicePg(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-service-pg"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasServicePg Delete a Postgres service
func XDeleteDbaasServicePg(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-service-pg"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasServicePg Get a DBaaS PostgreSQL service
func XGetDbaasServicePg(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-service-pg"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasServicePg Update a DBaaS PostgreSQL service
func XUpdateDbaasServicePg(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-service-pg"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XStartDbaasPgMaintenance Initiate PostgreSQL maintenance update
func XStartDbaasPgMaintenance(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "start-dbaas-pg-maintenance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{name}/maintenance/start"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XStopDbaasPgMigration Stop a DBaaS PostgreSQL migration
func XStopDbaasPgMigration(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "stop-dbaas-pg-migration"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{name}/migration/stop"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasPgConnectionPool Create a DBaaS PostgreSQL connection pool
func XCreateDbaasPgConnectionPool(paramServiceName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-pg-connection-pool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{service-name}/connection-pool"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasPgConnectionPool Delete a DBaaS PostgreSQL connection pool
func XDeleteDbaasPgConnectionPool(paramServiceName string, paramConnectionPoolName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-pg-connection-pool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{service-name}/connection-pool/{connection-pool-name}"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{connection-pool-name}", paramConnectionPoolName, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasPgConnectionPool Update a DBaaS PostgreSQL connection pool
func XUpdateDbaasPgConnectionPool(paramServiceName string, paramConnectionPoolName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-pg-connection-pool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{service-name}/connection-pool/{connection-pool-name}"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{connection-pool-name}", paramConnectionPoolName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasPgDatabase Create a DBaaS Postgres database
func XCreateDbaasPgDatabase(paramServiceName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-pg-database"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{service-name}/database"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasPgDatabase Delete a DBaaS Postgres database
func XDeleteDbaasPgDatabase(paramServiceName string, paramDatabaseName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-pg-database"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{service-name}/database/{database-name}"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{database-name}", paramDatabaseName, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasPostgresUser Create a DBaaS Postgres user
func XCreateDbaasPostgresUser(paramServiceName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-postgres-user"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{service-name}/user"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasPostgresUser Delete a DBaaS Postgres user
func XDeleteDbaasPostgresUser(paramServiceName string, paramUsername string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-postgres-user"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{service-name}/user/{username}"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasPostgresAllowReplication Update access control for one service user
func XUpdateDbaasPostgresAllowReplication(paramServiceName string, paramUsername string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-postgres-allow-replication"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{service-name}/user/{username}/allow-replication"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetDbaasPostgresUserPassword Reset the credentials of a DBaaS Postgres user
func XResetDbaasPostgresUserPassword(paramServiceName string, paramUsername string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-dbaas-postgres-user-password"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{service-name}/user/{username}/password/reset"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRevealDbaasPostgresUserPassword Reveal the secrets of a DBaaS Postgres user
func XRevealDbaasPostgresUserPassword(paramServiceName string, paramUsername string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reveal-dbaas-postgres-user-password"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{service-name}/user/{username}/password/reveal"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasPgUpgradeCheck create-dbaas-pg-upgrade-check
func XCreateDbaasPgUpgradeCheck(paramService string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-pg-upgrade-check"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-postgres/{service}/upgrade-check"
	url = strings.Replace(url, "{service}", paramService, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListDbaasServices List DBaaS services
func XListDbaasServices(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-dbaas-services"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-service"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasServiceLogs Get logs of DBaaS service
func XGetDbaasServiceLogs(paramServiceName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-service-logs"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-service-logs/{service-name}"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasServiceMetrics Get metrics of DBaaS service
func XGetDbaasServiceMetrics(paramServiceName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-service-metrics"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-service-metrics/{service-name}"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListDbaasServiceTypes DBaaS Service Types
func XListDbaasServiceTypes(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-dbaas-service-types"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-service-type"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasServiceType Get a DBaaS service type
func XGetDbaasServiceType(paramServiceTypeName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-service-type"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-service-type/{service-type-name}"
	url = strings.Replace(url, "{service-type-name}", paramServiceTypeName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasService Delete a DBaaS service
func XDeleteDbaasService(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-service"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-service/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasSettingsGrafana Get DBaaS Grafana settings
func XGetDbaasSettingsGrafana(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-settings-grafana"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-settings-grafana"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasSettingsKafka Get DBaaS Kafka settings
func XGetDbaasSettingsKafka(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-settings-kafka"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-settings-kafka"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasSettingsMysql Get DBaaS MySQL settings
func XGetDbaasSettingsMysql(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-settings-mysql"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-settings-mysql"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasSettingsOpensearch Get DBaaS OpenSearch settings
func XGetDbaasSettingsOpensearch(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-settings-opensearch"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-settings-opensearch"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasSettingsPg Get DBaaS PostgreSQL settings
func XGetDbaasSettingsPg(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-settings-pg"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-settings-pg"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasSettingsValkey Get DBaaS Valkey settings
func XGetDbaasSettingsValkey(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-settings-valkey"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-settings-valkey"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasTaskMigrationCheck create-dbaas-task-migration-check
func XCreateDbaasTaskMigrationCheck(paramService string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-task-migration-check"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-task-migration-check/{service}"
	url = strings.Replace(url, "{service}", paramService, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasTask Get a DBaaS task
func XGetDbaasTask(paramService string, paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-task"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-task/{service}/{id}"
	url = strings.Replace(url, "{service}", paramService, 1)
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasServiceValkey Create a DBaaS Valkey service
func XCreateDbaasServiceValkey(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-service-valkey"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-valkey/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasServiceValkey Delete a Valkey service
func XDeleteDbaasServiceValkey(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-service-valkey"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-valkey/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDbaasServiceValkey get-dbaas-service-valkey
func XGetDbaasServiceValkey(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dbaas-service-valkey"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-valkey/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDbaasServiceValkey update-dbaas-service-valkey
func XUpdateDbaasServiceValkey(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dbaas-service-valkey"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-valkey/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XStartDbaasValkeyMaintenance Initiate Valkey maintenance update
func XStartDbaasValkeyMaintenance(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "start-dbaas-valkey-maintenance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-valkey/{name}/maintenance/start"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XStopDbaasValkeyMigration Stop a DBaaS Valkey migration
func XStopDbaasValkeyMigration(paramName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "stop-dbaas-valkey-migration"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-valkey/{name}/migration/stop"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDbaasValkeyUser Create a DBaaS Valkey user
func XCreateDbaasValkeyUser(paramServiceName string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dbaas-valkey-user"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-valkey/{service-name}/user"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDbaasValkeyUser Delete a DBaaS Valkey user
func XDeleteDbaasValkeyUser(paramServiceName string, paramUsername string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dbaas-valkey-user"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-valkey/{service-name}/user/{username}"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetDbaasValkeyUserPassword Reset the credentials of a DBaaS Valkey user
func XResetDbaasValkeyUserPassword(paramServiceName string, paramUsername string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-dbaas-valkey-user-password"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-valkey/{service-name}/user/{username}/password/reset"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRevealDbaasValkeyUserPassword Reveal the secrets of a DBaaS Valkey user
func XRevealDbaasValkeyUserPassword(paramServiceName string, paramUsername string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reveal-dbaas-valkey-user-password"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dbaas-valkey/{service-name}/user/{username}/password/reveal"
	url = strings.Replace(url, "{service-name}", paramServiceName, 1)
	url = strings.Replace(url, "{username}", paramUsername, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListDeployTargets List Deploy Targets
func XListDeployTargets(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-deploy-targets"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/deploy-target"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDeployTarget Retrieve Deploy Target details
func XGetDeployTarget(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-deploy-target"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/deploy-target/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDnsDomain Create DNS domain
func XCreateDnsDomain(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dns-domain"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dns-domain"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListDnsDomains List DNS domains
func XListDnsDomains(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-dns-domains"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dns-domain"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateDnsDomainRecord Create DNS domain record
func XCreateDnsDomainRecord(paramDomainId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-dns-domain-record"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dns-domain/{domain-id}/record"
	url = strings.Replace(url, "{domain-id}", paramDomainId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListDnsDomainRecords List DNS domain records
func XListDnsDomainRecords(paramDomainId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-dns-domain-records"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dns-domain/{domain-id}/record"
	url = strings.Replace(url, "{domain-id}", paramDomainId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDnsDomainRecord Delete DNS domain record
func XDeleteDnsDomainRecord(paramDomainId string, paramRecordId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dns-domain-record"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dns-domain/{domain-id}/record/{record-id}"
	url = strings.Replace(url, "{domain-id}", paramDomainId, 1)
	url = strings.Replace(url, "{record-id}", paramRecordId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDnsDomainRecord Retrieve DNS domain record details
func XGetDnsDomainRecord(paramDomainId string, paramRecordId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dns-domain-record"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dns-domain/{domain-id}/record/{record-id}"
	url = strings.Replace(url, "{domain-id}", paramDomainId, 1)
	url = strings.Replace(url, "{record-id}", paramRecordId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateDnsDomainRecord Update DNS domain record
func XUpdateDnsDomainRecord(paramDomainId string, paramRecordId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-dns-domain-record"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dns-domain/{domain-id}/record/{record-id}"
	url = strings.Replace(url, "{domain-id}", paramDomainId, 1)
	url = strings.Replace(url, "{record-id}", paramRecordId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteDnsDomain Delete DNS Domain
func XDeleteDnsDomain(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-dns-domain"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dns-domain/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDnsDomain Retrieve DNS domain details
func XGetDnsDomain(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dns-domain"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dns-domain/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetDnsDomainZoneFile Retrieve DNS domain zone file
func XGetDnsDomainZoneFile(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-dns-domain-zone-file"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/dns-domain/{id}/zone"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateElasticIp Create an Elastic IP
func XCreateElasticIp(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-elastic-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/elastic-ip"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListElasticIps List Elastic IPs
func XListElasticIps(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-elastic-ips"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/elastic-ip"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteElasticIp Delete an Elastic IP
func XDeleteElasticIp(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-elastic-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/elastic-ip/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetElasticIp Retrieve Elastic IP details
func XGetElasticIp(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-elastic-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/elastic-ip/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateElasticIp Update an Elastic IP
func XUpdateElasticIp(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-elastic-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/elastic-ip/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetElasticIpField Reset an Elastic IP field to its default value
func XResetElasticIpField(paramId string, paramField string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-elastic-ip-field"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/elastic-ip/{id}/{field}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{field}", paramField, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XAttachInstanceToElasticIp Attach a Compute instance to an Elastic IP
func XAttachInstanceToElasticIp(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "attach-instance-to-elastic-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/elastic-ip/{id}:attach"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDetachInstanceFromElasticIp Detach a Compute instance from an Elastic IP
func XDetachInstanceFromElasticIp(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "detach-instance-from-elastic-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/elastic-ip/{id}:detach"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetEnvImpact [BETA] Retrieve organization environmental impact reports
func XGetEnvImpact(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-env-impact"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/env-impact"

	req := cli.Client.Get().URL(url)

	paramPeriod := params.GetString("period")
	if paramPeriod != "" {
		req = req.AddQuery("period", fmt.Sprintf("%v", paramPeriod))
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListEvents List Events
func XListEvents(params *viper.Viper) (*gentleman.Response, interface{}, error) {
	handlerPath := "list-events"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/event"

	req := cli.Client.Get().URL(url)

	paramFrom := params.GetString("from")
	if paramFrom != "" {
		req = req.AddQuery("from", fmt.Sprintf("%v", paramFrom))
	}
	paramTo := params.GetString("to")
	if paramTo != "" {
		req = req.AddQuery("to", fmt.Sprintf("%v", paramTo))
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after
	}

	return resp, decoded, nil
}

// XGetIamOrganizationPolicy Retrieve IAM Organization Policy
func XGetIamOrganizationPolicy(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-iam-organization-policy"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/iam-organization-policy"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateIamOrganizationPolicy Update IAM Organization Policy
func XUpdateIamOrganizationPolicy(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-iam-organization-policy"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/iam-organization-policy"

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetIamOrganizationPolicy Reset IAM Organization Policy
func XResetIamOrganizationPolicy(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-iam-organization-policy"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/iam-organization-policy:reset"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateIamRole Create IAM Role
func XCreateIamRole(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-iam-role"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/iam-role"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListIamRoles List IAM Roles
func XListIamRoles(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-iam-roles"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/iam-role"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteIamRole Delete IAM Role
func XDeleteIamRole(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-iam-role"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/iam-role/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetIamRole Retrieve IAM Role
func XGetIamRole(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-iam-role"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/iam-role/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateIamRole Update IAM Role
func XUpdateIamRole(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-iam-role"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/iam-role/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateIamRolePolicy Update IAM Role Policy
func XUpdateIamRolePolicy(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-iam-role-policy"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/iam-role/{id}:policy"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateInstance Create a Compute instance
func XCreateInstance(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListInstances List Compute instances
func XListInstances(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-instances"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance"

	req := cli.Client.Get().URL(url)

	paramManagerId := params.GetString("manager-id")
	if paramManagerId != "" {
		req = req.AddQuery("manager-id", fmt.Sprintf("%v", paramManagerId))
	}
	paramManagerType := params.GetString("manager-type")
	if paramManagerType != "" {
		req = req.AddQuery("manager-type", fmt.Sprintf("%v", paramManagerType))
	}
	paramIpAddress := params.GetString("ip-address")
	if paramIpAddress != "" {
		req = req.AddQuery("ip-address", fmt.Sprintf("%v", paramIpAddress))
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateInstancePool Create an Instance Pool
func XCreateInstancePool(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-instance-pool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-pool"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListInstancePools List Instance Pools
func XListInstancePools(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-instance-pools"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-pool"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteInstancePool Delete an Instance Pool
func XDeleteInstancePool(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-instance-pool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-pool/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetInstancePool Retrieve Instance Pool details
func XGetInstancePool(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-instance-pool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-pool/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateInstancePool Update an Instance Pool
func XUpdateInstancePool(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-instance-pool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-pool/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetInstancePoolField Reset an Instance Pool field to its default value
func XResetInstancePoolField(paramId string, paramField string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-instance-pool-field"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-pool/{id}/{field}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{field}", paramField, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XEvictInstancePoolMembers Evict Instance Pool members
func XEvictInstancePoolMembers(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "evict-instance-pool-members"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-pool/{id}:evict"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XScaleInstancePool Scale an Instance Pool
func XScaleInstancePool(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "scale-instance-pool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-pool/{id}:scale"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListInstanceTypes List Compute instance Types
func XListInstanceTypes(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-instance-types"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-type"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetInstanceType Retrieve Instance Type details
func XGetInstanceType(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-instance-type"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance-type/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteInstance Delete a Compute instance
func XDeleteInstance(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetInstance Retrieve Compute instance details
func XGetInstance(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateInstance Update a Compute instance
func XUpdateInstance(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetInstanceField Reset Instance field
func XResetInstanceField(paramId string, paramField string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-instance-field"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}/{field}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{field}", paramField, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XAddInstanceProtection Set instance destruction protection
func XAddInstanceProtection(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "add-instance-protection"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:add-protection"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateSnapshot Create a Snapshot of a Compute instance
func XCreateSnapshot(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-snapshot"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:create-snapshot"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XEnableTpm Enable tpm for the instance.
func XEnableTpm(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "enable-tpm"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:enable-tpm"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRevealInstancePassword Reveal the password used during instance creation or the latest password reset.
func XRevealInstancePassword(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reveal-instance-password"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:password"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRebootInstance Reboot a Compute instance
func XRebootInstance(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reboot-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:reboot"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRemoveInstanceProtection Remove instance destruction protection
func XRemoveInstanceProtection(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "remove-instance-protection"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:remove-protection"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetInstance Reset a Compute instance to a base/target template
func XResetInstance(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:reset"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetInstancePassword Reset a compute instance password
func XResetInstancePassword(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-instance-password"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:reset-password"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResizeInstanceDisk Resize a Compute instance disk
func XResizeInstanceDisk(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "resize-instance-disk"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:resize-disk"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XScaleInstance Scale a Compute instance to a new Instance Type
func XScaleInstance(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "scale-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:scale"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XStartInstance Start a Compute instance
func XStartInstance(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "start-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:start"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XStopInstance Stop a Compute instance
func XStopInstance(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "stop-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{id}:stop"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRevertInstanceToSnapshot Revert a snapshot for an instance
func XRevertInstanceToSnapshot(paramInstanceId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "revert-instance-to-snapshot"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/instance/{instance-id}:revert-snapshot"
	url = strings.Replace(url, "{instance-id}", paramInstanceId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateLoadBalancer Create a Load Balancer
func XCreateLoadBalancer(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-load-balancer"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListLoadBalancers List Load Balancers
func XListLoadBalancers(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-load-balancers"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteLoadBalancer Delete a Load Balancer
func XDeleteLoadBalancer(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-load-balancer"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetLoadBalancer Retrieve Load Balancer details
func XGetLoadBalancer(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-load-balancer"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateLoadBalancer Update a Load Balancer
func XUpdateLoadBalancer(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-load-balancer"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XAddServiceToLoadBalancer Add a Load Balancer Service
func XAddServiceToLoadBalancer(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "add-service-to-load-balancer"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}/service"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteLoadBalancerService Delete a Load Balancer Service
func XDeleteLoadBalancerService(paramId string, paramServiceId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-load-balancer-service"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}/service/{service-id}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{service-id}", paramServiceId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetLoadBalancerService Retrieve Load Balancer Service details
func XGetLoadBalancerService(paramId string, paramServiceId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-load-balancer-service"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}/service/{service-id}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{service-id}", paramServiceId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateLoadBalancerService Update a Load Balancer Service
func XUpdateLoadBalancerService(paramId string, paramServiceId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-load-balancer-service"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}/service/{service-id}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{service-id}", paramServiceId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetLoadBalancerServiceField Reset a Load Balancer Service field to its default value
func XResetLoadBalancerServiceField(paramId string, paramServiceId string, paramField string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-load-balancer-service-field"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}/service/{service-id}/{field}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{service-id}", paramServiceId, 1)
	url = strings.Replace(url, "{field}", paramField, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetLoadBalancerField Reset a Load Balancer field to its default value
func XResetLoadBalancerField(paramId string, paramField string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-load-balancer-field"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/load-balancer/{id}/{field}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{field}", paramField, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetOperation Retrieve Operation details
func XGetOperation(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-operation"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/operation/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetOrganization Retrieve an organization
func XGetOrganization(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-organization"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/organization"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreatePrivateNetwork Create a Private Network
func XCreatePrivateNetwork(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-private-network"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListPrivateNetworks List Private Networks
func XListPrivateNetworks(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-private-networks"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeletePrivateNetwork Delete a Private Network
func XDeletePrivateNetwork(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-private-network"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetPrivateNetwork Retrieve Private Network details
func XGetPrivateNetwork(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-private-network"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdatePrivateNetwork Update a Private Network
func XUpdatePrivateNetwork(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-private-network"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetPrivateNetworkField Reset Private Network field
func XResetPrivateNetworkField(paramId string, paramField string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-private-network-field"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network/{id}/{field}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{field}", paramField, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XAttachInstanceToPrivateNetwork Attach a Compute instance to a Private Network
func XAttachInstanceToPrivateNetwork(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "attach-instance-to-private-network"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network/{id}:attach"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDetachInstanceFromPrivateNetwork Detach a Compute instance from a Private Network
func XDetachInstanceFromPrivateNetwork(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "detach-instance-from-private-network"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network/{id}:detach"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdatePrivateNetworkInstanceIp Update the IP address of an instance attached to a managed private network
func XUpdatePrivateNetworkInstanceIp(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-private-network-instance-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/private-network/{id}:update-ip"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListQuotas List Organization Quotas
func XListQuotas(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-quotas"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/quota"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetQuota Retrieve Resource Quota
func XGetQuota(paramEntity string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-quota"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/quota/{entity}"
	url = strings.Replace(url, "{entity}", paramEntity, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteReverseDnsElasticIp Delete the PTR DNS record for an elastic IP
func XDeleteReverseDnsElasticIp(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-reverse-dns-elastic-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/reverse-dns/elastic-ip/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetReverseDnsElasticIp Query the PTR DNS records for an elastic IP
func XGetReverseDnsElasticIp(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-reverse-dns-elastic-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/reverse-dns/elastic-ip/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateReverseDnsElasticIp Update/Create the PTR DNS record for an elastic IP
func XUpdateReverseDnsElasticIp(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-reverse-dns-elastic-ip"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/reverse-dns/elastic-ip/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteReverseDnsInstance Delete the PTR DNS record for an instance
func XDeleteReverseDnsInstance(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-reverse-dns-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/reverse-dns/instance/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetReverseDnsInstance Query the PTR DNS records for an instance
func XGetReverseDnsInstance(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-reverse-dns-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/reverse-dns/instance/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateReverseDnsInstance Update/Create the PTR DNS record for an instance
func XUpdateReverseDnsInstance(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-reverse-dns-instance"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/reverse-dns/instance/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateSecurityGroup Create a Security Group
func XCreateSecurityGroup(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListSecurityGroups List Security Groups.
func XListSecurityGroups(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-security-groups"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group"

	req := cli.Client.Get().URL(url)

	paramVisibility := params.GetString("visibility")
	if paramVisibility != "" {
		req = req.AddQuery("visibility", fmt.Sprintf("%v", paramVisibility))
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteSecurityGroup Delete a Security Group
func XDeleteSecurityGroup(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetSecurityGroup Retrieve Security Group details
func XGetSecurityGroup(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XAddRuleToSecurityGroup Create a Security Group rule
func XAddRuleToSecurityGroup(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "add-rule-to-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group/{id}/rules"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteRuleFromSecurityGroup Delete a Security Group rule
func XDeleteRuleFromSecurityGroup(paramId string, paramRuleId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-rule-from-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group/{id}/rules/{rule-id}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{rule-id}", paramRuleId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XAddExternalSourceToSecurityGroup Add an external source as a member of a Security Group
func XAddExternalSourceToSecurityGroup(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "add-external-source-to-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group/{id}:add-source"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XAttachInstanceToSecurityGroup Attach a Compute instance to a Security Group
func XAttachInstanceToSecurityGroup(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "attach-instance-to-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group/{id}:attach"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDetachInstanceFromSecurityGroup Detach a Compute instance from a Security Group
func XDetachInstanceFromSecurityGroup(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "detach-instance-from-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group/{id}:detach"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRemoveExternalSourceFromSecurityGroup Remove an external source from a Security Group
func XRemoveExternalSourceFromSecurityGroup(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "remove-external-source-from-security-group"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/security-group/{id}:remove-source"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateSksCluster Create an SKS cluster
func XCreateSksCluster(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-sks-cluster"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListSksClusters List SKS clusters
func XListSksClusters(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-sks-clusters"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListSksClusterDeprecatedResources Resources that are scheduled to be removed in future kubernetes releases
func XListSksClusterDeprecatedResources(paramId string, params *viper.Viper) (*gentleman.Response, interface{}, error) {
	handlerPath := "list-sks-cluster-deprecated-resources"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster-deprecated-resources/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after
	}

	return resp, decoded, nil
}

// XGenerateSksClusterKubeconfig Generate a new Kubeconfig file for a SKS cluster
func XGenerateSksClusterKubeconfig(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "generate-sks-cluster-kubeconfig"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster-kubeconfig/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListSksClusterVersions List available versions for SKS clusters
func XListSksClusterVersions(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-sks-cluster-versions"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster-version"

	req := cli.Client.Get().URL(url)

	paramIncludeDeprecated := params.GetString("include-deprecated")
	if paramIncludeDeprecated != "" {
		req = req.AddQuery("include-deprecated", fmt.Sprintf("%v", paramIncludeDeprecated))
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteSksCluster Delete an SKS cluster
func XDeleteSksCluster(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-sks-cluster"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetSksCluster Retrieve SKS cluster details
func XGetSksCluster(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-sks-cluster"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateSksCluster Update an SKS cluster
func XUpdateSksCluster(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-sks-cluster"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetSksClusterAuthorityCert Get the certificate for a SKS cluster authority
func XGetSksClusterAuthorityCert(paramId string, paramAuthority string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-sks-cluster-authority-cert"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/authority/{authority}/cert"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{authority}", paramAuthority, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetSksClusterInspection Get the latest inspection result
func XGetSksClusterInspection(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-sks-cluster-inspection"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/inspection"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateSksNodepool Create a new SKS Nodepool
func XCreateSksNodepool(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-sks-nodepool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/nodepool"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteSksNodepool Delete an SKS Nodepool
func XDeleteSksNodepool(paramId string, paramSksNodepoolId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-sks-nodepool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/nodepool/{sks-nodepool-id}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{sks-nodepool-id}", paramSksNodepoolId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetSksNodepool Retrieve SKS Nodepool details
func XGetSksNodepool(paramId string, paramSksNodepoolId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-sks-nodepool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/nodepool/{sks-nodepool-id}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{sks-nodepool-id}", paramSksNodepoolId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateSksNodepool Update an SKS Nodepool
func XUpdateSksNodepool(paramId string, paramSksNodepoolId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-sks-nodepool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/nodepool/{sks-nodepool-id}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{sks-nodepool-id}", paramSksNodepoolId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetSksNodepoolField Reset an SKS Nodepool field to its default value
func XResetSksNodepoolField(paramId string, paramSksNodepoolId string, paramField string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-sks-nodepool-field"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/nodepool/{sks-nodepool-id}/{field}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{sks-nodepool-id}", paramSksNodepoolId, 1)
	url = strings.Replace(url, "{field}", paramField, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XEvictSksNodepoolMembers Evict Nodepool members
func XEvictSksNodepoolMembers(paramId string, paramSksNodepoolId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "evict-sks-nodepool-members"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/nodepool/{sks-nodepool-id}:evict"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{sks-nodepool-id}", paramSksNodepoolId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XScaleSksNodepool Scale a SKS Nodepool
func XScaleSksNodepool(paramId string, paramSksNodepoolId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "scale-sks-nodepool"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/nodepool/{sks-nodepool-id}:scale"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{sks-nodepool-id}", paramSksNodepoolId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRotateSksCcmCredentials Rotate Exoscale CCM credentials
func XRotateSksCcmCredentials(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "rotate-sks-ccm-credentials"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/rotate-ccm-credentials"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRotateSksCsiCredentials Rotate Exoscale CSI credentials
func XRotateSksCsiCredentials(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "rotate-sks-csi-credentials"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/rotate-csi-credentials"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRotateSksOperatorsCa Rotate operators certificate authority
func XRotateSksOperatorsCa(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "rotate-sks-operators-ca"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/rotate-operators-ca"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpgradeSksCluster Upgrade an SKS cluster
func XUpgradeSksCluster(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "upgrade-sks-cluster"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/upgrade"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpgradeSksClusterServiceLevel Upgrade a SKS cluster to pro
func XUpgradeSksClusterServiceLevel(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "upgrade-sks-cluster-service-level"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/upgrade-service-level"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XResetSksClusterField Reset an SKS cluster field to its default value
func XResetSksClusterField(paramId string, paramField string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "reset-sks-cluster-field"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sks-cluster/{id}/{field}"
	url = strings.Replace(url, "{id}", paramId, 1)
	url = strings.Replace(url, "{field}", paramField, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListSnapshots List Snapshots
func XListSnapshots(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-snapshots"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/snapshot"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteSnapshot Delete a Snapshot
func XDeleteSnapshot(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-snapshot"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/snapshot/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetSnapshot Retrieve Snapshot details
func XGetSnapshot(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-snapshot"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/snapshot/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XExportSnapshot Export a Snapshot
func XExportSnapshot(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "export-snapshot"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/snapshot/{id}:export"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XPromoteSnapshotToTemplate Promote a Snapshot to a Template
func XPromoteSnapshotToTemplate(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "promote-snapshot-to-template"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/snapshot/{id}:promote"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListSosBucketsUsage List SOS Buckets Usage
func XListSosBucketsUsage(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-sos-buckets-usage"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sos-buckets-usage"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetSosPresignedUrl Retrieve Presigned Download URL for SOS object
func XGetSosPresignedUrl(paramBucket string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-sos-presigned-url"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/sos/{bucket}/presigned-url"
	url = strings.Replace(url, "{bucket}", paramBucket, 1)

	req := cli.Client.Get().URL(url)

	paramKey := params.GetString("key")
	if paramKey != "" {
		req = req.AddQuery("key", fmt.Sprintf("%v", paramKey))
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListSshKeys List SSH keys
func XListSshKeys(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-ssh-keys"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/ssh-key"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRegisterSshKey Import SSH key
func XRegisterSshKey(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "register-ssh-key"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/ssh-key"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteSshKey Delete a SSH key
func XDeleteSshKey(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-ssh-key"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/ssh-key/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetSshKey Retrieve SSH key details
func XGetSshKey(paramName string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-ssh-key"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/ssh-key/{name}"
	url = strings.Replace(url, "{name}", paramName, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListTemplates List Templates
func XListTemplates(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-templates"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/template"

	req := cli.Client.Get().URL(url)

	paramVisibility := params.GetString("visibility")
	if paramVisibility != "" {
		req = req.AddQuery("visibility", fmt.Sprintf("%v", paramVisibility))
	}
	paramFamily := params.GetString("family")
	if paramFamily != "" {
		req = req.AddQuery("family", fmt.Sprintf("%v", paramFamily))
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XRegisterTemplate Register a Template
func XRegisterTemplate(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "register-template"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/template"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCopyTemplate Copy a Template from a zone to another
func XCopyTemplate(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "copy-template"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/template/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteTemplate Delete a Template
func XDeleteTemplate(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-template"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/template/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetTemplate Retrieve Template details
func XGetTemplate(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-template"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/template/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateTemplate Update template attributes
func XUpdateTemplate(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-template"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/template/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XGetUsageReport Retrieve organization usage reports
func XGetUsageReport(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "get-usage-report"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/usage-report"

	req := cli.Client.Get().URL(url)

	paramPeriod := params.GetString("period")
	if paramPeriod != "" {
		req = req.AddQuery("period", fmt.Sprintf("%v", paramPeriod))
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XCreateUser Create a User
func XCreateUser(params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "create-user"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/user"

	req := cli.Client.Post().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListUsers List Users
func XListUsers(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-users"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/user"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XDeleteUser Delete User
func XDeleteUser(paramId string, params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "delete-user"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/user/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Delete().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XUpdateUserRole Update a User's IAM role
func XUpdateUserRole(paramId string, params *viper.Viper, body string) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "update-user-role"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/user/{id}"
	url = strings.Replace(url, "{id}", paramId, 1)

	req := cli.Client.Put().URL(url)

	if body != "" {
		req = req.AddHeader("Content-Type", "application/json").BodyString(body)
	}

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

// XListZones List Zones
func XListZones(params *viper.Viper) (*gentleman.Response, map[string]interface{}, error) {
	handlerPath := "list-zones"
	if xSubcommand {
		handlerPath = "x " + handlerPath
	}

	server := viper.GetString("server")
	if server == "" {
		server = xServers()[viper.GetInt("server-index")]["url"]
	}

	url := server + "/zone"

	req := cli.Client.Get().URL(url)

	cli.HandleBefore(handlerPath, params, req)

	resp, err := req.Do()
	if err != nil {
		return nil, nil, errors.Wrap(err, "Request failed")
	}

	var decoded map[string]interface{}

	if resp.StatusCode < 400 {
		if err := cli.UnmarshalResponse(resp, &decoded); err != nil {
			return nil, nil, errors.Wrap(err, "Unmarshalling response failed")
		}
	} else {
		return nil, nil, errors.Errorf("HTTP %d: %s", resp.StatusCode, resp.String())
	}

	after := cli.HandleAfter(handlerPath, params, resp, decoded)
	if after != nil {
		decoded = after.(map[string]interface{})
	}

	return resp, decoded, nil
}

func xRegister(subcommand bool) {
	root := cli.Root

	if subcommand {
		root = &cobra.Command{
			Use:   "x",
			Short: "Exoscale Public API",
			Long:  cli.Markdown("\nInfrastructure automation API, allowing programmatic access to all Exoscale products and services.\n\nThe [OpenAPI Specification](http://spec.openapis.org/oas/v3.0.3.html) source of this documentation can be obtained here:\n\n* [JSON format](https://openapi-v2.exoscale.com/source.json)\n* [YAML format](https://openapi-v2.exoscale.com/source.yaml)"),
		}
		xSubcommand = true
	} else {
		cli.Root.Short = "Exoscale Public API"
		cli.Root.Long = cli.Markdown("\nInfrastructure automation API, allowing programmatic access to all Exoscale products and services.\n\nThe [OpenAPI Specification](http://spec.openapis.org/oas/v3.0.3.html) source of this documentation can be obtained here:\n\n* [JSON format](https://openapi-v2.exoscale.com/source.json)\n* [YAML format](https://openapi-v2.exoscale.com/source.yaml)")
	}

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-anti-affinity-group",
			Short:   "Create an Anti-affinity Group",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Anti-affinity Group description\n    maxLength: 255\n    type: string\n  name:\n    description: Anti-affinity Group name\n    maxLength: 255\n    minLength: 1\n    type: string\nrequired:\n- name\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateAntiAffinityGroup(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-anti-affinity-groups",
			Short:   "List Anti-affinity Groups",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListAntiAffinityGroups(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-anti-affinity-group id",
			Short:   "Delete an Anti-affinity Group",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteAntiAffinityGroup(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-anti-affinity-group id",
			Short:   "Retrieve Anti-affinity Group details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetAntiAffinityGroup(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-api-key",
			Short:   "Create a new API key",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  name:\n    description: IAM API Key Name\n    maxLength: 255\n    minLength: 1\n    type: string\n  role-id:\n    description: IAM API Key Role ID\n    format: uuid\n    type: string\nrequired:\n- role-id\n- name\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateApiKey(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-api-keys",
			Short:   "List API keys",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListApiKeys(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-api-key id",
			Short:   "Delete an API key",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteApiKey(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-api-key id",
			Short:   "Get API key",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetApiKey(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-block-storage-volume",
			Short:   "Create a block storage volume",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  block-storage-snapshot:\n    $ref: '#/components/schemas/block-storage-snapshot-target'\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Volume name\n    maxLength: 255\n    type: string\n  size:\n    description: |-\n      Volume size in GiB.\n                                  When a snapshot ID is supplied, this defaults to the size of the source volume, but can be set to a larger value.\n    format: int64\n    minimum: 1\n    type: integer\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateBlockStorageVolume(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-block-storage-volumes",
			Short:   "List block storage volumes",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListBlockStorageVolumes(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cmd.Flags().String("instance-id", "", "")

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-block-storage-snapshots",
			Short:   "List block storage snapshots",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListBlockStorageSnapshots(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-block-storage-snapshot id",
			Short:   "Delete a block storage snapshot, data will be unrecoverable",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteBlockStorageSnapshot(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-block-storage-snapshot id",
			Short:   "Retrieve block storage snapshot details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetBlockStorageSnapshot(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-block-storage-snapshot id",
			Short:   "Update block storage volume snapshot",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Snapshot name\n    maxLength: 255\n    nullable: true\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateBlockStorageSnapshot(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-block-storage-volume id",
			Short:   "Delete a block storage volume, data will be unrecoverable",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteBlockStorageVolume(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-block-storage-volume id",
			Short:   "Retrieve block storage volume details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetBlockStorageVolume(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-block-storage-volume id",
			Short:   "Update block storage volume",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Volume name\n    maxLength: 255\n    nullable: true\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateBlockStorageVolume(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "attach-block-storage-volume-to-instance id",
			Short:   "Attach block storage volume to an instance",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  instance:\n    $ref: '#/components/schemas/instance-target'\nrequired:\n- instance\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XAttachBlockStorageVolumeToInstance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-block-storage-snapshot id",
			Short:   "Create a block storage snapshot",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Snapshot name\n    maxLength: 255\n    minLength: 1\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateBlockStorageSnapshot(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "detach-block-storage-volume id",
			Short:   "Detach block storage volume",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XDetachBlockStorageVolume(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "resize-block-storage-volume id",
			Short:   "Resize a block storage volume",
			Long:    cli.Markdown("This operation resizes a Block storage volume. Note: the volume can only grow, cannot be shrunk.\n## Request Schema (application/json)\n\nproperties:\n  size:\n    description: Volume size in GiB\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\nrequired:\n- size\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XResizeBlockStorageVolume(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-console-proxy-url id",
			Short:   "Retrieve signed url valid for 60 seconds to connect via console-proxy websocket to VM VNC console.",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetConsoleProxyUrl(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-ca-certificate",
			Short:   "Get DBaaS CA Certificate",
			Long:    cli.Markdown("Returns a CA Certificate required to reach a DBaaS service through a TLS-protected connection."),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasCaCertificate(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-external-endpoint-datadog endpoint-id",
			Short:   "delete-dbaas-external-endpoint-datadog",
			Long:    cli.Markdown("[BETA] Delete DataDog external integration endpoint"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasExternalEndpointDatadog(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-external-endpoint-datadog endpoint-id",
			Short:   "get-dbaas-external-endpoint-datadog",
			Long:    cli.Markdown("[BETA] Get DataDog external endpoint settings"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasExternalEndpointDatadog(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-external-endpoint-datadog endpoint-id",
			Short:   "update-dbaas-external-endpoint-datadog",
			Long:    cli.Markdown("[BETA] Update DataDog external integration endpoint\n## Request Schema (application/json)\n\nproperties:\n  settings:\n    properties:\n      datadog-api-key:\n        description: Datadog API key\n        maxLength: 256\n        minLength: 1\n        pattern: ^[A-Za-z0-9]{1,256}$\n        type: string\n      datadog-tags:\n        description: Custom tags provided by user\n        items:\n          $ref: '#/components/schemas/dbaas-datadog-tag'\n        type: array\n      disable-consumer-stats:\n        description: Disable kafka consumer group metrics. Applies only when attached to kafka services.\n        type: boolean\n      kafka-consumer-check-instances:\n        description: Number of separate instances to fetch kafka consumer statistics with. Applies only when attached to kafka services.\n        format: int64\n        maximum: 100\n        minimum: 1\n        type: integer\n      kafka-consumer-stats-timeout:\n        description: Number of seconds that datadog will wait to get consumer statistics from brokers. Applies only when attached to kafka services.\n        format: int64\n        maximum: 300\n        minimum: 2\n        type: integer\n      max-partition-contexts:\n        description: Maximum number of partition contexts to send. Applies only when attached to kafka services.\n        format: int64\n        maximum: 200000\n        minimum: 200\n        type: integer\n      site:\n        $ref: '#/components/schemas/enum-datadog-site'\n    required:\n    - datadog-api-key\n    type: object\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasExternalEndpointDatadog(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-external-endpoint-datadog name",
			Short:   "create-dbaas-external-endpoint-datadog",
			Long:    cli.Markdown("[BETA] Create DataDog external integration endpoint\n## Request Schema (application/json)\n\nproperties:\n  settings:\n    properties:\n      datadog-api-key:\n        description: Datadog API key\n        maxLength: 256\n        minLength: 1\n        pattern: ^[A-Za-z0-9]{1,256}$\n        type: string\n      datadog-tags:\n        description: Custom tags provided by user\n        items:\n          $ref: '#/components/schemas/dbaas-datadog-tag'\n        type: array\n      disable-consumer-stats:\n        description: Disable kafka consumer group metrics. Applies only when attached to kafka services.\n        type: boolean\n      kafka-consumer-check-instances:\n        description: Number of separate instances to fetch kafka consumer statistics with. Applies only when attached to kafka services.\n        format: int64\n        maximum: 100\n        minimum: 1\n        type: integer\n      kafka-consumer-stats-timeout:\n        description: Number of seconds that datadog will wait to get consumer statistics from brokers. Applies only when attached to kafka services.\n        format: int64\n        maximum: 300\n        minimum: 2\n        type: integer\n      max-partition-contexts:\n        description: Maximum number of partition contexts to send. Applies only when attached to kafka services.\n        format: int64\n        maximum: 200000\n        minimum: 200\n        type: integer\n      site:\n        $ref: '#/components/schemas/enum-datadog-site'\n    required:\n    - datadog-api-key\n    - site\n    type: object\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasExternalEndpointDatadog(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-external-endpoint-elasticsearch endpoint-id",
			Short:   "delete-dbaas-external-endpoint-elasticsearch",
			Long:    cli.Markdown("[BETA] Delete ElasticSearch logs external integration endpoint"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasExternalEndpointElasticsearch(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-external-endpoint-elasticsearch endpoint-id",
			Short:   "get-dbaas-external-endpoint-elasticsearch",
			Long:    cli.Markdown("[BETA] Get ElasticSearch Logs external integration endpoint settings"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasExternalEndpointElasticsearch(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-external-endpoint-elasticsearch endpoint-id",
			Short:   "update-dbaas-external-endpoint-elasticsearch",
			Long:    cli.Markdown("[BETA] Update ElasticSearch Logs external integration endpoint\n## Request Schema (application/json)\n\nproperties:\n  settings:\n    properties:\n      ca:\n        description: PEM encoded CA certificate\n        maxLength: 16384\n        type: string\n      index-days-max:\n        description: Maximum number of days of logs to keep\n        format: int64\n        maximum: 10000\n        minimum: 1\n        type: integer\n      index-prefix:\n        description: Elasticsearch index prefix\n        maxLength: 1000\n        minLength: 1\n        pattern: ^[a-z0-9][a-z0-9-_.]+$\n        type: string\n      timeout:\n        description: Elasticsearch request timeout limit\n        format: int64\n        maximum: 120\n        minimum: 10\n        type: integer\n      url:\n        description: Elasticsearch connection URL\n        maxLength: 2048\n        minLength: 12\n        type: string\n    type: object\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasExternalEndpointElasticsearch(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-external-endpoint-elasticsearch name",
			Short:   "create-dbaas-external-endpoint-elasticsearch",
			Long:    cli.Markdown("[BETA] Create ElasticSearch Logs external integration endpoint\n## Request Schema (application/json)\n\nproperties:\n  settings:\n    properties:\n      ca:\n        description: PEM encoded CA certificate\n        maxLength: 16384\n        type: string\n      index-days-max:\n        description: Maximum number of days of logs to keep\n        format: int64\n        maximum: 10000\n        minimum: 1\n        type: integer\n      index-prefix:\n        description: Elasticsearch index prefix\n        maxLength: 1000\n        minLength: 1\n        pattern: ^[a-z0-9][a-z0-9-_.]+$\n        type: string\n      timeout:\n        description: Elasticsearch request timeout limit\n        format: int64\n        maximum: 120\n        minimum: 10\n        type: integer\n      url:\n        description: Elasticsearch connection URL\n        maxLength: 2048\n        minLength: 12\n        type: string\n    required:\n    - url\n    - index-prefix\n    type: object\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasExternalEndpointElasticsearch(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-external-endpoint-opensearch endpoint-id",
			Short:   "delete-dbaas-external-endpoint-opensearch",
			Long:    cli.Markdown("[BETA] Delete OpenSearch logs external integration endpoint"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasExternalEndpointOpensearch(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-external-endpoint-opensearch endpoint-id",
			Short:   "get-dbaas-external-endpoint-opensearch",
			Long:    cli.Markdown("[BETA] Get OpenSearch Logs external integration endpoint settings"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasExternalEndpointOpensearch(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-external-endpoint-opensearch endpoint-id",
			Short:   "update-dbaas-external-endpoint-opensearch",
			Long:    cli.Markdown("[BETA] Update OpenSearch Logs external integration endpoint\n## Request Schema (application/json)\n\nproperties:\n  settings:\n    properties:\n      ca:\n        description: PEM encoded CA certificate\n        maxLength: 16384\n        type: string\n      index-days-max:\n        description: Maximum number of days of logs to keep\n        format: int64\n        maximum: 10000\n        minimum: 1\n        type: integer\n      index-prefix:\n        description: OpenSearch index prefix\n        maxLength: 1000\n        minLength: 1\n        pattern: ^[a-z0-9][a-z0-9-_.]+$\n        type: string\n      timeout:\n        description: OpenSearch request timeout limit\n        format: int64\n        maximum: 120\n        minimum: 10\n        type: integer\n      url:\n        description: OpenSearch connection URL\n        maxLength: 2048\n        minLength: 12\n        type: string\n    type: object\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasExternalEndpointOpensearch(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-external-endpoint-opensearch name",
			Short:   "create-dbaas-external-endpoint-opensearch",
			Long:    cli.Markdown("[BETA] Create OpenSearch Logs external integration endpoint\n## Request Schema (application/json)\n\nproperties:\n  settings:\n    properties:\n      ca:\n        description: PEM encoded CA certificate\n        maxLength: 16384\n        type: string\n      index-days-max:\n        description: Maximum number of days of logs to keep\n        format: int64\n        maximum: 10000\n        minimum: 1\n        type: integer\n      index-prefix:\n        description: OpenSearch index prefix\n        maxLength: 1000\n        minLength: 1\n        pattern: ^[a-z0-9][a-z0-9-_.]+$\n        type: string\n      timeout:\n        description: OpenSearch request timeout limit\n        format: int64\n        maximum: 120\n        minimum: 10\n        type: integer\n      url:\n        description: OpenSearch connection URL\n        maxLength: 2048\n        minLength: 12\n        type: string\n    required:\n    - url\n    - index-prefix\n    type: object\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasExternalEndpointOpensearch(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-external-endpoint-prometheus endpoint-id",
			Short:   "delete-dbaas-external-endpoint-prometheus",
			Long:    cli.Markdown("[BETA] Delete Prometheus external integration endpoint"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasExternalEndpointPrometheus(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-external-endpoint-prometheus endpoint-id",
			Short:   "get-dbaas-external-endpoint-prometheus",
			Long:    cli.Markdown("[BETA] Get Prometheus external integration endpoint settings"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasExternalEndpointPrometheus(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-external-endpoint-prometheus endpoint-id",
			Short:   "update-dbaas-external-endpoint-prometheus",
			Long:    cli.Markdown("[BETA] Update Prometheus external integration endpoint\n## Request Schema (application/json)\n\nproperties:\n  settings:\n    properties:\n      basic-auth-password:\n        description: Prometheus basic authentication password\n        maxLength: 64\n        minLength: 8\n        type: string\n      basic-auth-username:\n        description: Prometheus basic authentication username\n        maxLength: 32\n        minLength: 5\n        type: string\n    type: object\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasExternalEndpointPrometheus(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-external-endpoint-prometheus name",
			Short:   "create-dbaas-external-endpoint-prometheus",
			Long:    cli.Markdown("[BETA] Create Prometheus external integration endpoint\n## Request Schema (application/json)\n\nproperties:\n  settings:\n    properties:\n      basic-auth-password:\n        description: Prometheus basic authentication password\n        maxLength: 64\n        minLength: 8\n        type: string\n      basic-auth-username:\n        description: Prometheus basic authentication username\n        maxLength: 32\n        minLength: 5\n        type: string\n    type: object\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasExternalEndpointPrometheus(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-external-endpoint-rsyslog endpoint-id",
			Short:   "delete-dbaas-external-endpoint-rsyslog",
			Long:    cli.Markdown("[BETA] Delete RSyslog external integration endpoint"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasExternalEndpointRsyslog(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-external-endpoint-rsyslog endpoint-id",
			Short:   "get-dbaas-external-endpoint-rsyslog",
			Long:    cli.Markdown("[BETA] Get RSyslog external integration endpoint settings"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasExternalEndpointRsyslog(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-external-endpoint-rsyslog endpoint-id",
			Short:   "update-dbaas-external-endpoint-rsyslog",
			Long:    cli.Markdown("[BETA] Update RSyslog external integration endpoint\n## Request Schema (application/json)\n\nproperties:\n  settings:\n    properties:\n      ca:\n        description: PEM encoded CA certificate\n        maxLength: 16384\n        type: string\n      cert:\n        description: PEM encoded client certificate\n        maxLength: 16384\n        type: string\n      format:\n        $ref: '#/components/schemas/enum-rsyslog-format'\n      key:\n        description: PEM encoded client key\n        maxLength: 16384\n        type: string\n      logline:\n        description: Custom syslog message format\n        maxLength: 512\n        minLength: 1\n        pattern: ^[ -~\t]+$\n        type: string\n      max-message-size:\n        description: Rsyslog max message size\n        format: int64\n        maximum: 2.147483647e+09\n        minimum: 2048\n        type: integer\n      port:\n        description: Rsyslog server port\n        format: int64\n        maximum: 65535\n        minimum: 1\n        type: integer\n      sd:\n        description: Structured data block for log message\n        maxLength: 1024\n        type: string\n      server:\n        description: Rsyslog server IP address or hostname\n        maxLength: 255\n        minLength: 4\n        type: string\n      tls:\n        description: Require TLS\n        type: boolean\n    type: object\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasExternalEndpointRsyslog(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-external-endpoint-rsyslog name",
			Short:   "create-dbaas-external-endpoint-rsyslog",
			Long:    cli.Markdown("[BETA] Create RSyslog external integration endpoint\n## Request Schema (application/json)\n\nproperties:\n  settings:\n    properties:\n      ca:\n        description: PEM encoded CA certificate\n        maxLength: 16384\n        type: string\n      cert:\n        description: PEM encoded client certificate\n        maxLength: 16384\n        type: string\n      format:\n        $ref: '#/components/schemas/enum-rsyslog-format'\n      key:\n        description: PEM encoded client key\n        maxLength: 16384\n        type: string\n      logline:\n        description: Custom syslog message format\n        maxLength: 512\n        minLength: 1\n        pattern: ^[ -~\t]+$\n        type: string\n      max-message-size:\n        description: Rsyslog max message size\n        format: int64\n        maximum: 2.147483647e+09\n        minimum: 2048\n        type: integer\n      port:\n        description: Rsyslog server port\n        format: int64\n        maximum: 65535\n        minimum: 1\n        type: integer\n      sd:\n        description: Structured data block for log message\n        maxLength: 1024\n        type: string\n      server:\n        description: Rsyslog server IP address or hostname\n        maxLength: 255\n        minLength: 4\n        type: string\n      tls:\n        description: Require TLS\n        type: boolean\n    required:\n    - server\n    - port\n    - tls\n    - format\n    type: object\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasExternalEndpointRsyslog(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-dbaas-external-endpoint-types",
			Short:   "list-dbaas-external-endpoint-types",
			Long:    cli.Markdown("[BETA] List available external endpoint types and their schemas for DBaaS external integrations"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListDbaasExternalEndpointTypes(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "attach-dbaas-service-to-endpoint source-service-name",
			Short:   "attach-dbaas-service-to-endpoint",
			Long:    cli.Markdown("[BETA] Create a new DBaaS connection between a DBaaS service and an external service\n## Request Schema (application/json)\n\nproperties:\n  dest-endpoint-id:\n    description: External endpoint id\n    format: uuid\n    type: string\n  type:\n    $ref: '#/components/schemas/enum-external-endpoint-types'\nrequired:\n- dest-endpoint-id\n- type\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XAttachDbaasServiceToEndpoint(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "detach-dbaas-service-from-endpoint source-service-name",
			Short:   "detach-dbaas-service-from-endpoint",
			Long:    cli.Markdown("[BETA] Detach a DBaaS external integration from a service\n## Request Schema (application/json)\n\nproperties:\n  integration-id:\n    description: External Integration ID\n    format: uuid\n    type: string\nrequired:\n- integration-id\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XDetachDbaasServiceFromEndpoint(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-dbaas-external-endpoints",
			Short:   "list-dbaas-external-endpoints",
			Long:    cli.Markdown("[BETA] List available external endpoints for integrations"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListDbaasExternalEndpoints(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-external-integration-settings-datadog integration-id",
			Short:   "get-dbaas-external-integration-settings-datadog",
			Long:    cli.Markdown("[BETA] Get Datadog integration settings"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasExternalIntegrationSettingsDatadog(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-external-integration-settings-datadog integration-id",
			Short:   "update-dbaas-external-integration-settings-datadog",
			Long:    cli.Markdown("[BETA] Manage Datadog integration settings\n## Request Schema (application/json)\n\nproperties:\n  settings:\n    $ref: '#/components/schemas/dbaas-integration-settings-datadog'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasExternalIntegrationSettingsDatadog(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-external-integration integration-id",
			Short:   "get-dbaas-external-integration",
			Long:    cli.Markdown("[BETA] Get a DBaaS external integration"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasExternalIntegration(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-dbaas-external-integrations service-name",
			Short:   "list-dbaas-external-integrations",
			Long:    cli.Markdown("[BETA] List all DBaaS connections between services and external endpoints"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListDbaasExternalIntegrations(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-service-grafana name",
			Short:   "create-dbaas-service-grafana",
			Long:    cli.Markdown("Create a DBaaS Grafana service\n## Request Schema (application/json)\n\nproperties:\n  fork-from-service:\n    $ref: '#/components/schemas/dbaas-service-name'\n  grafana-settings:\n    $ref: '#/components/schemas/json-schema-grafana'\n  ip-filter:\n    description: Allowed CIDR address blocks for incoming connections\n    items:\n      type: string\n    type: array\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\nrequired:\n- plan\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasServiceGrafana(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-service-grafana name",
			Short:   "Delete a Grafana service",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasServiceGrafana(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-service-grafana name",
			Short:   "Get a DBaaS Grafana service",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasServiceGrafana(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-service-grafana name",
			Short:   "Update a DBaaS Grafana service",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  grafana-settings:\n    $ref: '#/components/schemas/json-schema-grafana'\n  ip-filter:\n    description: Allowed CIDR address blocks for incoming connections\n    items:\n      type: string\n    type: array\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasServiceGrafana(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "start-dbaas-grafana-maintenance name",
			Short:   "Initiate Grafana maintenance update",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XStartDbaasGrafanaMaintenance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-dbaas-grafana-user-password service-name username",
			Short:   "Reset the credentials of a DBaaS Grafana user",
			Long:    cli.Markdown("If no password is provided one will be generated automatically.\n## Request Schema (application/json)\n\nproperties:\n  password:\n    $ref: '#/components/schemas/dbaas-user-password'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XResetDbaasGrafanaUserPassword(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reveal-dbaas-grafana-user-password service-name username",
			Short:   "Reveal the secrets of a DBaaS Grafana user",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XRevealDbaasGrafanaUserPassword(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-integration",
			Short:   "create-dbaas-integration",
			Long:    cli.Markdown("[BETA] Create a new DBaaS integration between two services\n## Request Schema (application/json)\n\nproperties:\n  dest-service:\n    $ref: '#/components/schemas/dbaas-service-name'\n  integration-type:\n    $ref: '#/components/schemas/enum-integration-types'\n  settings:\n    description: Integration settings\n    type: object\n  source-service:\n    $ref: '#/components/schemas/dbaas-service-name'\nrequired:\n- integration-type\n- source-service\n- dest-service\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasIntegration(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-dbaas-integration-settings integration-type source-type dest-type",
			Short:   "list-dbaas-integration-settings",
			Long:    cli.Markdown("[BETA] Get DBaaS integration settings"),
			Example: examples,
			Args:    cobra.MinimumNArgs(3),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListDbaasIntegrationSettings(args[0], args[1], args[2], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-dbaas-integration-types",
			Short:   "list-dbaas-integration-types",
			Long:    cli.Markdown("[BETA] Get DBaaS integration types"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListDbaasIntegrationTypes(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-integration id",
			Short:   "delete-dbaas-integration",
			Long:    cli.Markdown("[BETA] Delete a DBaaS Integration"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasIntegration(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-integration id",
			Short:   "get-dbaas-integration",
			Long:    cli.Markdown("[BETA] Get a DBaaS Integration"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasIntegration(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-integration id",
			Short:   "update-dbaas-integration",
			Long:    cli.Markdown("[BETA] Update a existing DBaaS integration\n## Request Schema (application/json)\n\nproperties:\n  settings:\n    description: Integration settings\n    type: object\nrequired:\n- settings\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasIntegration(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-service-kafka name",
			Short:   "Create a DBaaS Kafka service",
			Long:    cli.Markdown("Create a DBaaS Kafka service\n## Request Schema (application/json)\n\nproperties:\n  authentication-methods:\n    description: Kafka authentication methods\n    properties:\n      certificate:\n        description: Enable certificate/SSL authentication\n        type: boolean\n      sasl:\n        description: Enable SASL authentication\n        type: boolean\n    type: object\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  kafka-connect-enabled:\n    description: Allow clients to connect to kafka_connect from the public internet for service nodes that are in a project VPC or another type of private network\n    type: boolean\n  kafka-connect-settings:\n    $ref: '#/components/schemas/json-schema-kafka-connect'\n  kafka-rest-enabled:\n    description: Enable Kafka-REST service\n    type: boolean\n  kafka-rest-settings:\n    $ref: '#/components/schemas/json-schema-kafka-rest'\n  kafka-settings:\n    $ref: '#/components/schemas/json-schema-kafka'\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  schema-registry-enabled:\n    description: Enable Schema-Registry service\n    type: boolean\n  schema-registry-settings:\n    $ref: '#/components/schemas/json-schema-schema-registry'\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\n  version:\n    description: Kafka major version\n    minLength: 1\n    type: string\nrequired:\n- plan\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasServiceKafka(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-service-kafka name",
			Short:   "Delete a Kafka service",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasServiceKafka(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-service-kafka name",
			Short:   "Get a DBaaS Kafka service",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasServiceKafka(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-service-kafka name",
			Short:   "Update a DBaaS Kafka service",
			Long:    cli.Markdown("Update a DBaaS Kafka service\n## Request Schema (application/json)\n\nproperties:\n  authentication-methods:\n    description: Kafka authentication methods\n    properties:\n      certificate:\n        description: Enable certificate/SSL authentication\n        type: boolean\n      sasl:\n        description: Enable SASL authentication\n        type: boolean\n    type: object\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  kafka-connect-enabled:\n    description: Allow clients to connect to kafka_connect from the public internet for service nodes that are in a project VPC or another type of private network\n    type: boolean\n  kafka-connect-settings:\n    $ref: '#/components/schemas/json-schema-kafka-connect'\n  kafka-rest-enabled:\n    description: Enable Kafka-REST service\n    type: boolean\n  kafka-rest-settings:\n    $ref: '#/components/schemas/json-schema-kafka-rest'\n  kafka-settings:\n    $ref: '#/components/schemas/json-schema-kafka'\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  schema-registry-enabled:\n    description: Enable Schema-Registry service\n    type: boolean\n  schema-registry-settings:\n    $ref: '#/components/schemas/json-schema-schema-registry'\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\n  version:\n    description: Kafka major version\n    minLength: 1\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasServiceKafka(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-kafka-acl-config name",
			Short:   "Get DBaaS kafka ACL configuration",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasKafkaAclConfig(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "start-dbaas-kafka-maintenance name",
			Short:   "Initiate Kafka maintenance update",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XStartDbaasKafkaMaintenance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-kafka-schema-registry-acl-config name",
			Short:   "Add a Kafka Schema Registry ACL entry",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  id:\n    $ref: '#/components/schemas/dbaas-kafka-acl-id'\n  permission:\n    description: Kafka Schema Registry permission\n    enum:\n    - schema_registry_read\n    - schema_registry_write\n    type: string\n  resource:\n    description: Kafka Schema Registry name or pattern\n    maxLength: 249\n    minLength: 1\n    type: string\n  username:\n    description: Kafka username or username pattern\n    maxLength: 64\n    minLength: 1\n    type: string\nrequired:\n- username\n- resource\n- permission\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasKafkaSchemaRegistryAclConfig(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-kafka-schema-registry-acl-config name acl-id",
			Short:   "Delete a Kafka ACL entry",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasKafkaSchemaRegistryAclConfig(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-kafka-topic-acl-config name",
			Short:   "Add a Kafka topic ACL entry",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  id:\n    $ref: '#/components/schemas/dbaas-kafka-acl-id'\n  permission:\n    description: Kafka permission\n    enum:\n    - admin\n    - read\n    - readwrite\n    - write\n    type: string\n  topic:\n    description: Kafka topic name or pattern\n    maxLength: 249\n    minLength: 1\n    type: string\n  username:\n    description: Kafka username or username pattern\n    maxLength: 64\n    minLength: 1\n    type: string\nrequired:\n- username\n- topic\n- permission\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasKafkaTopicAclConfig(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-kafka-topic-acl-config name acl-id",
			Short:   "Delete a Kafka ACL entry",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasKafkaTopicAclConfig(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reveal-dbaas-kafka-connect-password service-name",
			Short:   "Reveal the secrets for DBaaS Kafka Connect",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XRevealDbaasKafkaConnectPassword(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-kafka-user service-name",
			Short:   "Create a DBaaS Kafka user",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  username:\n    $ref: '#/components/schemas/dbaas-user-username'\nrequired:\n- username\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasKafkaUser(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-kafka-user service-name username",
			Short:   "Delete a DBaaS kafka user",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasKafkaUser(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-dbaas-kafka-user-password service-name username",
			Short:   "Reset the credentials of a DBaaS Kafka user",
			Long:    cli.Markdown("If no password is provided one will be generated automatically.\n## Request Schema (application/json)\n\nproperties:\n  password:\n    $ref: '#/components/schemas/dbaas-user-password'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XResetDbaasKafkaUserPassword(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reveal-dbaas-kafka-user-password service-name username",
			Short:   "Reveal the secrets of a DBaaS Kafka user",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XRevealDbaasKafkaUserPassword(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-migration-status name",
			Short:   "Get a DBaaS migration status",
			Long:    cli.Markdown("Get a DBaaS migration status"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasMigrationStatus(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-service-mysql name",
			Short:   "Create a DBaaS MySQL service",
			Long:    cli.Markdown("Create a DBaaS MySQL service\n## Request Schema (application/json)\n\nproperties:\n  admin-password:\n    description: Custom password for admin user. Defaults to random string. This must be set only when a new service is being created.\n    maxLength: 256\n    minLength: 8\n    pattern: ^[a-zA-Z0-9-_]+$\n    type: string\n  admin-username:\n    description: Custom username for admin user. This must be set only when a new service is being created.\n    maxLength: 64\n    minLength: 1\n    pattern: ^[_A-Za-z0-9][-._A-Za-z0-9]{0,63}$\n    type: string\n  backup-schedule:\n    properties:\n      backup-hour:\n        description: The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.\n        format: int64\n        maximum: 23\n        minimum: 0\n        type: integer\n      backup-minute:\n        description: The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.\n        format: int64\n        maximum: 59\n        minimum: 0\n        type: integer\n    type: object\n  binlog-retention-period:\n    description: The minimum amount of time in seconds to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default for example if using the MySQL Debezium Kafka connector.\n    format: int64\n    maximum: 86400\n    minimum: 600\n    type: integer\n  fork-from-service:\n    $ref: '#/components/schemas/dbaas-service-name'\n  integrations:\n    description: Service integrations to be enabled when creating the service.\n    items:\n      properties:\n        dest-service:\n          $ref: '#/components/schemas/dbaas-service-name'\n        settings:\n          description: Integration settings\n          type: object\n        source-service:\n          $ref: '#/components/schemas/dbaas-service-name'\n        type:\n          description: Integration type\n          enum:\n          - read_replica\n          type: string\n      required:\n      - type\n      type: object\n    type: array\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  migration:\n    description: Migrate data from existing server\n    properties:\n      dbname:\n        description: Database name for bootstrapping the initial connection\n        maxLength: 63\n        minLength: 1\n        type: string\n      host:\n        description: Hostname or IP address of the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n      ignore-dbs:\n        description: Comma-separated list of databases, which should be ignored during migration (supported by MySQL only at the moment)\n        maxLength: 2048\n        minLength: 1\n        type: string\n      method:\n        $ref: '#/components/schemas/enum-migration-method'\n      password:\n        description: Password for authentication with the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n      port:\n        description: Port number of the server where to migrate data from\n        format: int64\n        maximum: 65535\n        minimum: 1\n        type: integer\n      ssl:\n        description: The server where to migrate data from is secured with SSL\n        type: boolean\n      username:\n        description: User name for authentication with the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n    required:\n    - host\n    - port\n    type: object\n  mysql-settings:\n    $ref: '#/components/schemas/json-schema-mysql'\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  recovery-backup-time:\n    description: ISO time of a backup to recover from for services that support arbitrary times\n    minLength: 1\n    type: string\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\n  version:\n    description: MySQL major version\n    minLength: 1\n    type: string\nrequired:\n- plan\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasServiceMysql(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-service-mysql name",
			Short:   "Delete a MySQL service",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasServiceMysql(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-service-mysql name",
			Short:   "Get a DBaaS MySQL service",
			Long:    cli.Markdown("Get a DBaaS MySQL service"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasServiceMysql(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-service-mysql name",
			Short:   "Update a DBaaS MySQL service",
			Long:    cli.Markdown("Update a DBaaS MySQL service\n## Request Schema (application/json)\n\nproperties:\n  backup-schedule:\n    properties:\n      backup-hour:\n        description: The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.\n        format: int64\n        maximum: 23\n        minimum: 0\n        type: integer\n      backup-minute:\n        description: The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.\n        format: int64\n        maximum: 59\n        minimum: 0\n        type: integer\n    type: object\n  binlog-retention-period:\n    description: The minimum amount of time in seconds to keep binlog entries before deletion. This may be extended for services that require binlog entries for longer than the default for example if using the MySQL Debezium Kafka connector.\n    format: int64\n    maximum: 86400\n    minimum: 600\n    type: integer\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  migration:\n    description: Migrate data from existing server\n    properties:\n      dbname:\n        description: Database name for bootstrapping the initial connection\n        maxLength: 63\n        minLength: 1\n        type: string\n      host:\n        description: Hostname or IP address of the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n      ignore-dbs:\n        description: Comma-separated list of databases, which should be ignored during migration (supported by MySQL only at the moment)\n        maxLength: 2048\n        minLength: 1\n        type: string\n      method:\n        $ref: '#/components/schemas/enum-migration-method'\n      password:\n        description: Password for authentication with the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n      port:\n        description: Port number of the server where to migrate data from\n        format: int64\n        maximum: 65535\n        minimum: 1\n        type: integer\n      ssl:\n        description: The server where to migrate data from is secured with SSL\n        type: boolean\n      username:\n        description: User name for authentication with the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n    required:\n    - host\n    - port\n    type: object\n  mysql-settings:\n    $ref: '#/components/schemas/json-schema-mysql'\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasServiceMysql(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "enable-dbaas-mysql-writes name",
			Short:   "Temporarily enable writes for MySQL services in read-only mode due to filled up storage",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XEnableDbaasMysqlWrites(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "start-dbaas-mysql-maintenance name",
			Short:   "Initiate MySQL maintenance update",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XStartDbaasMysqlMaintenance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "stop-dbaas-mysql-migration name",
			Short:   "Stop a DBaaS MySQL migration",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XStopDbaasMysqlMigration(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-mysql-database service-name",
			Short:   "Create a DBaaS MySQL database",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  database-name:\n    $ref: '#/components/schemas/dbaas-database-name'\nrequired:\n- database-name\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasMysqlDatabase(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-mysql-database service-name database-name",
			Short:   "Delete a DBaaS MySQL database",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasMysqlDatabase(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-mysql-user service-name",
			Short:   "Create a DBaaS MySQL user",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  authentication:\n    $ref: '#/components/schemas/enum-mysql-authentication-plugin'\n  username:\n    $ref: '#/components/schemas/dbaas-user-username'\nrequired:\n- username\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasMysqlUser(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-mysql-user service-name username",
			Short:   "Delete a DBaaS MySQL user",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasMysqlUser(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-dbaas-mysql-user-password service-name username",
			Short:   "Reset the credentials of a DBaaS mysql user",
			Long:    cli.Markdown("If no password is provided one will be generated automatically.\n## Request Schema (application/json)\n\nproperties:\n  authentication:\n    $ref: '#/components/schemas/enum-mysql-authentication-plugin'\n  password:\n    $ref: '#/components/schemas/dbaas-user-password'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XResetDbaasMysqlUserPassword(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reveal-dbaas-mysql-user-password service-name username",
			Short:   "Reveal the secrets of a DBaaS MySQL user",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XRevealDbaasMysqlUserPassword(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-service-opensearch name",
			Short:   "Create a DBaaS OpenSearch service",
			Long:    cli.Markdown("Create a DBaaS OpenSearch service\n## Request Schema (application/json)\n\nproperties:\n  fork-from-service:\n    $ref: '#/components/schemas/dbaas-service-name'\n  index-patterns:\n    description: 'Allows you to create glob style patterns and set a max number of indexes matching this pattern you want to keep. Creating indexes exceeding this value will cause the oldest one to get deleted. You could for example create a pattern looking like ''logs.?'' and then create index logs.1, logs.2 etc, it will delete logs.1 once you create logs.6. Do note ''logs.?'' does not apply to logs.10. Note: Setting max_index_count to 0 will do nothing and the pattern gets ignored.'\n    items:\n      properties:\n        max-index-count:\n          description: Maximum number of indexes to keep\n          format: int64\n          minimum: 0\n          type: integer\n        pattern:\n          description: fnmatch pattern\n          maxLength: 1024\n          type: string\n        sorting-algorithm:\n          description: Deletion sorting algorithm\n          enum:\n          - alphabetical\n          - creation_date\n          type: string\n      type: object\n    type: array\n  index-template:\n    description: Template settings for all new indexes\n    properties:\n      mapping-nested-objects-limit:\n        description: The maximum number of nested JSON objects that a single document can contain across all nested types. This limit helps to prevent out of memory errors when a document contains too many nested objects. Default is 10000.\n        format: int64\n        maximum: 100000\n        minimum: 0\n        type: integer\n      number-of-replicas:\n        description: The number of replicas each primary shard has.\n        format: int64\n        maximum: 29\n        minimum: 0\n        type: integer\n      number-of-shards:\n        description: The number of primary shards that an index should have.\n        format: int64\n        maximum: 1024\n        minimum: 1\n        type: integer\n    type: object\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  keep-index-refresh-interval:\n    description: Aiven automation resets index.refresh_interval to default value for every index to be sure that indices are always visible to search. If it doesn't fit your case, you can disable this by setting up this flag to true.\n    type: boolean\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  max-index-count:\n    description: Maximum number of indexes to keep before deleting the oldest one\n    format: int64\n    minimum: 0\n    type: integer\n  opensearch-dashboards:\n    description: OpenSearch Dashboards settings\n    properties:\n      enabled:\n        description: 'Enable or disable OpenSearch Dashboards (default: true)'\n        type: boolean\n      max-old-space-size:\n        description: 'Limits the maximum amount of memory (in MiB) the OpenSearch Dashboards process can use. This sets the max_old_space_size option of the nodejs running the OpenSearch Dashboards. Note: the memory reserved by OpenSearch Dashboards is not available for OpenSearch. (default: 128)'\n        format: int64\n        maximum: 1024\n        minimum: 64\n        type: integer\n      opensearch-request-timeout:\n        description: 'Timeout in milliseconds for requests made by OpenSearch Dashboards towards OpenSearch (default: 30000)'\n        format: int64\n        maximum: 120000\n        minimum: 5000\n        type: integer\n    type: object\n  opensearch-settings:\n    $ref: '#/components/schemas/json-schema-opensearch'\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  recovery-backup-name:\n    description: Name of a backup to recover from for services that support backup names\n    minLength: 1\n    type: string\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\n  version:\n    description: OpenSearch major version\n    minLength: 1\n    type: string\nrequired:\n- plan\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasServiceOpensearch(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-service-opensearch name",
			Short:   "Delete a OpenSearch service",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasServiceOpensearch(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-service-opensearch name",
			Short:   "Get a DBaaS OpenSearch service",
			Long:    cli.Markdown("Get a DBaaS OpenSearch service"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasServiceOpensearch(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-service-opensearch name",
			Short:   "Update a DBaaS OpenSearch service",
			Long:    cli.Markdown("Update a DBaaS OpenSearch service\n## Request Schema (application/json)\n\nproperties:\n  index-patterns:\n    description: 'Allows you to create glob style patterns and set a max number of indexes matching this pattern you want to keep. Creating indexes exceeding this value will cause the oldest one to get deleted. You could for example create a pattern looking like ''logs.?'' and then create index logs.1, logs.2 etc, it will delete logs.1 once you create logs.6. Do note ''logs.?'' does not apply to logs.10. Note: Setting max_index_count to 0 will do nothing and the pattern gets ignored.'\n    items:\n      properties:\n        max-index-count:\n          description: Maximum number of indexes to keep\n          format: int64\n          minimum: 0\n          type: integer\n        pattern:\n          description: fnmatch pattern\n          maxLength: 1024\n          type: string\n        sorting-algorithm:\n          description: Deletion sorting algorithm\n          enum:\n          - alphabetical\n          - creation_date\n          type: string\n      type: object\n    type: array\n  index-template:\n    description: Template settings for all new indexes\n    properties:\n      mapping-nested-objects-limit:\n        description: The maximum number of nested JSON objects that a single document can contain across all nested types. This limit helps to prevent out of memory errors when a document contains too many nested objects. Default is 10000.\n        format: int64\n        maximum: 100000\n        minimum: 0\n        type: integer\n      number-of-replicas:\n        description: The number of replicas each primary shard has.\n        format: int64\n        maximum: 29\n        minimum: 0\n        type: integer\n      number-of-shards:\n        description: The number of primary shards that an index should have.\n        format: int64\n        maximum: 1024\n        minimum: 1\n        type: integer\n    type: object\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  keep-index-refresh-interval:\n    description: Aiven automation resets index.refresh_interval to default value for every index to be sure that indices are always visible to search. If it doesn't fit your case, you can disable this by setting up this flag to true.\n    type: boolean\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  max-index-count:\n    description: Maximum number of indexes to keep before deleting the oldest one\n    format: int64\n    minimum: 0\n    type: integer\n  opensearch-dashboards:\n    description: OpenSearch Dashboards settings\n    properties:\n      enabled:\n        description: 'Enable or disable OpenSearch Dashboards (default: true)'\n        type: boolean\n      max-old-space-size:\n        description: 'Limits the maximum amount of memory (in MiB) the OpenSearch Dashboards process can use. This sets the max_old_space_size option of the nodejs running the OpenSearch Dashboards. Note: the memory reserved by OpenSearch Dashboards is not available for OpenSearch. (default: 128)'\n        format: int64\n        maximum: 1024\n        minimum: 64\n        type: integer\n      opensearch-request-timeout:\n        description: 'Timeout in milliseconds for requests made by OpenSearch Dashboards towards OpenSearch (default: 30000)'\n        format: int64\n        maximum: 120000\n        minimum: 5000\n        type: integer\n    type: object\n  opensearch-settings:\n    $ref: '#/components/schemas/json-schema-opensearch'\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\n  version:\n    description: Version\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasServiceOpensearch(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-opensearch-acl-config name",
			Short:   "Get DBaaS OpenSearch ACL configuration",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasOpensearchAclConfig(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-opensearch-acl-config name",
			Short:   "Create a DBaaS OpenSearch ACL configuration",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  acl-enabled:\n    description: Enable OpenSearch ACLs. When disabled authenticated service users have unrestricted access.\n    type: boolean\n  acls:\n    description: List of OpenSearch ACLs\n    items:\n      properties:\n        rules:\n          items:\n            properties:\n              index:\n                description: OpenSearch index pattern\n                maxLength: 249\n                type: string\n              permission:\n                $ref: '#/components/schemas/enum-opensearch-rule-permission'\n            required:\n            - index\n            type: object\n          type: array\n        username:\n          $ref: '#/components/schemas/dbaas-user-username'\n      type: object\n    type: array\n  extended-acl-enabled:\n    description: Enable to enforce index rules in a limited fashion for requests that use the _mget, _msearch, and _bulk APIs\n    type: boolean\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasOpensearchAclConfig(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "start-dbaas-opensearch-maintenance name",
			Short:   "Initiate OpenSearch maintenance update",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XStartDbaasOpensearchMaintenance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-opensearch-user service-name",
			Short:   "Create a DBaaS OpenSearch user",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  username:\n    $ref: '#/components/schemas/dbaas-user-username'\nrequired:\n- username\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasOpensearchUser(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-opensearch-user service-name username",
			Short:   "Delete a DBaaS OpenSearch user",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasOpensearchUser(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-dbaas-opensearch-user-password service-name username",
			Short:   "Reset the credentials of a DBaaS OpenSearch user",
			Long:    cli.Markdown("If no password is provided one will be generated automatically.\n## Request Schema (application/json)\n\nproperties:\n  password:\n    $ref: '#/components/schemas/dbaas-user-password'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XResetDbaasOpensearchUserPassword(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reveal-dbaas-opensearch-user-password service-name username",
			Short:   "Reveal the secrets of a DBaaS OpenSearch user",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XRevealDbaasOpensearchUserPassword(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-service-pg name",
			Short:   "Create a DBaaS PostgreSQL service",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  admin-password:\n    description: Custom password for admin user. Defaults to random string. This must be set only when a new service is being created.\n    maxLength: 256\n    minLength: 8\n    pattern: ^[a-zA-Z0-9-_]+$\n    type: string\n  admin-username:\n    description: Custom username for admin user. This must be set only when a new service is being created.\n    maxLength: 64\n    minLength: 1\n    pattern: ^[_A-Za-z0-9][-._A-Za-z0-9]{0,63}$\n    type: string\n  backup-schedule:\n    properties:\n      backup-hour:\n        description: The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.\n        format: int64\n        maximum: 23\n        minimum: 0\n        type: integer\n      backup-minute:\n        description: The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.\n        format: int64\n        maximum: 59\n        minimum: 0\n        type: integer\n    type: object\n  fork-from-service:\n    $ref: '#/components/schemas/dbaas-service-name'\n  integrations:\n    description: Service integrations to be enabled when creating the service.\n    items:\n      properties:\n        dest-service:\n          $ref: '#/components/schemas/dbaas-service-name'\n        settings:\n          description: Integration settings\n          type: object\n        source-service:\n          $ref: '#/components/schemas/dbaas-service-name'\n        type:\n          description: Integration type\n          enum:\n          - read_replica\n          type: string\n      required:\n      - type\n      type: object\n    type: array\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  migration:\n    description: Migrate data from existing server\n    properties:\n      dbname:\n        description: Database name for bootstrapping the initial connection\n        maxLength: 63\n        minLength: 1\n        type: string\n      host:\n        description: Hostname or IP address of the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n      ignore-dbs:\n        description: Comma-separated list of databases, which should be ignored during migration (supported by MySQL only at the moment)\n        maxLength: 2048\n        minLength: 1\n        type: string\n      method:\n        $ref: '#/components/schemas/enum-migration-method'\n      password:\n        description: Password for authentication with the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n      port:\n        description: Port number of the server where to migrate data from\n        format: int64\n        maximum: 65535\n        minimum: 1\n        type: integer\n      ssl:\n        description: The server where to migrate data from is secured with SSL\n        type: boolean\n      username:\n        description: User name for authentication with the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n    required:\n    - host\n    - port\n    type: object\n  pg-settings:\n    $ref: '#/components/schemas/json-schema-pg'\n  pgbouncer-settings:\n    $ref: '#/components/schemas/json-schema-pgbouncer'\n  pglookout-settings:\n    $ref: '#/components/schemas/json-schema-pglookout'\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  recovery-backup-time:\n    description: ISO time of a backup to recover from for services that support arbitrary times\n    minLength: 1\n    type: string\n  shared-buffers-percentage:\n    description: Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.\n    format: int64\n    maximum: 60\n    minimum: 20\n    type: integer\n  synchronous-replication:\n    $ref: '#/components/schemas/enum-pg-synchronous-replication'\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\n  timescaledb-settings:\n    $ref: '#/components/schemas/json-schema-timescaledb'\n  variant:\n    $ref: '#/components/schemas/enum-pg-variant'\n  version:\n    $ref: '#/components/schemas/dbaas-pg-target-versions'\n  work-mem:\n    description: Sets the maximum amount of memory to be used by a query operation (such as a sort or hash table) before writing to temporary disk files, in MB. Default is 1MB + 0.075% of total RAM (up to 32MB).\n    format: int64\n    maximum: 1024\n    minimum: 1\n    type: integer\nrequired:\n- plan\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasServicePg(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-service-pg name",
			Short:   "Delete a Postgres service",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasServicePg(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-service-pg name",
			Short:   "Get a DBaaS PostgreSQL service",
			Long:    cli.Markdown("Get a DBaaS PostgreSQL service"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasServicePg(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-service-pg name",
			Short:   "Update a DBaaS PostgreSQL service",
			Long:    cli.Markdown("Update a DBaaS PostgreSQL service\n## Request Schema (application/json)\n\nproperties:\n  backup-schedule:\n    properties:\n      backup-hour:\n        description: The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.\n        format: int64\n        maximum: 23\n        minimum: 0\n        type: integer\n      backup-minute:\n        description: The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.\n        format: int64\n        maximum: 59\n        minimum: 0\n        type: integer\n    type: object\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  migration:\n    description: Migrate data from existing server\n    properties:\n      dbname:\n        description: Database name for bootstrapping the initial connection\n        maxLength: 63\n        minLength: 1\n        type: string\n      host:\n        description: Hostname or IP address of the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n      ignore-dbs:\n        description: Comma-separated list of databases, which should be ignored during migration (supported by MySQL only at the moment)\n        maxLength: 2048\n        minLength: 1\n        type: string\n      method:\n        $ref: '#/components/schemas/enum-migration-method'\n      password:\n        description: Password for authentication with the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n      port:\n        description: Port number of the server where to migrate data from\n        format: int64\n        maximum: 65535\n        minimum: 1\n        type: integer\n      ssl:\n        description: The server where to migrate data from is secured with SSL\n        type: boolean\n      username:\n        description: User name for authentication with the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n    required:\n    - host\n    - port\n    type: object\n  pg-settings:\n    $ref: '#/components/schemas/json-schema-pg'\n  pgbouncer-settings:\n    $ref: '#/components/schemas/json-schema-pgbouncer'\n  pglookout-settings:\n    $ref: '#/components/schemas/json-schema-pglookout'\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  shared-buffers-percentage:\n    description: Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.\n    format: int64\n    maximum: 60\n    minimum: 20\n    type: integer\n  synchronous-replication:\n    $ref: '#/components/schemas/enum-pg-synchronous-replication'\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\n  timescaledb-settings:\n    $ref: '#/components/schemas/json-schema-timescaledb'\n  variant:\n    $ref: '#/components/schemas/enum-pg-variant'\n  version:\n    description: Version\n    type: string\n  work-mem:\n    description: Sets the maximum amount of memory to be used by a query operation (such as a sort or hash table) before writing to temporary disk files, in MB. Default is 1MB + 0.075% of total RAM (up to 32MB).\n    format: int64\n    maximum: 1024\n    minimum: 1\n    type: integer\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasServicePg(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "start-dbaas-pg-maintenance name",
			Short:   "Initiate PostgreSQL maintenance update",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XStartDbaasPgMaintenance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "stop-dbaas-pg-migration name",
			Short:   "Stop a DBaaS PostgreSQL migration",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XStopDbaasPgMigration(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-pg-connection-pool service-name",
			Short:   "Create a DBaaS PostgreSQL connection pool",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  database-name:\n    $ref: '#/components/schemas/dbaas-database-name'\n  mode:\n    $ref: '#/components/schemas/enum-pg-pool-mode'\n  name:\n    $ref: '#/components/schemas/dbaas-pg-pool-name'\n  size:\n    $ref: '#/components/schemas/dbaas-pg-pool-size'\n  username:\n    $ref: '#/components/schemas/dbaas-pg-pool-username'\nrequired:\n- name\n- database-name\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasPgConnectionPool(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-pg-connection-pool service-name connection-pool-name",
			Short:   "Delete a DBaaS PostgreSQL connection pool",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasPgConnectionPool(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-pg-connection-pool service-name connection-pool-name",
			Short:   "Update a DBaaS PostgreSQL connection pool",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  database-name:\n    $ref: '#/components/schemas/dbaas-database-name'\n  mode:\n    $ref: '#/components/schemas/enum-pg-pool-mode'\n  size:\n    $ref: '#/components/schemas/dbaas-pg-pool-size'\n  username:\n    $ref: '#/components/schemas/dbaas-pg-pool-username'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasPgConnectionPool(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-pg-database service-name",
			Short:   "Create a DBaaS Postgres database",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  database-name:\n    $ref: '#/components/schemas/dbaas-database-name'\n  lc-collate:\n    description: Default string sort order (LC_COLLATE) for PostgreSQL database\n    maxLength: 128\n    type: string\n  lc-ctype:\n    description: Default character classification (LC_CTYPE) for PostgreSQL database\n    maxLength: 128\n    type: string\nrequired:\n- database-name\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasPgDatabase(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-pg-database service-name database-name",
			Short:   "Delete a DBaaS Postgres database",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasPgDatabase(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-postgres-user service-name",
			Short:   "Create a DBaaS Postgres user",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  allow-replication:\n    type: boolean\n  username:\n    $ref: '#/components/schemas/dbaas-user-username'\nrequired:\n- username\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasPostgresUser(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-postgres-user service-name username",
			Short:   "Delete a DBaaS Postgres user",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasPostgresUser(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-postgres-allow-replication service-name username",
			Short:   "Update access control for one service user",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  allow-replication:\n    type: boolean\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasPostgresAllowReplication(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-dbaas-postgres-user-password service-name username",
			Short:   "Reset the credentials of a DBaaS Postgres user",
			Long:    cli.Markdown("If no password is provided one will be generated automatically.\n## Request Schema (application/json)\n\nproperties:\n  password:\n    $ref: '#/components/schemas/dbaas-user-password'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XResetDbaasPostgresUserPassword(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reveal-dbaas-postgres-user-password service-name username",
			Short:   "Reveal the secrets of a DBaaS Postgres user",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XRevealDbaasPostgresUserPassword(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-pg-upgrade-check service",
			Short:   "create-dbaas-pg-upgrade-check",
			Long:    cli.Markdown("Check whether you can upgrade Postgres service to a newer version\n## Request Schema (application/json)\n\nproperties:\n  target-version:\n    $ref: '#/components/schemas/dbaas-pg-target-versions'\nrequired:\n- target-version\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasPgUpgradeCheck(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-dbaas-services",
			Short:   "List DBaaS services",
			Long:    cli.Markdown("List DBaaS services"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListDbaasServices(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-service-logs service-name",
			Short:   "Get logs of DBaaS service",
			Long:    cli.Markdown("Get logs of DBaaS service\n## Request Schema (application/json)\n\nproperties:\n  limit:\n    description: 'How many log entries to receive at most, up to 500 (default: 100)'\n    format: int64\n    maximum: 500\n    minimum: 1\n    type: integer\n  offset:\n    description: Opaque offset identifier\n    type: string\n  sort-order:\n    $ref: '#/components/schemas/enum-sort-order'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XGetDbaasServiceLogs(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-service-metrics service-name",
			Short:   "Get metrics of DBaaS service",
			Long:    cli.Markdown("Get metrics of DBaaS service\n## Request Schema (application/json)\n\nproperties:\n  period:\n    description: 'Metrics time period (default: hour)'\n    enum:\n    - hour\n    - week\n    - year\n    - month\n    - day\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XGetDbaasServiceMetrics(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-dbaas-service-types",
			Short:   "DBaaS Service Types",
			Long:    cli.Markdown("List available service types for DBaaS"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListDbaasServiceTypes(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-service-type service-type-name",
			Short:   "Get a DBaaS service type",
			Long:    cli.Markdown("Get a DBaaS service type"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasServiceType(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-service name",
			Short:   "Delete a DBaaS service",
			Long:    cli.Markdown("Delete a DBaaS service"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasService(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-settings-grafana",
			Short:   "Get DBaaS Grafana settings",
			Long:    cli.Markdown("Get DBaaS Grafana settings"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasSettingsGrafana(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-settings-kafka",
			Short:   "Get DBaaS Kafka settings",
			Long:    cli.Markdown("Get DBaaS Kafka settings"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasSettingsKafka(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-settings-mysql",
			Short:   "Get DBaaS MySQL settings",
			Long:    cli.Markdown("Get DBaaS MySQL settings"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasSettingsMysql(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-settings-opensearch",
			Short:   "Get DBaaS OpenSearch settings",
			Long:    cli.Markdown("Get DBaaS OpenSearch settings"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasSettingsOpensearch(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-settings-pg",
			Short:   "Get DBaaS PostgreSQL settings",
			Long:    cli.Markdown("Get DBaaS PostgreSQL settings"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasSettingsPg(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-settings-valkey",
			Short:   "Get DBaaS Valkey settings",
			Long:    cli.Markdown("Returns the default settings for Valkey."),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasSettingsValkey(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-task-migration-check service",
			Short:   "create-dbaas-task-migration-check",
			Long:    cli.Markdown("Create a DBaaS task to check migration\n## Request Schema (application/json)\n\nproperties:\n  ignore-dbs:\n    description: Comma-separated list of databases, which should be ignored during migration (supported by MySQL only at the moment)\n    maxLength: 2048\n    minLength: 1\n    type: string\n  method:\n    $ref: '#/components/schemas/enum-migration-method'\n  source-service-uri:\n    description: Service URI of the source MySQL or PostgreSQL database with admin credentials.\n    maxLength: 512\n    minLength: 1\n    type: string\nrequired:\n- source-service-uri\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasTaskMigrationCheck(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-task service id",
			Short:   "Get a DBaaS task",
			Long:    cli.Markdown("Get a DBaaS task"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasTask(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-service-valkey name",
			Short:   "Create a DBaaS Valkey service",
			Long:    cli.Markdown("Create a DBaaS Valkey service\n## Request Schema (application/json)\n\nproperties:\n  fork-from-service:\n    $ref: '#/components/schemas/dbaas-service-name'\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  migration:\n    description: Migrate data from existing server\n    properties:\n      dbname:\n        description: Database name for bootstrapping the initial connection\n        maxLength: 63\n        minLength: 1\n        type: string\n      host:\n        description: Hostname or IP address of the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n      ignore-dbs:\n        description: Comma-separated list of databases, which should be ignored during migration (supported by MySQL only at the moment)\n        maxLength: 2048\n        minLength: 1\n        type: string\n      method:\n        $ref: '#/components/schemas/enum-migration-method'\n      password:\n        description: Password for authentication with the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n      port:\n        description: Port number of the server where to migrate data from\n        format: int64\n        maximum: 65535\n        minimum: 1\n        type: integer\n      ssl:\n        description: The server where to migrate data from is secured with SSL\n        type: boolean\n      username:\n        description: User name for authentication with the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n    required:\n    - host\n    - port\n    type: object\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  recovery-backup-name:\n    description: Name of a backup to recover from for services that support backup names\n    minLength: 1\n    type: string\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\n  valkey-settings:\n    $ref: '#/components/schemas/json-schema-valkey'\nrequired:\n- plan\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasServiceValkey(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-service-valkey name",
			Short:   "Delete a Valkey service",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasServiceValkey(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dbaas-service-valkey name",
			Short:   "get-dbaas-service-valkey",
			Long:    cli.Markdown("Get a DBaaS Valkey service"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDbaasServiceValkey(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dbaas-service-valkey name",
			Short:   "update-dbaas-service-valkey",
			Long:    cli.Markdown("Update a DBaaS Valkey service\n## Request Schema (application/json)\n\nproperties:\n  ip-filter:\n    description: Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'\n    items:\n      type: string\n    type: array\n  maintenance:\n    description: Automatic maintenance settings\n    properties:\n      dow:\n        description: Day of week for installing updates\n        enum:\n        - saturday\n        - tuesday\n        - never\n        - wednesday\n        - sunday\n        - friday\n        - monday\n        - thursday\n        type: string\n      time:\n        description: Time for installing updates, UTC\n        maxLength: 8\n        minLength: 8\n        type: string\n    required:\n    - dow\n    - time\n    type: object\n  migration:\n    description: Migrate data from existing server\n    properties:\n      dbname:\n        description: Database name for bootstrapping the initial connection\n        maxLength: 63\n        minLength: 1\n        type: string\n      host:\n        description: Hostname or IP address of the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n      ignore-dbs:\n        description: Comma-separated list of databases, which should be ignored during migration (supported by MySQL only at the moment)\n        maxLength: 2048\n        minLength: 1\n        type: string\n      method:\n        $ref: '#/components/schemas/enum-migration-method'\n      password:\n        description: Password for authentication with the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n      port:\n        description: Port number of the server where to migrate data from\n        format: int64\n        maximum: 65535\n        minimum: 1\n        type: integer\n      ssl:\n        description: The server where to migrate data from is secured with SSL\n        type: boolean\n      username:\n        description: User name for authentication with the server where to migrate data from\n        maxLength: 255\n        minLength: 1\n        type: string\n    required:\n    - host\n    - port\n    type: object\n  plan:\n    description: Subscription plan\n    maxLength: 128\n    minLength: 1\n    type: string\n  termination-protection:\n    description: Service is protected against termination and powering off\n    type: boolean\n  valkey-settings:\n    $ref: '#/components/schemas/json-schema-valkey'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDbaasServiceValkey(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "start-dbaas-valkey-maintenance name",
			Short:   "Initiate Valkey maintenance update",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XStartDbaasValkeyMaintenance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "stop-dbaas-valkey-migration name",
			Short:   "Stop a DBaaS Valkey migration",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XStopDbaasValkeyMigration(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dbaas-valkey-user service-name",
			Short:   "Create a DBaaS Valkey user",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  username:\n    $ref: '#/components/schemas/dbaas-user-username'\nrequired:\n- username\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDbaasValkeyUser(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dbaas-valkey-user service-name username",
			Short:   "Delete a DBaaS Valkey user",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDbaasValkeyUser(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-dbaas-valkey-user-password service-name username",
			Short:   "Reset the credentials of a DBaaS Valkey user",
			Long:    cli.Markdown("If no password is provided one will be generated automatically.\n## Request Schema (application/json)\n\nproperties:\n  password:\n    $ref: '#/components/schemas/dbaas-user-password'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XResetDbaasValkeyUserPassword(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reveal-dbaas-valkey-user-password service-name username",
			Short:   "Reveal the secrets of a DBaaS Valkey user",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XRevealDbaasValkeyUserPassword(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-deploy-targets",
			Short:   "List Deploy Targets",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListDeployTargets(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-deploy-target id",
			Short:   "Retrieve Deploy Target details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDeployTarget(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dns-domain",
			Short:   "Create DNS domain",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\ndescription: DNS Domain\nproperties:\n  unicode-name:\n    description: Domain name\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDnsDomain(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-dns-domains",
			Short:   "List DNS domains",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListDnsDomains(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-dns-domain-record domain-id",
			Short:   "Create DNS domain record",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  content:\n    description: DNS domain record content\n    type: string\n  name:\n    description: DNS domain record name\n    type: string\n  priority:\n    description: DNS domain record priority\n    format: int64\n    minimum: 0\n    type: integer\n  ttl:\n    description: DNS domain record TTL\n    format: int64\n    minimum: 0\n    type: integer\n  type:\n    description: DNS domain record type\n    enum:\n    - NS\n    - CAA\n    - NAPTR\n    - POOL\n    - A\n    - HINFO\n    - CNAME\n    - SSHFP\n    - SRV\n    - AAAA\n    - MX\n    - TXT\n    - ALIAS\n    - URL\n    - SPF\n    type: string\nrequired:\n- name\n- type\n- content\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateDnsDomainRecord(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-dns-domain-records domain-id",
			Short:   "List DNS domain records",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListDnsDomainRecords(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dns-domain-record domain-id record-id",
			Short:   "Delete DNS domain record",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDnsDomainRecord(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dns-domain-record domain-id record-id",
			Short:   "Retrieve DNS domain record details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDnsDomainRecord(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-dns-domain-record domain-id record-id",
			Short:   "Update DNS domain record",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  content:\n    description: DNS domain record content\n    type: string\n  name:\n    description: DNS domain record name\n    type: string\n  priority:\n    description: DNS domain record priority\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\n  ttl:\n    description: DNS domain record TTL\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateDnsDomainRecord(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-dns-domain id",
			Short:   "Delete DNS Domain",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteDnsDomain(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dns-domain id",
			Short:   "Retrieve DNS domain details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDnsDomain(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-dns-domain-zone-file id",
			Short:   "Retrieve DNS domain zone file",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetDnsDomainZoneFile(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-elastic-ip",
			Short:   "Create an Elastic IP",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  addressfamily:\n    description: 'Elastic IP address family (default: :inet4)'\n    enum:\n    - inet4\n    - inet6\n    type: string\n  description:\n    description: Elastic IP description\n    maxLength: 255\n    type: string\n  healthcheck:\n    $ref: '#/components/schemas/elastic-ip-healthcheck'\n  labels:\n    $ref: '#/components/schemas/labels'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateElasticIp(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-elastic-ips",
			Short:   "List Elastic IPs",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListElasticIps(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-elastic-ip id",
			Short:   "Delete an Elastic IP",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteElasticIp(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-elastic-ip id",
			Short:   "Retrieve Elastic IP details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetElasticIp(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-elastic-ip id",
			Short:   "Update an Elastic IP",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Elastic IP description\n    maxLength: 255\n    type: string\n  healthcheck:\n    $ref: '#/components/schemas/elastic-ip-healthcheck'\n  labels:\n    $ref: '#/components/schemas/labels'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateElasticIp(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-elastic-ip-field id field",
			Short:   "Reset an Elastic IP field to its default value",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XResetElasticIpField(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "attach-instance-to-elastic-ip id",
			Short:   "Attach a Compute instance to an Elastic IP",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  instance:\n    $ref: '#/components/schemas/instance-target'\nrequired:\n- instance\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XAttachInstanceToElasticIp(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "detach-instance-from-elastic-ip id",
			Short:   "Detach a Compute instance from an Elastic IP",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  instance:\n    $ref: '#/components/schemas/instance-target'\nrequired:\n- instance\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XDetachInstanceFromElasticIp(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-env-impact",
			Short:   "[BETA] Retrieve organization environmental impact reports",
			Long:    cli.Markdown("[BETA] Returns environmental impact reports for an organization"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetEnvImpact(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cmd.Flags().String("period", "", "")

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-events",
			Short:   "List Events",
			Long:    cli.Markdown("Retrieve Mutation Events for a given date range. Defaults to retrieving Events for the past 24 hours.\n         Both a `from` and `to` arguments can be specified to filter Events over a specific period.\n         Events will be the the most descriptive possible but not all fields are mandatory"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListEvents(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cmd.Flags().String("from", "", "")
		cmd.Flags().String("to", "", "")

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-iam-organization-policy",
			Short:   "Retrieve IAM Organization Policy",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetIamOrganizationPolicy(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-iam-organization-policy",
			Short:   "Update IAM Organization Policy",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\ndescription: Policy\nproperties:\n  default-service-strategy:\n    description: IAM default service strategy\n    enum:\n    - allow\n    - deny\n    type: string\n  services:\n    additionalProperties:\n      $ref: '#/components/schemas/iam-service-policy'\n    description: IAM services\n    type: object\nrequired:\n- default-service-strategy\n- services\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateIamOrganizationPolicy(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-iam-organization-policy",
			Short:   "Reset IAM Organization Policy",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XResetIamOrganizationPolicy(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-iam-role",
			Short:   "Create IAM Role",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: IAM Role description\n    maxLength: 255\n    minLength: 1\n    type: string\n  editable:\n    description: 'Sets if the IAM Role Policy is editable or not (default: true). This setting cannot be changed after creation'\n    type: boolean\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: IAM Role name\n    maxLength: 191\n    minLength: 1\n    type: string\n  permissions:\n    description: IAM Role permissions\n    items:\n      enum:\n      - bypass-governance-retention\n      - reset-iam-organization-policy\n      type: string\n    type: array\n    uniqueItems: true\n  policy:\n    $ref: '#/components/schemas/iam-policy'\nrequired:\n- name\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateIamRole(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-iam-roles",
			Short:   "List IAM Roles",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListIamRoles(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-iam-role id",
			Short:   "Delete IAM Role",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteIamRole(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-iam-role id",
			Short:   "Retrieve IAM Role",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetIamRole(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-iam-role id",
			Short:   "Update IAM Role",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: IAM Role description\n    maxLength: 255\n    minLength: 1\n    type: string\n  labels:\n    $ref: '#/components/schemas/labels'\n  permissions:\n    description: IAM Role permissions\n    items:\n      enum:\n      - bypass-governance-retention\n      - reset-iam-organization-policy\n      type: string\n    type: array\n    uniqueItems: true\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateIamRole(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-iam-role-policy id",
			Short:   "Update IAM Role Policy",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\ndescription: Policy\nproperties:\n  default-service-strategy:\n    description: IAM default service strategy\n    enum:\n    - allow\n    - deny\n    type: string\n  services:\n    additionalProperties:\n      $ref: '#/components/schemas/iam-service-policy'\n    description: IAM services\n    type: object\nrequired:\n- default-service-strategy\n- services\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateIamRolePolicy(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-instance",
			Short:   "Create a Compute instance",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  anti-affinity-groups:\n    description: Instance Anti-affinity Groups\n    items:\n      $ref: '#/components/schemas/anti-affinity-group'\n    type: array\n    uniqueItems: true\n  auto-start:\n    description: 'Start Instance on creation (default: true)'\n    type: boolean\n  deploy-target:\n    $ref: '#/components/schemas/deploy-target'\n  disk-size:\n    description: Instance disk size in GiB\n    format: int64\n    maximum: 51200\n    minimum: 10\n    type: integer\n  instance-type:\n    $ref: '#/components/schemas/instance-type'\n  ipv6-enabled:\n    description: 'Enable IPv6. DEPRECATED: use `public-ip-assignments`.'\n    type: boolean\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Instance name\n    maxLength: 255\n    minLength: 1\n    type: string\n  public-ip-assignment:\n    $ref: '#/components/schemas/public-ip-assignment'\n  secureboot-enabled:\n    description: Enable secure boot\n    type: boolean\n  security-groups:\n    description: Instance Security Groups\n    items:\n      $ref: '#/components/schemas/security-group'\n    type: array\n    uniqueItems: true\n  ssh-key:\n    $ref: '#/components/schemas/ssh-key'\n  ssh-keys:\n    description: Instance SSH Keys\n    items:\n      $ref: '#/components/schemas/ssh-key'\n    type: array\n    uniqueItems: true\n  template:\n    $ref: '#/components/schemas/template'\n  tpm-enabled:\n    description: Enable Trusted Platform Module (TPM)\n    type: boolean\n  user-data:\n    description: Instance Cloud-init user-data (base64 encoded)\n    maxLength: 32768\n    minLength: 1\n    type: string\nrequired:\n- disk-size\n- instance-type\n- template\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateInstance(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-instances",
			Short:   "List Compute instances",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListInstances(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cmd.Flags().String("manager-id", "", "")
		cmd.Flags().String("manager-type", "", "")
		cmd.Flags().String("ip-address", "", "")

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-instance-pool",
			Short:   "Create an Instance Pool",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  anti-affinity-groups:\n    description: Instance Pool Anti-affinity Groups\n    items:\n      $ref: '#/components/schemas/anti-affinity-group'\n    type: array\n    uniqueItems: true\n  deploy-target:\n    $ref: '#/components/schemas/deploy-target'\n  description:\n    description: Instance Pool description\n    maxLength: 255\n    type: string\n  disk-size:\n    description: Instances disk size in GiB\n    format: int64\n    maximum: 51200\n    minimum: 10\n    type: integer\n  elastic-ips:\n    description: Instances Elastic IPs\n    items:\n      $ref: '#/components/schemas/elastic-ip'\n    type: array\n    uniqueItems: true\n  instance-prefix:\n    description: 'Prefix to apply to Instances names (default: pool)'\n    maxLength: 30\n    minLength: 1\n    type: string\n  instance-type:\n    $ref: '#/components/schemas/instance-type'\n  ipv6-enabled:\n    description: 'Enable IPv6. DEPRECATED: use `public-ip-assignments`.'\n    type: boolean\n  labels:\n    $ref: '#/components/schemas/labels'\n  min-available:\n    description: Minimum number of running Instances\n    format: int64\n    minimum: 0\n    type: integer\n  name:\n    description: Instance Pool name\n    maxLength: 255\n    minLength: 1\n    type: string\n  private-networks:\n    description: Instance Pool Private Networks\n    items:\n      $ref: '#/components/schemas/private-network'\n    type: array\n    uniqueItems: true\n  public-ip-assignment:\n    description: Determines public IP assignment of the Instances. Type `none` is final and can't be changed later on.\n    enum:\n    - inet4\n    - dual\n    - none\n    type: string\n  security-groups:\n    description: Instance Pool Security Groups\n    items:\n      $ref: '#/components/schemas/security-group'\n    type: array\n    uniqueItems: true\n  size:\n    description: Number of Instances\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\n  ssh-key:\n    $ref: '#/components/schemas/ssh-key'\n  ssh-keys:\n    description: Instances SSH Keys\n    items:\n      $ref: '#/components/schemas/ssh-key'\n    type: array\n    uniqueItems: true\n  template:\n    $ref: '#/components/schemas/template'\n  user-data:\n    description: Instances Cloud-init user-data\n    minLength: 1\n    type: string\nrequired:\n- name\n- size\n- instance-type\n- template\n- disk-size\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateInstancePool(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-instance-pools",
			Short:   "List Instance Pools",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListInstancePools(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-instance-pool id",
			Short:   "Delete an Instance Pool",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteInstancePool(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-instance-pool id",
			Short:   "Retrieve Instance Pool details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetInstancePool(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-instance-pool id",
			Short:   "Update an Instance Pool",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  anti-affinity-groups:\n    description: Instance Pool Anti-affinity Groups\n    items:\n      $ref: '#/components/schemas/anti-affinity-group'\n    nullable: true\n    type: array\n    uniqueItems: true\n  deploy-target:\n    $ref: '#/components/schemas/deploy-target'\n  description:\n    description: Instance Pool description\n    maxLength: 255\n    type: string\n  disk-size:\n    description: Instances disk size in GiB\n    format: int64\n    maximum: 51200\n    minimum: 10\n    type: integer\n  elastic-ips:\n    description: Instances Elastic IPs\n    items:\n      $ref: '#/components/schemas/elastic-ip'\n    nullable: true\n    type: array\n  instance-prefix:\n    description: 'Prefix to apply to Instances names (default: pool)'\n    nullable: true\n    type: string\n  instance-type:\n    $ref: '#/components/schemas/instance-type'\n  ipv6-enabled:\n    description: 'Enable IPv6. DEPRECATED: use `public-ip-assignments`.'\n    type: boolean\n  labels:\n    $ref: '#/components/schemas/labels'\n  min-available:\n    description: Minimum number of running Instances\n    format: int64\n    minimum: 0\n    nullable: true\n    type: integer\n  name:\n    description: Instance Pool name\n    maxLength: 255\n    minLength: 1\n    type: string\n  private-networks:\n    description: Instance Pool Private Networks\n    items:\n      $ref: '#/components/schemas/private-network'\n    nullable: true\n    type: array\n    uniqueItems: true\n  public-ip-assignment:\n    description: Determines public IP assignment of the Instances.\n    enum:\n    - inet4\n    - dual\n    type: string\n  security-groups:\n    description: Instance Pool Security Groups\n    items:\n      $ref: '#/components/schemas/security-group'\n    nullable: true\n    type: array\n    uniqueItems: true\n  ssh-key:\n    $ref: '#/components/schemas/ssh-key'\n  ssh-keys:\n    description: Instances SSH keys\n    items:\n      $ref: '#/components/schemas/ssh-key'\n    nullable: true\n    type: array\n    uniqueItems: true\n  template:\n    $ref: '#/components/schemas/template'\n  user-data:\n    description: Instances Cloud-init user-data\n    minLength: 1\n    nullable: true\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateInstancePool(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-instance-pool-field id field",
			Short:   "Reset an Instance Pool field to its default value",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XResetInstancePoolField(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "evict-instance-pool-members id",
			Short:   "Evict Instance Pool members",
			Long:    cli.Markdown("This operation evicts the specified Compute instances member from the Instance Pool, shrinking it to `&lt;current pool size&gt; - &lt;# evicted members&gt;`.\n## Request Schema (application/json)\n\nproperties:\n  instances:\n    items:\n      format: uuid\n      type: string\n    type: array\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XEvictInstancePoolMembers(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "scale-instance-pool id",
			Short:   "Scale an Instance Pool",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  size:\n    description: Number of managed Instances\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\nrequired:\n- size\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XScaleInstancePool(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-instance-types",
			Short:   "List Compute instance Types",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListInstanceTypes(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-instance-type id",
			Short:   "Retrieve Instance Type details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetInstanceType(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-instance id",
			Short:   "Delete a Compute instance",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteInstance(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-instance id",
			Short:   "Retrieve Compute instance details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetInstance(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-instance id",
			Short:   "Update a Compute instance",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Instance name\n    maxLength: 255\n    minLength: 1\n    type: string\n  public-ip-assignment:\n    $ref: '#/components/schemas/public-ip-assignment'\n  user-data:\n    description: Instance Cloud-init user-data (base64 encoded)\n    maxLength: 32768\n    minLength: 1\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateInstance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-instance-field id field",
			Short:   "Reset Instance field",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XResetInstanceField(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "add-instance-protection id",
			Short:   "Set instance destruction protection",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XAddInstanceProtection(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-snapshot id",
			Short:   "Create a Snapshot of a Compute instance",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateSnapshot(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "enable-tpm id",
			Short:   "Enable tpm for the instance.",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XEnableTpm(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reveal-instance-password id",
			Short:   "Reveal the password used during instance creation or the latest password reset.",
			Long:    cli.Markdown("Reveal the password used during instance creation or the latest password reset.\n            This is only available for VMs created against templates having the `password-enabled`\n            property set to `true`.\n\n            Passwords are transiently stored for at most 24 hours and intended to be retrieved shortly after\n            creation or resets."),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XRevealInstancePassword(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reboot-instance id",
			Short:   "Reboot a Compute instance",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XRebootInstance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "remove-instance-protection id",
			Short:   "Remove instance destruction protection",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XRemoveInstanceProtection(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-instance id",
			Short:   "Reset a Compute instance to a base/target template",
			Long:    cli.Markdown("This operation re-installs a Compute instance to a base template. If target template is provided it will be used to recreated instance from. Warning: the operation wipes all data stored on the disk.\n## Request Schema (application/json)\n\nproperties:\n  disk-size:\n    description: Instance disk size in GiB\n    format: int64\n    maximum: 51200\n    minimum: 10\n    type: integer\n  template:\n    $ref: '#/components/schemas/template'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XResetInstance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-instance-password id",
			Short:   "Reset a compute instance password",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XResetInstancePassword(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "resize-instance-disk id",
			Short:   "Resize a Compute instance disk",
			Long:    cli.Markdown("This operation resizes a Compute instance's disk volume. Note: the disk can only grow, cannot be shrunk.\n## Request Schema (application/json)\n\nproperties:\n  disk-size:\n    description: Instance disk size in GiB\n    format: int64\n    maximum: 51200\n    minimum: 10\n    type: integer\nrequired:\n- disk-size\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XResizeInstanceDisk(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "scale-instance id",
			Short:   "Scale a Compute instance to a new Instance Type",
			Long:    cli.Markdown("This operation changes the Compute instance's type. Note: the new Instance Type must be within the same family (e.g. a standard instance cannot be scaled to gpu2 or storage).\n## Request Schema (application/json)\n\nproperties:\n  instance-type:\n    $ref: '#/components/schemas/instance-type'\nrequired:\n- instance-type\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XScaleInstance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "start-instance id",
			Short:   "Start a Compute instance",
			Long:    cli.Markdown("This operation starts a virtual machine, potentially using a rescue profile if specified\n## Request Schema (application/json)\n\nproperties:\n  rescue-profile:\n    description: 'Boot in Rescue Mode, using named profile (supported: netboot, netboot-efi)'\n    enum:\n    - netboot-efi\n    - netboot\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XStartInstance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "stop-instance id",
			Short:   "Stop a Compute instance",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XStopInstance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "revert-instance-to-snapshot instance-id",
			Short:   "Revert a snapshot for an instance",
			Long:    cli.Markdown("This operation reverts the snapshot to the Compute instance volume, restoring stored data as it was at the time of the snapshot.\nThe Compute instance must be previously stopped.\n## Request Schema (application/json)\n\nproperties:\n  id:\n    description: Snapshot ID\n    format: uuid\n    type: string\nrequired:\n- id\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XRevertInstanceToSnapshot(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-load-balancer",
			Short:   "Create a Load Balancer",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Load Balancer description\n    maxLength: 255\n    type: string\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Load Balancer name\n    maxLength: 255\n    minLength: 1\n    type: string\nrequired:\n- name\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateLoadBalancer(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-load-balancers",
			Short:   "List Load Balancers",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListLoadBalancers(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-load-balancer id",
			Short:   "Delete a Load Balancer",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteLoadBalancer(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-load-balancer id",
			Short:   "Retrieve Load Balancer details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetLoadBalancer(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-load-balancer id",
			Short:   "Update a Load Balancer",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Load Balancer description\n    maxLength: 255\n    type: string\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Load Balancer name\n    maxLength: 255\n    minLength: 1\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateLoadBalancer(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "add-service-to-load-balancer id",
			Short:   "Add a Load Balancer Service",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Load Balancer Service description\n    maxLength: 255\n    type: string\n  healthcheck:\n    $ref: '#/components/schemas/load-balancer-service-healthcheck'\n  instance-pool:\n    $ref: '#/components/schemas/instance-pool'\n  name:\n    description: Load Balancer Service name\n    maxLength: 255\n    minLength: 1\n    type: string\n  port:\n    description: Port exposed on the Load Balancer's public IP\n    format: int64\n    maximum: 65535\n    minimum: 1\n    type: integer\n  protocol:\n    description: Network traffic protocol\n    enum:\n    - tcp\n    - udp\n    type: string\n  strategy:\n    description: Load balancing strategy\n    enum:\n    - round-robin\n    - maglev-hash\n    - source-hash\n    type: string\n  target-port:\n    description: Port on which the network traffic will be forwarded to on the receiving instance\n    format: int64\n    maximum: 65535\n    minimum: 1\n    type: integer\nrequired:\n- name\n- instance-pool\n- protocol\n- strategy\n- port\n- target-port\n- healthcheck\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XAddServiceToLoadBalancer(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-load-balancer-service id service-id",
			Short:   "Delete a Load Balancer Service",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteLoadBalancerService(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-load-balancer-service id service-id",
			Short:   "Retrieve Load Balancer Service details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetLoadBalancerService(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-load-balancer-service id service-id",
			Short:   "Update a Load Balancer Service",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Load Balancer Service description\n    maxLength: 255\n    type: string\n  healthcheck:\n    $ref: '#/components/schemas/load-balancer-service-healthcheck'\n  name:\n    description: Load Balancer Service name\n    maxLength: 255\n    type: string\n  port:\n    description: Port exposed on the Load Balancer's public IP\n    format: int64\n    maximum: 65535\n    minimum: 1\n    type: integer\n  protocol:\n    description: Network traffic protocol\n    enum:\n    - tcp\n    - udp\n    type: string\n  strategy:\n    description: Load balancing strategy\n    enum:\n    - round-robin\n    - maglev-hash\n    - source-hash\n    type: string\n  target-port:\n    description: Port on which the network traffic will be forwarded to on the receiving instance\n    format: int64\n    maximum: 65535\n    minimum: 1\n    type: integer\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateLoadBalancerService(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-load-balancer-service-field id service-id field",
			Short:   "Reset a Load Balancer Service field to its default value",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(3),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XResetLoadBalancerServiceField(args[0], args[1], args[2], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-load-balancer-field id field",
			Short:   "Reset a Load Balancer field to its default value",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XResetLoadBalancerField(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-operation id",
			Short:   "Retrieve Operation details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetOperation(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-organization",
			Short:   "Retrieve an organization",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetOrganization(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-private-network",
			Short:   "Create a Private Network",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Private Network description\n    maxLength: 255\n    type: string\n  end-ip:\n    description: Private Network end IP address\n    format: ipv4\n    type: string\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Private Network name\n    maxLength: 255\n    minLength: 1\n    type: string\n  netmask:\n    description: Private Network netmask\n    format: ipv4\n    type: string\n  options:\n    $ref: '#/components/schemas/private-network-options'\n  start-ip:\n    description: Private Network start IP address\n    format: ipv4\n    type: string\nrequired:\n- name\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreatePrivateNetwork(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-private-networks",
			Short:   "List Private Networks",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListPrivateNetworks(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-private-network id",
			Short:   "Delete a Private Network",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeletePrivateNetwork(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-private-network id",
			Short:   "Retrieve Private Network details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetPrivateNetwork(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-private-network id",
			Short:   "Update a Private Network",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Private Network description\n    maxLength: 255\n    type: string\n  end-ip:\n    description: Private Network end IP address\n    format: ipv4\n    type: string\n  labels:\n    $ref: '#/components/schemas/labels'\n  name:\n    description: Private Network name\n    maxLength: 255\n    minLength: 1\n    type: string\n  netmask:\n    description: Private Network netmask\n    format: ipv4\n    type: string\n  options:\n    $ref: '#/components/schemas/private-network-options'\n  start-ip:\n    description: Private Network start IP address\n    format: ipv4\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdatePrivateNetwork(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-private-network-field id field",
			Short:   "Reset Private Network field",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XResetPrivateNetworkField(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "attach-instance-to-private-network id",
			Short:   "Attach a Compute instance to a Private Network",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  instance:\n    description: Compute instance\n    properties:\n      id:\n        description: Instance ID\n        format: uuid\n        type: string\n    type: object\n  ip:\n    description: Static IP address lease for the corresponding network interface\n    format: ipv4\n    type: string\nrequired:\n- instance\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XAttachInstanceToPrivateNetwork(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "detach-instance-from-private-network id",
			Short:   "Detach a Compute instance from a Private Network",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  instance:\n    $ref: '#/components/schemas/instance'\nrequired:\n- instance\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XDetachInstanceFromPrivateNetwork(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-private-network-instance-ip id",
			Short:   "Update the IP address of an instance attached to a managed private network",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  instance:\n    properties:\n      id:\n        description: Instance ID\n        format: uuid\n        type: string\n    required:\n    - id\n    type: object\n  ip:\n    description: Static IP address lease for the corresponding network interface\n    format: ipv4\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdatePrivateNetworkInstanceIp(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-quotas",
			Short:   "List Organization Quotas",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListQuotas(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-quota entity",
			Short:   "Retrieve Resource Quota",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetQuota(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-reverse-dns-elastic-ip id",
			Short:   "Delete the PTR DNS record for an elastic IP",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteReverseDnsElasticIp(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-reverse-dns-elastic-ip id",
			Short:   "Query the PTR DNS records for an elastic IP",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetReverseDnsElasticIp(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-reverse-dns-elastic-ip id",
			Short:   "Update/Create the PTR DNS record for an elastic IP",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  domain-name:\n    maxLength: 253\n    minLength: 1\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateReverseDnsElasticIp(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-reverse-dns-instance id",
			Short:   "Delete the PTR DNS record for an instance",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteReverseDnsInstance(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-reverse-dns-instance id",
			Short:   "Query the PTR DNS records for an instance",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetReverseDnsInstance(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-reverse-dns-instance id",
			Short:   "Update/Create the PTR DNS record for an instance",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  domain-name:\n    maxLength: 253\n    minLength: 1\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateReverseDnsInstance(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-security-group",
			Short:   "Create a Security Group",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Security Group description\n    maxLength: 255\n    type: string\n  name:\n    description: Security Group name\n    maxLength: 255\n    minLength: 1\n    type: string\nrequired:\n- name\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateSecurityGroup(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-security-groups",
			Short:   "List Security Groups.",
			Long:    cli.Markdown("Lists security groups. When visibility is set to public, lists public security groups.\nPublic security groups are objects maintained by Exoscale which contain source addresses for\nrelevant services hosted by Exoscale. They can be used a source in ingress rules and as a destination\nin egress rules."),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListSecurityGroups(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cmd.Flags().String("visibility", "", "")

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-security-group id",
			Short:   "Delete a Security Group",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteSecurityGroup(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-security-group id",
			Short:   "Retrieve Security Group details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetSecurityGroup(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "add-rule-to-security-group id",
			Short:   "Create a Security Group rule",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Security Group rule description\n    maxLength: 255\n    type: string\n  end-port:\n    description: End port of the range\n    format: int64\n    maximum: 65535\n    minimum: 1\n    type: integer\n  flow-direction:\n    description: Network flow direction to match\n    enum:\n    - ingress\n    - egress\n    type: string\n  icmp:\n    description: 'ICMP details (default: -1 (ANY))'\n    properties:\n      code:\n        format: int64\n        maximum: 254\n        minimum: -1\n        nullable: true\n        type: integer\n      type:\n        format: int64\n        maximum: 254\n        minimum: -1\n        nullable: true\n        type: integer\n    type: object\n  network:\n    description: CIDR-formatted network allowed\n    type: string\n  protocol:\n    description: Network protocol\n    enum:\n    - tcp\n    - esp\n    - icmp\n    - udp\n    - gre\n    - ah\n    - ipip\n    - icmpv6\n    type: string\n  security-group:\n    $ref: '#/components/schemas/security-group-resource'\n  start-port:\n    description: Start port of the range\n    format: int64\n    maximum: 65535\n    minimum: 1\n    type: integer\nrequired:\n- flow-direction\n- protocol\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XAddRuleToSecurityGroup(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-rule-from-security-group id rule-id",
			Short:   "Delete a Security Group rule",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteRuleFromSecurityGroup(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "add-external-source-to-security-group id",
			Short:   "Add an external source as a member of a Security Group",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  cidr:\n    description: CIDR-formatted network to add\n    type: string\nrequired:\n- cidr\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XAddExternalSourceToSecurityGroup(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "attach-instance-to-security-group id",
			Short:   "Attach a Compute instance to a Security Group",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  instance:\n    $ref: '#/components/schemas/instance'\nrequired:\n- instance\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XAttachInstanceToSecurityGroup(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "detach-instance-from-security-group id",
			Short:   "Detach a Compute instance from a Security Group",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  instance:\n    $ref: '#/components/schemas/instance'\nrequired:\n- instance\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XDetachInstanceFromSecurityGroup(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "remove-external-source-from-security-group id",
			Short:   "Remove an external source from a Security Group",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  cidr:\n    description: CIDR-formatted network to remove\n    type: string\nrequired:\n- cidr\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XRemoveExternalSourceFromSecurityGroup(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-sks-cluster",
			Short:   "Create an SKS cluster",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  addons:\n    description: Cluster addons\n    items:\n      enum:\n      - exoscale-cloud-controller\n      - exoscale-container-storage-interface\n      - metrics-server\n      type: string\n    type: array\n    uniqueItems: true\n  auto-upgrade:\n    description: Enable auto upgrade of the control plane to the latest patch version available\n    type: boolean\n  cni:\n    description: Cluster CNI\n    enum:\n    - calico\n    - cilium\n    type: string\n  create-default-security-group:\n    description: Creates an ad-hoc security group based on the choice of the selected CNI\n    nullable: true\n    type: boolean\n  description:\n    description: Cluster description\n    maxLength: 255\n    nullable: true\n    type: string\n  enable-kube-proxy:\n    description: Indicates whether to deploy the Kubernetes network proxy. When unspecified, defaults to `true` unless Cilium CNI is selected\n    type: boolean\n  feature-gates:\n    description: A list of Kubernetes-only Alpha features to enable for API server component\n    items:\n      type: string\n    type: array\n    uniqueItems: true\n  labels:\n    $ref: '#/components/schemas/sks-cluster-labels'\n  level:\n    description: Cluster service level\n    enum:\n    - starter\n    - pro\n    type: string\n  name:\n    description: Cluster name\n    maxLength: 255\n    minLength: 1\n    type: string\n  networking:\n    $ref: '#/components/schemas/networking'\n  oidc:\n    $ref: '#/components/schemas/sks-oidc'\n  version:\n    description: Control plane Kubernetes version\n    type: string\nrequired:\n- name\n- level\n- version\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateSksCluster(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-sks-clusters",
			Short:   "List SKS clusters",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListSksClusters(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-sks-cluster-deprecated-resources id",
			Short:   "Resources that are scheduled to be removed in future kubernetes releases",
			Long:    cli.Markdown("This operation returns the deprecated resources for a given cluster"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListSksClusterDeprecatedResources(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "generate-sks-cluster-kubeconfig id",
			Short:   "Generate a new Kubeconfig file for a SKS cluster",
			Long:    cli.Markdown("This operation returns a Kubeconfig file encoded in base64.\n## Request Schema (application/json)\n\ndescription: Kubeconfig request for a SKS cluster\nproperties:\n  groups:\n    description: List of roles. The certificate present in the Kubeconfig will have these roles set in the Org field.\n    items:\n      type: string\n    type: array\n  ttl:\n    description: 'Validity in seconds of the Kubeconfig user certificate (default: 30 days)'\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\n  user:\n    description: User name in the generated Kubeconfig. The certificate present in the Kubeconfig will also have this name set for the CN field.\n    type: string\nrequired:\n- user\n- groups\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XGenerateSksClusterKubeconfig(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-sks-cluster-versions",
			Short:   "List available versions for SKS clusters",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListSksClusterVersions(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cmd.Flags().String("include-deprecated", "", "")

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-sks-cluster id",
			Short:   "Delete an SKS cluster",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteSksCluster(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-sks-cluster id",
			Short:   "Retrieve SKS cluster details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetSksCluster(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-sks-cluster id",
			Short:   "Update an SKS cluster",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  addons:\n    description: Cluster addons\n    items:\n      enum:\n      - exoscale-cloud-controller\n      - exoscale-container-storage-interface\n      - metrics-server\n      type: string\n    type: array\n    uniqueItems: true\n  auto-upgrade:\n    description: Enable auto upgrade of the control plane to the latest patch version available\n    type: boolean\n  description:\n    description: Cluster description\n    maxLength: 255\n    nullable: true\n    type: string\n  enable-operators-ca:\n    description: Add or remove the operators certificate authority (CA) from the list of trusted CAs of the api server. The default value is true\n    type: boolean\n  feature-gates:\n    description: A list of Kubernetes-only Alpha features to enable for API server component\n    items:\n      type: string\n    nullable: true\n    type: array\n    uniqueItems: true\n  labels:\n    $ref: '#/components/schemas/sks-cluster-labels'\n  name:\n    description: Cluster name\n    maxLength: 255\n    minLength: 1\n    type: string\n  oidc:\n    $ref: '#/components/schemas/sks-oidc'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateSksCluster(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-sks-cluster-authority-cert id authority",
			Short:   "Get the certificate for a SKS cluster authority",
			Long:    cli.Markdown("This operation returns the certificate for the given SKS cluster authority encoded in base64."),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetSksClusterAuthorityCert(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-sks-cluster-inspection id",
			Short:   "Get the latest inspection result",
			Long:    cli.Markdown("Helps troubleshoot common problems when deploying a kubernetes cluster. Inspections run every couple of minutes."),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetSksClusterInspection(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-sks-nodepool id",
			Short:   "Create a new SKS Nodepool",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  addons:\n    description: Nodepool addons\n    items:\n      enum:\n      - storage-lvm\n      type: string\n    type: array\n    uniqueItems: true\n  anti-affinity-groups:\n    description: Nodepool Anti-affinity Groups\n    items:\n      $ref: '#/components/schemas/anti-affinity-group'\n    type: array\n    uniqueItems: true\n  deploy-target:\n    $ref: '#/components/schemas/deploy-target'\n  description:\n    description: Nodepool description\n    maxLength: 255\n    type: string\n  disk-size:\n    description: Nodepool instances disk size in GiB\n    format: int64\n    maximum: 51200\n    minimum: 20\n    type: integer\n  instance-prefix:\n    description: 'Prefix to apply to instances names (default: pool), lowercase only'\n    maxLength: 30\n    minLength: 1\n    type: string\n  instance-type:\n    $ref: '#/components/schemas/instance-type'\n  kubelet-image-gc:\n    $ref: '#/components/schemas/kubelet-image-gc'\n  labels:\n    $ref: '#/components/schemas/sks-nodepool-labels'\n  name:\n    description: Nodepool name, lowercase only\n    maxLength: 255\n    minLength: 1\n    type: string\n  private-networks:\n    description: Nodepool Private Networks\n    items:\n      $ref: '#/components/schemas/private-network'\n    type: array\n    uniqueItems: true\n  public-ip-assignment:\n    description: |-\n      Configures public IP assignment of the Instances with:\n\n      * IPv4 (`inet4`) addressing only (default);\n      * both IPv4 and IPv6 (`dual`) addressing.\n    enum:\n    - inet4\n    - dual\n    type: string\n  security-groups:\n    description: Nodepool Security Groups\n    items:\n      $ref: '#/components/schemas/security-group'\n    type: array\n    uniqueItems: true\n  size:\n    description: Number of instances\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\n  taints:\n    $ref: '#/components/schemas/sks-nodepool-taints'\nrequired:\n- name\n- size\n- disk-size\n- instance-type\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateSksNodepool(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-sks-nodepool id sks-nodepool-id",
			Short:   "Delete an SKS Nodepool",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteSksNodepool(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-sks-nodepool id sks-nodepool-id",
			Short:   "Retrieve SKS Nodepool details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetSksNodepool(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-sks-nodepool id sks-nodepool-id",
			Short:   "Update an SKS Nodepool",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  anti-affinity-groups:\n    description: Nodepool Anti-affinity Groups\n    items:\n      $ref: '#/components/schemas/anti-affinity-group'\n    type: array\n    uniqueItems: true\n  deploy-target:\n    $ref: '#/components/schemas/deploy-target'\n  description:\n    description: Nodepool description\n    maxLength: 255\n    type: string\n  disk-size:\n    description: Nodepool instances disk size in GiB\n    format: int64\n    maximum: 51200\n    minimum: 20\n    type: integer\n  instance-prefix:\n    description: 'Prefix to apply to managed instances names (default: pool), lowercase only'\n    maxLength: 30\n    minLength: 1\n    type: string\n  instance-type:\n    $ref: '#/components/schemas/instance-type'\n  labels:\n    $ref: '#/components/schemas/sks-nodepool-labels'\n  name:\n    description: Nodepool name, lowercase only\n    maxLength: 255\n    minLength: 1\n    type: string\n  private-networks:\n    description: Nodepool Private Networks\n    items:\n      $ref: '#/components/schemas/private-network'\n    type: array\n    uniqueItems: true\n  public-ip-assignment:\n    description: |-\n      Configures public IP assignment of the Instances with:\n\n      * IPv4 (`inet4`) addressing only;\n      * both IPv4 and IPv6 (`dual`) addressing.\n    enum:\n    - inet4\n    - dual\n    type: string\n  security-groups:\n    description: Nodepool Security Groups\n    items:\n      $ref: '#/components/schemas/security-group'\n    type: array\n    uniqueItems: true\n  taints:\n    $ref: '#/components/schemas/sks-nodepool-taints'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateSksNodepool(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-sks-nodepool-field id sks-nodepool-id field",
			Short:   "Reset an SKS Nodepool field to its default value",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(3),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XResetSksNodepoolField(args[0], args[1], args[2], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "evict-sks-nodepool-members id sks-nodepool-id",
			Short:   "Evict Nodepool members",
			Long:    cli.Markdown("This operation evicts the specified Compute instances member from the Nodepool, shrinking it to `&lt;current nodepool size&gt; - &lt;# evicted members&gt;`.\n## Request Schema (application/json)\n\nproperties:\n  instances:\n    items:\n      format: uuid\n      type: string\n    type: array\n    uniqueItems: true\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XEvictSksNodepoolMembers(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "scale-sks-nodepool id sks-nodepool-id",
			Short:   "Scale a SKS Nodepool",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  size:\n    description: Number of instances\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\nrequired:\n- size\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[2:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XScaleSksNodepool(args[0], args[1], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "rotate-sks-ccm-credentials id",
			Short:   "Rotate Exoscale CCM credentials",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XRotateSksCcmCredentials(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "rotate-sks-csi-credentials id",
			Short:   "Rotate Exoscale CSI credentials",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XRotateSksCsiCredentials(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "rotate-sks-operators-ca id",
			Short:   "Rotate operators certificate authority",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XRotateSksOperatorsCa(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "upgrade-sks-cluster id",
			Short:   "Upgrade an SKS cluster",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  version:\n    description: Control plane Kubernetes version\n    type: string\nrequired:\n- version\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpgradeSksCluster(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "upgrade-sks-cluster-service-level id",
			Short:   "Upgrade a SKS cluster to pro",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpgradeSksClusterServiceLevel(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "reset-sks-cluster-field id field",
			Short:   "Reset an SKS cluster field to its default value",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(2),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XResetSksClusterField(args[0], args[1], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-snapshots",
			Short:   "List Snapshots",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListSnapshots(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-snapshot id",
			Short:   "Delete a Snapshot",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteSnapshot(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-snapshot id",
			Short:   "Retrieve Snapshot details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetSnapshot(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "export-snapshot id",
			Short:   "Export a Snapshot",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XExportSnapshot(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "promote-snapshot-to-template id",
			Short:   "Promote a Snapshot to a Template",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  default-user:\n    description: Template default user\n    maxLength: 255\n    minLength: 1\n    type: string\n  description:\n    description: Template description\n    maxLength: 4096\n    type: string\n  name:\n    description: Template name\n    maxLength: 255\n    minLength: 1\n    type: string\n  password-enabled:\n    description: Enable password-based login in the template\n    type: boolean\n  ssh-key-enabled:\n    description: Enable SSH key-based login in the template\n    type: boolean\nrequired:\n- name\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XPromoteSnapshotToTemplate(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-sos-buckets-usage",
			Short:   "List SOS Buckets Usage",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListSosBucketsUsage(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-sos-presigned-url bucket",
			Short:   "Retrieve Presigned Download URL for SOS object",
			Long:    cli.Markdown("Generates Presigned Download URL for SOS object"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetSosPresignedUrl(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cmd.Flags().String("key", "", "")

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-ssh-keys",
			Short:   "List SSH keys",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListSshKeys(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "register-ssh-key",
			Short:   "Import SSH key",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  name:\n    description: SSH key name\n    pattern: ^[a-zA-Z0-9]{1}[a-zA-Z0-9._-]{0,254}$\n    type: string\n  public-key:\n    description: Public key value\n    type: string\nrequired:\n- name\n- public-key\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XRegisterSshKey(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-ssh-key name",
			Short:   "Delete a SSH key",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteSshKey(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-ssh-key name",
			Short:   "Retrieve SSH key details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetSshKey(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-templates",
			Short:   "List Templates",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListTemplates(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cmd.Flags().String("visibility", "", "")
		cmd.Flags().String("family", "", "")

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "register-template",
			Short:   "Register a Template",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  boot-mode:\n    description: 'Boot mode (default: legacy)'\n    enum:\n    - legacy\n    - uefi\n    type: string\n  build:\n    description: Template build\n    maxLength: 255\n    minLength: 1\n    type: string\n  checksum:\n    description: Template MD5 checksum\n    minLength: 1\n    type: string\n  default-user:\n    description: Template default user\n    maxLength: 255\n    minLength: 1\n    type: string\n  description:\n    description: Template description\n    maxLength: 255\n    type: string\n  maintainer:\n    description: Template maintainer\n    maxLength: 255\n    minLength: 1\n    type: string\n  name:\n    description: Template name\n    maxLength: 255\n    minLength: 1\n    type: string\n  password-enabled:\n    description: Enable password-based login\n    type: boolean\n  size:\n    description: Template size\n    exclusiveMinimum: true\n    format: int64\n    minimum: 0\n    type: integer\n  ssh-key-enabled:\n    description: Enable SSH key-based login\n    type: boolean\n  url:\n    description: Template source URL\n    minLength: 1\n    type: string\n  version:\n    description: Template version\n    maxLength: 255\n    minLength: 1\n    type: string\nrequired:\n- name\n- url\n- checksum\n- ssh-key-enabled\n- password-enabled\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XRegisterTemplate(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "copy-template id",
			Short:   "Copy a Template from a zone to another",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  target-zone:\n    $ref: '#/components/schemas/zone'\nrequired:\n- target-zone\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCopyTemplate(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-template id",
			Short:   "Delete a Template",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteTemplate(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-template id",
			Short:   "Retrieve Template details",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetTemplate(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-template id",
			Short:   "Update template attributes",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  description:\n    description: Template Description\n    maxLength: 255\n    type: string\n  name:\n    description: Template name\n    maxLength: 255\n    minLength: 1\n    type: string\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateTemplate(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "get-usage-report",
			Short:   "Retrieve organization usage reports",
			Long:    cli.Markdown("Returns aggregated usage reports for an organization"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XGetUsageReport(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cmd.Flags().String("period", "", "")

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "create-user",
			Short:   "Create a User",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  email:\n    description: User Email\n    type: string\n  role:\n    $ref: '#/components/schemas/iam-role'\nrequired:\n- email\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[0:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XCreateUser(params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-users",
			Short:   "List Users",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListUsers(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "delete-user id",
			Short:   "Delete User",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XDeleteUser(args[0], params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "update-user-role id",
			Short:   "Update a User's IAM role",
			Long:    cli.Markdown("\n## Request Schema (application/json)\n\nproperties:\n  role:\n    $ref: '#/components/schemas/iam-role'\ntype: object\n"),
			Example: examples,
			Args:    cobra.MinimumNArgs(1),
			Run: func(cmd *cobra.Command, args []string) {
				body, err := cli.GetBody("application/json", args[1:])
				if err != nil {
					log.Fatal().Err(err).Msg("Unable to get body")
				}

				_, decoded, err := XUpdateUserRole(args[0], params, body)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

	func() {
		params := viper.New()

		var examples string

		cmd := &cobra.Command{
			Use:     "list-zones",
			Short:   "List Zones",
			Long:    cli.Markdown(""),
			Example: examples,
			Args:    cobra.MinimumNArgs(0),
			Run: func(cmd *cobra.Command, args []string) {

				_, decoded, err := XListZones(params)
				if err != nil {
					log.Fatal().Err(err).Msg("Error calling operation")
				}

				if err := cli.Formatter.Format(decoded); err != nil {
					log.Fatal().Err(err).Msg("Formatting failed")
				}

			},
		}

		root.AddCommand(cmd)

		cli.SetCustomFlags(cmd)

		if cmd.Flags().HasFlags() {
			params.BindPFlags(cmd.Flags())
		}

	}()

}
