/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util.internal;

import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.model.BmcException;
import jakarta.annotation.Nonnull;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshAuthTokenTransformingFuture<FROM, TO>
implements Future<TO> {
    private static final Logger LOG = LoggerFactory.getLogger(RefreshAuthTokenTransformingFuture.class);
    @Nonnull
    private Future<FROM> delegate;
    private final Function<FROM, TO> transformer;
    private final RefreshableOnNotAuthenticatedProvider<?> authProvider;
    private final Supplier<Future<FROM>> generateNewFutureForRetry;

    public RefreshAuthTokenTransformingFuture(@Nonnull Future<FROM> delegate, Function<FROM, TO> transformer, RefreshableOnNotAuthenticatedProvider<?> authProvider, Supplier<Future<FROM>> generateNewFutureForRetry) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        this.delegate = delegate;
        this.transformer = transformer;
        this.authProvider = authProvider;
        this.generateNewFutureForRetry = generateNewFutureForRetry;
        LOG.warn("The class {} should not be used after version 1.25.1. You are using an oci-java-sdk-common version newer than 1.25.1 with a service client of version 1.25.1 or older. Upgrade your service client version to match your oci-java-sdk-common version.", (Object)this.getClass().getName());
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public TO get() throws InterruptedException, ExecutionException {
        FROM from = this.delegate.get();
        try {
            return this.transformer.apply(from);
        }
        catch (BmcException e) {
            if (e.getStatusCode() == 401) {
                this.authProvider.refresh();
                this.delegate = this.generateNewFutureForRetry.get();
                return this.transformer.apply(this.delegate.get());
            }
            throw e;
        }
    }

    @Override
    public TO get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        FROM from = this.delegate.get(timeout, unit);
        try {
            return this.transformer.apply(from);
        }
        catch (BmcException e) {
            if (e.getStatusCode() == 401) {
                this.authProvider.refresh();
                this.delegate = this.generateNewFutureForRetry.get();
                return this.transformer.apply(this.delegate.get(timeout, unit));
            }
            throw e;
        }
    }
}

