/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waiter;

import com.oracle.bmc.waiter.WaiterConfiguration;
import com.oracle.bmc.waiter.WaiterScheduler;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericWaiter {
    private static final Logger LOG = LoggerFactory.getLogger(GenericWaiter.class);
    private final WaiterConfiguration waiterConfiguration;

    public <REQUEST, RESPONSE> Optional<RESPONSE> execute(Supplier<REQUEST> requestSupplier, Function<REQUEST, RESPONSE> functionCall, Predicate<RESPONSE> terminationPredicate) {
        WaiterConfiguration.WaitContext context = new WaiterConfiguration.WaitContext(System.currentTimeMillis());
        Object r = null;
        while (true) {
            LOG.debug("Invoking function call");
            r = functionCall.apply(requestSupplier.get());
            if (terminationPredicate.test(r)) {
                LOG.debug("Total Latency for this API call is: {}ms", (Object)(context.getCurrentTime() - context.getStartTime()));
                return Optional.of(r);
            }
            context.incrementAttempts();
            context.setCurrentTime(System.currentTimeMillis());
            LOG.debug("Retry attempt: {}", (Object)context.getAttemptsMade());
            if (this.waiterConfiguration.getTerminationStrategy().shouldTerminate(context)) break;
            try {
                long sleepTime = this.waiterConfiguration.getDelayStrategy().nextDelay(context);
                LOG.debug("Sleeping for {}ms, context at: {}", (Object)sleepTime, (Object)context);
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                LOG.info("Waiter interrupted");
                Thread.currentThread().interrupt();
                return Optional.empty();
            }
        }
        LOG.debug("Termination strategy decided to terminate with context at: {}", (Object)context);
        LOG.debug("Total Latency for this API call is: {}ms", (Object)(context.getCurrentTime() - context.getStartTime()));
        return Optional.empty();
    }

    @ConstructorProperties(value={"waiterConfiguration"})
    public GenericWaiter(WaiterConfiguration waiterConfiguration) {
        this.waiterConfiguration = waiterConfiguration;
    }

    public WaiterConfiguration getWaiterConfiguration() {
        return this.waiterConfiguration;
    }

    public <T> CompletionStage<Optional<T>> executeAsync(WaiterScheduler runner, Supplier<CompletionStage<T>> downstream, Predicate<T> terminationPredicate) {
        WaiterConfiguration.WaitContext context = new WaiterConfiguration.WaitContext(System.currentTimeMillis());
        return this.executeAsync(runner, downstream, terminationPredicate, context);
    }

    private <T> CompletionStage<Optional<T>> executeAsync(WaiterScheduler runner, Supplier<CompletionStage<T>> upstream, Predicate<T> terminationPredicate, WaiterConfiguration.WaitContext context) {
        CompletionStage<Object> stage;
        LOG.debug("Invoking function call");
        try {
            stage = upstream.get();
        }
        catch (Exception e) {
            return GenericWaiter.failedFuture(e);
        }
        return stage.thenCompose(result -> {
            if (terminationPredicate.test(result)) {
                return CompletableFuture.completedFuture(Optional.of(result));
            }
            context.incrementAttempts();
            context.setCurrentTime(System.currentTimeMillis());
            if (this.waiterConfiguration.getTerminationStrategy().shouldTerminate(context)) {
                LOG.debug("Termination strategy decided to terminate with context at: {}", (Object)context);
                return CompletableFuture.completedFuture(Optional.empty());
            }
            long sleepTime = this.waiterConfiguration.getDelayStrategy().nextDelay(context);
            if (sleepTime == 0L) {
                LOG.debug("Retrying immediately (sleep time 0ms), context at: {}", (Object)sleepTime, (Object)context);
                return this.executeAsync(runner, upstream, terminationPredicate, context);
            }
            LOG.debug("Sleeping for {}ms, context at: {}", (Object)sleepTime, (Object)context);
            CancellableCompletableFuture delayedFuture = new CancellableCompletableFuture();
            delayedFuture.upstreamFuture = runner.schedule(() -> this.lambda$executeAsync$1(delayedFuture, runner, (Supplier)upstream, terminationPredicate, context), sleepTime, TimeUnit.MILLISECONDS);
            return delayedFuture;
        });
    }

    private static <T> CompletionStage<T> failedFuture(Throwable t) {
        CompletableFuture res = new CompletableFuture();
        res.completeExceptionally(t);
        return res;
    }

    private /* synthetic */ void lambda$executeAsync$1(CancellableCompletableFuture delayedFuture, WaiterScheduler runner, Supplier upstream, Predicate terminationPredicate, WaiterConfiguration.WaitContext context) {
        if (delayedFuture.isCancelled()) {
            return;
        }
        this.executeAsync(runner, upstream, terminationPredicate, context).whenComplete((r, t) -> {
            if (t == null) {
                delayedFuture.complete(r);
            } else {
                delayedFuture.completeExceptionally((Throwable)t);
            }
        });
    }

    private static class CancellableCompletableFuture<T>
    extends CompletableFuture<T> {
        volatile Future<?> upstreamFuture;

        private CancellableCompletableFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            Future<?> upstreamFuture;
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled && (upstreamFuture = this.upstreamFuture) != null) {
                upstreamFuture.cancel(mayInterruptIfRunning);
            }
            return cancelled;
        }
    }
}

