/*
 * image.h:
 * Attempt to find GIF/JPEG/PNG data embedded in buffers.
 *
 * Copyright (c) 2012 David Suárez.
 * Email: david.sephirot@gmail.com
 *
 * Copyright (c) 2001 Chris Lightfoot.
 * Email: chris@ex-parrot.com; WWW: http://www.ex-parrot.com/~chris/
 *
 */

#ifndef __IMAGE_H__
#define __IMAGE_H__

#include <stddef.h>

unsigned char *find_gif_image(const unsigned char *data, const size_t len,
        unsigned char **gifdata, size_t *giflen);

unsigned char *find_jpeg_image(const unsigned char *data, const size_t len,
        unsigned char **jpegdata, size_t *jpeglen);

unsigned char *find_png_image(const unsigned char *data, const size_t len,
        unsigned char **pngdata, size_t *pnglen);

unsigned char *find_webp_image(const unsigned char *data, const size_t len,
        unsigned char **webpdata, size_t *webplen);

unsigned char *find_avif_image(const unsigned char *data, const size_t len,
        unsigned char **avifdata, size_t *aviflen);

#endif /* __IMAGE_H__ */
