/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.zip.GZIPInputStream;

public class ResourceLoader {
    public static int MAX_REDIRECTS = 20;

    public static URLConnection urlConnection(URL url) throws IOException {
        if ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol())) {
            HttpURLConnection conn;
            block4: {
                HashSet<String> visited = new HashSet<String>();
                String cookies = null;
                int count = MAX_REDIRECTS;
                do {
                    int status;
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setInstanceFollowRedirects(false);
                    conn.setRequestProperty("Accept-Encoding", "gzip");
                    if (cookies != null) {
                        conn.setRequestProperty("Cookie", cookies);
                    }
                    if ((status = conn.getResponseCode()) != 301 && status != 302) break block4;
                    String location = conn.getHeaderField("Location");
                    url = new URL(location);
                    cookies = conn.getHeaderField("Set-Cookie");
                    if (visited.contains(location)) {
                        throw new IOException("HTTP redirect loop through " + location);
                    }
                    visited.add(location);
                } while (--count >= 0);
                throw new IOException("HTTP redirects more than " + MAX_REDIRECTS + " times");
            }
            return conn;
        }
        return url.openConnection();
    }

    public static InputStream urlStream(URL url) throws IOException {
        URLConnection conn = ResourceLoader.urlConnection(url);
        InputStream inputStream = conn.getInputStream();
        String contentEncoding = conn.getContentEncoding();
        if ("gzip".equals(contentEncoding)) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return inputStream;
    }
}

