/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javajs.util.Lst;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import org.jmol.util.Logger;
import org.openscience.jmol.app.webexport.WebPanel;

class ArrayListTransferHandler
extends TransferHandler {
    DataFlavor localArrayListFlavor;
    DataFlavor serialArrayListFlavor;
    String localArrayListType = "application/x-java-jvm-local-objectref;class=java.util.ArrayList";
    JList<?> source = null;
    int[] sourceIndices = null;
    int addIndex = -1;
    int addCount = 0;
    WebPanel webPanel;

    ArrayListTransferHandler(WebPanel webPanel) {
        this.webPanel = webPanel;
        try {
            this.localArrayListFlavor = new DataFlavor(this.localArrayListType);
        }
        catch (ClassNotFoundException e) {
            System.out.println("ArrayListTransferHandler: unable to create data flavor");
        }
        this.serialArrayListFlavor = new DataFlavor(ArrayList.class, "ArrayList");
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        Lst alist;
        JList target;
        block12: {
            if (this.sourceIndices == null || !this.canImport(c, t.getTransferDataFlavors())) {
                return false;
            }
            target = null;
            alist = null;
            try {
                target = (JList)c;
                if (this.hasLocalArrayListFlavor(t.getTransferDataFlavors())) {
                    alist = (Lst)t.getTransferData(this.localArrayListFlavor);
                    break block12;
                }
                if (this.hasSerialArrayListFlavor(t.getTransferDataFlavors())) {
                    alist = (Lst)t.getTransferData(this.serialArrayListFlavor);
                    break block12;
                }
                return false;
            }
            catch (UnsupportedFlavorException ufe) {
                Logger.error("importData: unsupported data flavor");
                return false;
            }
            catch (IOException ioe) {
                Logger.error("importData: I/O exception");
                return false;
            }
        }
        int targetIndex = target.getSelectedIndex();
        if (this.source.equals(target) && targetIndex >= this.sourceIndices[0] && targetIndex <= this.sourceIndices[this.sourceIndices.length - 1]) {
            this.sourceIndices = null;
            return true;
        }
        DefaultListModel listModel = (DefaultListModel)target.getModel();
        int max = listModel.getSize();
        if (targetIndex < 0) {
            targetIndex = max;
        } else {
            if (this.sourceIndices[0] < targetIndex) {
                ++targetIndex;
            }
            if (targetIndex > max) {
                targetIndex = max;
            }
        }
        this.addIndex = targetIndex;
        this.addCount = alist.size();
        for (int i = 0; i < alist.size(); ++i) {
            listModel.add(targetIndex++, ArrayListTransferHandler.objectOf(listModel, alist.get(i)));
        }
        return true;
    }

    private static Object objectOf(DefaultListModel<?> listModel, Object objectName) {
        if (objectName instanceof String) {
            String name = (String)objectName;
            int i = listModel.size();
            while (--i >= 0) {
                Object o = listModel.get(i);
                if (o instanceof String || !o.toString().equals(name)) continue;
                return listModel.get(i);
            }
        }
        return objectName;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        if (action == 2 && this.sourceIndices != null) {
            int i;
            DefaultListModel model = (DefaultListModel)this.source.getModel();
            if (this.addCount > 0) {
                for (i = 0; i < this.sourceIndices.length; ++i) {
                    if (this.sourceIndices[i] <= this.addIndex) continue;
                    int n = i;
                    this.sourceIndices[n] = this.sourceIndices[n] + this.addCount;
                }
            }
            for (i = this.sourceIndices.length - 1; i >= 0; --i) {
                model.remove(this.sourceIndices[i]);
            }
            ((JList)c).setSelectedIndices(new int[0]);
            if (this.webPanel != null) {
                this.webPanel.syncLists();
            }
        }
        this.sourceIndices = null;
        this.addIndex = -1;
        this.addCount = 0;
    }

    private boolean hasLocalArrayListFlavor(DataFlavor[] flavors) {
        if (this.localArrayListFlavor == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(this.localArrayListFlavor)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSerialArrayListFlavor(DataFlavor[] flavors) {
        if (this.serialArrayListFlavor == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(this.serialArrayListFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        if (this.hasLocalArrayListFlavor(flavors)) {
            return true;
        }
        return this.hasSerialArrayListFlavor(flavors);
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof JList) {
            this.source = (JList)c;
            this.sourceIndices = this.source.getSelectedIndices();
            List<?> values = this.source.getSelectedValuesList();
            if (values == null || values.size() == 0) {
                return null;
            }
            Lst<String> alist = new Lst<String>();
            for (int i = 0; i < values.size(); ++i) {
                Object o = values.get(i);
                String str = o.toString();
                if (str == null) {
                    str = "";
                }
                alist.addLast(str);
            }
            return new ArrayListTransferable(alist);
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    class ArrayListTransferable
    implements Transferable {
        Lst<String> data;

        ArrayListTransferable(Lst<String> alist) {
            this.data = alist;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{ArrayListTransferHandler.this.localArrayListFlavor, ArrayListTransferHandler.this.serialArrayListFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (ArrayListTransferHandler.this.localArrayListFlavor.equals(flavor)) {
                return true;
            }
            return ArrayListTransferHandler.this.serialArrayListFlavor.equals(flavor);
        }
    }
}

