/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;

public class GenericParser<U> {
    protected final Map<Class<?>, Function<U, ?>> parsers;

    public GenericParser() {
        this(new LinkedHashMap());
    }

    public GenericParser(GenericParser<U> parser) {
        this(new LinkedHashMap(parser.parsers));
    }

    protected GenericParser(Map<Class<?>, Function<U, ?>> parsers) {
        this.parsers = parsers;
    }

    public <T> GenericParser<U> registerParser(Class<T> type, Function<U, T> value) {
        this.parsers.put(type, value);
        return this;
    }

    public boolean supports(Class<?> type) {
        return this.parsers.containsKey(type);
    }

    public <T> T parse(Class<T> type, U value) {
        Function<U, ?> parser = this.parsers.get(type);
        if (parser == null) {
            throw new UnsupportedOperationException(type + " is not supported");
        }
        try {
            return (T)parser.apply(value);
        }
        catch (RuntimeException ex) {
            throw new UncheckedParseException("Failed to parse [" + value + "] as " + type, ex);
        }
    }

    public <T> Optional<T> tryParse(Class<T> type, U value) {
        try {
            return Optional.ofNullable(this.parse(type, value));
        }
        catch (RuntimeException ex) {
            Logging.trace(ex);
            return Optional.empty();
        }
    }
}

