/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import sun.util.locale.Extension;
import sun.util.locale.InternalLocaleBuilder;
import sun.util.locale.LanguageTag;
import sun.util.locale.LocaleUtils;
import sun.util.locale.UnicodeLocaleExtension;

public class LocaleExtensions {
    private final Map<Character, Extension> extensionMap;
    private final String id;
    public static final LocaleExtensions CALENDAR_JAPANESE = new LocaleExtensions("u-ca-japanese", Character.valueOf('u'), UnicodeLocaleExtension.CA_JAPANESE);
    public static final LocaleExtensions NUMBER_THAI = new LocaleExtensions("u-nu-thai", Character.valueOf('u'), UnicodeLocaleExtension.NU_THAI);

    private LocaleExtensions(String id, Character key, Extension value) {
        this.id = id;
        this.extensionMap = Collections.singletonMap(key, value);
    }

    LocaleExtensions(Map<InternalLocaleBuilder.CaseInsensitiveChar, String> extensions, Set<InternalLocaleBuilder.CaseInsensitiveString> uattributes, Map<InternalLocaleBuilder.CaseInsensitiveString, String> ukeywords) {
        boolean hasUKeywords;
        boolean hasExtension = !LocaleUtils.isEmpty(extensions);
        boolean hasUAttributes = !LocaleUtils.isEmpty(uattributes);
        boolean bl = hasUKeywords = !LocaleUtils.isEmpty(ukeywords);
        if (!(hasExtension || hasUAttributes || hasUKeywords)) {
            this.id = "";
            this.extensionMap = Collections.emptyMap();
            return;
        }
        TreeMap<Character, Extension> map = new TreeMap<Character, Extension>();
        if (hasExtension) {
            for (Map.Entry<InternalLocaleBuilder.CaseInsensitiveChar, String> ext : extensions.entrySet()) {
                char key = LocaleUtils.toLower(ext.getKey().value());
                String value = ext.getValue();
                if (LanguageTag.isPrivateusePrefixChar(key) && (value = InternalLocaleBuilder.removePrivateuseVariant(value)) == null) continue;
                map.put(Character.valueOf(key), new Extension(key, LocaleUtils.toLowerString(value)));
            }
        }
        if (hasUAttributes || hasUKeywords) {
            TreeSet<String> uaset = null;
            TreeMap<String, String> ukmap = null;
            if (hasUAttributes) {
                uaset = new TreeSet<String>();
                for (InternalLocaleBuilder.CaseInsensitiveString cis : uattributes) {
                    uaset.add(LocaleUtils.toLowerString(cis.value()));
                }
            }
            if (hasUKeywords) {
                ukmap = new TreeMap<String, String>();
                for (Map.Entry<InternalLocaleBuilder.CaseInsensitiveString, String> kwd : ukeywords.entrySet()) {
                    String key = LocaleUtils.toLowerString(kwd.getKey().value());
                    String type = LocaleUtils.toLowerString(kwd.getValue());
                    ukmap.put(key, type);
                }
            }
            UnicodeLocaleExtension ule = new UnicodeLocaleExtension(uaset, ukmap);
            map.put(Character.valueOf('u'), ule);
        }
        if (map.isEmpty()) {
            this.id = "";
            this.extensionMap = Collections.emptyMap();
        } else {
            this.id = LocaleExtensions.toID(map);
            this.extensionMap = map;
        }
    }

    public Set<Character> getKeys() {
        if (this.extensionMap.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.extensionMap.keySet());
    }

    public Extension getExtension(Character key) {
        return this.extensionMap.get(Character.valueOf(LocaleUtils.toLower(key.charValue())));
    }

    public String getExtensionValue(Character key) {
        Extension ext = this.extensionMap.get(Character.valueOf(LocaleUtils.toLower(key.charValue())));
        if (ext == null) {
            return null;
        }
        return ext.getValue();
    }

    public Set<String> getUnicodeLocaleAttributes() {
        Extension ext = this.extensionMap.get(Character.valueOf('u'));
        if (ext == null) {
            return Collections.emptySet();
        }
        assert (ext instanceof UnicodeLocaleExtension);
        return ((UnicodeLocaleExtension)ext).getUnicodeLocaleAttributes();
    }

    public Set<String> getUnicodeLocaleKeys() {
        Extension ext = this.extensionMap.get(Character.valueOf('u'));
        if (ext == null) {
            return Collections.emptySet();
        }
        assert (ext instanceof UnicodeLocaleExtension);
        return ((UnicodeLocaleExtension)ext).getUnicodeLocaleKeys();
    }

    public String getUnicodeLocaleType(String unicodeLocaleKey) {
        Extension ext = this.extensionMap.get(Character.valueOf('u'));
        if (ext == null) {
            return null;
        }
        assert (ext instanceof UnicodeLocaleExtension);
        return ((UnicodeLocaleExtension)ext).getUnicodeLocaleType(LocaleUtils.toLowerString(unicodeLocaleKey));
    }

    public boolean isEmpty() {
        return this.extensionMap.isEmpty();
    }

    public static boolean isValidKey(char c) {
        return LanguageTag.isExtensionSingletonChar(c) || LanguageTag.isPrivateusePrefixChar(c);
    }

    public static boolean isValidUnicodeLocaleKey(String ukey) {
        return UnicodeLocaleExtension.isKey(ukey);
    }

    private static String toID(SortedMap<Character, Extension> map) {
        StringBuilder buf = new StringBuilder();
        Extension privuse = null;
        for (Map.Entry<Character, Extension> entry : map.entrySet()) {
            char singleton = entry.getKey().charValue();
            Extension extension = entry.getValue();
            if (LanguageTag.isPrivateusePrefixChar(singleton)) {
                privuse = extension;
                continue;
            }
            if (buf.length() > 0) {
                buf.append("-");
            }
            buf.append(extension);
        }
        if (privuse != null) {
            if (buf.length() > 0) {
                buf.append("-");
            }
            buf.append(privuse);
        }
        return buf.toString();
    }

    public String toString() {
        return this.id;
    }

    public String getID() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LocaleExtensions)) {
            return false;
        }
        return this.id.equals(((LocaleExtensions)other).id);
    }
}

