/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos.macho;

import com.install4j.runtime.installer.platform.macos.macho.SegmentCommand;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class Segment64Command
extends SegmentCommand {
    private static final String TEXT = "__TEXT";
    private long vmaddr;
    private long vmsize;
    private long fileoff;
    private long filesize;
    private int maxprot;
    private int initprot;
    private int nsects;
    private int flags;
    private final List<Section64> textSections = new ArrayList<Section64>();

    public Segment64Command(int length) {
        super(length);
    }

    @Override
    public void readData(ByteBuffer buf, boolean bit64) throws IOException {
        buf.get(this.segmentName);
        this.vmaddr = buf.getLong();
        this.vmsize = buf.getLong();
        this.fileoff = buf.getLong();
        this.filesize = buf.getLong();
        this.maxprot = buf.getInt();
        this.initprot = buf.getInt();
        this.nsects = buf.getInt();
        this.flags = buf.getInt();
        if (this.nsects > 0 && TEXT.equals(this.getSegmentName())) {
            for (int currentSectionId = 0; currentSectionId < this.nsects; ++currentSectionId) {
                this.textSections.add(new Section64(buf));
            }
        }
    }

    @Override
    public void writeData(ByteBuffer buf, boolean bit64) throws IOException {
        buf.put(this.segmentName);
        buf.putLong(this.vmaddr);
        buf.putLong(this.vmsize);
        buf.putLong(this.fileoff);
        buf.putLong(this.filesize);
        buf.putInt(this.maxprot);
        buf.putInt(this.initprot);
        buf.putInt(this.nsects);
        buf.putInt(this.flags);
    }

    public Section64 findTextSection(String name) {
        byte[] searchedName = Arrays.copyOf(name.getBytes(StandardCharsets.UTF_8), 16);
        for (Section64 textSection : this.textSections) {
            if (!Arrays.equals(textSection.sectname, searchedName)) continue;
            return textSection;
        }
        return null;
    }

    @Override
    public long getVmsize() {
        return this.vmsize;
    }

    @Override
    public void setVmsize(long vmsize) {
        this.vmsize = vmsize;
    }

    @Override
    public long getFilesize() {
        return this.filesize;
    }

    @Override
    public long getFileoff() {
        return this.fileoff;
    }

    @Override
    public void setFilesize(long filesize) {
        this.filesize = filesize;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String toString() {
        return "Segment64Command{segmentName=" + this.getSegmentName() + ", vmaddr=" + this.vmaddr + ", vmsize=" + this.vmsize + ", fileoff=" + this.fileoff + ", filesize=" + this.filesize + ", maxprot=" + this.maxprot + ", initprot=" + this.initprot + ", nsects=" + this.nsects + ", flags=" + this.flags + '}';
    }

    public static class Section64 {
        private static final int NAME_LENGTH = 16;
        private final byte[] sectname = new byte[16];
        private final byte[] segname = new byte[16];
        private final long addr;
        private final long size;
        private final int offset;
        private final int align;
        private final int reloff;
        private final int nreloc;
        private final int flags;
        private final int reserved1;
        private final int reserved2;
        private final int reserved3;

        public Section64(ByteBuffer buf) {
            buf.get(this.sectname);
            buf.get(this.segname);
            this.addr = buf.getLong();
            this.size = buf.getLong();
            this.offset = buf.getInt();
            this.align = buf.getInt();
            this.reloff = buf.getInt();
            this.nreloc = buf.getInt();
            this.flags = buf.getInt();
            this.reserved1 = buf.getInt();
            this.reserved2 = buf.getInt();
            this.reserved3 = buf.getInt();
        }

        public long getSize() {
            return this.size;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

