/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DocValuesIterator;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.Impact;
import org.apache.lucene.index.Impacts;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PendingSoftDeletes;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CommandLineUtil;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.NamedThreadFactory;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.lucene.util.Version;

public final class CheckIndex
implements Closeable {
    private PrintStream infoStream;
    private Directory dir;
    private Lock writeLock;
    private volatile boolean closed;
    private NumberFormat nf = NumberFormat.getInstance(Locale.ROOT);
    private boolean doSlowChecks;
    private boolean failFast;
    private boolean verbose;
    private boolean checksumsOnly;
    private int threadCount = Runtime.getRuntime().availableProcessors();
    private static boolean assertsOn;

    public CheckIndex(Directory dir) throws IOException {
        this(dir, dir.obtainLock("write.lock"));
    }

    public CheckIndex(Directory dir, Lock writeLock) {
        this.dir = dir;
        this.writeLock = writeLock;
        this.infoStream = null;
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("this instance is closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        IOUtils.close(this.writeLock);
    }

    public void setDoSlowChecks(boolean v) {
        this.doSlowChecks = v;
    }

    public boolean doSlowChecks() {
        return this.doSlowChecks;
    }

    public void setFailFast(boolean v) {
        this.failFast = v;
    }

    public boolean getFailFast() {
        return this.failFast;
    }

    public boolean getChecksumsOnly() {
        return this.checksumsOnly;
    }

    public void setChecksumsOnly(boolean v) {
        this.checksumsOnly = v;
    }

    public void setThreadCount(int tc) {
        if (tc <= 0) {
            throw new IllegalArgumentException("setThreadCount requires a number larger than 0, but got: " + tc);
        }
        this.threadCount = tc;
    }

    public void setInfoStream(PrintStream out, boolean verbose) {
        this.infoStream = out;
        this.verbose = verbose;
    }

    public void setInfoStream(PrintStream out) {
        this.setInfoStream(out, false);
    }

    private static void msg(PrintStream out, ByteArrayOutputStream msg) {
        if (out != null) {
            out.println(msg.toString(StandardCharsets.UTF_8));
        }
    }

    private static void msg(PrintStream out, String msg) {
        if (out != null) {
            out.println(msg);
        }
    }

    public Status checkIndex() throws IOException {
        return this.checkIndex(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status checkIndex(List<String> onlySegments) throws IOException {
        ExecutorService executorService = null;
        if (this.threadCount > 1) {
            executorService = Executors.newFixedThreadPool(this.threadCount, new NamedThreadFactory("async-check-index"));
        }
        CheckIndex.msg(this.infoStream, "Checking index with threadCount: " + this.threadCount);
        try {
            Status status = this.checkIndex(onlySegments, executorService);
            return status;
        }
        finally {
            if (executorService != null) {
                executorService.shutdown();
                try {
                    executorService.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    CheckIndex.msg(this.infoStream, "ERROR: Interrupted exception occurred when shutting down executor service");
                    if (this.infoStream != null) {
                        e.printStackTrace(this.infoStream);
                    }
                }
                finally {
                    executorService.shutdownNow();
                }
            }
        }
    }

    public Status checkIndex(List<String> onlySegments, ExecutorService executorService) throws IOException {
        String segmentsFileName;
        this.ensureOpen();
        long startNS = System.nanoTime();
        SegmentInfos sis = null;
        Status result = new Status();
        result.dir = this.dir;
        Object[] files = this.dir.listAll();
        String lastSegmentsFile = SegmentInfos.getLastCommitSegmentsFileName((String[])files);
        if (lastSegmentsFile == null) {
            throw new IndexNotFoundException("no segments* file found in " + this.dir + ": files: " + Arrays.toString(files));
        }
        try {
            sis = SegmentInfos.readCommit(this.dir, lastSegmentsFile, 0);
        }
        catch (Throwable t) {
            if (this.failFast) {
                throw IOUtils.rethrowAlways(t);
            }
            CheckIndex.msg(this.infoStream, "ERROR: could not read any segments file in directory");
            result.missingSegments = true;
            if (this.infoStream != null) {
                t.printStackTrace(this.infoStream);
            }
            return result;
        }
        if (this.infoStream != null) {
            int maxDoc = 0;
            int delCount = 0;
            for (Object info : sis) {
                maxDoc += ((SegmentCommitInfo)info).info.maxDoc();
                delCount += ((SegmentCommitInfo)info).getDelCount();
            }
            this.infoStream.println(String.format(Locale.ROOT, "%.2f%% total deletions; %d documents; %d deletions", 100.0 * (double)delCount / (double)maxDoc, maxDoc, delCount));
        }
        Version oldest = null;
        Version newest = null;
        String oldSegs = null;
        for (SegmentCommitInfo si : sis) {
            Version version = si.info.getVersion();
            if (version == null) {
                oldSegs = "pre-3.1";
                continue;
            }
            if (oldest == null || !version.onOrAfter(oldest)) {
                oldest = version;
            }
            if (newest != null && !version.onOrAfter(newest)) continue;
            newest = version;
        }
        int numSegments = sis.size();
        result.segmentsFileName = segmentsFileName = sis.getSegmentsFileName();
        result.numSegments = numSegments;
        result.userData = sis.getUserData();
        Object userDataString = sis.getUserData().size() > 0 ? " userData=" + sis.getUserData() : "";
        Object versionString = "";
        if (oldSegs != null) {
            versionString = newest != null ? "versions=[" + oldSegs + " .. " + newest + "]" : "version=" + oldSegs;
        } else if (newest != null) {
            versionString = oldest.equals(newest) ? "version=" + oldest : "versions=[" + oldest + " .. " + newest + "]";
        }
        CheckIndex.msg(this.infoStream, "Segments file=" + segmentsFileName + " numSegments=" + numSegments + " " + (String)versionString + " id=" + StringHelper.idToString(sis.getId()) + (String)userDataString);
        if (onlySegments != null) {
            result.partial = true;
            if (this.infoStream != null) {
                this.infoStream.print("\nChecking only these segments:");
                for (String s2 : onlySegments) {
                    this.infoStream.print(" " + s2);
                }
            }
            result.segmentsChecked.addAll(onlySegments);
            CheckIndex.msg(this.infoStream, ":");
        }
        result.newSegments = sis.clone();
        result.newSegments.clear();
        result.maxSegmentName = -1L;
        if (executorService == null) {
            for (int i = 0; i < numSegments; ++i) {
                SegmentCommitInfo info = sis.info(i);
                this.updateMaxSegmentName(result, info);
                if (onlySegments != null && !onlySegments.contains(info.info.name)) continue;
                CheckIndex.msg(this.infoStream, 1 + i + " of " + numSegments + ": name=" + info.info.name + " maxDoc=" + info.info.maxDoc());
                Status.SegmentInfoStatus segmentInfoStatus = this.testSegment(sis, info, this.infoStream);
                this.processSegmentInfoStatusResult(result, info, segmentInfoStatus);
            }
        } else {
            SegmentCommitInfo info;
            int i;
            ByteArrayOutputStream[] outputs = new ByteArrayOutputStream[numSegments];
            CompletableFuture[] futures = new CompletableFuture[numSegments];
            ArrayList<SegmentCommitInfo> segmentCommitInfos = new ArrayList<SegmentCommitInfo>();
            for (SegmentCommitInfo sci : sis) {
                segmentCommitInfos.add(sci);
            }
            Collections.sort(segmentCommitInfos, (info1, info2) -> {
                try {
                    return Long.compare(info1.sizeInBytes(), info2.sizeInBytes());
                }
                catch (IOException e) {
                    CheckIndex.msg(this.infoStream, "ERROR: IOException occurred when comparing SegmentCommitInfo file sizes");
                    if (this.infoStream != null) {
                        e.printStackTrace(this.infoStream);
                    }
                    return 0;
                }
            });
            for (i = numSegments - 1; i >= 0; --i) {
                info = (SegmentCommitInfo)segmentCommitInfos.get(i);
                this.updateMaxSegmentName(result, info);
                if (onlySegments != null && !onlySegments.contains(info.info.name)) continue;
                SegmentInfos finalSis = sis;
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                PrintStream stream = new PrintStream((OutputStream)output, true, IOUtils.UTF_8);
                CheckIndex.msg(stream, 1 + i + " of " + numSegments + ": name=" + info.info.name + " maxDoc=" + info.info.maxDoc());
                outputs[i] = output;
                futures[i] = this.runAsyncSegmentCheck(() -> this.testSegment(finalSis, info, stream), executorService);
            }
            for (i = 0; i < numSegments; ++i) {
                info = (SegmentCommitInfo)segmentCommitInfos.get(i);
                if (onlySegments != null && !onlySegments.contains(info.info.name)) continue;
                ByteArrayOutputStream output = outputs[i];
                Status.SegmentInfoStatus segmentInfoStatus = null;
                try {
                    segmentInfoStatus = (Status.SegmentInfoStatus)futures[i].get();
                }
                catch (InterruptedException e) {
                    CheckIndex.msg(this.infoStream, output);
                    CheckIndex.msg(this.infoStream, "ERROR: Interrupted exception occurred when getting segment check result for segment " + info.info.name);
                    if (this.infoStream != null) {
                        e.printStackTrace(this.infoStream);
                    }
                }
                catch (ExecutionException e) {
                    CheckIndex.msg(this.infoStream, output.toString(StandardCharsets.UTF_8));
                    assert (this.failFast);
                    throw new CheckIndexException("Segment " + info.info.name + " check failed.", e.getCause());
                }
                CheckIndex.msg(this.infoStream, output);
                this.processSegmentInfoStatusResult(result, info, segmentInfoStatus);
            }
        }
        if (0 == result.numBadSegments) {
            result.clean = true;
        } else {
            CheckIndex.msg(this.infoStream, "WARNING: " + result.numBadSegments + " broken segments (containing " + result.totLoseDocCount + " documents) detected");
        }
        if (!(result.validCounter = result.maxSegmentName < sis.counter)) {
            result.clean = false;
            result.newSegments.counter = result.maxSegmentName + 1L;
            CheckIndex.msg(this.infoStream, "ERROR: Next segment name counter " + sis.counter + " is not greater than max segment name " + result.maxSegmentName);
        }
        if (result.clean) {
            CheckIndex.msg(this.infoStream, "No problems were detected with this index.\n");
        }
        CheckIndex.msg(this.infoStream, String.format(Locale.ROOT, "Took %.3f sec total.", CheckIndex.nsToSec(System.nanoTime() - startNS)));
        return result;
    }

    private void updateMaxSegmentName(Status result, SegmentCommitInfo info) {
        long segmentName = Long.parseLong(info.info.name.substring(1), 36);
        if (segmentName > result.maxSegmentName) {
            result.maxSegmentName = segmentName;
        }
    }

    private void processSegmentInfoStatusResult(Status result, SegmentCommitInfo info, Status.SegmentInfoStatus segmentInfoStatus) {
        result.segmentInfos.add(segmentInfoStatus);
        if (segmentInfoStatus.error != null) {
            result.totLoseDocCount += segmentInfoStatus.toLoseDocCount;
            ++result.numBadSegments;
        } else {
            result.newSegments.add(info.clone());
        }
    }

    private <R> CompletableFuture<R> runAsyncSegmentCheck(Callable<R> asyncCallable, ExecutorService executorService) {
        return CompletableFuture.supplyAsync(this.callableToSupplier(asyncCallable), executorService);
    }

    private <T> Supplier<T> callableToSupplier(Callable<T> callable) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new CompletionException(e);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status.SegmentInfoStatus testSegment(SegmentInfos sis, SegmentCommitInfo info, PrintStream infoStream) throws IOException {
        Status.SegmentInfoStatus segInfoStat = new Status.SegmentInfoStatus();
        segInfoStat.name = info.info.name;
        segInfoStat.maxDoc = info.info.maxDoc();
        Version version = info.info.getVersion();
        if (info.info.maxDoc() <= 0) {
            throw new CheckIndexException(" illegal number of documents: maxDoc=" + info.info.maxDoc());
        }
        int toLoseDocCount = info.info.maxDoc();
        try (IndexReader reader = null;){
            int numDocs;
            CheckIndex.msg(infoStream, "    version=" + (version == null ? "3.0" : version));
            CheckIndex.msg(infoStream, "    id=" + StringHelper.idToString(info.info.getId()));
            Codec codec = info.info.getCodec();
            CheckIndex.msg(infoStream, "    codec=" + codec);
            segInfoStat.codec = codec;
            CheckIndex.msg(infoStream, "    compound=" + info.info.getUseCompoundFile());
            segInfoStat.compound = info.info.getUseCompoundFile();
            CheckIndex.msg(infoStream, "    numFiles=" + info.files().size());
            Sort indexSort = info.info.getIndexSort();
            if (indexSort != null) {
                CheckIndex.msg(infoStream, "    sort=" + indexSort);
            }
            segInfoStat.numFiles = info.files().size();
            segInfoStat.sizeMB = (double)info.sizeInBytes() / 1048576.0;
            NumberFormat numberFormat = this.nf;
            synchronized (numberFormat) {
                CheckIndex.msg(infoStream, "    size (MB)=" + this.nf.format(segInfoStat.sizeMB));
            }
            Map<String, String> diagnostics = info.info.getDiagnostics();
            segInfoStat.diagnostics = diagnostics;
            if (diagnostics.size() > 0) {
                CheckIndex.msg(infoStream, "    diagnostics = " + diagnostics);
            }
            if (!info.hasDeletions()) {
                CheckIndex.msg(infoStream, "    no deletions");
                segInfoStat.hasDeletions = false;
            } else {
                CheckIndex.msg(infoStream, "    has deletions [delGen=" + info.getDelGen() + "]");
                segInfoStat.hasDeletions = true;
                segInfoStat.deletionsGen = info.getDelGen();
            }
            long startOpenReaderNS = System.nanoTime();
            if (infoStream != null) {
                infoStream.print("    test: open reader.........");
            }
            reader = new SegmentReader(info, sis.getIndexCreatedVersionMajor(), IOContext.DEFAULT);
            CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [took %.3f sec]", CheckIndex.nsToSec(System.nanoTime() - startOpenReaderNS)));
            segInfoStat.openReaderPassed = true;
            long startIntegrityNS = System.nanoTime();
            if (infoStream != null) {
                infoStream.print("    test: check integrity.....");
            }
            ((SegmentReader)reader).checkIntegrity();
            CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [took %.3f sec]", CheckIndex.nsToSec(System.nanoTime() - startIntegrityNS)));
            if (((SegmentReader)reader).maxDoc() != info.info.maxDoc()) {
                throw new CheckIndexException("SegmentReader.maxDoc() " + ((SegmentReader)reader).maxDoc() + " != SegmentInfo.maxDoc " + info.info.maxDoc());
            }
            toLoseDocCount = numDocs = ((SegmentReader)reader).numDocs();
            if (reader.hasDeletions()) {
                if (((SegmentReader)reader).numDocs() != info.info.maxDoc() - info.getDelCount()) {
                    throw new CheckIndexException("delete count mismatch: info=" + (info.info.maxDoc() - info.getDelCount()) + " vs reader=" + ((SegmentReader)reader).numDocs());
                }
                if (info.info.maxDoc() - ((SegmentReader)reader).numDocs() > ((SegmentReader)reader).maxDoc()) {
                    throw new CheckIndexException("too many deleted docs: maxDoc()=" + ((SegmentReader)reader).maxDoc() + " vs del count=" + (info.info.maxDoc() - ((SegmentReader)reader).numDocs()));
                }
                if (info.info.maxDoc() - ((SegmentReader)reader).numDocs() != info.getDelCount()) {
                    throw new CheckIndexException("delete count mismatch: info=" + info.getDelCount() + " vs reader=" + (info.info.maxDoc() - ((SegmentReader)reader).numDocs()));
                }
            } else if (info.getDelCount() != 0) {
                throw new CheckIndexException("delete count mismatch: info=" + info.getDelCount() + " vs reader=" + (info.info.maxDoc() - ((SegmentReader)reader).numDocs()));
            }
            if (!this.checksumsOnly) {
                String softDeletesField;
                segInfoStat.liveDocStatus = CheckIndex.testLiveDocs((CodecReader)reader, infoStream, this.failFast);
                segInfoStat.fieldInfoStatus = CheckIndex.testFieldInfos((CodecReader)reader, infoStream, this.failFast);
                segInfoStat.fieldNormStatus = CheckIndex.testFieldNorms((CodecReader)reader, infoStream, this.failFast);
                segInfoStat.termIndexStatus = CheckIndex.testPostings((CodecReader)reader, infoStream, this.verbose, this.doSlowChecks, this.failFast);
                segInfoStat.storedFieldStatus = CheckIndex.testStoredFields((CodecReader)reader, infoStream, this.failFast);
                segInfoStat.termVectorStatus = CheckIndex.testTermVectors((CodecReader)reader, infoStream, this.verbose, this.doSlowChecks, this.failFast);
                segInfoStat.docValuesStatus = CheckIndex.testDocValues((CodecReader)reader, infoStream, this.failFast);
                segInfoStat.pointsStatus = CheckIndex.testPoints((CodecReader)reader, infoStream, this.failFast);
                segInfoStat.vectorValuesStatus = CheckIndex.testVectors((CodecReader)reader, infoStream, this.failFast);
                if (indexSort != null) {
                    segInfoStat.indexSortStatus = CheckIndex.testSort((CodecReader)reader, indexSort, infoStream, this.failFast);
                }
                if ((softDeletesField = ((SegmentReader)reader).getFieldInfos().getSoftDeletesField()) != null) {
                    segInfoStat.softDeletesStatus = CheckIndex.checkSoftDeletes(softDeletesField, info, (SegmentReader)reader, infoStream, this.failFast);
                }
                if (segInfoStat.liveDocStatus.error != null) {
                    throw new CheckIndexException("Live docs test failed", segInfoStat.liveDocStatus.error);
                }
                if (segInfoStat.fieldInfoStatus.error != null) {
                    throw new CheckIndexException("Field Info test failed", segInfoStat.fieldInfoStatus.error);
                }
                if (segInfoStat.fieldNormStatus.error != null) {
                    throw new CheckIndexException("Field Norm test failed", segInfoStat.fieldNormStatus.error);
                }
                if (segInfoStat.termIndexStatus.error != null) {
                    throw new CheckIndexException("Term Index test failed", segInfoStat.termIndexStatus.error);
                }
                if (segInfoStat.storedFieldStatus.error != null) {
                    throw new CheckIndexException("Stored Field test failed", segInfoStat.storedFieldStatus.error);
                }
                if (segInfoStat.termVectorStatus.error != null) {
                    throw new CheckIndexException("Term Vector test failed", segInfoStat.termVectorStatus.error);
                }
                if (segInfoStat.docValuesStatus.error != null) {
                    throw new CheckIndexException("DocValues test failed", segInfoStat.docValuesStatus.error);
                }
                if (segInfoStat.pointsStatus.error != null) {
                    throw new CheckIndexException("Points test failed", segInfoStat.pointsStatus.error);
                }
                if (segInfoStat.vectorValuesStatus.error != null) {
                    throw new CheckIndexException("Vectors test failed", segInfoStat.vectorValuesStatus.error);
                }
                if (segInfoStat.indexSortStatus != null && segInfoStat.indexSortStatus.error != null) {
                    throw new CheckIndexException("Index Sort test failed", segInfoStat.indexSortStatus.error);
                }
                if (segInfoStat.softDeletesStatus != null && segInfoStat.softDeletesStatus.error != null) {
                    throw new CheckIndexException("Soft Deletes test failed", segInfoStat.softDeletesStatus.error);
                }
            }
            CheckIndex.msg(infoStream, "");
        }
        return segInfoStat;
    }

    public static Status.IndexSortStatus testSort(CodecReader reader, Sort sort, PrintStream infoStream, boolean failFast) throws IOException {
        Status.IndexSortStatus status;
        block8: {
            long startNS = System.nanoTime();
            status = new Status.IndexSortStatus();
            if (sort != null) {
                if (infoStream != null) {
                    infoStream.print("    test: index sort..........");
                }
                SortField[] fields = sort.getSort();
                int[] reverseMul = new int[fields.length];
                LeafFieldComparator[] comparators = new LeafFieldComparator[fields.length];
                LeafReaderContext readerContext = new LeafReaderContext(reader);
                for (int i = 0; i < fields.length; ++i) {
                    reverseMul[i] = fields[i].getReverse() ? -1 : 1;
                    comparators[i] = fields[i].getComparator(1, false).getLeafComparator(readerContext);
                }
                int maxDoc = reader.maxDoc();
                try {
                    for (int docID = 1; docID < maxDoc; ++docID) {
                        int cmp = 0;
                        for (int i = 0; i < comparators.length; ++i) {
                            comparators[i].copy(0, docID - 1);
                            comparators[i].setBottom(0);
                            cmp = reverseMul[i] * comparators[i].compareBottom(docID);
                            if (cmp != 0) break;
                        }
                        if (cmp <= 0) continue;
                        throw new CheckIndexException("segment has indexSort=" + sort + " but docID=" + (docID - 1) + " sorts after docID=" + docID);
                    }
                    CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [took %.3f sec]", CheckIndex.nsToSec(System.nanoTime() - startNS)));
                }
                catch (Throwable e) {
                    if (failFast) {
                        throw IOUtils.rethrowAlways(e);
                    }
                    CheckIndex.msg(infoStream, "ERROR [" + String.valueOf(e.getMessage()) + "]");
                    status.error = e;
                    if (infoStream == null) break block8;
                    e.printStackTrace(infoStream);
                }
            }
        }
        return status;
    }

    public static Status.LiveDocStatus testLiveDocs(CodecReader reader, PrintStream infoStream, boolean failFast) throws IOException {
        Status.LiveDocStatus status;
        block11: {
            long startNS = System.nanoTime();
            status = new Status.LiveDocStatus();
            try {
                if (infoStream != null) {
                    infoStream.print("    test: check live docs.....");
                }
                int numDocs = reader.numDocs();
                if (reader.hasDeletions()) {
                    Bits liveDocs = reader.getLiveDocs();
                    if (liveDocs == null) {
                        throw new CheckIndexException("segment should have deletions, but liveDocs is null");
                    }
                    int numLive = 0;
                    for (int j = 0; j < liveDocs.length(); ++j) {
                        if (!liveDocs.get(j)) continue;
                        ++numLive;
                    }
                    if (numLive != numDocs) {
                        throw new CheckIndexException("liveDocs count mismatch: info=" + numDocs + ", vs bits=" + numLive);
                    }
                    status.numDeleted = reader.numDeletedDocs();
                    CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d deleted docs] [took %.3f sec]", status.numDeleted, CheckIndex.nsToSec(System.nanoTime() - startNS)));
                } else {
                    Bits liveDocs = reader.getLiveDocs();
                    if (liveDocs != null) {
                        for (int j = 0; j < liveDocs.length(); ++j) {
                            if (liveDocs.get(j)) continue;
                            throw new CheckIndexException("liveDocs mismatch: info says no deletions but doc " + j + " is deleted.");
                        }
                    }
                    CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [took %.3f sec]", CheckIndex.nsToSec(System.nanoTime() - startNS)));
                }
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (infoStream == null) break block11;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    public static Status.FieldInfoStatus testFieldInfos(CodecReader reader, PrintStream infoStream, boolean failFast) throws IOException {
        Status.FieldInfoStatus status;
        block5: {
            long startNS = System.nanoTime();
            status = new Status.FieldInfoStatus();
            try {
                if (infoStream != null) {
                    infoStream.print("    test: field infos.........");
                }
                FieldInfos fieldInfos = reader.getFieldInfos();
                for (FieldInfo f : fieldInfos) {
                    f.checkConsistency();
                }
                CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d fields] [took %.3f sec]", fieldInfos.size(), CheckIndex.nsToSec(System.nanoTime() - startNS)));
                status.totFields = fieldInfos.size();
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (infoStream == null) break block5;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    public static Status.FieldNormStatus testFieldNorms(CodecReader reader, PrintStream infoStream, boolean failFast) throws IOException {
        Status.FieldNormStatus status;
        block6: {
            long startNS = System.nanoTime();
            status = new Status.FieldNormStatus();
            try {
                NormsProducer normsReader;
                if (infoStream != null) {
                    infoStream.print("    test: field norms.........");
                }
                if ((normsReader = reader.getNormsReader()) != null) {
                    normsReader = normsReader.getMergeInstance();
                }
                for (FieldInfo info : reader.getFieldInfos()) {
                    if (!info.hasNorms()) continue;
                    CheckIndex.checkNumericDocValues(info.name, normsReader.getNorms(info), normsReader.getNorms(info));
                    ++status.totFields;
                }
                CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d fields] [took %.3f sec]", status.totFields, CheckIndex.nsToSec(System.nanoTime() - startNS)));
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (infoStream == null) break block6;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    private static Status.TermIndexStatus checkFields(Fields fields, Bits liveDocs, int maxDoc, FieldInfos fieldInfos, NormsProducer normsProducer, boolean doPrint, boolean isVectors, PrintStream infoStream, boolean verbose, boolean doSlowChecks) throws IOException {
        long startNS = doPrint ? System.nanoTime() : 0L;
        Status.TermIndexStatus status = new Status.TermIndexStatus();
        int computedFieldCount = 0;
        PostingsEnum postings = null;
        String lastField = null;
        for (String field : fields) {
            int i;
            int seekCount;
            BytesRef term;
            boolean expectedHasFreqs;
            BytesRef minTerm;
            BytesRef maxTerm;
            if (lastField != null && field.compareTo(lastField) <= 0) {
                throw new CheckIndexException("fields out of order: lastField=" + lastField + " field=" + field);
            }
            lastField = field;
            FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
            if (fieldInfo == null) {
                throw new CheckIndexException("fieldsEnum inconsistent with fieldInfos, no fieldInfos for: " + field);
            }
            if (fieldInfo.getIndexOptions() == IndexOptions.NONE) {
                throw new CheckIndexException("fieldsEnum inconsistent with fieldInfos, isIndexed == false for: " + field);
            }
            ++computedFieldCount;
            Terms terms = fields.terms(field);
            if (terms == null) continue;
            if (terms.getDocCount() > maxDoc) {
                throw new CheckIndexException("docCount > maxDoc for field: " + field + ", docCount=" + terms.getDocCount() + ", maxDoc=" + maxDoc);
            }
            boolean hasFreqs = terms.hasFreqs();
            boolean hasPositions = terms.hasPositions();
            boolean hasPayloads = terms.hasPayloads();
            boolean hasOffsets = terms.hasOffsets();
            if (isVectors) {
                maxTerm = null;
                minTerm = null;
            } else {
                BytesRef bb = terms.getMin();
                if (bb != null) {
                    assert (bb.isValid());
                    minTerm = BytesRef.deepCopyOf(bb);
                } else {
                    minTerm = null;
                }
                bb = terms.getMax();
                if (bb != null) {
                    assert (bb.isValid());
                    maxTerm = BytesRef.deepCopyOf(bb);
                    if (minTerm == null) {
                        throw new CheckIndexException("field \"" + field + "\" has null minTerm but non-null maxTerm");
                    }
                } else {
                    maxTerm = null;
                    if (minTerm != null) {
                        throw new CheckIndexException("field \"" + field + "\" has non-null minTerm but null maxTerm");
                    }
                }
            }
            boolean bl = expectedHasFreqs = isVectors || fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
            if (hasFreqs != expectedHasFreqs) {
                throw new CheckIndexException("field \"" + field + "\" should have hasFreqs=" + expectedHasFreqs + " but got " + hasFreqs);
            }
            if (!isVectors) {
                boolean expectedHasOffsets;
                boolean expectedHasPositions;
                boolean bl2 = expectedHasPositions = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
                if (hasPositions != expectedHasPositions) {
                    throw new CheckIndexException("field \"" + field + "\" should have hasPositions=" + expectedHasPositions + " but got " + hasPositions);
                }
                boolean expectedHasPayloads = fieldInfo.hasPayloads();
                if (hasPayloads != expectedHasPayloads) {
                    throw new CheckIndexException("field \"" + field + "\" should have hasPayloads=" + expectedHasPayloads + " but got " + hasPayloads);
                }
                boolean bl3 = expectedHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
                if (hasOffsets != expectedHasOffsets) {
                    throw new CheckIndexException("field \"" + field + "\" should have hasOffsets=" + expectedHasOffsets + " but got " + hasOffsets);
                }
            }
            TermsEnum termsEnum = terms.iterator();
            boolean hasOrd = true;
            long termCountStart = status.delTermCount + status.termCount;
            BytesRefBuilder lastTerm = null;
            long sumTotalTermFreq = 0L;
            long sumDocFreq = 0L;
            FixedBitSet visitedDocs = new FixedBitSet(maxDoc);
            block3: while ((term = termsEnum.next()) != null) {
                int doc;
                int docID;
                int skipDocID;
                int idx;
                int doc2;
                int docFreq;
                assert (term.isValid());
                if (lastTerm == null) {
                    lastTerm = new BytesRefBuilder();
                    lastTerm.copyBytes(term);
                } else {
                    if (lastTerm.get().compareTo(term) >= 0) {
                        throw new CheckIndexException("terms out of order: lastTerm=" + lastTerm.get() + " term=" + term);
                    }
                    lastTerm.copyBytes(term);
                }
                if (!isVectors) {
                    if (minTerm == null) {
                        assert (maxTerm == null);
                        throw new CheckIndexException("field=\"" + field + "\": invalid term: term=" + term + ", minTerm=" + minTerm);
                    }
                    if (term.compareTo(minTerm) < 0) {
                        throw new CheckIndexException("field=\"" + field + "\": invalid term: term=" + term + ", minTerm=" + minTerm);
                    }
                    if (term.compareTo(maxTerm) > 0) {
                        throw new CheckIndexException("field=\"" + field + "\": invalid term: term=" + term + ", maxTerm=" + maxTerm);
                    }
                }
                if ((docFreq = termsEnum.docFreq()) <= 0) {
                    throw new CheckIndexException("docfreq: " + docFreq + " is out of bounds");
                }
                sumDocFreq += (long)docFreq;
                postings = termsEnum.postings(postings, 120);
                if (!hasFreqs && termsEnum.totalTermFreq() != (long)termsEnum.docFreq()) {
                    throw new CheckIndexException("field \"" + field + "\" hasFreqs is false, but TermsEnum.totalTermFreq()=" + termsEnum.totalTermFreq() + " (should be " + termsEnum.docFreq() + ")");
                }
                if (hasOrd) {
                    long ordExpected;
                    long ord = -1L;
                    try {
                        ord = termsEnum.ord();
                    }
                    catch (UnsupportedOperationException uoe) {
                        hasOrd = false;
                    }
                    if (hasOrd && ord != (ordExpected = status.delTermCount + status.termCount - termCountStart)) {
                        throw new CheckIndexException("ord mismatch: TermsEnum has ord=" + ord + " vs actual=" + ordExpected);
                    }
                }
                int lastDoc = -1;
                int docCount = 0;
                boolean hasNonDeletedDocs = false;
                long totalTermFreq = 0L;
                while ((doc2 = postings.nextDoc()) != Integer.MAX_VALUE) {
                    visitedDocs.set(doc2);
                    int freq = postings.freq();
                    if (freq <= 0) {
                        throw new CheckIndexException("term " + term + ": doc " + doc2 + ": freq " + freq + " is out of bounds");
                    }
                    if (!hasFreqs && postings.freq() != 1) {
                        throw new CheckIndexException("term " + term + ": doc " + doc2 + ": freq " + freq + " != 1 when Terms.hasFreqs() is false");
                    }
                    totalTermFreq += (long)freq;
                    if (liveDocs == null || liveDocs.get(doc2)) {
                        hasNonDeletedDocs = true;
                        ++status.totFreq;
                        if (freq >= 0) {
                            status.totPos += (long)freq;
                        }
                    }
                    ++docCount;
                    if (doc2 <= lastDoc) {
                        throw new CheckIndexException("term " + term + ": doc " + doc2 + " <= lastDoc " + lastDoc);
                    }
                    if (doc2 >= maxDoc) {
                        throw new CheckIndexException("term " + term + ": doc " + doc2 + " >= maxDoc " + maxDoc);
                    }
                    lastDoc = doc2;
                    int lastPos = -1;
                    int lastOffset = 0;
                    if (!hasPositions) continue;
                    for (int j = 0; j < freq; ++j) {
                        int pos = postings.nextPosition();
                        if (pos < 0) {
                            throw new CheckIndexException("term " + term + ": doc " + doc2 + ": pos " + pos + " is out of bounds");
                        }
                        if (pos > 0x7FFFFF7F) {
                            throw new CheckIndexException("term " + term + ": doc " + doc2 + ": pos " + pos + " > IndexWriter.MAX_POSITION=2147483519");
                        }
                        if (pos < lastPos) {
                            throw new CheckIndexException("term " + term + ": doc " + doc2 + ": pos " + pos + " < lastPos " + lastPos);
                        }
                        lastPos = pos;
                        BytesRef payload = postings.getPayload();
                        if (payload != null) assert (payload.isValid());
                        if (payload != null && payload.length < 1) {
                            throw new CheckIndexException("term " + term + ": doc " + doc2 + ": pos " + pos + " payload length is out of bounds " + payload.length);
                        }
                        if (!hasOffsets) continue;
                        int startOffset = postings.startOffset();
                        int endOffset = postings.endOffset();
                        if (startOffset < 0) {
                            throw new CheckIndexException("term " + term + ": doc " + doc2 + ": pos " + pos + ": startOffset " + startOffset + " is out of bounds");
                        }
                        if (startOffset < lastOffset) {
                            throw new CheckIndexException("term " + term + ": doc " + doc2 + ": pos " + pos + ": startOffset " + startOffset + " < lastStartOffset " + lastOffset + "; consider using the FixBrokenOffsets tool in Lucene's backward-codecs module to correct your index");
                        }
                        if (endOffset < 0) {
                            throw new CheckIndexException("term " + term + ": doc " + doc2 + ": pos " + pos + ": endOffset " + endOffset + " is out of bounds");
                        }
                        if (endOffset < startOffset) {
                            throw new CheckIndexException("term " + term + ": doc " + doc2 + ": pos " + pos + ": endOffset " + endOffset + " < startOffset " + startOffset);
                        }
                        lastOffset = startOffset;
                    }
                }
                if (hasNonDeletedDocs) {
                    ++status.termCount;
                } else {
                    ++status.delTermCount;
                }
                long totalTermFreq2 = termsEnum.totalTermFreq();
                if (docCount != docFreq) {
                    throw new CheckIndexException("term " + term + " docFreq=" + docFreq + " != tot docs w/o deletions " + docCount);
                }
                if (docFreq > terms.getDocCount()) {
                    throw new CheckIndexException("term " + term + " docFreq=" + docFreq + " > docCount=" + terms.getDocCount());
                }
                if (totalTermFreq2 <= 0L) {
                    throw new CheckIndexException("totalTermFreq: " + totalTermFreq2 + " is out of bounds");
                }
                sumTotalTermFreq += totalTermFreq;
                if (totalTermFreq != totalTermFreq2) {
                    throw new CheckIndexException("term " + term + " totalTermFreq=" + totalTermFreq2 + " != recomputed totalTermFreq=" + totalTermFreq);
                }
                if (totalTermFreq2 < (long)docFreq) {
                    throw new CheckIndexException("totalTermFreq: " + totalTermFreq2 + " is out of bounds, docFreq=" + docFreq);
                }
                if (!hasFreqs && totalTermFreq != (long)docFreq) {
                    throw new CheckIndexException("term " + term + " totalTermFreq=" + totalTermFreq + " !=  docFreq=" + docFreq);
                }
                if (hasPositions) {
                    for (idx = 0; idx < 7; ++idx) {
                        skipDocID = (int)((long)(idx + 1) * (long)maxDoc / 8L);
                        docID = (postings = termsEnum.postings(postings, 120)).advance(skipDocID);
                        if (docID == Integer.MAX_VALUE) break;
                        if (docID < skipDocID) {
                            throw new CheckIndexException("term " + term + ": advance(docID=" + skipDocID + ") returned docID=" + docID);
                        }
                        int freq = postings.freq();
                        if (freq <= 0) {
                            throw new CheckIndexException("termFreq " + freq + " is out of bounds");
                        }
                        int lastPosition = -1;
                        int lastOffset = 0;
                        for (int posUpto = 0; posUpto < freq; ++posUpto) {
                            int pos = postings.nextPosition();
                            if (pos < 0) {
                                throw new CheckIndexException("position " + pos + " is out of bounds");
                            }
                            if (pos < lastPosition) {
                                throw new CheckIndexException("position " + pos + " is < lastPosition " + lastPosition);
                            }
                            lastPosition = pos;
                            if (!hasOffsets) continue;
                            int startOffset = postings.startOffset();
                            int endOffset = postings.endOffset();
                            if (!isVectors) {
                                if (startOffset < 0) {
                                    throw new CheckIndexException("term " + term + ": doc " + docID + ": pos " + pos + ": startOffset " + startOffset + " is out of bounds");
                                }
                                if (startOffset < lastOffset) {
                                    throw new CheckIndexException("term " + term + ": doc " + docID + ": pos " + pos + ": startOffset " + startOffset + " < lastStartOffset " + lastOffset);
                                }
                                if (endOffset < 0) {
                                    throw new CheckIndexException("term " + term + ": doc " + docID + ": pos " + pos + ": endOffset " + endOffset + " is out of bounds");
                                }
                                if (endOffset < startOffset) {
                                    throw new CheckIndexException("term " + term + ": doc " + docID + ": pos " + pos + ": endOffset " + endOffset + " < startOffset " + startOffset);
                                }
                            }
                            lastOffset = startOffset;
                        }
                        int nextDocID = postings.nextDoc();
                        if (nextDocID == Integer.MAX_VALUE) break;
                        if (nextDocID <= docID) {
                            throw new CheckIndexException("term " + term + ": advance(docID=" + skipDocID + "), then .next() returned docID=" + nextDocID + " vs prev docID=" + docID);
                        }
                        if (!isVectors) {
                            continue;
                        }
                        break;
                    }
                } else {
                    for (idx = 0; idx < 7; ++idx) {
                        skipDocID = (int)((long)(idx + 1) * (long)maxDoc / 8L);
                        docID = (postings = termsEnum.postings(postings, 0)).advance(skipDocID);
                        if (docID == Integer.MAX_VALUE) break;
                        if (docID < skipDocID) {
                            throw new CheckIndexException("term " + term + ": advance(docID=" + skipDocID + ") returned docID=" + docID);
                        }
                        int nextDocID = postings.nextDoc();
                        if (nextDocID == Integer.MAX_VALUE) break;
                        if (nextDocID <= docID) {
                            throw new CheckIndexException("term " + term + ": advance(docID=" + skipDocID + "), then .next() returned docID=" + nextDocID + " vs prev docID=" + docID);
                        }
                        if (!isVectors) {
                            continue;
                        }
                        break;
                    }
                }
                if (!doSlowChecks && docFreq <= 1024 && (status.termCount + status.delTermCount) % 1024L != 0L) continue;
                if (doSlowChecks) {
                    int max = -1;
                    int maxFreq = 0;
                    ImpactsEnum impactsEnum = termsEnum.impacts(8);
                    postings = termsEnum.postings(postings, 8);
                    doc = impactsEnum.nextDoc();
                    while (true) {
                        if (postings.nextDoc() != doc) {
                            throw new CheckIndexException("Wrong next doc: " + doc + ", expected " + postings.docID());
                        }
                        if (doc == Integer.MAX_VALUE) break;
                        if (postings.freq() != impactsEnum.freq()) {
                            throw new CheckIndexException("Wrong freq, expected " + postings.freq() + ", but got " + impactsEnum.freq());
                        }
                        if (doc > max) {
                            impactsEnum.advanceShallow(doc);
                            Impacts impacts = impactsEnum.getImpacts();
                            CheckIndex.checkImpacts(impacts, doc);
                            max = impacts.getDocIdUpTo(0);
                            List<Impact> impacts0 = impacts.getImpacts(0);
                            maxFreq = impacts0.get((int)(impacts0.size() - 1)).freq;
                        }
                        if (impactsEnum.freq() > maxFreq) {
                            throw new CheckIndexException("freq " + impactsEnum.freq() + " is greater than the max freq according to impacts " + maxFreq);
                        }
                        doc = impactsEnum.nextDoc();
                    }
                }
                ImpactsEnum impactsEnum = termsEnum.impacts(8);
                postings = termsEnum.postings(postings, 8);
                int max = -1;
                int maxFreq = 0;
                block10: do {
                    List<Impact> perLevelImpacts;
                    int level;
                    Impacts impacts;
                    int delta;
                    int target;
                    boolean advance;
                    doc = impactsEnum.docID();
                    if ((field.hashCode() + doc & 1) == 1) {
                        advance = false;
                        target = doc + 1;
                    } else {
                        advance = true;
                        delta = Math.min(1 + (31 * field.hashCode() + doc & 0x1FF), Integer.MAX_VALUE - doc);
                        target = impactsEnum.docID() + delta;
                    }
                    if (target > max && target % 2 == 1) {
                        delta = Math.min(31 * field.hashCode() + target & 0x1FF, Integer.MAX_VALUE - target);
                        max = target + delta;
                        impactsEnum.advanceShallow(target);
                        impacts = impactsEnum.getImpacts();
                        CheckIndex.checkImpacts(impacts, doc);
                        maxFreq = Integer.MAX_VALUE;
                        for (level = 0; level < impacts.numLevels(); ++level) {
                            if (impacts.getDocIdUpTo(level) < max) continue;
                            perLevelImpacts = impacts.getImpacts(level);
                            maxFreq = perLevelImpacts.get((int)(perLevelImpacts.size() - 1)).freq;
                            break;
                        }
                    }
                    doc = advance ? impactsEnum.advance(target) : impactsEnum.nextDoc();
                    if (postings.advance(target) != doc) {
                        throw new CheckIndexException("Impacts do not advance to the same document as postings for target " + target + ", postings: " + postings.docID() + ", impacts: " + doc);
                    }
                    if (doc == Integer.MAX_VALUE) continue block3;
                    if (postings.freq() != impactsEnum.freq()) {
                        throw new CheckIndexException("Wrong freq, expected " + postings.freq() + ", but got " + impactsEnum.freq());
                    }
                    if (doc < max) continue;
                    delta = Math.min(31 * field.hashCode() + target & 0x1FF, Integer.MAX_VALUE - doc);
                    max = doc + delta;
                    impactsEnum.advanceShallow(doc);
                    impacts = impactsEnum.getImpacts();
                    CheckIndex.checkImpacts(impacts, doc);
                    maxFreq = Integer.MAX_VALUE;
                    for (level = 0; level < impacts.numLevels(); ++level) {
                        if (impacts.getDocIdUpTo(level) < max) continue;
                        perLevelImpacts = impacts.getImpacts(level);
                        maxFreq = perLevelImpacts.get((int)(perLevelImpacts.size() - 1)).freq;
                        continue block10;
                    }
                } while (impactsEnum.freq() <= maxFreq);
                throw new CheckIndexException("Term frequency " + impactsEnum.freq() + " is greater than the max freq according to impacts " + maxFreq);
            }
            if (minTerm != null && status.termCount + status.delTermCount == 0L) {
                throw new CheckIndexException("field=\"" + field + "\": minTerm is non-null yet we saw no terms: " + minTerm);
            }
            Terms fieldTerms = fields.terms(field);
            if (fieldTerms == null) continue;
            long fieldTermCount = status.delTermCount + status.termCount - termCountStart;
            Object stats = fieldTerms.getStats();
            assert (stats != null);
            if (status.blockTreeStats == null) {
                status.blockTreeStats = new HashMap<String, Object>();
            }
            status.blockTreeStats.put(field, stats);
            long actualSumDocFreq = fields.terms(field).getSumDocFreq();
            if (sumDocFreq != actualSumDocFreq) {
                throw new CheckIndexException("sumDocFreq for field " + field + "=" + actualSumDocFreq + " != recomputed sumDocFreq=" + sumDocFreq);
            }
            long actualSumTotalTermFreq = fields.terms(field).getSumTotalTermFreq();
            if (sumTotalTermFreq != actualSumTotalTermFreq) {
                throw new CheckIndexException("sumTotalTermFreq for field " + field + "=" + actualSumTotalTermFreq + " != recomputed sumTotalTermFreq=" + sumTotalTermFreq);
            }
            if (!hasFreqs && sumTotalTermFreq != sumDocFreq) {
                throw new CheckIndexException("sumTotalTermFreq for field " + field + " should be " + sumDocFreq + ", got sumTotalTermFreq=" + sumTotalTermFreq);
            }
            int v = fieldTerms.getDocCount();
            if (visitedDocs.cardinality() != v) {
                throw new CheckIndexException("docCount for field " + field + "=" + v + " != recomputed docCount=" + visitedDocs.cardinality());
            }
            if (fieldInfo.hasNorms() && !isVectors) {
                NumericDocValues norms = normsProducer.getNorms(fieldInfo);
                int actualCount = 0;
                int doc = norms.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (liveDocs == null || liveDocs.get(doc)) {
                        long norm = norms.longValue();
                        if (norm != 0L) {
                            ++actualCount;
                            if (!visitedDocs.get(doc)) {
                                throw new CheckIndexException("Document " + doc + " doesn't have terms according to postings but has a norm value that is not zero: " + Long.toUnsignedString(norm));
                            }
                        } else if (norm == 0L && visitedDocs.get(doc)) {
                            throw new CheckIndexException("Document " + doc + " has terms according to postings but its norm value is 0, which may only be used on documents that have no terms");
                        }
                    }
                    doc = norms.nextDoc();
                }
                int expectedCount = 0;
                int doc3 = visitedDocs.nextSetBit(0);
                while (doc3 != Integer.MAX_VALUE) {
                    if (liveDocs == null || liveDocs.get(doc3)) {
                        ++expectedCount;
                    }
                    doc3 = doc3 + 1 >= visitedDocs.length() ? Integer.MAX_VALUE : visitedDocs.nextSetBit(doc3 + 1);
                }
                if (expectedCount != actualCount) {
                    throw new CheckIndexException("actual norm count: " + actualCount + " but expected: " + expectedCount);
                }
            }
            if (lastTerm != null) {
                if (termsEnum.seekCeil(lastTerm.get()) != TermsEnum.SeekStatus.FOUND) {
                    throw new CheckIndexException("seek to last term " + lastTerm.get() + " failed");
                }
                if (!termsEnum.term().equals(lastTerm.get())) {
                    throw new CheckIndexException("seek to last term " + lastTerm.get() + " returned FOUND but seeked to the wrong term " + termsEnum.term());
                }
                int expectedDocFreq = termsEnum.docFreq();
                PostingsEnum d = termsEnum.postings(null, 0);
                int docFreq = 0;
                while (d.nextDoc() != Integer.MAX_VALUE) {
                    ++docFreq;
                }
                if (docFreq != expectedDocFreq) {
                    throw new CheckIndexException("docFreq for last term " + lastTerm.get() + "=" + expectedDocFreq + " != recomputed docFreq=" + docFreq);
                }
            }
            long termCount = -1L;
            if (fieldTermCount > 0L && (termCount = fields.terms(field).size()) != -1L && termCount != fieldTermCount) {
                throw new CheckIndexException("termCount mismatch " + termCount + " vs " + fieldTermCount);
            }
            if (!hasOrd || status.termCount - termCountStart <= 0L || (seekCount = (int)Math.min(10000L, termCount)) <= 0) continue;
            BytesRef[] seekTerms = new BytesRef[seekCount];
            for (i = seekCount - 1; i >= 0; --i) {
                long ord = (long)i * (termCount / (long)seekCount);
                termsEnum.seekExact(ord);
                long actualOrd = termsEnum.ord();
                if (actualOrd != ord) {
                    throw new CheckIndexException("seek to ord " + ord + " returned ord " + actualOrd);
                }
                seekTerms[i] = BytesRef.deepCopyOf(termsEnum.term());
            }
            for (i = seekCount - 1; i >= 0; --i) {
                if (termsEnum.seekCeil(seekTerms[i]) != TermsEnum.SeekStatus.FOUND) {
                    throw new CheckIndexException("seek to existing term " + seekTerms[i] + " failed");
                }
                if (!termsEnum.term().equals(seekTerms[i])) {
                    throw new CheckIndexException("seek to existing term " + seekTerms[i] + " returned FOUND but seeked to the wrong term " + termsEnum.term());
                }
                if ((postings = termsEnum.postings(postings, 0)) != null) continue;
                throw new CheckIndexException("null DocsEnum from to existing term " + seekTerms[i]);
            }
        }
        int fieldCount = fields.size();
        if (fieldCount != -1) {
            if (fieldCount < 0) {
                throw new CheckIndexException("invalid fieldCount: " + fieldCount);
            }
            if (fieldCount != computedFieldCount) {
                throw new CheckIndexException("fieldCount mismatch " + fieldCount + " vs recomputed field count " + computedFieldCount);
            }
        }
        if (doPrint) {
            CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d terms; %d terms/docs pairs; %d tokens] [took %.3f sec]", status.termCount, status.totFreq, status.totPos, CheckIndex.nsToSec(System.nanoTime() - startNS)));
        }
        if (verbose && status.blockTreeStats != null && infoStream != null && status.termCount > 0L) {
            for (Map.Entry<String, Object> ent : status.blockTreeStats.entrySet()) {
                infoStream.println("      field \"" + ent.getKey() + "\":");
                infoStream.println("      " + ent.getValue().toString().replace("\n", "\n      "));
            }
        }
        return status;
    }

    static void checkImpacts(Impacts impacts, int lastTarget) {
        int level;
        int numLevels = impacts.numLevels();
        if (numLevels < 1) {
            throw new CheckIndexException("The number of levels must be >= 1, got " + numLevels);
        }
        int docIdUpTo0 = impacts.getDocIdUpTo(0);
        if (docIdUpTo0 < lastTarget) {
            throw new CheckIndexException("getDocIdUpTo returned " + docIdUpTo0 + " on level 0, which is less than the target " + lastTarget);
        }
        for (level = 1; level < numLevels; ++level) {
            int previousDocIdUpTo;
            int docIdUpTo = impacts.getDocIdUpTo(level);
            if (docIdUpTo >= (previousDocIdUpTo = impacts.getDocIdUpTo(level - 1))) continue;
            throw new CheckIndexException("Decreasing return for getDocIdUpTo: level " + (level - 1) + " returned " + previousDocIdUpTo + " but level " + level + " returned " + docIdUpTo + " for target " + lastTarget);
        }
        for (level = 0; level < numLevels; ++level) {
            List<Impact> perLevelImpacts = impacts.getImpacts(level);
            if (perLevelImpacts.isEmpty()) {
                throw new CheckIndexException("Got empty list of impacts on level " + level);
            }
            Impact first = perLevelImpacts.get(0);
            if (first.freq < 1) {
                throw new CheckIndexException("First impact had a freq <= 0: " + first);
            }
            if (first.norm == 0L) {
                throw new CheckIndexException("First impact had a norm == 0: " + first);
            }
            Impact previous = first;
            for (int i = 1; i < perLevelImpacts.size(); ++i) {
                Impact impact = perLevelImpacts.get(i);
                if (impact.freq > previous.freq && Long.compareUnsigned(impact.norm, previous.norm) > 0) continue;
                throw new CheckIndexException("Impacts are not ordered or contain dups, got " + previous + " then " + impact);
            }
            if (level <= 0) continue;
            Iterator<Impact> previousIt = impacts.getImpacts(level - 1).iterator();
            previous = previousIt.next();
            Iterator<Impact> it = perLevelImpacts.iterator();
            Impact impact = it.next();
            while (previousIt.hasNext()) {
                previous = previousIt.next();
                if (previous.freq <= impact.freq && Long.compareUnsigned(previous.norm, impact.norm) >= 0) continue;
                if (!it.hasNext()) {
                    throw new CheckIndexException("Found impact " + previous + " on level " + (level - 1) + " but no impact on level " + level + " triggers a better score: " + perLevelImpacts);
                }
                impact = it.next();
            }
        }
    }

    public static Status.TermIndexStatus testPostings(CodecReader reader, PrintStream infoStream) throws IOException {
        return CheckIndex.testPostings(reader, infoStream, false, true, false);
    }

    public static Status.TermIndexStatus testPostings(CodecReader reader, PrintStream infoStream, boolean verbose, boolean doSlowChecks, boolean failFast) throws IOException {
        Status.TermIndexStatus status;
        block6: {
            int maxDoc = reader.maxDoc();
            try {
                FieldsProducer fields;
                if (infoStream != null) {
                    infoStream.print("    test: terms, freq, prox...");
                }
                if ((fields = reader.getPostingsReader()) == null) {
                    return new Status.TermIndexStatus();
                }
                fields = fields.getMergeInstance();
                FieldInfos fieldInfos = reader.getFieldInfos();
                NormsProducer normsProducer = reader.getNormsReader();
                if (normsProducer != null) {
                    normsProducer = normsProducer.getMergeInstance();
                }
                status = CheckIndex.checkFields(fields, reader.getLiveDocs(), maxDoc, fieldInfos, normsProducer, true, false, infoStream, verbose, doSlowChecks);
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR: " + e);
                status = new Status.TermIndexStatus();
                status.error = e;
                if (infoStream == null) break block6;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    public static Status.PointsStatus testPoints(CodecReader reader, PrintStream infoStream, boolean failFast) throws IOException {
        Status.PointsStatus status;
        block12: {
            if (infoStream != null) {
                infoStream.print("    test: points..............");
            }
            long startNS = System.nanoTime();
            FieldInfos fieldInfos = reader.getFieldInfos();
            status = new Status.PointsStatus();
            try {
                if (fieldInfos.hasPointValues()) {
                    PointsReader pointsReader = reader.getPointsReader();
                    if (pointsReader == null) {
                        throw new CheckIndexException("there are fields with points, but reader.getPointsReader() is null");
                    }
                    for (FieldInfo fieldInfo : fieldInfos) {
                        PointValues values2;
                        if (fieldInfo.getPointDimensionCount() <= 0 || (values2 = pointsReader.getValues(fieldInfo.name)) == null) continue;
                        ++status.totalValueFields;
                        long size = values2.size();
                        int docCount = values2.getDocCount();
                        long crossCost = values2.estimatePointCount(new ConstantRelationIntersectVisitor(PointValues.Relation.CELL_CROSSES_QUERY));
                        if (crossCost < size / 2L) {
                            throw new CheckIndexException("estimatePointCount should return >= size/2 when all cells match");
                        }
                        long insideCost = values2.estimatePointCount(new ConstantRelationIntersectVisitor(PointValues.Relation.CELL_INSIDE_QUERY));
                        if (insideCost < size) {
                            throw new CheckIndexException("estimatePointCount should return >= size when all cells fully match");
                        }
                        long outsideCost = values2.estimatePointCount(new ConstantRelationIntersectVisitor(PointValues.Relation.CELL_OUTSIDE_QUERY));
                        if (outsideCost != 0L) {
                            throw new CheckIndexException("estimatePointCount should return 0 when no cells match");
                        }
                        VerifyPointsVisitor visitor = new VerifyPointsVisitor(fieldInfo.name, reader.maxDoc(), values2);
                        values2.intersect(visitor);
                        if (visitor.getPointCountSeen() != size) {
                            throw new CheckIndexException("point values for field \"" + fieldInfo.name + "\" claims to have size=" + size + " points, but in fact has " + visitor.getPointCountSeen());
                        }
                        if (visitor.getDocCountSeen() != (long)docCount) {
                            throw new CheckIndexException("point values for field \"" + fieldInfo.name + "\" claims to have docCount=" + docCount + " but in fact has " + visitor.getDocCountSeen());
                        }
                        status.totalValuePoints += visitor.getPointCountSeen();
                    }
                }
                CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d fields, %d points] [took %.3f sec]", status.totalValueFields, status.totalValuePoints, CheckIndex.nsToSec(System.nanoTime() - startNS)));
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR: " + e);
                status.error = e;
                if (infoStream == null) break block12;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    public static Status.VectorValuesStatus testVectors(CodecReader reader, PrintStream infoStream, boolean failFast) throws IOException {
        Status.VectorValuesStatus status;
        block11: {
            if (infoStream != null) {
                infoStream.print("    test: vectors.............");
            }
            long startNS = System.nanoTime();
            FieldInfos fieldInfos = reader.getFieldInfos();
            status = new Status.VectorValuesStatus();
            try {
                if (fieldInfos.hasVectorValues()) {
                    block6: for (FieldInfo fieldInfo : fieldInfos) {
                        if (!fieldInfo.hasVectorValues()) continue;
                        int dimension = fieldInfo.getVectorDimension();
                        if (dimension <= 0) {
                            throw new CheckIndexException("Field \"" + fieldInfo.name + "\" has vector values but dimension is " + dimension);
                        }
                        if (reader.getFloatVectorValues(fieldInfo.name) == null && reader.getByteVectorValues(fieldInfo.name) == null) continue;
                        ++status.totalKnnVectorFields;
                        switch (fieldInfo.getVectorEncoding()) {
                            case BYTE: {
                                CheckIndex.checkByteVectorValues(Objects.requireNonNull(reader.getByteVectorValues(fieldInfo.name)), fieldInfo, status, reader);
                                continue block6;
                            }
                            case FLOAT32: {
                                CheckIndex.checkFloatVectorValues(Objects.requireNonNull(reader.getFloatVectorValues(fieldInfo.name)), fieldInfo, status, reader);
                                continue block6;
                            }
                        }
                        throw new CheckIndexException("Field \"" + fieldInfo.name + "\" has unexpected vector encoding: " + fieldInfo.getVectorEncoding());
                    }
                }
                CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d fields, %d vectors] [took %.3f sec]", status.totalKnnVectorFields, status.totalVectorValues, CheckIndex.nsToSec(System.nanoTime() - startNS)));
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR: " + e);
                status.error = e;
                if (infoStream == null) break block11;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    private static void checkFloatVectorValues(FloatVectorValues values2, FieldInfo fieldInfo, Status.VectorValuesStatus status, CodecReader codecReader) throws IOException {
        int docCount = 0;
        int everyNdoc = Math.max(values2.size() / 64, 1);
        while (values2.nextDoc() != Integer.MAX_VALUE) {
            int valueLength;
            if (values2.docID() % everyNdoc == 0) {
                TopDocs docs = codecReader.getVectorReader().search(fieldInfo.name, values2.vectorValue(), 10, null, Integer.MAX_VALUE);
                if (docs.scoreDocs.length == 0) {
                    throw new CheckIndexException("Field \"" + fieldInfo.name + "\" failed to search k nearest neighbors");
                }
            }
            if ((valueLength = values2.vectorValue().length) != fieldInfo.getVectorDimension()) {
                throw new CheckIndexException("Field \"" + fieldInfo.name + "\" has a value whose dimension=" + valueLength + " not matching the field's dimension=" + fieldInfo.getVectorDimension());
            }
            ++docCount;
        }
        if (docCount != values2.size()) {
            throw new CheckIndexException("Field \"" + fieldInfo.name + "\" has size=" + values2.size() + " but when iterated, returns " + docCount + " docs with values");
        }
        status.totalVectorValues += (long)docCount;
    }

    private static void checkByteVectorValues(ByteVectorValues values2, FieldInfo fieldInfo, Status.VectorValuesStatus status, CodecReader codecReader) throws IOException {
        int docCount = 0;
        int everyNdoc = Math.max(values2.size() / 64, 1);
        while (values2.nextDoc() != Integer.MAX_VALUE) {
            int valueLength;
            if (values2.docID() % everyNdoc == 0) {
                TopDocs docs = codecReader.getVectorReader().search(fieldInfo.name, values2.vectorValue(), 10, (Bits)null, Integer.MAX_VALUE);
                if (docs.scoreDocs.length == 0) {
                    throw new CheckIndexException("Field \"" + fieldInfo.name + "\" failed to search k nearest neighbors");
                }
            }
            if ((valueLength = values2.vectorValue().length) != fieldInfo.getVectorDimension()) {
                throw new CheckIndexException("Field \"" + fieldInfo.name + "\" has a value whose dimension=" + valueLength + " not matching the field's dimension=" + fieldInfo.getVectorDimension());
            }
            ++docCount;
        }
        if (docCount != values2.size()) {
            throw new CheckIndexException("Field \"" + fieldInfo.name + "\" has size=" + values2.size() + " but when iterated, returns " + docCount + " docs with values");
        }
        status.totalVectorValues += (long)docCount;
    }

    public static Status.StoredFieldStatus testStoredFields(CodecReader reader, PrintStream infoStream, boolean failFast) throws IOException {
        Status.StoredFieldStatus status;
        block6: {
            long startNS = System.nanoTime();
            status = new Status.StoredFieldStatus();
            try {
                if (infoStream != null) {
                    infoStream.print("    test: stored fields.......");
                }
                Bits liveDocs = reader.getLiveDocs();
                StoredFieldsReader storedFields = reader.getFieldsReader().getMergeInstance();
                for (int j = 0; j < reader.maxDoc(); ++j) {
                    DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor();
                    storedFields.document(j, visitor);
                    Document doc = visitor.getDocument();
                    if (liveDocs != null && !liveDocs.get(j)) continue;
                    ++status.docCount;
                    status.totFields += (long)doc.getFields().size();
                }
                if (status.docCount != reader.numDocs()) {
                    throw new CheckIndexException("docCount=" + status.docCount + " but saw " + status.docCount + " undeleted docs");
                }
                CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d total field count; avg %.1f fields per doc] [took %.3f sec]", status.totFields, Float.valueOf((float)status.totFields / (float)status.docCount), CheckIndex.nsToSec(System.nanoTime() - startNS)));
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (infoStream == null) break block6;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    public static Status.DocValuesStatus testDocValues(CodecReader reader, PrintStream infoStream, boolean failFast) throws IOException {
        Status.DocValuesStatus status;
        block6: {
            long startNS = System.nanoTime();
            status = new Status.DocValuesStatus();
            try {
                DocValuesProducer dvReader;
                if (infoStream != null) {
                    infoStream.print("    test: docvalues...........");
                }
                if ((dvReader = reader.getDocValuesReader()) != null) {
                    dvReader = dvReader.getMergeInstance();
                }
                for (FieldInfo fieldInfo : reader.getFieldInfos()) {
                    if (fieldInfo.getDocValuesType() == DocValuesType.NONE) continue;
                    ++status.totalValueFields;
                    CheckIndex.checkDocValues(fieldInfo, dvReader, reader.maxDoc(), infoStream, status);
                }
                CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d docvalues fields; %d BINARY; %d NUMERIC; %d SORTED; %d SORTED_NUMERIC; %d SORTED_SET] [took %.3f sec]", status.totalValueFields, status.totalBinaryFields, status.totalNumericFields, status.totalSortedFields, status.totalSortedNumericFields, status.totalSortedSetFields, CheckIndex.nsToSec(System.nanoTime() - startNS)));
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (infoStream == null) break block6;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    private static void checkDVIterator(FieldInfo fi, int maxDoc, DocValuesIteratorSupplier producer) throws IOException {
        String field = fi.name;
        DocValuesIterator it1 = producer.get(fi);
        DocValuesIterator it2 = producer.get(fi);
        int i = 0;
        int doc = it1.nextDoc();
        while (true) {
            if (i++ % 10 == 1) {
                int doc2 = it2.advance(doc - 1);
                if (doc2 < doc - 1) {
                    throw new CheckIndexException("dv iterator field=" + field + ": doc=" + (doc - 1) + " went backwords (got: " + doc2 + ")");
                }
                if (doc2 == doc - 1) {
                    doc2 = it2.nextDoc();
                }
                if (doc2 != doc) {
                    throw new CheckIndexException("dv iterator field=" + field + ": doc=" + doc + " was not found through advance() (got: " + doc2 + ")");
                }
                if (it2.docID() != doc) {
                    throw new CheckIndexException("dv iterator field=" + field + ": doc=" + doc + " reports wrong doc ID (got: " + it2.docID() + ")");
                }
            }
            if (doc == Integer.MAX_VALUE) break;
            doc = it1.nextDoc();
        }
        it1 = producer.get(fi);
        it2 = producer.get(fi);
        i = 0;
        int lastDoc = -1;
        int doc2 = it1.nextDoc();
        while (doc2 != Integer.MAX_VALUE) {
            if (i++ % 13 == 1) {
                boolean found;
                if (doc2 - 1 == lastDoc != (found = it2.advanceExact(doc2 - 1))) {
                    throw new CheckIndexException("dv iterator field=" + field + ": doc=" + (doc2 - 1) + " disagrees about whether document exists (got: " + found + ")");
                }
                if (it2.docID() != doc2 - 1) {
                    throw new CheckIndexException("dv iterator field=" + field + ": doc=" + (doc2 - 1) + " reports wrong doc ID (got: " + it2.docID() + ")");
                }
                boolean found2 = it2.advanceExact(doc2 - 1);
                if (found != found2) {
                    throw new CheckIndexException("dv iterator field=" + field + ": doc=" + (doc2 - 1) + " has unstable advanceExact");
                }
                if (i % 2 == 0) {
                    int doc22 = it2.nextDoc();
                    if (doc2 != doc22) {
                        throw new CheckIndexException("dv iterator field=" + field + ": doc=" + doc2 + " was not found through advance() (got: " + doc22 + ")");
                    }
                    if (it2.docID() != doc2) {
                        throw new CheckIndexException("dv iterator field=" + field + ": doc=" + doc2 + " reports wrong doc ID (got: " + it2.docID() + ")");
                    }
                }
            }
            lastDoc = doc2;
            doc2 = it1.nextDoc();
        }
    }

    private static void checkBinaryDocValues(String fieldName, int maxDoc, BinaryDocValues bdv, BinaryDocValues bdv2) throws IOException {
        if (bdv.docID() != -1) {
            throw new CheckIndexException("binary dv iterator for field: " + fieldName + " should start at docID=-1, but got " + bdv.docID());
        }
        int doc = bdv.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            BytesRef value = bdv.binaryValue();
            value.isValid();
            if (!bdv2.advanceExact(doc)) {
                throw new CheckIndexException("advanceExact did not find matching doc ID: " + doc);
            }
            BytesRef value2 = bdv2.binaryValue();
            if (!value.equals(value2)) {
                throw new CheckIndexException("nextDoc and advanceExact report different values: " + value + " != " + value2);
            }
            doc = bdv.nextDoc();
        }
    }

    private static void checkSortedDocValues(String fieldName, int maxDoc, SortedDocValues dv, SortedDocValues dv2) throws IOException {
        if (dv.docID() != -1) {
            throw new CheckIndexException("sorted dv iterator for field: " + fieldName + " should start at docID=-1, but got " + dv.docID());
        }
        int maxOrd = dv.getValueCount() - 1;
        FixedBitSet seenOrds = new FixedBitSet(dv.getValueCount());
        int maxOrd2 = -1;
        int doc = dv.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int ord = dv.ordValue();
            if (ord == -1) {
                throw new CheckIndexException("dv for field: " + fieldName + " has -1 ord");
            }
            if (ord < -1 || ord > maxOrd) {
                throw new CheckIndexException("ord out of bounds: " + ord);
            }
            maxOrd2 = Math.max(maxOrd2, ord);
            seenOrds.set(ord);
            if (!dv2.advanceExact(doc)) {
                throw new CheckIndexException("advanceExact did not find matching doc ID: " + doc);
            }
            int ord2 = dv2.ordValue();
            if (ord != ord2) {
                throw new CheckIndexException("nextDoc and advanceExact report different ords: " + ord + " != " + ord2);
            }
            doc = dv.nextDoc();
        }
        if (maxOrd != maxOrd2) {
            throw new CheckIndexException("dv for field: " + fieldName + " reports wrong maxOrd=" + maxOrd + " but this is not the case: " + maxOrd2);
        }
        if (seenOrds.cardinality() != dv.getValueCount()) {
            throw new CheckIndexException("dv for field: " + fieldName + " has holes in its ords, valueCount=" + dv.getValueCount() + " but only used: " + seenOrds.cardinality());
        }
        BytesRef lastValue = null;
        for (int i = 0; i <= maxOrd; ++i) {
            BytesRef term = dv.lookupOrd(i);
            term.isValid();
            if (lastValue != null && term.compareTo(lastValue) <= 0) {
                throw new CheckIndexException("dv for field: " + fieldName + " has ords out of order: " + lastValue + " >=" + term);
            }
            lastValue = BytesRef.deepCopyOf(term);
        }
    }

    private static void checkSortedSetDocValues(String fieldName, int maxDoc, SortedSetDocValues dv, SortedSetDocValues dv2) throws IOException {
        long maxOrd = dv.getValueCount() - 1L;
        LongBitSet seenOrds = new LongBitSet(dv.getValueCount());
        long maxOrd2 = -1L;
        int docID = dv.nextDoc();
        while (docID != Integer.MAX_VALUE) {
            int count = dv.docValueCount();
            if (count == 0) {
                throw new CheckIndexException("sortedset dv for field: " + fieldName + " returned docValueCount=0 for docID=" + docID);
            }
            if (!dv2.advanceExact(docID)) {
                throw new CheckIndexException("advanceExact did not find matching doc ID: " + docID);
            }
            int count2 = dv2.docValueCount();
            if (count != count2) {
                throw new CheckIndexException("advanceExact reports different value count: " + count + " != " + count2);
            }
            long lastOrd = -1L;
            int ordCount = 0;
            for (int i = 0; i < count; ++i) {
                long ord2;
                if (count != dv.docValueCount()) {
                    throw new CheckIndexException("value count changed from " + count + " to " + dv.docValueCount() + " during iterating over all values");
                }
                long ord = dv.nextOrd();
                if (ord != (ord2 = dv2.nextOrd())) {
                    throw new CheckIndexException("nextDoc and advanceExact report different ords: " + ord + " != " + ord2);
                }
                if (ord <= lastOrd) {
                    throw new CheckIndexException("ords out of order: " + ord + " <= " + lastOrd + " for doc: " + docID);
                }
                if (ord < 0L || ord > maxOrd) {
                    throw new CheckIndexException("ord out of bounds: " + ord);
                }
                lastOrd = ord;
                maxOrd2 = Math.max(maxOrd2, ord);
                seenOrds.set(ord);
                ++ordCount;
            }
            if (dv.docValueCount() != dv2.docValueCount()) {
                throw new CheckIndexException("dv and dv2 report different values count after iterating over all values: " + dv.docValueCount() + " != " + dv2.docValueCount());
            }
            if (ordCount == 0) {
                throw new CheckIndexException("dv for field: " + fieldName + " returned docID=" + docID + " yet has no ordinals");
            }
            docID = dv.nextDoc();
        }
        if (maxOrd != maxOrd2) {
            throw new CheckIndexException("dv for field: " + fieldName + " reports wrong maxOrd=" + maxOrd + " but this is not the case: " + maxOrd2);
        }
        if (seenOrds.cardinality() != dv.getValueCount()) {
            throw new CheckIndexException("dv for field: " + fieldName + " has holes in its ords, valueCount=" + dv.getValueCount() + " but only used: " + seenOrds.cardinality());
        }
        BytesRef lastValue = null;
        for (long i = 0L; i <= maxOrd; ++i) {
            BytesRef term = dv.lookupOrd(i);
            assert (term.isValid());
            if (lastValue != null && term.compareTo(lastValue) <= 0) {
                throw new CheckIndexException("dv for field: " + fieldName + " has ords out of order: " + lastValue + " >=" + term);
            }
            lastValue = BytesRef.deepCopyOf(term);
        }
    }

    private static void checkSortedNumericDocValues(String fieldName, int maxDoc, SortedNumericDocValues ndv, SortedNumericDocValues ndv2) throws IOException {
        if (ndv.docID() != -1) {
            throw new CheckIndexException("dv iterator for field: " + fieldName + " should start at docID=-1, but got " + ndv.docID());
        }
        int docID = ndv.nextDoc();
        while (docID != Integer.MAX_VALUE) {
            int count = ndv.docValueCount();
            if (count == 0) {
                throw new CheckIndexException("sorted numeric dv for field: " + fieldName + " returned docValueCount=0 for docID=" + docID);
            }
            if (!ndv2.advanceExact(docID)) {
                throw new CheckIndexException("advanceExact did not find matching doc ID: " + docID);
            }
            int count2 = ndv2.docValueCount();
            if (count != count2) {
                throw new CheckIndexException("advanceExact reports different value count: " + count + " != " + count2);
            }
            long previous = Long.MIN_VALUE;
            for (int j = 0; j < count; ++j) {
                long value = ndv.nextValue();
                if (value < previous) {
                    throw new CheckIndexException("values out of order: " + value + " < " + previous + " for doc: " + docID);
                }
                previous = value;
                long value2 = ndv2.nextValue();
                if (value == value2) continue;
                throw new CheckIndexException("advanceExact reports different value: " + value + " != " + value2);
            }
            docID = ndv.nextDoc();
        }
    }

    private static void checkNumericDocValues(String fieldName, NumericDocValues ndv, NumericDocValues ndv2) throws IOException {
        if (ndv.docID() != -1) {
            throw new CheckIndexException("dv iterator for field: " + fieldName + " should start at docID=-1, but got " + ndv.docID());
        }
        int doc = ndv.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            long value = ndv.longValue();
            if (!ndv2.advanceExact(doc)) {
                throw new CheckIndexException("advanceExact did not find matching doc ID: " + doc);
            }
            long value2 = ndv2.longValue();
            if (value != value2) {
                throw new CheckIndexException("advanceExact reports different value: " + value + " != " + value2);
            }
            doc = ndv.nextDoc();
        }
    }

    private static void checkDocValues(FieldInfo fi, DocValuesProducer dvReader, int maxDoc, PrintStream infoStream, Status.DocValuesStatus status) throws Exception {
        switch (fi.getDocValuesType()) {
            case SORTED: {
                ++status.totalSortedFields;
                CheckIndex.checkDVIterator(fi, maxDoc, dvReader::getSorted);
                CheckIndex.checkSortedDocValues(fi.name, maxDoc, dvReader.getSorted(fi), dvReader.getSorted(fi));
                break;
            }
            case SORTED_NUMERIC: {
                ++status.totalSortedNumericFields;
                CheckIndex.checkDVIterator(fi, maxDoc, dvReader::getSortedNumeric);
                CheckIndex.checkSortedNumericDocValues(fi.name, maxDoc, dvReader.getSortedNumeric(fi), dvReader.getSortedNumeric(fi));
                break;
            }
            case SORTED_SET: {
                ++status.totalSortedSetFields;
                CheckIndex.checkDVIterator(fi, maxDoc, dvReader::getSortedSet);
                CheckIndex.checkSortedSetDocValues(fi.name, maxDoc, dvReader.getSortedSet(fi), dvReader.getSortedSet(fi));
                break;
            }
            case BINARY: {
                ++status.totalBinaryFields;
                CheckIndex.checkDVIterator(fi, maxDoc, dvReader::getBinary);
                CheckIndex.checkBinaryDocValues(fi.name, maxDoc, dvReader.getBinary(fi), dvReader.getBinary(fi));
                break;
            }
            case NUMERIC: {
                ++status.totalNumericFields;
                CheckIndex.checkDVIterator(fi, maxDoc, dvReader::getNumeric);
                CheckIndex.checkNumericDocValues(fi.name, dvReader.getNumeric(fi), dvReader.getNumeric(fi));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public static Status.TermVectorStatus testTermVectors(CodecReader reader, PrintStream infoStream) throws IOException {
        return CheckIndex.testTermVectors(reader, infoStream, false, false, false);
    }

    public static Status.TermVectorStatus testTermVectors(CodecReader reader, PrintStream infoStream, boolean verbose, boolean doSlowChecks, boolean failFast) throws IOException {
        Status.TermVectorStatus status;
        block31: {
            long startNS = System.nanoTime();
            status = new Status.TermVectorStatus();
            FieldInfos fieldInfos = reader.getFieldInfos();
            try {
                TermVectorsReader vectorsReader;
                FieldsProducer postingsFields;
                if (infoStream != null) {
                    infoStream.print("    test: term vectors........");
                }
                PostingsEnum postings = null;
                PostingsEnum postingsDocs = null;
                Bits liveDocs = reader.getLiveDocs();
                if (doSlowChecks) {
                    postingsFields = reader.getPostingsReader();
                    if (postingsFields != null) {
                        postingsFields = postingsFields.getMergeInstance();
                    }
                } else {
                    postingsFields = null;
                }
                if ((vectorsReader = reader.getTermVectorsReader()) != null) {
                    vectorsReader = vectorsReader.getMergeInstance();
                    for (int j = 0; j < reader.maxDoc(); ++j) {
                        boolean doStats;
                        Fields tfv = vectorsReader.get(j);
                        if (tfv == null) continue;
                        CheckIndex.checkFields(tfv, null, 1, fieldInfos, null, false, true, infoStream, verbose, doSlowChecks);
                        boolean bl = doStats = liveDocs == null || liveDocs.get(j);
                        if (doStats) {
                            ++status.docCount;
                        }
                        for (String field : tfv) {
                            FieldInfo fieldInfo;
                            if (doStats) {
                                ++status.totVectors;
                            }
                            if (!(fieldInfo = fieldInfos.fieldInfo(field)).hasVectors()) {
                                throw new CheckIndexException("docID=" + j + " has term vectors for field=" + field + " but FieldInfo has storeTermVector=false");
                            }
                            if (!doSlowChecks) continue;
                            Terms terms = tfv.terms(field);
                            TermsEnum termsEnum = terms.iterator();
                            boolean postingsHasFreq = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
                            boolean postingsHasPayload = fieldInfo.hasPayloads();
                            boolean vectorsHasPayload = terms.hasPayloads();
                            if (postingsFields == null) {
                                throw new CheckIndexException("vector field=" + field + " does not exist in postings; doc=" + j);
                            }
                            Terms postingsTerms = postingsFields.terms(field);
                            if (postingsTerms == null) {
                                throw new CheckIndexException("vector field=" + field + " does not exist in postings; doc=" + j);
                            }
                            TermsEnum postingsTermsEnum = postingsTerms.iterator();
                            boolean hasProx = terms.hasOffsets() || terms.hasPositions();
                            BytesRef term = null;
                            while ((term = termsEnum.next()) != null) {
                                postings = termsEnum.postings(postings, 120);
                                assert (postings != null);
                                if (!postingsTermsEnum.seekExact(term)) {
                                    throw new CheckIndexException("vector term=" + term + " field=" + field + " does not exist in postings; doc=" + j);
                                }
                                postingsDocs = postingsTermsEnum.postings(postingsDocs, 120);
                                assert (postingsDocs != null);
                                int advanceDoc = postingsDocs.advance(j);
                                if (advanceDoc != j) {
                                    throw new CheckIndexException("vector term=" + term + " field=" + field + ": doc=" + j + " was not found in postings (got: " + advanceDoc + ")");
                                }
                                int doc = postings.nextDoc();
                                if (doc != 0) {
                                    throw new CheckIndexException("vector for doc " + j + " didn't return docID=0: got docID=" + doc);
                                }
                                if (!postingsHasFreq) continue;
                                int tf = postings.freq();
                                if (postingsHasFreq && postingsDocs.freq() != tf) {
                                    throw new CheckIndexException("vector term=" + term + " field=" + field + " doc=" + j + ": freq=" + tf + " differs from postings freq=" + postingsDocs.freq());
                                }
                                if (!hasProx) continue;
                                for (int i = 0; i < tf; ++i) {
                                    BytesRef payload;
                                    int pos = postings.nextPosition();
                                    if (postingsTerms.hasPositions()) {
                                        int postingsPos = postingsDocs.nextPosition();
                                        if (terms.hasPositions() && pos != postingsPos) {
                                            throw new CheckIndexException("vector term=" + term + " field=" + field + " doc=" + j + ": pos=" + pos + " differs from postings pos=" + postingsPos);
                                        }
                                    }
                                    int startOffset = postings.startOffset();
                                    int endOffset = postings.endOffset();
                                    if (startOffset != -1 && endOffset != -1 && postingsTerms.hasOffsets()) {
                                        int postingsStartOffset = postingsDocs.startOffset();
                                        int postingsEndOffset = postingsDocs.endOffset();
                                        if (startOffset != postingsStartOffset) {
                                            throw new CheckIndexException("vector term=" + term + " field=" + field + " doc=" + j + ": startOffset=" + startOffset + " differs from postings startOffset=" + postingsStartOffset);
                                        }
                                        if (endOffset != postingsEndOffset) {
                                            throw new CheckIndexException("vector term=" + term + " field=" + field + " doc=" + j + ": endOffset=" + endOffset + " differs from postings endOffset=" + postingsEndOffset);
                                        }
                                    }
                                    if ((payload = postings.getPayload()) != null) assert (vectorsHasPayload);
                                    if (!postingsHasPayload || !vectorsHasPayload) continue;
                                    if (payload == null) {
                                        if (postingsDocs.getPayload() == null) continue;
                                        throw new CheckIndexException("vector term=" + term + " field=" + field + " doc=" + j + " has no payload but postings does: " + postingsDocs.getPayload());
                                    }
                                    if (postingsDocs.getPayload() == null) {
                                        throw new CheckIndexException("vector term=" + term + " field=" + field + " doc=" + j + " has payload=" + payload + " but postings does not.");
                                    }
                                    BytesRef postingsPayload = postingsDocs.getPayload();
                                    if (payload.equals(postingsPayload)) continue;
                                    throw new CheckIndexException("vector term=" + term + " field=" + field + " doc=" + j + " has payload=" + payload + " but differs from postings payload=" + postingsPayload);
                                }
                            }
                        }
                    }
                }
                float vectorAvg = status.docCount == 0 ? 0.0f : (float)status.totVectors / (float)status.docCount;
                CheckIndex.msg(infoStream, String.format(Locale.ROOT, "OK [%d total term vector count; avg %.1f term/freq vector fields per doc] [took %.3f sec]", status.totVectors, Float.valueOf(vectorAvg), CheckIndex.nsToSec(System.nanoTime() - startNS)));
            }
            catch (Throwable e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (infoStream == null) break block31;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    public void exorciseIndex(Status result) throws IOException {
        this.ensureOpen();
        if (result.partial) {
            throw new IllegalArgumentException("can only exorcise an index that was fully checked (this status checked a subset of segments)");
        }
        result.newSegments.changed();
        result.newSegments.commit(result.dir);
    }

    private static boolean testAsserts() {
        assertsOn = true;
        return true;
    }

    public static boolean assertsOn() {
        assert (CheckIndex.testAsserts());
        return assertsOn;
    }

    public static void main(String[] args2) throws IOException, InterruptedException {
        int exitCode = CheckIndex.doMain(args2);
        System.exit(exitCode);
    }

    @SuppressForbidden(reason="System.out required: command line tool")
    private static int doMain(String[] args2) throws IOException, InterruptedException {
        Options opts;
        try {
            opts = CheckIndex.parseOptions(args2);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            return 1;
        }
        if (!CheckIndex.assertsOn()) {
            System.out.println("\nNOTE: testing will be more thorough if you run java with '-ea:org.apache.lucene...', so assertions are enabled");
        }
        System.out.println("\nOpening index @ " + opts.indexPath + "\n");
        FSDirectory directory = null;
        Path path = Paths.get(opts.indexPath, new String[0]);
        try {
            directory = opts.dirImpl == null ? FSDirectory.open(path) : CommandLineUtil.newFSDirectory(opts.dirImpl, path);
        }
        catch (Throwable t) {
            System.out.println("ERROR: could not open directory \"" + opts.indexPath + "\"; exiting");
            t.printStackTrace(System.out);
            return 1;
        }
        try (FSDirectory dir = directory;){
            int n;
            try (CheckIndex checker = new CheckIndex(dir);){
                opts.out = System.out;
                n = checker.doCheck(opts);
            }
            return n;
        }
    }

    @SuppressForbidden(reason="System.err required: command line tool")
    public static Options parseOptions(String[] args2) {
        Options opts = new Options();
        for (int i = 0; i < args2.length; ++i) {
            String arg = args2[i];
            if ("-fast".equals(arg)) {
                opts.doChecksumsOnly = true;
                continue;
            }
            if ("-exorcise".equals(arg)) {
                opts.doExorcise = true;
                continue;
            }
            if ("-crossCheckTermVectors".equals(arg)) {
                System.err.println("-crossCheckTermVectors is deprecated, use -slow instead");
                opts.doSlowChecks = true;
                continue;
            }
            if ("-slow".equals(arg)) {
                opts.doSlowChecks = true;
                continue;
            }
            if (arg.equals("-verbose")) {
                opts.verbose = true;
                continue;
            }
            if (arg.equals("-segment")) {
                if (i == args2.length - 1) {
                    throw new IllegalArgumentException("ERROR: missing name for -segment option");
                }
                opts.onlySegments.add(args2[++i]);
                continue;
            }
            if ("-dir-impl".equals(arg)) {
                if (i == args2.length - 1) {
                    throw new IllegalArgumentException("ERROR: missing value for -dir-impl option");
                }
                opts.dirImpl = args2[++i];
                continue;
            }
            if ("-threadCount".equals(arg)) {
                if (i == args2.length - 1) {
                    throw new IllegalArgumentException("-threadCount requires a following number");
                }
                opts.threadCount = Integer.parseInt(args2[++i]);
                if (opts.threadCount > 0) continue;
                throw new IllegalArgumentException("-threadCount requires a number larger than 0, but got: " + opts.threadCount);
            }
            if (opts.indexPath != null) {
                throw new IllegalArgumentException("ERROR: unexpected extra argument '" + args2[i] + "'");
            }
            opts.indexPath = args2[i];
        }
        if (opts.indexPath == null) {
            throw new IllegalArgumentException("\nERROR: index path not specified\nUsage: java org.apache.lucene.index.CheckIndex pathToIndex [-exorcise] [-slow] [-segment X] [-segment Y] [-threadCount X] [-dir-impl X]\n\n  -exorcise: actually write a new segments_N file, removing any problematic segments\n  -fast: just verify file checksums, omitting logical integrity checks\n  -slow: do additional slow checks; THIS IS VERY SLOW!\n  -codec X: when exorcising, codec to write the new segments_N file with\n  -verbose: print additional details\n  -segment X: only check the specified segments.  This can be specified multiple\n              times, to check more than one segment, eg '-segment _2 -segment _a'.\n              You can't use this with the -exorcise option\n  -threadCount X: number of threads used to check index concurrently.\n                  When not specified, this will default to the number of CPU cores.\n                  When '-threadCount 1' is used, index checking will be performed sequentially.\n  -dir-impl X: use a specific " + FSDirectory.class.getSimpleName() + " implementation. If no package is specified the " + FSDirectory.class.getPackage().getName() + " package will be used.\n\n**WARNING**: -exorcise *LOSES DATA*. This should only be used on an emergency basis as it will cause\ndocuments (perhaps many) to be permanently removed from the index.  Always make\na backup copy of your index before running this!  Do not run this tool on an index\nthat is actively being written to.  You have been warned!\n\nRun without -exorcise, this tool will open the index, report version information\nand report any exceptions it hits and what action it would take if -exorcise were\nspecified.  With -exorcise, this tool will remove any segments that have issues and\nwrite a new segments_N file.  This means all documents contained in the affected\nsegments will be removed.\n\nThis tool exits with exit code 1 if the index cannot be opened or has any\ncorruption, else 0.\n");
        }
        if (opts.onlySegments.size() == 0) {
            opts.onlySegments = null;
        } else if (opts.doExorcise) {
            throw new IllegalArgumentException("ERROR: cannot specify both -exorcise and -segment");
        }
        if (opts.doChecksumsOnly && opts.doSlowChecks) {
            throw new IllegalArgumentException("ERROR: cannot specify both -fast and -slow");
        }
        return opts;
    }

    public int doCheck(Options opts) throws IOException, InterruptedException {
        this.setDoSlowChecks(opts.doSlowChecks);
        this.setChecksumsOnly(opts.doChecksumsOnly);
        this.setInfoStream(opts.out, opts.verbose);
        if (opts.threadCount > 0) {
            this.setThreadCount(opts.threadCount);
        }
        Status result = this.checkIndex(opts.onlySegments);
        if (result.missingSegments) {
            return 1;
        }
        if (!result.clean) {
            if (!opts.doExorcise) {
                opts.out.println("WARNING: would write new segments file, and " + result.totLoseDocCount + " documents would be lost, if -exorcise were specified\n");
            } else {
                opts.out.println("WARNING: " + result.totLoseDocCount + " documents will be lost\n");
                opts.out.println("NOTE: will write new segments file in 5 seconds; this will remove " + result.totLoseDocCount + " docs from the index. YOU WILL LOSE DATA. THIS IS YOUR LAST CHANCE TO CTRL+C!");
                for (int s2 = 0; s2 < 5; ++s2) {
                    Thread.sleep(1000L);
                    opts.out.println("  " + (5 - s2) + "...");
                }
                opts.out.println("Writing...");
                this.exorciseIndex(result);
                opts.out.println("OK");
                opts.out.println("Wrote new segments file \"" + result.newSegments.getSegmentsFileName() + "\"");
            }
        }
        opts.out.println("");
        if (result.clean) {
            return 0;
        }
        return 1;
    }

    private static Status.SoftDeletsStatus checkSoftDeletes(String softDeletesField, SegmentCommitInfo info, SegmentReader reader, PrintStream infoStream, boolean failFast) throws IOException {
        Status.SoftDeletsStatus status;
        block5: {
            status = new Status.SoftDeletsStatus();
            if (infoStream != null) {
                infoStream.print("    test: check soft deletes.....");
            }
            try {
                int softDeletes = PendingSoftDeletes.countSoftDeletes(FieldExistsQuery.getDocValuesDocIdSetIterator(softDeletesField, reader), reader.getLiveDocs());
                if (softDeletes != info.getSoftDelCount()) {
                    throw new CheckIndexException("actual soft deletes: " + softDeletes + " but expected: " + info.getSoftDelCount());
                }
            }
            catch (Exception e) {
                if (failFast) {
                    throw IOUtils.rethrowAlways(e);
                }
                CheckIndex.msg(infoStream, "ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (infoStream == null) break block5;
                e.printStackTrace(infoStream);
            }
        }
        return status;
    }

    private static double nsToSec(long ns) {
        return (double)ns / (double)TimeUnit.SECONDS.toNanos(1L);
    }

    public static class CheckIndexException
    extends RuntimeException {
        public CheckIndexException(String message) {
            super(message);
        }

        public CheckIndexException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class Options {
        boolean doExorcise = false;
        boolean doSlowChecks = false;
        boolean verbose = false;
        boolean doChecksumsOnly = false;
        int threadCount;
        List<String> onlySegments = new ArrayList<String>();
        String indexPath = null;
        String dirImpl = null;
        PrintStream out = null;

        public String getDirImpl() {
            return this.dirImpl;
        }

        public String getIndexPath() {
            return this.indexPath;
        }

        public void setOut(PrintStream out) {
            this.out = out;
        }
    }

    @FunctionalInterface
    private static interface DocValuesIteratorSupplier {
        public DocValuesIterator get(FieldInfo var1) throws IOException;
    }

    private static class ConstantRelationIntersectVisitor
    implements PointValues.IntersectVisitor {
        private final PointValues.Relation relation;

        ConstantRelationIntersectVisitor(PointValues.Relation relation) {
            this.relation = relation;
        }

        @Override
        public void visit(int docID) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visit(int docID, byte[] packedValue) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            return this.relation;
        }
    }

    public static class VerifyPointsVisitor
    implements PointValues.IntersectVisitor {
        private long pointCountSeen;
        private int lastDocID = -1;
        private final FixedBitSet docsSeen;
        private final byte[] lastMinPackedValue;
        private final byte[] lastMaxPackedValue;
        private final byte[] lastPackedValue;
        private final byte[] globalMinPackedValue;
        private final byte[] globalMaxPackedValue;
        private final int packedBytesCount;
        private final int packedIndexBytesCount;
        private final int numDataDims;
        private final int numIndexDims;
        private final int bytesPerDim;
        private final ArrayUtil.ByteArrayComparator comparator;
        private final String fieldName;

        public VerifyPointsVisitor(String fieldName, int maxDoc, PointValues values2) throws IOException {
            this.fieldName = fieldName;
            this.numDataDims = values2.getNumDimensions();
            this.numIndexDims = values2.getNumIndexDimensions();
            this.bytesPerDim = values2.getBytesPerDimension();
            this.comparator = ArrayUtil.getUnsignedComparator(this.bytesPerDim);
            this.packedBytesCount = this.numDataDims * this.bytesPerDim;
            this.packedIndexBytesCount = this.numIndexDims * this.bytesPerDim;
            this.globalMinPackedValue = values2.getMinPackedValue();
            this.globalMaxPackedValue = values2.getMaxPackedValue();
            this.docsSeen = new FixedBitSet(maxDoc);
            this.lastMinPackedValue = new byte[this.packedIndexBytesCount];
            this.lastMaxPackedValue = new byte[this.packedIndexBytesCount];
            this.lastPackedValue = new byte[this.packedBytesCount];
            if ((long)values2.getDocCount() > values2.size()) {
                throw new CheckIndexException("point values for field \"" + fieldName + "\" claims to have size=" + values2.size() + " points and inconsistent docCount=" + values2.getDocCount());
            }
            if (values2.getDocCount() > maxDoc) {
                throw new CheckIndexException("point values for field \"" + fieldName + "\" claims to have docCount=" + values2.getDocCount() + " but that's greater than maxDoc=" + maxDoc);
            }
            if (this.globalMinPackedValue == null) {
                if (values2.size() != 0L) {
                    throw new CheckIndexException("getMinPackedValue is null points for field \"" + fieldName + "\" yet size=" + values2.size());
                }
            } else if (this.globalMinPackedValue.length != this.packedIndexBytesCount) {
                throw new CheckIndexException("getMinPackedValue for field \"" + fieldName + "\" return length=" + this.globalMinPackedValue.length + " array, but should be " + this.packedBytesCount);
            }
            if (this.globalMaxPackedValue == null) {
                if (values2.size() != 0L) {
                    throw new CheckIndexException("getMaxPackedValue is null points for field \"" + fieldName + "\" yet size=" + values2.size());
                }
            } else if (this.globalMaxPackedValue.length != this.packedIndexBytesCount) {
                throw new CheckIndexException("getMaxPackedValue for field \"" + fieldName + "\" return length=" + this.globalMaxPackedValue.length + " array, but should be " + this.packedBytesCount);
            }
        }

        public long getPointCountSeen() {
            return this.pointCountSeen;
        }

        public long getDocCountSeen() {
            return this.docsSeen.cardinality();
        }

        @Override
        public void visit(int docID) {
            throw new CheckIndexException("codec called IntersectVisitor.visit without a packed value for docID=" + docID);
        }

        @Override
        public void visit(int docID, byte[] packedValue) {
            this.checkPackedValue("packed value", packedValue, docID);
            ++this.pointCountSeen;
            this.docsSeen.set(docID);
            for (int dim = 0; dim < this.numIndexDims; ++dim) {
                int offset = this.bytesPerDim * dim;
                if (this.comparator.compare(packedValue, offset, this.lastMinPackedValue, offset) < 0) {
                    throw new CheckIndexException("packed points value " + Arrays.toString(packedValue) + " for field=\"" + this.fieldName + "\", docID=" + docID + " is out-of-bounds of the last cell min=" + Arrays.toString(this.lastMinPackedValue) + " max=" + Arrays.toString(this.lastMaxPackedValue) + " dim=" + dim);
                }
                if (this.comparator.compare(packedValue, offset, this.lastMaxPackedValue, offset) <= 0) continue;
                throw new CheckIndexException("packed points value " + Arrays.toString(packedValue) + " for field=\"" + this.fieldName + "\", docID=" + docID + " is out-of-bounds of the last cell min=" + Arrays.toString(this.lastMinPackedValue) + " max=" + Arrays.toString(this.lastMaxPackedValue) + " dim=" + dim);
            }
            if (this.numDataDims == 1) {
                int cmp = this.comparator.compare(this.lastPackedValue, 0, packedValue, 0);
                if (cmp > 0) {
                    throw new CheckIndexException("packed points value " + Arrays.toString(packedValue) + " for field=\"" + this.fieldName + "\", for docID=" + docID + " is out-of-order vs the previous document's value " + Arrays.toString(this.lastPackedValue));
                }
                if (cmp == 0 && docID < this.lastDocID) {
                    throw new CheckIndexException("packed points value is the same, but docID=" + docID + " is out of order vs previous docID=" + this.lastDocID + ", field=\"" + this.fieldName + "\"");
                }
                System.arraycopy(packedValue, 0, this.lastPackedValue, 0, this.bytesPerDim);
                this.lastDocID = docID;
            }
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            this.checkPackedValue("min packed value", minPackedValue, -1);
            System.arraycopy(minPackedValue, 0, this.lastMinPackedValue, 0, this.packedIndexBytesCount);
            this.checkPackedValue("max packed value", maxPackedValue, -1);
            System.arraycopy(maxPackedValue, 0, this.lastMaxPackedValue, 0, this.packedIndexBytesCount);
            for (int dim = 0; dim < this.numIndexDims; ++dim) {
                int offset = this.bytesPerDim * dim;
                if (this.comparator.compare(minPackedValue, offset, maxPackedValue, offset) > 0) {
                    throw new CheckIndexException("packed points cell minPackedValue " + Arrays.toString(minPackedValue) + " is out-of-bounds of the cell's maxPackedValue " + Arrays.toString(maxPackedValue) + " dim=" + dim + " field=\"" + this.fieldName + "\"");
                }
                if (this.comparator.compare(minPackedValue, offset, this.globalMinPackedValue, offset) < 0) {
                    throw new CheckIndexException("packed points cell minPackedValue " + Arrays.toString(minPackedValue) + " is out-of-bounds of the global minimum " + Arrays.toString(this.globalMinPackedValue) + " dim=" + dim + " field=\"" + this.fieldName + "\"");
                }
                if (this.comparator.compare(maxPackedValue, offset, this.globalMinPackedValue, offset) < 0) {
                    throw new CheckIndexException("packed points cell maxPackedValue " + Arrays.toString(maxPackedValue) + " is out-of-bounds of the global minimum " + Arrays.toString(this.globalMinPackedValue) + " dim=" + dim + " field=\"" + this.fieldName + "\"");
                }
                if (this.comparator.compare(minPackedValue, offset, this.globalMaxPackedValue, offset) > 0) {
                    throw new CheckIndexException("packed points cell minPackedValue " + Arrays.toString(minPackedValue) + " is out-of-bounds of the global maximum " + Arrays.toString(this.globalMaxPackedValue) + " dim=" + dim + " field=\"" + this.fieldName + "\"");
                }
                if (this.comparator.compare(maxPackedValue, offset, this.globalMaxPackedValue, offset) <= 0) continue;
                throw new CheckIndexException("packed points cell maxPackedValue " + Arrays.toString(maxPackedValue) + " is out-of-bounds of the global maximum " + Arrays.toString(this.globalMaxPackedValue) + " dim=" + dim + " field=\"" + this.fieldName + "\"");
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        private void checkPackedValue(String desc, byte[] packedValue, int docID) {
            if (packedValue == null) {
                throw new CheckIndexException(desc + " is null for docID=" + docID + " field=\"" + this.fieldName + "\"");
            }
            if (packedValue.length != (docID < 0 ? this.packedIndexBytesCount : this.packedBytesCount)) {
                throw new CheckIndexException(desc + " has incorrect length=" + packedValue.length + " vs expected=" + this.packedIndexBytesCount + " for docID=" + docID + " field=\"" + this.fieldName + "\"");
            }
        }
    }

    public static class Status {
        public boolean clean;
        public boolean missingSegments;
        public String segmentsFileName;
        public int numSegments;
        public List<String> segmentsChecked = new ArrayList<String>();
        public boolean toolOutOfDate;
        public List<SegmentInfoStatus> segmentInfos = new ArrayList<SegmentInfoStatus>();
        public Directory dir;
        SegmentInfos newSegments;
        public int totLoseDocCount;
        public int numBadSegments;
        public boolean partial;
        public long maxSegmentName;
        public boolean validCounter;
        public Map<String, String> userData;

        Status() {
        }

        public static final class SoftDeletsStatus {
            public Throwable error;

            SoftDeletsStatus() {
            }
        }

        public static final class IndexSortStatus {
            public Throwable error;

            IndexSortStatus() {
            }
        }

        public static final class VectorValuesStatus {
            public long totalVectorValues;
            public int totalKnnVectorFields;
            public Throwable error;

            VectorValuesStatus() {
            }
        }

        public static final class PointsStatus {
            public long totalValuePoints;
            public int totalValueFields;
            public Throwable error;

            PointsStatus() {
            }
        }

        public static final class DocValuesStatus {
            public long totalValueFields;
            public long totalNumericFields;
            public long totalBinaryFields;
            public long totalSortedFields;
            public long totalSortedNumericFields;
            public long totalSortedSetFields;
            public Throwable error;

            DocValuesStatus() {
            }
        }

        public static final class TermVectorStatus {
            public int docCount = 0;
            public long totVectors = 0L;
            public Throwable error;

            TermVectorStatus() {
            }
        }

        public static final class StoredFieldStatus {
            public int docCount = 0;
            public long totFields = 0L;
            public Throwable error;

            StoredFieldStatus() {
            }
        }

        public static final class TermIndexStatus {
            public long termCount = 0L;
            public long delTermCount = 0L;
            public long totFreq = 0L;
            public long totPos = 0L;
            public Throwable error;
            public Map<String, Object> blockTreeStats = null;

            TermIndexStatus() {
            }
        }

        public static final class FieldNormStatus {
            public long totFields = 0L;
            public Throwable error;

            private FieldNormStatus() {
            }
        }

        public static final class FieldInfoStatus {
            public long totFields = 0L;
            public Throwable error;

            private FieldInfoStatus() {
            }
        }

        public static final class LiveDocStatus {
            public int numDeleted;
            public Throwable error;

            private LiveDocStatus() {
            }
        }

        public static class SegmentInfoStatus {
            public String name;
            public Codec codec;
            public int maxDoc;
            public boolean compound;
            public int numFiles;
            public double sizeMB;
            public boolean hasDeletions;
            public long deletionsGen;
            public boolean openReaderPassed;
            public int toLoseDocCount;
            public Map<String, String> diagnostics;
            public LiveDocStatus liveDocStatus;
            public FieldInfoStatus fieldInfoStatus;
            public FieldNormStatus fieldNormStatus;
            public TermIndexStatus termIndexStatus;
            public StoredFieldStatus storedFieldStatus;
            public TermVectorStatus termVectorStatus;
            public DocValuesStatus docValuesStatus;
            public PointsStatus pointsStatus;
            public IndexSortStatus indexSortStatus;
            public VectorValuesStatus vectorValuesStatus;
            public SoftDeletsStatus softDeletesStatus;
            public Throwable error;

            SegmentInfoStatus() {
            }
        }
    }
}

