/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions.js;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DiagnosticErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.js.JavascriptBaseVisitor;
import org.apache.lucene.expressions.js.JavascriptErrorHandlingLexer;
import org.apache.lucene.expressions.js.JavascriptParser;
import org.apache.lucene.expressions.js.JavascriptParserErrorStrategy;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.util.IOUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class JavascriptCompiler {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final int CLASSFILE_VERSION = 65;
    private static final MethodType MT_EXPRESSION_CTOR_LOOKUP = MethodType.methodType(Void.TYPE, String.class, String[].class);
    private static final String COMPILED_EXPRESSION_CLASS = JavascriptCompiler.class.getName() + "$CompiledExpression";
    private static final String COMPILED_EXPRESSION_INTERNAL = COMPILED_EXPRESSION_CLASS.replace('.', '/');
    private static final Type EXPRESSION_TYPE = Type.getType(Expression.class);
    private static final Type FUNCTION_VALUES_TYPE = Type.getType(DoubleValues.class);
    private static final Type METHOD_HANDLE_TYPE = Type.getType(MethodHandle.class);
    private static final Type JAVASCRIPT_COMPILER_TYPE = Type.getType(JavascriptCompiler.class);
    private static final Type THROWABLE_TYPE = Type.getType(Throwable.class);
    private static final Method EXPRESSION_CTOR = JavascriptCompiler.getAsmMethod(Void.TYPE, "<init>", String.class, String[].class);
    private static final Method EVALUATE_METHOD = JavascriptCompiler.getAsmMethod(Double.TYPE, "evaluate", DoubleValues[].class);
    private static final Method DOUBLE_VAL_METHOD = JavascriptCompiler.getAsmMethod(Double.TYPE, "doubleValue", new Class[0]);
    private static final Method PATCH_STACK_METHOD = JavascriptCompiler.getAsmMethod(Throwable.class, "patchStackTrace", Throwable.class, Expression.class);
    private static final Type[] EVALUATE_EXCEPTIONS = new Type[]{Type.getType(IOException.class)};
    private static final Handle DYNAMIC_CONSTANT_BOOTSTRAP_HANDLE = new Handle(6, JAVASCRIPT_COMPILER_TYPE.getInternalName(), "dynamicConstantBootstrap", MethodType.methodType(MethodHandle.class, MethodHandles.Lookup.class, String.class, Class.class, String.class).toMethodDescriptorString(), false);
    final String sourceText;
    final Map<String, MethodHandle> functions;
    final boolean picky;
    public static final Map<String, MethodHandle> DEFAULT_FUNCTIONS = JavascriptCompiler.loadDefaultFunctions();

    private static Method getAsmMethod(Class<?> rtype, String name, Class<?> ... ptypes) {
        return new Method(name, MethodType.methodType(rtype, ptypes).toMethodDescriptorString());
    }

    public static Expression compile(String sourceText) throws ParseException {
        return JavascriptCompiler.compile(sourceText, DEFAULT_FUNCTIONS);
    }

    public static Expression compile(String sourceText, Map<String, MethodHandle> functions) throws ParseException {
        return JavascriptCompiler.compile(sourceText, functions, false);
    }

    @Deprecated
    public static Map<String, MethodHandle> convertLegacyFunctions(Map<String, java.lang.reflect.Method> functions) throws IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        HashMap<String, MethodHandle> newMap = new HashMap<String, MethodHandle>();
        for (Map.Entry<String, java.lang.reflect.Method> e : functions.entrySet()) {
            newMap.put(e.getKey(), lookup.unreflect(e.getValue()));
        }
        return newMap;
    }

    static Expression compile(String sourceText, Map<String, MethodHandle> functions, boolean picky) throws ParseException {
        for (MethodHandle m : functions.values()) {
            JavascriptCompiler.checkFunction(m);
        }
        return new JavascriptCompiler(sourceText, functions, picky).compileExpression();
    }

    private JavascriptCompiler(String sourceText, Map<String, MethodHandle> functions, boolean picky) {
        this.sourceText = Objects.requireNonNull(sourceText, "sourceText");
        this.functions = Map.copyOf(functions);
        this.picky = picky;
    }

    private Expression compileExpression() throws ParseException {
        LinkedHashMap<String, Integer> externalsMap = new LinkedHashMap<String, Integer>();
        ClassWriter classWriter = new ClassWriter(3);
        try {
            this.generateClass(this.getAntlrParseTree(), classWriter, externalsMap);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ParseException) {
                throw (ParseException)re.getCause();
            }
            throw re;
        }
        try {
            MethodHandles.Lookup lookup = LOOKUP.defineHiddenClassWithClassData(classWriter.toByteArray(), this.functions, true, new MethodHandles.Lookup.ClassOption[0]);
            return this.invokeConstructor(lookup, lookup.lookupClass(), externalsMap);
        }
        catch (ReflectiveOperationException exception) {
            throw new IllegalStateException("An internal error occurred attempting to compile the expression (" + this.sourceText + ").", exception);
        }
    }

    private Expression invokeConstructor(MethodHandles.Lookup lookup, Class<?> expressionClass, Map<String, Integer> externalsMap) throws ReflectiveOperationException {
        MethodHandle ctor = lookup.findConstructor(expressionClass, MT_EXPRESSION_CTOR_LOOKUP);
        try {
            return ctor.invoke(this.sourceText, (String[])externalsMap.keySet().toArray(String[]::new));
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    private ParseTree getAntlrParseTree() throws ParseException {
        ANTLRInputStream antlrInputStream = new ANTLRInputStream(this.sourceText);
        JavascriptErrorHandlingLexer javascriptLexer = new JavascriptErrorHandlingLexer((CharStream)antlrInputStream);
        javascriptLexer.removeErrorListeners();
        JavascriptParser javascriptParser = new JavascriptParser((TokenStream)new CommonTokenStream((TokenSource)javascriptLexer));
        javascriptParser.removeErrorListeners();
        if (this.picky) {
            this.setupPicky(javascriptParser);
        }
        javascriptParser.setErrorHandler((ANTLRErrorStrategy)new JavascriptParserErrorStrategy());
        return javascriptParser.compile();
    }

    private void setupPicky(JavascriptParser parser) {
        parser.addErrorListener((ANTLRErrorListener)new DiagnosticErrorListener(true));
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(this){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new RuntimeException(new ParseException("line (" + line + "), offset (" + charPositionInLine + "), symbol (" + String.valueOf(offendingSymbol) + ") " + msg, charPositionInLine));
            }
        });
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL_EXACT_AMBIG_DETECTION);
    }

    private void generateClass(ParseTree parseTree, ClassWriter classWriter, final Map<String, Integer> externalsMap) throws ParseException {
        classWriter.visit(65, 49, COMPILED_EXPRESSION_INTERNAL, null, EXPRESSION_TYPE.getInternalName(), null);
        GeneratorAdapter constructor = new GeneratorAdapter(1, EXPRESSION_CTOR, null, null, (ClassVisitor)classWriter);
        constructor.loadThis();
        constructor.loadArgs();
        constructor.invokeConstructor(EXPRESSION_TYPE, EXPRESSION_CTOR);
        constructor.returnValue();
        constructor.endMethod();
        final GeneratorAdapter gen = new GeneratorAdapter(1, EVALUATE_METHOD, null, EVALUATE_EXCEPTIONS, (ClassVisitor)classWriter);
        Label beginTry = gen.newLabel();
        Label endTry = gen.newLabel();
        Label catchHandler = gen.newLabel();
        gen.visitTryCatchBlock(beginTry, endTry, catchHandler, THROWABLE_TYPE.getInternalName());
        gen.mark(beginTry);
        new JavascriptBaseVisitor<Void>(){
            private final Deque<Type> typeStack = new ArrayDeque<Type>();
            private final Map<String, Integer> constantsMap = new HashMap<String, Integer>();

            @Override
            public Void visitCompile(JavascriptParser.CompileContext ctx) {
                this.typeStack.push(Type.DOUBLE_TYPE);
                this.visit((ParseTree)ctx.expression());
                this.typeStack.pop();
                return null;
            }

            @Override
            public Void visitPrecedence(JavascriptParser.PrecedenceContext ctx) {
                this.visit((ParseTree)ctx.expression());
                return null;
            }

            @Override
            public Void visitNumeric(JavascriptParser.NumericContext ctx) {
                if (ctx.HEX() != null) {
                    this.pushLong(Long.parseLong(ctx.HEX().getText().substring(2), 16));
                } else if (ctx.OCTAL() != null) {
                    this.pushLong(Long.parseLong(ctx.OCTAL().getText().substring(1), 8));
                } else if (ctx.DECIMAL() != null) {
                    gen.push(Double.parseDouble(ctx.DECIMAL().getText()));
                    gen.cast(Type.DOUBLE_TYPE, this.typeStack.peek());
                } else {
                    throw new IllegalStateException("Unknown operation specified: " + ctx.getText());
                }
                return null;
            }

            @Override
            public Void visitExternal(JavascriptParser.ExternalContext ctx) {
                String text = ctx.VARIABLE().getText();
                int arguments = ctx.expression().size();
                boolean parens = ctx.LP() != null && ctx.RP() != null;
                MethodHandle mh = parens ? JavascriptCompiler.this.functions.get(text) : null;
                try {
                    if (mh != null) {
                        int arity = mh.type().parameterCount();
                        if (arguments != arity) {
                            throw new ParseException("Invalid expression '" + JavascriptCompiler.this.sourceText + "': Expected (" + arity + ") arguments for function call (" + text + "), but found (" + arguments + ").", ctx.start.getStartIndex());
                        }
                        gen.visitLdcInsn((Object)new ConstantDynamic("func" + String.valueOf(this.constantsMap.computeIfAbsent(text, k -> this.constantsMap.size())), METHOD_HANDLE_TYPE.getDescriptor(), DYNAMIC_CONSTANT_BOOTSTRAP_HANDLE, new Object[]{text}));
                        this.typeStack.push(Type.DOUBLE_TYPE);
                        for (int argument = 0; argument < arguments; ++argument) {
                            this.visit((ParseTree)ctx.expression(argument));
                        }
                        this.typeStack.pop();
                        gen.visitMethodInsn(182, METHOD_HANDLE_TYPE.getInternalName(), "invokeExact", mh.type().descriptorString(), false);
                        gen.cast(Type.DOUBLE_TYPE, this.typeStack.peek());
                    } else if (!parens || arguments == 0 && text.contains(".")) {
                        text = JavascriptCompiler.normalizeQuotes(ctx.getText());
                        int index = externalsMap.computeIfAbsent(text, k -> externalsMap.size());
                        gen.loadArg(0);
                        gen.push(index);
                        gen.arrayLoad(FUNCTION_VALUES_TYPE);
                        gen.invokeVirtual(FUNCTION_VALUES_TYPE, DOUBLE_VAL_METHOD);
                        gen.cast(Type.DOUBLE_TYPE, this.typeStack.peek());
                    } else {
                        throw new ParseException("Invalid expression '" + JavascriptCompiler.this.sourceText + "': Unrecognized function call (" + text + ").", ctx.start.getStartIndex());
                    }
                    return null;
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Void visitUnary(JavascriptParser.UnaryContext ctx) {
                if (ctx.BOOLNOT() != null) {
                    Label labelNotTrue = new Label();
                    Label labelNotReturn = new Label();
                    this.typeStack.push(Type.INT_TYPE);
                    this.visit((ParseTree)ctx.expression());
                    this.typeStack.pop();
                    gen.visitJumpInsn(153, labelNotTrue);
                    this.pushBoolean(false);
                    gen.goTo(labelNotReturn);
                    gen.visitLabel(labelNotTrue);
                    this.pushBoolean(true);
                    gen.visitLabel(labelNotReturn);
                } else if (ctx.BWNOT() != null) {
                    this.typeStack.push(Type.LONG_TYPE);
                    this.visit((ParseTree)ctx.expression());
                    this.typeStack.pop();
                    gen.push(-1L);
                    gen.visitInsn(131);
                    gen.cast(Type.LONG_TYPE, this.typeStack.peek());
                } else if (ctx.ADD() != null) {
                    this.visit((ParseTree)ctx.expression());
                } else if (ctx.SUB() != null) {
                    this.typeStack.push(Type.DOUBLE_TYPE);
                    this.visit((ParseTree)ctx.expression());
                    this.typeStack.pop();
                    gen.visitInsn(119);
                    gen.cast(Type.DOUBLE_TYPE, this.typeStack.peek());
                } else {
                    throw new IllegalStateException("Unknown operation specified: " + ctx.getText());
                }
                return null;
            }

            @Override
            public Void visitMuldiv(JavascriptParser.MuldivContext ctx) {
                int opcode;
                if (ctx.MUL() != null) {
                    opcode = 107;
                } else if (ctx.DIV() != null) {
                    opcode = 111;
                } else if (ctx.REM() != null) {
                    opcode = 115;
                } else {
                    throw new IllegalStateException("Unknown operation specified: " + ctx.getText());
                }
                this.pushArith(opcode, ctx.expression(0), ctx.expression(1));
                return null;
            }

            @Override
            public Void visitAddsub(JavascriptParser.AddsubContext ctx) {
                int opcode;
                if (ctx.ADD() != null) {
                    opcode = 99;
                } else if (ctx.SUB() != null) {
                    opcode = 103;
                } else {
                    throw new IllegalStateException("Unknown operation specified: " + ctx.getText());
                }
                this.pushArith(opcode, ctx.expression(0), ctx.expression(1));
                return null;
            }

            @Override
            public Void visitBwshift(JavascriptParser.BwshiftContext ctx) {
                int opcode;
                if (ctx.LSH() != null) {
                    opcode = 121;
                } else if (ctx.RSH() != null) {
                    opcode = 123;
                } else if (ctx.USH() != null) {
                    opcode = 125;
                } else {
                    throw new IllegalStateException("Unknown operation specified: " + ctx.getText());
                }
                this.pushShift(opcode, ctx.expression(0), ctx.expression(1));
                return null;
            }

            @Override
            public Void visitBoolcomp(JavascriptParser.BoolcompContext ctx) {
                int opcode;
                if (ctx.LT() != null) {
                    opcode = 155;
                } else if (ctx.LTE() != null) {
                    opcode = 158;
                } else if (ctx.GT() != null) {
                    opcode = 157;
                } else if (ctx.GTE() != null) {
                    opcode = 156;
                } else {
                    throw new IllegalStateException("Unknown operation specified: " + ctx.getText());
                }
                this.pushCond(opcode, ctx.expression(0), ctx.expression(1));
                return null;
            }

            @Override
            public Void visitBooleqne(JavascriptParser.BooleqneContext ctx) {
                int opcode;
                if (ctx.EQ() != null) {
                    opcode = 153;
                } else if (ctx.NE() != null) {
                    opcode = 154;
                } else {
                    throw new IllegalStateException("Unknown operation specified: " + ctx.getText());
                }
                this.pushCond(opcode, ctx.expression(0), ctx.expression(1));
                return null;
            }

            @Override
            public Void visitBwand(JavascriptParser.BwandContext ctx) {
                this.pushBitwise(127, ctx.expression(0), ctx.expression(1));
                return null;
            }

            @Override
            public Void visitBwxor(JavascriptParser.BwxorContext ctx) {
                this.pushBitwise(131, ctx.expression(0), ctx.expression(1));
                return null;
            }

            @Override
            public Void visitBwor(JavascriptParser.BworContext ctx) {
                this.pushBitwise(129, ctx.expression(0), ctx.expression(1));
                return null;
            }

            @Override
            public Void visitBooland(JavascriptParser.BoolandContext ctx) {
                Label andFalse = new Label();
                Label andEnd = new Label();
                this.typeStack.push(Type.INT_TYPE);
                this.visit((ParseTree)ctx.expression(0));
                gen.visitJumpInsn(153, andFalse);
                this.visit((ParseTree)ctx.expression(1));
                gen.visitJumpInsn(153, andFalse);
                this.typeStack.pop();
                this.pushBoolean(true);
                gen.goTo(andEnd);
                gen.visitLabel(andFalse);
                this.pushBoolean(false);
                gen.visitLabel(andEnd);
                return null;
            }

            @Override
            public Void visitBoolor(JavascriptParser.BoolorContext ctx) {
                Label orTrue = new Label();
                Label orEnd = new Label();
                this.typeStack.push(Type.INT_TYPE);
                this.visit((ParseTree)ctx.expression(0));
                gen.visitJumpInsn(154, orTrue);
                this.visit((ParseTree)ctx.expression(1));
                gen.visitJumpInsn(154, orTrue);
                this.typeStack.pop();
                this.pushBoolean(false);
                gen.goTo(orEnd);
                gen.visitLabel(orTrue);
                this.pushBoolean(true);
                gen.visitLabel(orEnd);
                return null;
            }

            @Override
            public Void visitConditional(JavascriptParser.ConditionalContext ctx) {
                Label condFalse = new Label();
                Label condEnd = new Label();
                this.typeStack.push(Type.INT_TYPE);
                this.visit((ParseTree)ctx.expression(0));
                this.typeStack.pop();
                gen.visitJumpInsn(153, condFalse);
                this.visit((ParseTree)ctx.expression(1));
                gen.goTo(condEnd);
                gen.visitLabel(condFalse);
                this.visit((ParseTree)ctx.expression(2));
                gen.visitLabel(condEnd);
                return null;
            }

            private void pushArith(int operator, JavascriptParser.ExpressionContext left, JavascriptParser.ExpressionContext right) {
                this.pushBinaryOp(operator, left, right, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE);
            }

            private void pushShift(int operator, JavascriptParser.ExpressionContext left, JavascriptParser.ExpressionContext right) {
                this.pushBinaryOp(operator, left, right, Type.LONG_TYPE, Type.INT_TYPE, Type.LONG_TYPE);
            }

            private void pushBitwise(int operator, JavascriptParser.ExpressionContext left, JavascriptParser.ExpressionContext right) {
                this.pushBinaryOp(operator, left, right, Type.LONG_TYPE, Type.LONG_TYPE, Type.LONG_TYPE);
            }

            private void pushBinaryOp(int operator, JavascriptParser.ExpressionContext left, JavascriptParser.ExpressionContext right, Type leftType, Type rightType, Type returnType) {
                this.typeStack.push(leftType);
                this.visit((ParseTree)left);
                this.typeStack.pop();
                this.typeStack.push(rightType);
                this.visit((ParseTree)right);
                this.typeStack.pop();
                gen.visitInsn(operator);
                gen.cast(returnType, this.typeStack.peek());
            }

            private void pushCond(int operator, JavascriptParser.ExpressionContext left, JavascriptParser.ExpressionContext right) {
                Label labelTrue = new Label();
                Label labelReturn = new Label();
                this.typeStack.push(Type.DOUBLE_TYPE);
                this.visit((ParseTree)left);
                this.visit((ParseTree)right);
                this.typeStack.pop();
                gen.ifCmp(Type.DOUBLE_TYPE, operator, labelTrue);
                this.pushBoolean(false);
                gen.goTo(labelReturn);
                gen.visitLabel(labelTrue);
                this.pushBoolean(true);
                gen.visitLabel(labelReturn);
            }

            private void pushBoolean(boolean truth) {
                switch (this.typeStack.peek().getSort()) {
                    case 5: {
                        gen.push(truth);
                        break;
                    }
                    case 7: {
                        gen.push(truth ? 1L : 0L);
                        break;
                    }
                    case 8: {
                        gen.push(truth ? 1.0 : 0.0);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid expected type: " + String.valueOf(this.typeStack.peek()));
                    }
                }
            }

            private void pushLong(long i) {
                switch (this.typeStack.peek().getSort()) {
                    case 5: {
                        gen.push((int)i);
                        break;
                    }
                    case 7: {
                        gen.push(i);
                        break;
                    }
                    case 8: {
                        gen.push((double)i);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid expected type: " + String.valueOf(this.typeStack.peek()));
                    }
                }
            }
        }.visit(parseTree);
        gen.mark(endTry);
        gen.returnValue();
        gen.mark(catchHandler);
        gen.loadThis();
        gen.invokeStatic(JAVASCRIPT_COMPILER_TYPE, PATCH_STACK_METHOD);
        gen.throwException();
        gen.endMethod();
        classWriter.visitEnd();
    }

    static String normalizeQuotes(String text) {
        StringBuilder out = new StringBuilder(text.length());
        boolean inDoubleQuotes = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                if ((c = text.charAt(++i)) == '\\') {
                    out.append('\\');
                }
            } else if (c == '\'') {
                if (inDoubleQuotes) {
                    out.append('\\');
                } else {
                    int j = JavascriptCompiler.findSingleQuoteStringEnd(text, i);
                    out.append(text, i, j);
                    i = j;
                }
            } else if (c == '\"') {
                c = '\'';
                inDoubleQuotes = !inDoubleQuotes;
            }
            out.append(c);
        }
        return out.toString();
    }

    static int findSingleQuoteStringEnd(String text, int start) {
        ++start;
        while (text.charAt(start) != '\'') {
            if (text.charAt(start) == '\\') {
                ++start;
            }
            ++start;
        }
        return start;
    }

    private static Map<String, MethodHandle> loadDefaultFunctions() {
        HashMap<String, MethodHandle> map = new HashMap<String, MethodHandle>();
        MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
        try {
            Properties props = new Properties();
            String name = JavascriptCompiler.class.getSimpleName() + ".properties";
            try (Reader in = IOUtils.getDecodingReader((InputStream)((InputStream)IOUtils.requireResourceNonNull((Object)JavascriptCompiler.class.getResourceAsStream(name), (String)name)), (Charset)StandardCharsets.UTF_8);){
                props.load(in);
            }
            for (String call : props.stringPropertyNames()) {
                String[] vals = props.getProperty(call).split(",");
                if (vals.length != 3) {
                    throw new Error("Syntax error while reading Javascript functions from resource");
                }
                Class<?> clazz = Class.forName(vals[0].trim());
                String methodName = vals[1].trim();
                int arity = Integer.parseInt(vals[2].trim());
                MethodHandle mh = publicLookup.findStatic(clazz, methodName, MethodType.methodType(Double.TYPE, Collections.nCopies(arity, Double.TYPE)));
                JavascriptCompiler.checkFunction(mh);
                map.put(call, mh);
            }
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new Error("Cannot resolve function", e);
        }
        return Collections.unmodifiableMap(map);
    }

    private static void checkFunction(MethodHandle method) {
        int refKind;
        Supplier<String> methodNameSupplier = method::toString;
        try {
            MethodHandleInfo cracked = LOOKUP.revealDirect(method);
            refKind = cracked.getReferenceKind();
            methodNameSupplier = () -> cracked.getDeclaringClass().getName() + "#" + cracked.getName() + String.valueOf(cracked.getMethodType());
        }
        catch (IllegalArgumentException | SecurityException iae) {
            refKind = 6;
        }
        if (refKind != 6 && refKind != 2) {
            throw new IllegalArgumentException(methodNameSupplier.get() + " is not static.");
        }
        MethodType type = method.type();
        int arity = type.parameterCount();
        for (int arg = 0; arg < arity; ++arg) {
            if (type.parameterType(arg) == Double.TYPE) continue;
            throw new IllegalArgumentException(methodNameSupplier.get() + " must take only double parameters.");
        }
        if (type.returnType() != Double.TYPE) {
            throw new IllegalArgumentException(methodNameSupplier.get() + " does not return a double.");
        }
    }

    static MethodHandle dynamicConstantBootstrap(MethodHandles.Lookup lookup, String constantName, Class<?> type, String functionName) throws IllegalAccessException {
        if (type != MethodHandle.class) {
            throw new IllegalArgumentException("Invalid type of constant: " + type.getName());
        }
        Map classData = Objects.requireNonNull(MethodHandles.classData(lookup, "_", Map.class), "Missing class data for " + String.valueOf(lookup));
        return (MethodHandle)Objects.requireNonNull(classData.get(functionName), "Function does not exist: " + functionName);
    }

    static Throwable patchStackTrace(Throwable t, Expression impl) {
        StackTraceElement extra = new StackTraceElement(impl.getClass().getName(), "evaluate", impl.sourceText, -1);
        StackTraceElement[] origStack = t.getStackTrace();
        StackTraceElement[] myStack = new Throwable().getStackTrace();
        Stream<StackTraceElement> top = Arrays.stream(origStack).limit(Math.max(0, origStack.length - myStack.length + 1));
        Stream<StackTraceElement> tail = Arrays.stream(myStack).skip(1L);
        t.setStackTrace((StackTraceElement[])Stream.of(top, Stream.of(extra), tail).flatMap(Function.identity()).toArray(StackTraceElement[]::new));
        return t;
    }
}

