/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.chainedAlertCondition.resolvers;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.opensearch.alerting.chainedAlertCondition.resolvers.ChainedAlertTriggerExpression;
import org.opensearch.alerting.chainedAlertCondition.resolvers.ChainedAlertTriggerResolver;
import org.opensearch.alerting.chainedAlertCondition.tokens.CAExpressionOperator;
import org.opensearch.alerting.chainedAlertCondition.tokens.CAExpressionToken;
import org.opensearch.alerting.chainedAlertCondition.tokens.ChainedAlertExpressionConstant;
import org.opensearch.alerting.chainedAlertCondition.tokens.ExpressionToken;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0012\u001a\u00020\u0000H\u0016J\u001e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002J\b\u0010\u0015\u001a\u00020\bH\u0016R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/opensearch/alerting/chainedAlertCondition/resolvers/ChainedAlertRPNResolver;", "Lorg/opensearch/alerting/chainedAlertCondition/resolvers/ChainedAlertTriggerResolver;", "polishNotation", "Ljava/util/ArrayList;", "Lorg/opensearch/alerting/chainedAlertCondition/tokens/ExpressionToken;", "Lkotlin/collections/ArrayList;", "(Ljava/util/ArrayList;)V", "eqString", "", "getEqString", "()Ljava/lang/String;", "eqString$delegate", "Lkotlin/Lazy;", "evaluate", "", "alertGeneratingMonitors", "", "getMonitorIds", "parsedTriggerCondition", "resolveMonitorExpression", "monitorExpString", "toString", "opensearch-alerting"})
public final class ChainedAlertRPNResolver
implements ChainedAlertTriggerResolver {
    @NotNull
    private final ArrayList<ExpressionToken> polishNotation;
    @NotNull
    private final Lazy eqString$delegate;

    public ChainedAlertRPNResolver(@NotNull ArrayList<ExpressionToken> polishNotation) {
        Intrinsics.checkNotNullParameter(polishNotation, (String)"polishNotation");
        this.polishNotation = polishNotation;
        this.eqString$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ ChainedAlertRPNResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                StringBuilder stringBuilder = new StringBuilder();
                for (ExpressionToken expToken : ChainedAlertRPNResolver.access$getPolishNotation$p(this.this$0)) {
                    ExpressionToken expressionToken = expToken;
                    if (expressionToken instanceof CAExpressionToken) {
                        stringBuilder.append(((CAExpressionToken)expToken).getValue());
                    } else if (expressionToken instanceof CAExpressionOperator) {
                        stringBuilder.append(((CAExpressionOperator)expToken).getValue());
                    } else if (expressionToken instanceof ChainedAlertExpressionConstant) {
                        stringBuilder.append(((ChainedAlertExpressionConstant)expToken).getType().getIdent());
                    } else {
                        throw new Exception();
                    }
                    stringBuilder.append(" ");
                }
                return stringBuilder.toString();
            }
        }));
    }

    private final String getEqString() {
        Lazy lazy = this.eqString$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public String toString() {
        String string = this.getEqString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"eqString");
        return string;
    }

    @Override
    public boolean evaluate(@NotNull Set<String> alertGeneratingMonitors) {
        Intrinsics.checkNotNullParameter(alertGeneratingMonitors, (String)"alertGeneratingMonitors");
        Stack<Boolean> tokenStack = new Stack<Boolean>();
        boolean res2 = true;
        for (ExpressionToken expToken : this.polishNotation) {
            ChainedAlertTriggerExpression chainedAlertTriggerExpression;
            ExpressionToken expressionToken = expToken;
            if (expressionToken instanceof CAExpressionToken) {
                tokenStack.push(this.resolveMonitorExpression(((CAExpressionToken)expToken).getValue(), alertGeneratingMonitors));
                continue;
            }
            if (!(expressionToken instanceof CAExpressionOperator)) continue;
            Boolean right = (Boolean)tokenStack.pop();
            Intrinsics.checkNotNullExpressionValue((Object)expToken, (String)"expToken");
            switch (WhenMappings.$EnumSwitchMapping$0[((CAExpressionOperator)expToken).ordinal()]) {
                case 1: {
                    Object e = tokenStack.pop();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"tokenStack.pop()");
                    boolean bl = (Boolean)e;
                    Intrinsics.checkNotNullExpressionValue((Object)right, (String)"right");
                    chainedAlertTriggerExpression = new ChainedAlertTriggerExpression.And(bl, right);
                    break;
                }
                case 2: {
                    Object e = tokenStack.pop();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"tokenStack.pop()");
                    boolean bl = (Boolean)e;
                    Intrinsics.checkNotNullExpressionValue((Object)right, (String)"right");
                    chainedAlertTriggerExpression = new ChainedAlertTriggerExpression.Or(bl, right);
                    break;
                }
                case 3: {
                    Intrinsics.checkNotNullExpressionValue((Object)right, (String)"right");
                    chainedAlertTriggerExpression = new ChainedAlertTriggerExpression.Not(res2, right);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No matching operator.");
                }
            }
            ChainedAlertTriggerExpression expr = chainedAlertTriggerExpression;
            tokenStack.push(expr.resolve());
        }
        Object e = tokenStack.pop();
        Intrinsics.checkNotNullExpressionValue(e, (String)"tokenStack.pop()");
        return (Boolean)e;
    }

    @Override
    @NotNull
    public Set<String> getMonitorIds(@NotNull ChainedAlertRPNResolver parsedTriggerCondition) {
        Intrinsics.checkNotNullParameter((Object)parsedTriggerCondition, (String)"parsedTriggerCondition");
        Set monitorIds2 = new LinkedHashSet();
        for (ExpressionToken expToken : this.polishNotation) {
            ExpressionToken expressionToken = expToken;
            if (expressionToken instanceof CAExpressionToken) {
                String[] stringArray;
                List tokens;
                String token;
                String monitorExpString = ((CAExpressionToken)expToken).getValue();
                if (!StringsKt.startsWith$default((String)monitorExpString, (String)ChainedAlertExpressionConstant.ConstantType.MONITOR.getIdent(), (boolean)false, (int)2, null) || ((CharSequence)(token = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)monitorExpString, (String)ChainedAlertExpressionConstant.ConstantType.BRACKET_LEFT.getIdent(), null, (int)2, null), (String)ChainedAlertExpressionConstant.ConstantType.BRACKET_RIGHT.getIdent(), null, (int)2, null))).length() == 0 || (tokens = StringsKt.split$default((CharSequence)token, (String[])(stringArray = new String[]{ChainedAlertExpressionConstant.ConstantType.EQUALS.getIdent()}), (boolean)false, (int)0, (int)6, null)).isEmpty() || tokens.size() != 2) continue;
                String identifier = (String)tokens.get(0);
                String value = (String)tokens.get(1);
                if (!Intrinsics.areEqual((Object)identifier, (Object)ChainedAlertExpressionConstant.ConstantType.ID.getIdent())) continue;
                monitorIds2.add(value);
                continue;
            }
            if (!(expressionToken instanceof CAExpressionOperator)) continue;
        }
        return monitorIds2;
    }

    private final boolean resolveMonitorExpression(String monitorExpString, Set<String> alertGeneratingMonitors) {
        if (!StringsKt.startsWith$default((String)monitorExpString, (String)ChainedAlertExpressionConstant.ConstantType.MONITOR.getIdent(), (boolean)false, (int)2, null)) {
            return false;
        }
        String token = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)monitorExpString, (String)ChainedAlertExpressionConstant.ConstantType.BRACKET_LEFT.getIdent(), null, (int)2, null), (String)ChainedAlertExpressionConstant.ConstantType.BRACKET_RIGHT.getIdent(), null, (int)2, null);
        if (((CharSequence)token).length() == 0) {
            return false;
        }
        String[] stringArray = new String[]{ChainedAlertExpressionConstant.ConstantType.EQUALS.getIdent()};
        List tokens = StringsKt.split$default((CharSequence)token, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (tokens.isEmpty() || tokens.size() != 2) {
            return false;
        }
        String identifier = (String)tokens.get(0);
        String value = (String)tokens.get(1);
        return Intrinsics.areEqual((Object)identifier, (Object)ChainedAlertExpressionConstant.ConstantType.ID.getIdent()) ? alertGeneratingMonitors.contains(value) : false;
    }

    public static final /* synthetic */ ArrayList access$getPolishNotation$p(ChainedAlertRPNResolver $this) {
        return $this.polishNotation;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CAExpressionOperator.values().length];
            try {
                nArray[CAExpressionOperator.AND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CAExpressionOperator.OR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CAExpressionOperator.NOT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

