/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.sampler;

import com.amazon.randomcutforest.config.IDynamicConfig;
import com.amazon.randomcutforest.sampler.ISampled;
import java.util.List;
import java.util.Optional;

public interface IStreamSampler<P>
extends IDynamicConfig {
    default public boolean update(P point, long sequenceIndex) {
        if (this.acceptPoint(sequenceIndex)) {
            this.addPoint(point);
            return true;
        }
        return false;
    }

    public boolean acceptPoint(long var1);

    public void addPoint(P var1);

    public List<ISampled<P>> getSample();

    public Optional<ISampled<P>> getEvictedPoint();

    default public boolean isReady() {
        return this.size() >= this.getCapacity() / 4;
    }

    default public boolean isFull() {
        return this.size() >= this.getCapacity();
    }

    public int getCapacity();

    public int size();

    public void setMaxSequenceIndex(long var1);
}

