
#ifndef WRAPLANDCLIENT_EXPORT_H
#define WRAPLANDCLIENT_EXPORT_H

#ifdef WRAPLANDCLIENT_STATIC_DEFINE
#  define WRAPLANDCLIENT_EXPORT
#  define WRAPLANDCLIENT_NO_EXPORT
#else
#  ifndef WRAPLANDCLIENT_EXPORT
#    ifdef WraplandClient_EXPORTS
        /* We are building this library */
#      define WRAPLANDCLIENT_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define WRAPLANDCLIENT_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef WRAPLANDCLIENT_NO_EXPORT
#    define WRAPLANDCLIENT_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef WRAPLANDCLIENT_DECL_DEPRECATED
#  define WRAPLANDCLIENT_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef WRAPLANDCLIENT_DECL_DEPRECATED_EXPORT
#  define WRAPLANDCLIENT_DECL_DEPRECATED_EXPORT WRAPLANDCLIENT_EXPORT WRAPLANDCLIENT_DECL_DEPRECATED
#endif

#ifndef WRAPLANDCLIENT_DECL_DEPRECATED_NO_EXPORT
#  define WRAPLANDCLIENT_DECL_DEPRECATED_NO_EXPORT WRAPLANDCLIENT_NO_EXPORT WRAPLANDCLIENT_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef WRAPLANDCLIENT_NO_DEPRECATED
#    define WRAPLANDCLIENT_NO_DEPRECATED
#  endif
#endif

#define WRAPLANDCLIENT_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(WRAPLANDCLIENT_NO_DEPRECATED) && !defined(WRAPLANDCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define WRAPLANDCLIENT_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define WRAPLANDCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(WRAPLANDCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define WRAPLANDCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(WRAPLANDCLIENT_NO_DEPRECATED_WARNINGS) && !defined(WRAPLANDCLIENT_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define WRAPLANDCLIENT_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define WRAPLANDCLIENT_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(WRAPLANDCLIENT_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define WRAPLANDCLIENT_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(WRAPLANDCLIENT_NO_DEPRECATED)
#  undef WRAPLANDCLIENT_DEPRECATED
#  define WRAPLANDCLIENT_DEPRECATED_EXPORT WRAPLANDCLIENT_EXPORT
#  define WRAPLANDCLIENT_DEPRECATED_NO_EXPORT WRAPLANDCLIENT_NO_EXPORT
#elif defined(WRAPLANDCLIENT_NO_DEPRECATED_WARNINGS)
#  define WRAPLANDCLIENT_DEPRECATED
#  define WRAPLANDCLIENT_DEPRECATED_EXPORT WRAPLANDCLIENT_EXPORT
#  define WRAPLANDCLIENT_DEPRECATED_NO_EXPORT WRAPLANDCLIENT_NO_EXPORT
#else
#  define WRAPLANDCLIENT_DEPRECATED WRAPLANDCLIENT_DECL_DEPRECATED
#  define WRAPLANDCLIENT_DEPRECATED_EXPORT WRAPLANDCLIENT_DECL_DEPRECATED_EXPORT
#  define WRAPLANDCLIENT_DEPRECATED_NO_EXPORT WRAPLANDCLIENT_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define WRAPLANDCLIENT_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define WRAPLANDCLIENT_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef WRAPLANDCLIENT_NO_DEPRECATED
#  define WRAPLANDCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT 0x20f00
#endif
#ifdef WRAPLANDCLIENT_NO_DEPRECATED_WARNINGS
#  define WRAPLANDCLIENT_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef WRAPLANDCLIENT_DEPRECATED_WARNINGS_SINCE
#  ifdef WRAPLANDCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define WRAPLANDCLIENT_DEPRECATED_WARNINGS_SINCE WRAPLANDCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define WRAPLANDCLIENT_DEPRECATED_WARNINGS_SINCE 0x20f00
#  endif
#endif

#ifndef WRAPLANDCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define WRAPLANDCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT 0x0
#endif

#ifdef WRAPLANDCLIENT_DEPRECATED
#  define WRAPLANDCLIENT_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > WRAPLANDCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define WRAPLANDCLIENT_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* WRAPLANDCLIENT_EXPORT_H */
