import events from "node:events";
import type { Backup } from "../../../models";
import type { NetworkOptions, SerialPortOptions } from "../../tstype";
import { type ApsDataRequest, type ApsRequest, NetworkState, ParamId, type ReceivedDataResponse, type Request } from "./constants";
export declare const busyQueue: Array<Request>;
export declare const apsBusyQueue: Array<ApsRequest>;
declare class Driver extends events.EventEmitter {
    private serialPort?;
    private serialPortOptions;
    private writer;
    private parser;
    private frameParserEvent;
    private seqNumber;
    private deviceStatus;
    private configChanged;
    private socketPort?;
    private timeoutCounter;
    private watchdogTriggeredTime;
    private lastFirmwareRxTime;
    private tickTimer;
    private driverStateStart;
    private driverState;
    private firmwareLog;
    private transactionID;
    private txState;
    private txCommand;
    private txSeq;
    private txTime;
    private networkOptions;
    private backup;
    private configMatchesBackup;
    private configIsNewNetwork;
    restoredFromBackup: boolean;
    paramMacAddress: bigint;
    paramTcAddress: bigint;
    paramFirmwareVersion: number;
    paramCurrentChannel: number;
    paramNwkPanid: number;
    paramNwkKey: Buffer<ArrayBuffer>;
    paramNwkUpdateId: number;
    paramChannelMask: number;
    paramProtocolVersion: number;
    paramFrameCounter: number;
    paramApsUseExtPanid: bigint;
    constructor(serialPortOptions: SerialPortOptions, networkOptions: NetworkOptions, backup: Backup | undefined, firmwareLog: string[]);
    cleanupAllQueues(): void;
    started(): boolean;
    protected intervals: NodeJS.Timeout[];
    protected registerInterval(interval: NodeJS.Timeout): void;
    protected catchPromise<T>(val: Promise<T>): Promise<undefined | Awaited<T>>;
    nextTransactionID(): number;
    private tick;
    private emitStateEvent;
    private needWatchdogReset;
    private resetWatchdog;
    private handleFirmwareEvent;
    private handleConnectedStateEvent;
    private handleConnectingStateEvent;
    private isNetworkConfigurationValid;
    private reconfigureNetwork;
    private handleReadConfigurationStateEvent;
    private handleReconfigureStateEvent;
    private handleWaitToReconnectStateEvent;
    private handleCloseAndRestartStateEvent;
    private handleApsQueueOnDeviceState;
    private handleStateEvent;
    private onPortClose;
    private onPortError;
    private isOpen;
    openSerialPort(baudrate: number): Promise<void>;
    private openSocketPort;
    close(): Promise<void>;
    readParameterRequest(parameterId: ParamId, parameter?: Buffer | undefined): Promise<unknown>;
    writeParameterRequest(parameterId: ParamId, parameter: Buffer | number | bigint): Promise<void>;
    private sendChangeChannelRequest;
    writeLinkKey(ieeeAddress: string, hashedKey: Buffer): Promise<void>;
    readFirmwareVersionRequest(): Promise<number>;
    readDeviceStatusRequest(): Promise<number>;
    private sendReadParameterRequest;
    private sendWriteParameterRequest;
    private sendReadFirmwareVersionRequest;
    private sendReadDeviceStateRequest;
    private sendRequest;
    private processQueue;
    private processBusyQueueTimeouts;
    changeNetworkStateRequest(networkState: NetworkState): Promise<void>;
    private sendChangeNetworkStateRequest;
    private checkDeviceStatus;
    enqueueApsDataRequest(request: ApsDataRequest): Promise<undefined | ReceivedDataResponse>;
    private processApsQueue;
    private sendReadApsConfirmRequest;
    private sendReadApsIndicationRequest;
    private sendEnqueueApsDataRequest;
    private processApsBusyQueueTimeouts;
    private calcCrc;
    macAddrStringToArray(addr: string): Array<number>;
    macAddrArrayToString(addr: Array<number>): string;
    /**
     *  generalArrayToString result is not reversed!
     */
    generalArrayToString(key: Array<number>, length: number): string;
    private nextSeqNumber;
    private onParsed;
    private sleep;
}
export default Driver;
//# sourceMappingURL=driver.d.ts.map