﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/servicecatalog/ServiceCatalog_EXPORTS.h>
#include <aws/servicecatalog/model/LaunchPathSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ServiceCatalog {
namespace Model {
class ListLaunchPathsResult {
 public:
  AWS_SERVICECATALOG_API ListLaunchPathsResult() = default;
  AWS_SERVICECATALOG_API ListLaunchPathsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SERVICECATALOG_API ListLaunchPathsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Information about the launch path.</p>
   */
  inline const Aws::Vector<LaunchPathSummary>& GetLaunchPathSummaries() const { return m_launchPathSummaries; }
  template <typename LaunchPathSummariesT = Aws::Vector<LaunchPathSummary>>
  void SetLaunchPathSummaries(LaunchPathSummariesT&& value) {
    m_launchPathSummariesHasBeenSet = true;
    m_launchPathSummaries = std::forward<LaunchPathSummariesT>(value);
  }
  template <typename LaunchPathSummariesT = Aws::Vector<LaunchPathSummary>>
  ListLaunchPathsResult& WithLaunchPathSummaries(LaunchPathSummariesT&& value) {
    SetLaunchPathSummaries(std::forward<LaunchPathSummariesT>(value));
    return *this;
  }
  template <typename LaunchPathSummariesT = LaunchPathSummary>
  ListLaunchPathsResult& AddLaunchPathSummaries(LaunchPathSummariesT&& value) {
    m_launchPathSummariesHasBeenSet = true;
    m_launchPathSummaries.emplace_back(std::forward<LaunchPathSummariesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The page token to use to retrieve the next set of results. If there are no
   * additional results, this value is null.</p>
   */
  inline const Aws::String& GetNextPageToken() const { return m_nextPageToken; }
  template <typename NextPageTokenT = Aws::String>
  void SetNextPageToken(NextPageTokenT&& value) {
    m_nextPageTokenHasBeenSet = true;
    m_nextPageToken = std::forward<NextPageTokenT>(value);
  }
  template <typename NextPageTokenT = Aws::String>
  ListLaunchPathsResult& WithNextPageToken(NextPageTokenT&& value) {
    SetNextPageToken(std::forward<NextPageTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListLaunchPathsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<LaunchPathSummary> m_launchPathSummaries;

  Aws::String m_nextPageToken;

  Aws::String m_requestId;
  bool m_launchPathSummariesHasBeenSet = false;
  bool m_nextPageTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ServiceCatalog
}  // namespace Aws
