﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appstream/AppStreamRequest.h>
#include <aws/appstream/AppStream_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace AppStream {
namespace Model {

/**
 */
class CreateImageBuilderStreamingURLRequest : public AppStreamRequest {
 public:
  AWS_APPSTREAM_API CreateImageBuilderStreamingURLRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CreateImageBuilderStreamingURL"; }

  AWS_APPSTREAM_API Aws::String SerializePayload() const override;

  AWS_APPSTREAM_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The name of the image builder.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  CreateImageBuilderStreamingURLRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time that the streaming URL will be valid, in seconds. Specify a value
   * between 1 and 604800 seconds. The default is 3600 seconds.</p>
   */
  inline long long GetValidity() const { return m_validity; }
  inline bool ValidityHasBeenSet() const { return m_validityHasBeenSet; }
  inline void SetValidity(long long value) {
    m_validityHasBeenSet = true;
    m_validity = value;
  }
  inline CreateImageBuilderStreamingURLRequest& WithValidity(long long value) {
    SetValidity(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  long long m_validity{0};
  bool m_nameHasBeenSet = false;
  bool m_validityHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppStream
}  // namespace Aws
