﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/autoscaling/AutoScaling_EXPORTS.h>
#include <aws/autoscaling/model/Activity.h>
#include <aws/autoscaling/model/ResponseMetadata.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace AutoScaling {
namespace Model {
class DescribeScalingActivitiesResult {
 public:
  AWS_AUTOSCALING_API DescribeScalingActivitiesResult() = default;
  AWS_AUTOSCALING_API DescribeScalingActivitiesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_AUTOSCALING_API DescribeScalingActivitiesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The scaling activities. Activities are sorted by start time. Activities still
   * in progress are described first.</p>
   */
  inline const Aws::Vector<Activity>& GetActivities() const { return m_activities; }
  template <typename ActivitiesT = Aws::Vector<Activity>>
  void SetActivities(ActivitiesT&& value) {
    m_activitiesHasBeenSet = true;
    m_activities = std::forward<ActivitiesT>(value);
  }
  template <typename ActivitiesT = Aws::Vector<Activity>>
  DescribeScalingActivitiesResult& WithActivities(ActivitiesT&& value) {
    SetActivities(std::forward<ActivitiesT>(value));
    return *this;
  }
  template <typename ActivitiesT = Activity>
  DescribeScalingActivitiesResult& AddActivities(ActivitiesT&& value) {
    m_activitiesHasBeenSet = true;
    m_activities.emplace_back(std::forward<ActivitiesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A string that indicates that the response contains more items than can be
   * returned in a single response. To receive additional items, specify this string
   * for the <code>NextToken</code> value when requesting the next set of items. This
   * value is null when there are no more items to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeScalingActivitiesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeScalingActivitiesResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Activity> m_activities;

  Aws::String m_nextToken;

  ResponseMetadata m_responseMetadata;
  bool m_activitiesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace AutoScaling
}  // namespace Aws
