﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ReservedInstancesConfiguration.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {

/**
 * <p>Describes the modification request/s.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ReservedInstancesModificationResult">AWS
 * API Reference</a></p>
 */
class ReservedInstancesModificationResponse {
 public:
  AWS_EC2_API ReservedInstancesModificationResponse() = default;
  AWS_EC2_API ReservedInstancesModificationResponse(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_EC2_API ReservedInstancesModificationResponse& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_EC2_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_EC2_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The ID for the Reserved Instances that were created as part of the
   * modification request. This field is only available when the modification is
   * fulfilled.</p>
   */
  inline const Aws::String& GetReservedInstancesId() const { return m_reservedInstancesId; }
  inline bool ReservedInstancesIdHasBeenSet() const { return m_reservedInstancesIdHasBeenSet; }
  template <typename ReservedInstancesIdT = Aws::String>
  void SetReservedInstancesId(ReservedInstancesIdT&& value) {
    m_reservedInstancesIdHasBeenSet = true;
    m_reservedInstancesId = std::forward<ReservedInstancesIdT>(value);
  }
  template <typename ReservedInstancesIdT = Aws::String>
  ReservedInstancesModificationResponse& WithReservedInstancesId(ReservedInstancesIdT&& value) {
    SetReservedInstancesId(std::forward<ReservedInstancesIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The target Reserved Instances configurations supplied as part of the
   * modification request.</p>
   */
  inline const ReservedInstancesConfiguration& GetTargetConfiguration() const { return m_targetConfiguration; }
  inline bool TargetConfigurationHasBeenSet() const { return m_targetConfigurationHasBeenSet; }
  template <typename TargetConfigurationT = ReservedInstancesConfiguration>
  void SetTargetConfiguration(TargetConfigurationT&& value) {
    m_targetConfigurationHasBeenSet = true;
    m_targetConfiguration = std::forward<TargetConfigurationT>(value);
  }
  template <typename TargetConfigurationT = ReservedInstancesConfiguration>
  ReservedInstancesModificationResponse& WithTargetConfiguration(TargetConfigurationT&& value) {
    SetTargetConfiguration(std::forward<TargetConfigurationT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_reservedInstancesId;

  ReservedInstancesConfiguration m_targetConfiguration;
  bool m_reservedInstancesIdHasBeenSet = false;
  bool m_targetConfigurationHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
