/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.listener;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;

public final class ChainedRepositoryListener
extends AbstractRepositoryListener {
    private final List<RepositoryListener> listeners = new CopyOnWriteArrayList<RepositoryListener>();

    public static RepositoryListener newInstance(RepositoryListener listener1, RepositoryListener listener2) {
        if (listener1 == null) {
            return listener2;
        }
        if (listener2 == null) {
            return listener1;
        }
        return new ChainedRepositoryListener(listener1, listener2);
    }

    public ChainedRepositoryListener(RepositoryListener ... listeners) {
        if (listeners != null) {
            this.add(Arrays.asList(listeners));
        }
    }

    public ChainedRepositoryListener(Collection<? extends RepositoryListener> listeners) {
        this.add(listeners);
    }

    public void add(Collection<? extends RepositoryListener> listeners) {
        if (listeners != null) {
            for (RepositoryListener repositoryListener : listeners) {
                this.add(repositoryListener);
            }
        }
    }

    public void add(RepositoryListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void remove(RepositoryListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    protected void handleError(RepositoryEvent event2, RepositoryListener listener, RuntimeException error2) {
    }

    @Override
    public void artifactDeployed(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactDeployed(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void artifactDeploying(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactDeploying(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void artifactDescriptorInvalid(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactDescriptorInvalid(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void artifactDescriptorMissing(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactDescriptorMissing(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void artifactDownloaded(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactDownloaded(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void artifactDownloading(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactDownloading(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void artifactInstalled(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactInstalled(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void artifactInstalling(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactInstalling(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void artifactResolved(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactResolved(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void artifactResolving(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.artifactResolving(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void metadataDeployed(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataDeployed(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void metadataDeploying(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataDeploying(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void metadataDownloaded(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataDownloaded(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void metadataDownloading(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataDownloading(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void metadataInstalled(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataInstalled(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void metadataInstalling(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataInstalling(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void metadataInvalid(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataInvalid(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void metadataResolved(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataResolved(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }

    @Override
    public void metadataResolving(RepositoryEvent event2) {
        Objects.requireNonNull(event2, "event cannot be null");
        for (RepositoryListener listener : this.listeners) {
            try {
                listener.metadataResolving(event2);
            }
            catch (RuntimeException e2) {
                this.handleError(event2, listener, e2);
            }
        }
    }
}

