/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.binary.dialogs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ui.editors.binary.HexManager;
import org.jkiss.dbeaver.ui.editors.binary.internal.BinaryEditorMessages;

public class GoToDialog
extends Dialog {
    private static final Pattern patternDecDigits = Pattern.compile("[0-9]+");
    private static final Pattern patternHexDigits = Pattern.compile("[0-9a-fA-F]+");
    private Shell dialogShell = null;
    private Button hexRadioButton = null;
    private Button decRadioButton = null;
    private Button showButton = null;
    private Button gotoButton = null;
    private Composite textComposite = null;
    private Text text = null;
    private Label label = null;
    private Label label2 = null;
    private long finalResult = -1L;
    private long buttonPressed = 0L;
    private boolean lastHexButtonSelected = true;
    private String lastLocationText = "";
    private long limit = -1L;
    private long tempResult = -1L;
    private final SelectionAdapter defaultSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            GoToDialog.this.text.setFocus();
        }
    };

    public GoToDialog(Shell aShell) {
        super(aShell);
    }

    private void createRadixPanel() {
        RowLayout rowLayout1 = new RowLayout();
        rowLayout1.marginTop = 2;
        rowLayout1.marginBottom = 2;
        rowLayout1.type = 512;
        Composite composite = new Composite(this.textComposite, 0);
        composite.setLayout((Layout)rowLayout1);
        SelectionAdapter hexTextSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GoToDialog.this.text.setText(GoToDialog.this.text.getText());
                GoToDialog.this.lastHexButtonSelected = e.widget == GoToDialog.this.hexRadioButton;
            }
        };
        this.hexRadioButton = new Button(composite, 16);
        this.hexRadioButton.setText("Hex");
        this.hexRadioButton.addSelectionListener((SelectionListener)this.defaultSelectionAdapter);
        this.hexRadioButton.addSelectionListener((SelectionListener)hexTextSelectionAdapter);
        this.decRadioButton = new Button(composite, 16);
        this.decRadioButton.setText("Dec");
        this.decRadioButton.addSelectionListener((SelectionListener)this.defaultSelectionAdapter);
        this.decRadioButton.addSelectionListener((SelectionListener)hexTextSelectionAdapter);
    }

    private void saveResultAndClose() {
        this.lastLocationText = this.text.getText();
        this.finalResult = this.tempResult;
        this.dialogShell.close();
    }

    public long getButtonPressed() {
        return this.buttonPressed;
    }

    private void createButtonsPanel() {
        RowLayout rowLayout1 = new RowLayout();
        rowLayout1.type = 512;
        rowLayout1.marginHeight = 10;
        rowLayout1.marginWidth = 10;
        rowLayout1.fill = true;
        Composite composite2 = new Composite((Composite)this.dialogShell, 0);
        FormData formData = new FormData();
        formData.left = new FormAttachment((Control)this.textComposite);
        formData.right = new FormAttachment(100);
        composite2.setLayoutData((Object)formData);
        composite2.setLayout((Layout)rowLayout1);
        this.showButton = new Button(composite2, 0);
        this.showButton.setText(BinaryEditorMessages.dialog_go_to_button_show_location);
        this.showButton.addSelectionListener((SelectionListener)this.defaultSelectionAdapter);
        this.showButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GoToDialog.this.buttonPressed = 1L;
                GoToDialog.this.saveResultAndClose();
            }
        });
        this.gotoButton = new Button(composite2, 0);
        this.gotoButton.setText(BinaryEditorMessages.dialog_go_to_button_go_to_location);
        this.gotoButton.addSelectionListener((SelectionListener)this.defaultSelectionAdapter);
        this.gotoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GoToDialog.this.buttonPressed = 2L;
                GoToDialog.this.saveResultAndClose();
            }
        });
        Button closeButton = new Button(composite2, 0);
        closeButton.setText(BinaryEditorMessages.dialog_go_to_button_close);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GoToDialog.this.dialogShell.close();
            }
        });
        this.dialogShell.setDefaultButton(this.showButton);
    }

    private void createTextPanel() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.textComposite = new Composite((Composite)this.dialogShell, 0);
        this.textComposite.setLayout((Layout)gridLayout);
        this.createRadixPanel();
        this.text = new Text(this.textComposite, 2052);
        this.text.setTextLimit(30);
        int columns = 35;
        GC gc = new GC((Drawable)this.text);
        FontMetrics fm = gc.getFontMetrics();
        int width = columns * fm.getAverageCharWidth();
        gc.dispose();
        this.text.setLayoutData((Object)new GridData(width, -1));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Matcher numberMatcher;
                String newText = GoToDialog.this.text.getText();
                int radix = 10;
                if (GoToDialog.this.hexRadioButton.getSelection()) {
                    numberMatcher = patternHexDigits.matcher(newText);
                    radix = 16;
                } else {
                    numberMatcher = patternDecDigits.matcher(newText);
                }
                GoToDialog.this.tempResult = -1L;
                if (numberMatcher.matches()) {
                    GoToDialog.this.tempResult = Long.parseLong(newText, radix);
                }
                if (GoToDialog.this.tempResult >= 0L && GoToDialog.this.tempResult <= GoToDialog.this.limit) {
                    GoToDialog.this.showButton.setEnabled(true);
                    GoToDialog.this.gotoButton.setEnabled(true);
                    GoToDialog.this.label2.setText("");
                } else {
                    GoToDialog.this.showButton.setEnabled(false);
                    GoToDialog.this.gotoButton.setEnabled(false);
                    if ("".equals(newText)) {
                        GoToDialog.this.label2.setText("");
                    } else if (GoToDialog.this.tempResult < 0L) {
                        GoToDialog.this.label2.setText(BinaryEditorMessages.dialog_go_to_label_not_number);
                    } else {
                        GoToDialog.this.label2.setText(BinaryEditorMessages.dialog_go_to_label_out_of_range);
                    }
                }
            }
        });
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.label);
        this.textComposite.setLayoutData((Object)formData);
    }

    private void createDialogShell() {
        this.dialogShell = new Shell(this.getParent(), 67680);
        this.dialogShell.setText(BinaryEditorMessages.dialog_go_to_title);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 3;
        formLayout.marginWidth = 3;
        this.dialogShell.setLayout((Layout)formLayout);
        this.label = new Label((Composite)this.dialogShell, 0);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100);
        this.label.setLayoutData((Object)formData);
        this.createTextPanel();
        this.createButtonsPanel();
        this.label2 = new Label((Composite)this.dialogShell, 0x1000000);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment(0);
        formData2.right = new FormAttachment(100);
        formData2.top = new FormAttachment((Control)this.textComposite);
        formData2.bottom = new FormAttachment(100, -10);
        this.label2.setLayoutData((Object)formData2);
    }

    public long open(long aLimit) {
        this.limit = aLimit;
        this.finalResult = -1L;
        this.buttonPressed = 0L;
        if (this.dialogShell == null || this.dialogShell.isDisposed()) {
            this.createDialogShell();
        }
        this.dialogShell.pack();
        HexManager.reduceDistance(this.getParent(), this.dialogShell);
        if (this.lastHexButtonSelected) {
            this.hexRadioButton.setSelection(true);
        } else {
            this.decRadioButton.setSelection(true);
        }
        this.label.setText(NLS.bind((String)BinaryEditorMessages.dialog_go_to_label_enter_location_number, (Object)this.limit, (Object)Long.toHexString(this.limit)));
        this.text.setText(this.lastLocationText);
        this.text.selectAll();
        this.text.setFocus();
        this.dialogShell.open();
        Display display = this.getParent().getDisplay();
        while (!this.dialogShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.finalResult;
    }
}

