/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.model;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.erd.ERDAttributeVisibility;
import org.jkiss.dbeaver.model.erd.ERDContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDViewStyle;
import org.jkiss.dbeaver.ui.editors.erd.model.ERDDecorator;
import org.jkiss.dbeaver.ui.editors.erd.part.EntityPart;
import org.jkiss.dbeaver.ui.editors.erd.part.NodePart;
import org.jkiss.dbeaver.ui.editors.erd.part.NotePart;

public interface ERDContainerDecorated
extends ERDContainer {
    @NotNull
    public ERDDecorator getDecorator();

    public ERDAttributeVisibility getAttributeVisibility();

    public boolean hasAttributeStyle(@NotNull ERDViewStyle var1);

    public NodeVisualInfo getVisualInfo(DBSEntity var1, boolean var2);

    public static class NodeVisualInfo {
        public Rectangle initBounds;
        public boolean transparent;
        public Color bgColor;
        public Color fgColor;
        public Font font;
        public int zOrder = 0;
        public int borderWidth = -1;
        public ERDAttributeVisibility attributeVisibility;

        public NodeVisualInfo() {
        }

        private void init(NodePart part) {
            this.initBounds = part.getBounds();
            IFigure figure = part.getFigure();
            if (figure != null) {
                this.transparent = !figure.isOpaque();
                this.bgColor = figure.getBackgroundColor();
                this.fgColor = figure.getForegroundColor();
                this.font = figure.getFont();
            }
        }

        public NodeVisualInfo(EntityPart part) {
            this.init(part);
            NodeVisualInfo visualInfo = part.getDiagram().getVisualInfo((DBSEntity)part.getEntity().getObject());
            if (visualInfo != null) {
                this.zOrder = visualInfo.zOrder;
            }
        }

        public NodeVisualInfo(NotePart part) {
            this.init(part);
            NodeVisualInfo visualInfo = part.getDiagram().getVisualInfo(part.getNote());
            if (visualInfo != null) {
                this.zOrder = visualInfo.zOrder;
            }
        }
    }
}

