/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.base.Objects;
import java.io.Serializable;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.jspecify.annotations.Nullable;

public class DefaultProblemId
extends ProblemId
implements Serializable {
    private final String id;
    private final String displayName;
    private final ProblemGroup parent;

    public DefaultProblemId(String id, String displayName, ProblemGroup parent) {
        this.id = id;
        this.displayName = displayName;
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public ProblemGroup getGroup() {
        return this.parent;
    }

    public String toString() {
        return DefaultProblemId.groupPath(this.getGroup()) + this.getName();
    }

    static String groupPath(@Nullable ProblemGroup group) {
        if (group == null) {
            return "";
        }
        ProblemGroup parent = group.getParent();
        return DefaultProblemId.groupPath(parent) + group.getName() + ":";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass().isAssignableFrom(ProblemId.class)) {
            return false;
        }
        ProblemId that = (ProblemId)o;
        if (!this.id.equals(that.getName())) {
            return false;
        }
        return this.parent.equals(that.getGroup());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.parent});
    }
}

