/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.util.Optional;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.internal.TypeValidationDataSpec;
import org.gradle.internal.reflect.validation.DefaultTypeAwareProblemBuilder;
import org.gradle.internal.reflect.validation.TypeAwareProblemBuilder;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.plugin.use.PluginId;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class ProblemRecordingTypeValidationContext
implements TypeValidationContext {
    private final Class<?> rootType;
    private final Supplier<Optional<PluginId>> pluginId;
    private final InternalProblems problems;

    public ProblemRecordingTypeValidationContext(@Nullable Class<?> rootType, Supplier<Optional<PluginId>> pluginId, InternalProblems problems) {
        this.rootType = rootType;
        this.pluginId = pluginId;
        this.problems = problems;
    }

    @Override
    public void visitTypeProblem(Action<? super TypeAwareProblemBuilder> problemSpec) {
        this.recordProblem(this.getDefaultTypeAwareProblemBuilder(problemSpec).build());
    }

    private Optional<PluginId> pluginId() {
        return this.pluginId.get();
    }

    @Override
    public void visitPropertyProblem(Action<? super TypeAwareProblemBuilder> problemSpec) {
        DefaultTypeAwareProblemBuilder problemBuilder = this.getDefaultTypeAwareProblemBuilder(problemSpec);
        problemBuilder.withAnnotationType(this.rootType);
        this.pluginId().map(PluginId::getId).ifPresent(id -> problemBuilder.additionalDataInternal(TypeValidationDataSpec.class, data -> data.pluginId(id)));
        this.recordProblem(problemBuilder.build());
    }

    private @NonNull DefaultTypeAwareProblemBuilder getDefaultTypeAwareProblemBuilder(Action<? super TypeAwareProblemBuilder> problemSpec) {
        DefaultTypeAwareProblemBuilder problemBuilder = new DefaultTypeAwareProblemBuilder(this.problems.getProblemBuilder());
        problemSpec.execute((Object)problemBuilder);
        return problemBuilder;
    }

    protected abstract void recordProblem(InternalProblem var1);
}

