/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependencies.internal;

import java.io.File;
import java.io.Writer;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.reporting.dependencies.internal.JsonProjectDependencyRenderer;
import org.gradle.api.reporting.dependencies.internal.ProjectPageRenderer;
import org.gradle.api.reporting.dependencies.internal.ProjectsPageRenderer;
import org.gradle.api.tasks.diagnostics.internal.ConfigurationDetails;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.ProjectsWithConfigurations;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;
import org.gradle.reporting.HtmlReportBuilder;
import org.gradle.reporting.HtmlReportRenderer;
import org.gradle.reporting.ReportRenderer;

public class HtmlDependencyReporter
extends ReportRenderer<ProjectsWithConfigurations<ProjectDetails.ProjectNameAndPath, ConfigurationDetails>, File> {
    private File outputDirectory;
    private final JsonProjectDependencyRenderer renderer;

    public HtmlDependencyReporter(VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator, VersionParser versionParser) {
        this.renderer = new JsonProjectDependencyRenderer(versionSelectorScheme, versionComparator, versionParser);
    }

    public void render(final ProjectsWithConfigurations<ProjectDetails.ProjectNameAndPath, ConfigurationDetails> projectsWithConfigurations, File outputDirectory) {
        this.outputDirectory = outputDirectory;
        HtmlReportRenderer renderer = new HtmlReportRenderer();
        renderer.render(projectsWithConfigurations.getProjects(), (ReportRenderer)new ReportRenderer<Set<ProjectDetails.ProjectNameAndPath>, HtmlReportBuilder>(){

            public void render(Set<ProjectDetails.ProjectNameAndPath> model, HtmlReportBuilder builder) {
                Transformer htmlPageScheme = HtmlDependencyReporter.this.projectNamingScheme("html");
                Transformer jsScheme = HtmlDependencyReporter.this.projectNamingScheme("js");
                ProjectPageRenderer projectPageRenderer = new ProjectPageRenderer((Transformer<String, ProjectDetails.ProjectNameAndPath>)jsScheme);
                builder.renderRawHtmlPage("index.html", model, (ReportRenderer)new ProjectsPageRenderer((Transformer<String, ProjectDetails.ProjectNameAndPath>)htmlPageScheme));
                for (ProjectDetails.ProjectNameAndPath project : model) {
                    String jsFileName = (String)jsScheme.transform((Object)project);
                    HtmlDependencyReporter.this.generateJsFile(project, projectsWithConfigurations.getConfigurationsFor(project), jsFileName);
                    String htmlFileName = (String)htmlPageScheme.transform((Object)project);
                    builder.renderRawHtmlPage(htmlFileName, (Object)project, (ReportRenderer)projectPageRenderer);
                }
            }
        }, outputDirectory);
    }

    private void generateJsFile(final ProjectDetails.ProjectNameAndPath project, final Iterable<ConfigurationDetails> configurations, String fileName) {
        final String prefix = "var projectDependencyReport = ";
        File file = new File(this.outputDirectory, fileName);
        IoActions.writeTextFile((File)file, (String)"utf-8", (Action)new ErroringAction<Writer>(){

            protected void doExecute(Writer writer) throws Exception {
                writer.write(prefix);
                HtmlDependencyReporter.this.renderer.render(project, configurations, writer);
                writer.write(";");
            }
        });
    }

    private Transformer<String, ProjectDetails.ProjectNameAndPath> projectNamingScheme(String extension) {
        return project -> this.toFileName((ProjectDetails.ProjectNameAndPath)project, "." + extension);
    }

    private String toFileName(ProjectDetails.ProjectNameAndPath project, String extension) {
        String name = project.getPath();
        if (name.equals(":")) {
            return "root" + extension;
        }
        return "root" + name.replace(":", ".") + extension;
    }
}

