/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.JOptionPane;
import jspecview.api.JSVFileDropper;
import jspecview.common.JSViewer;
import org.jmol.util.Logger;

public class AwtFileDropper
implements JSVFileDropper,
DropTargetListener {
    private JSViewer vwr;
    static int lastSelection = 0;

    @Override
    public AwtFileDropper set(JSViewer viewer) {
        this.vwr = viewer;
        return this;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(dtde.getSourceActions());
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Logger.debug("Drop detected...");
        Transferable t = dtde.getTransferable();
        boolean isAccepted = false;
        boolean doAppend = false;
        if (this.vwr.currentSource != null) {
            Object[] options = new Object[]{"Replace", "Append", "Cancel"};
            int ret = JOptionPane.showOptionDialog(null, "Select an option", "JSpecView File Drop", -1, 3, null, options, options[lastSelection]);
            if (ret < 0 || ret == 2) {
                return;
            }
            lastSelection = ret;
            doAppend = ret == 1;
        }
        String prefix = doAppend ? "" : "close ALL;";
        String postfix = doAppend ? "view all;overlayStacked false" : "overlay ALL";
        String cmd = "LOAD APPEND ";
        String fileToLoad = null;
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            Object o = null;
            try {
                dtde.acceptDrop(3);
                o = t.getTransferData(DataFlavor.javaFileListFlavor);
                isAccepted = true;
            }
            catch (Exception e) {
                Logger.error("transfer failed");
            }
            if (o instanceof List) {
                List list = (List)o;
                dtde.getDropTargetContext().dropComplete(true);
                dtde = null;
                SB sb = new SB();
                sb.append(prefix);
                for (int i = 0; i < list.size(); ++i) {
                    sb.append(cmd + PT.esc(((File)list.get(i)).getAbsolutePath()) + ";");
                }
                sb.append(postfix);
                cmd = sb.toString();
                Logger.info("Drop command = " + cmd);
                this.vwr.runScript(cmd);
                return;
            }
        }
        Logger.debug("browsing supported flavours to find something useful...");
        DataFlavor[] df = t.getTransferDataFlavors();
        if (df == null || df.length == 0) {
            return;
        }
        for (int i = 0; i < df.length; ++i) {
            DataFlavor flavor = df[i];
            Object o = null;
            Logger.info("df " + i + " flavor " + flavor);
            Logger.info("  class: " + flavor.getRepresentationClass().getName());
            Logger.info("  mime : " + flavor.getMimeType());
            if (flavor.getMimeType().startsWith("text/uri-list") && flavor.getRepresentationClass().getName().equals("java.lang.String")) {
                try {
                    if (!isAccepted) {
                        dtde.acceptDrop(3);
                    }
                    isAccepted = true;
                    o = t.getTransferData(flavor);
                }
                catch (Exception e) {
                    Logger.errorEx(null, e);
                }
                if (!(o instanceof String)) continue;
                dtde.getDropTargetContext().dropComplete(true);
                if (Logger.debugging) {
                    Logger.debug("  String: " + o.toString());
                }
                fileToLoad = o.toString();
                break;
            }
            if (!flavor.getMimeType().equals("application/x-java-serialized-object; class=java.lang.String")) continue;
            try {
                if (!isAccepted) {
                    dtde.acceptDrop(3);
                }
                isAccepted = true;
                o = t.getTransferData(df[i]);
            }
            catch (Exception e) {
                Logger.errorEx(null, e);
            }
            if (!(o instanceof String)) continue;
            String content = (String)o;
            dtde.getDropTargetContext().dropComplete(true);
            if (Logger.debugging) {
                Logger.debug("  String: " + content);
            }
            if (!content.startsWith("file:/")) continue;
            fileToLoad = content;
            break;
        }
        if (!isAccepted) {
            dtde.rejectDrop();
        }
        if (fileToLoad != null) {
            cmd = prefix + cmd + PT.esc(fileToLoad) + "\";" + postfix;
            Logger.info("Drop command = " + cmd);
            this.vwr.runScriptNow(cmd);
        }
    }
}

