/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.PathResourceManager;
import java.io.File;

public class FileResourceManager
extends PathResourceManager {
    public FileResourceManager(File base) {
        this(base, 1024L, true, false, null);
    }

    public FileResourceManager(File base, long transferMinSize) {
        this(base, transferMinSize, true, false, null);
    }

    public FileResourceManager(File base, long transferMinSize, boolean caseSensitive) {
        this(base, transferMinSize, caseSensitive, false, null);
    }

    public FileResourceManager(File base, long transferMinSize, boolean followLinks, String ... safePaths) {
        this(base, transferMinSize, true, followLinks, safePaths);
    }

    protected FileResourceManager(long transferMinSize, boolean caseSensitive, boolean followLinks, String ... safePaths) {
        super(transferMinSize, caseSensitive, followLinks, safePaths);
    }

    public FileResourceManager(File base, long transferMinSize, boolean caseSensitive, boolean followLinks, String ... safePaths) {
        super(base.toPath(), transferMinSize, caseSensitive, followLinks, safePaths);
    }

    public File getBase() {
        return new File(this.base);
    }

    @Override
    public FileResourceManager setBase(File base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        Object basePath = base.getAbsolutePath();
        if (!((String)basePath).endsWith("/")) {
            basePath = (String)basePath + "/";
        }
        this.base = basePath;
        return this;
    }
}

