/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.dom.saml.v2.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.EncryptedAssertionType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;

public class ResponseType
extends StatusResponseType {
    protected List<RTChoiceType> assertions = new ArrayList<RTChoiceType>();

    public ResponseType(String id, XMLGregorianCalendar issueInstant) {
        super(id, issueInstant);
    }

    public ResponseType(StatusResponseType srt) {
        super(srt);
    }

    public void addAssertion(RTChoiceType choice) {
        this.assertions.add(choice);
    }

    public void removeAssertion(RTChoiceType choice) {
        this.assertions.remove(choice);
    }

    public void replaceAssertion(String id, RTChoiceType newAssertion) {
        int index = 0;
        if (id != null && !id.isEmpty()) {
            for (RTChoiceType assertion : this.assertions) {
                if (assertion.getID().equals(id)) break;
                ++index;
            }
        }
        this.assertions.remove(index);
        this.assertions.add(index, newAssertion);
    }

    public List<RTChoiceType> getAssertions() {
        return Collections.unmodifiableList(this.assertions);
    }

    public static class RTChoiceType {
        private AssertionType assertion;
        private EncryptedAssertionType encryptedAssertion;
        private String id;

        public RTChoiceType(AssertionType assertion) {
            this.assertion = assertion;
            this.id = assertion.getID();
        }

        public RTChoiceType(EncryptedAssertionType encryptedAssertion) {
            this.encryptedAssertion = encryptedAssertion;
        }

        public AssertionType getAssertion() {
            return this.assertion;
        }

        public EncryptedAssertionType getEncryptedAssertion() {
            return this.encryptedAssertion;
        }

        public String getID() {
            return this.id;
        }
    }
}

