/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.spi.runtime;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractSecurityEvent
implements SecurityEvent {
    protected final SecurityIdentity securityIdentity;
    protected final Map<String, Object> eventProperties;

    protected AbstractSecurityEvent(SecurityIdentity securityIdentity, Map<String, Object> eventProperties) {
        this.securityIdentity = securityIdentity;
        this.eventProperties = eventProperties == null ? Map.of() : Map.copyOf(eventProperties);
    }

    @Override
    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    @Override
    public Map<String, Object> getEventProperties() {
        return this.eventProperties;
    }

    protected static String toString(MethodDescription methodDescription) {
        Objects.requireNonNull(methodDescription);
        return methodDescription.getClassName() + "#" + methodDescription.getMethodName();
    }

    protected static Map<String, Object> withProperties(String propertyKey, Object propertyValue, Map<String, Object> additionalProperties) {
        HashMap result;
        if (additionalProperties instanceof HashMap) {
            HashMap additionalPropertiesHashMap;
            result = additionalPropertiesHashMap = (HashMap)additionalProperties;
        } else {
            result = new HashMap();
            if (additionalProperties != null && !additionalProperties.isEmpty()) {
                result.putAll(additionalProperties);
            }
        }
        if (propertyValue != null) {
            result.put(propertyKey, propertyValue);
        }
        return result;
    }
}

