/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan.remote;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.Marshaller;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.infinispan.TaskCallback;
import org.keycloak.cluster.infinispan.WrapperClusterEvent;
import org.keycloak.common.util.ConcurrentMultivaluedHashMap;
import org.keycloak.common.util.Retry;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.connections.infinispan.NodeInfo;

@ClientListener(converterFactoryName="___eager-key-value-version-converter", useRawData=true)
public class RemoteInfinispanNotificationManager {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private final ConcurrentMap<String, TaskCallback> taskCallbacks = new ConcurrentHashMap<String, TaskCallback>();
    private final ConcurrentMultivaluedHashMap<String, ClusterListener> listeners = new ConcurrentMultivaluedHashMap();
    private final Executor executor;
    private final RemoteCache<String, Object> workCache;
    private final NodeInfo nodeInfo;
    private final Marshaller marshaller;

    public RemoteInfinispanNotificationManager(Executor executor, RemoteCache<String, Object> workCache, NodeInfo nodeInfo) {
        this.executor = executor;
        this.workCache = workCache;
        this.nodeInfo = nodeInfo;
        this.marshaller = workCache.getRemoteCacheContainer().getMarshaller();
    }

    public void addClientListener() {
        this.workCache.addClientListener((Object)this);
    }

    public void removeClientListener() {
        if (this.workCache.getRemoteCacheContainer().isStarted()) {
            this.workCache.removeClientListener((Object)this);
        }
    }

    public void registerListener(String taskKey, ClusterListener task) {
        this.listeners.add((Object)taskKey, (Object)task);
    }

    public TaskCallback registerTaskCallback(String taskKey, TaskCallback callback) {
        TaskCallback existing = this.taskCallbacks.putIfAbsent(taskKey, callback);
        return existing != null ? existing : callback;
    }

    public void notify(String taskKey, Collection<? extends ClusterEvent> events, boolean ignoreSender, ClusterProvider.DCNotify dcNotify) {
        if (events == null || events.isEmpty()) {
            return;
        }
        WrapperClusterEvent wrappedEvent = WrapperClusterEvent.wrap(taskKey, events, this.nodeInfo.nodeName(), this.nodeInfo.siteName(), dcNotify, ignoreSender);
        String eventKey = SecretGenerator.getInstance().generateSecureID();
        if (logger.isTraceEnabled()) {
            logger.tracef("Sending event with key %s: %s", (Object)eventKey, events);
        }
        Retry.executeWithBackoff(iteration -> {
            try {
                this.workCache.put((Object)eventKey, (Object)wrappedEvent, 120L, TimeUnit.SECONDS);
            }
            catch (HotRodClientException re) {
                if (logger.isDebugEnabled()) {
                    logger.debugf((Throwable)re, "Failed sending notification to remote cache '%s'. Key: '%s', iteration '%s'. Will try to retry the task", (Object)this.workCache.getName(), (Object)eventKey, (Object)iteration);
                }
                throw re;
            }
        }, (int)10, (int)10);
    }

    public String getMyNodeName() {
        return this.nodeInfo.nodeName();
    }

    @ClientCacheEntryCreated
    @ClientCacheEntryModified
    public void onEntryUpdated(ClientCacheEntryCustomEvent<byte[]> event) {
        try {
            byte[] data = (byte[])event.getEventData();
            ByteBuffer buffer = ByteBuffer.wrap(data);
            int length = UnsignedNumeric.readUnsignedInt((ByteBuffer)buffer);
            String key = (String)this.marshaller.objectFromByteBuffer(data, buffer.position(), length);
            buffer.position(buffer.position() + length);
            length = UnsignedNumeric.readUnsignedInt((ByteBuffer)buffer);
            Object value = this.marshaller.objectFromByteBuffer(data, buffer.position(), length);
            this.executor.execute(() -> this.eventReceived(key, value));
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error((Object)"Unexpected error handling an update/create event from Infinispan cluster", (Throwable)e);
        }
    }

    @ClientCacheEntryRemoved
    public void onEntryRemoved(ClientCacheEntryCustomEvent<byte[]> event) {
        try {
            byte[] data = (byte[])event.getEventData();
            ByteBuffer buffer = ByteBuffer.wrap(data);
            int length = UnsignedNumeric.readUnsignedInt((ByteBuffer)buffer);
            this.taskFinished((String)this.marshaller.objectFromByteBuffer(data, buffer.position(), length));
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error((Object)"Unexpected error handling a remove event from Infinispan cluster", (Throwable)e);
        }
    }

    private void eventReceived(String key, Object obj) {
        List myListeners;
        if (!(obj instanceof WrapperClusterEvent)) {
            if (obj == null && !key.startsWith("task::")) {
                logger.warnf("Event object wasn't available in remote cache after event was received. Event key: %s", (Object)key);
            }
            return;
        }
        WrapperClusterEvent event = (WrapperClusterEvent)obj;
        if (event.rejectEvent(this.nodeInfo.nodeName(), this.nodeInfo.siteName())) {
            return;
        }
        String eventKey = event.getEventKey();
        if (logger.isTraceEnabled()) {
            logger.tracef("Received event: %s", (Object)event);
        }
        if ((myListeners = (List)this.listeners.get((Object)eventKey)) != null) {
            for (ClusterEvent clusterEvent : event.getDelegateEvents()) {
                myListeners.forEach(clusterEvent);
            }
        }
    }

    private void taskFinished(String taskKey) {
        TaskCallback callback = (TaskCallback)this.taskCallbacks.remove(taskKey);
        if (callback == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debugf("Finished task '%s' with '%b'", (Object)taskKey, (Object)true);
        }
        callback.setSuccess(true);
        callback.getTaskCompletedLatch().countDown();
    }
}

