/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.device;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.cache.LocalCache;
import org.keycloak.cache.LocalCacheConfiguration;
import org.keycloak.cache.LocalCacheProvider;
import org.keycloak.device.DeviceRepresentationProvider;
import org.keycloak.device.DeviceRepresentationProviderFactory;
import org.keycloak.device.DeviceRepresentationProviderImpl;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import ua_parser.Client;
import ua_parser.Parser;

public class DeviceRepresentationProviderFactoryImpl
implements DeviceRepresentationProviderFactory {
    private static final Parser UA_PARSER = new Parser();
    private static final String CACHE_SIZE = "cacheSize";
    private static final int DEFAULT_CACHE_SIZE = 2048;
    public static final String PROVIDER_ID = "deviceRepresentation";
    private LocalCacheConfiguration<String, Client> cacheConfig;
    private LocalCache<String, Client> cache;

    public String getId() {
        return PROVIDER_ID;
    }

    public void init(Config.Scope config) {
        this.cacheConfig = LocalCacheConfiguration.builder().name("userAgent").maxSize(config.getInt(CACHE_SIZE, Integer.valueOf(2048)).intValue()).loader(arg_0 -> ((Parser)UA_PARSER).parse(arg_0)).build();
    }

    public void postInit(KeycloakSessionFactory factory) {
        try (KeycloakSession session = factory.create();){
            this.cache = ((LocalCacheProvider)session.getProvider(LocalCacheProvider.class)).create(this.cacheConfig);
            this.cacheConfig = null;
        }
    }

    public DeviceRepresentationProvider create(KeycloakSession session) {
        return new DeviceRepresentationProviderImpl(session, this.cache);
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name(CACHE_SIZE).type("Integer").helpText("Sets the maximum number of parsed user-agent values in the local cache.").defaultValue((Object)2048).add().build();
    }

    public void close() {
        if (this.cache != null) {
            this.cache.close();
            this.cache = null;
        }
    }
}

