/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import jakarta.persistence.AccessType;
import java.util.EnumSet;
import java.util.function.Supplier;
import org.hibernate.annotations.CascadeType;
import org.hibernate.boot.models.xml.spi.PersistenceUnitMetadata;
import org.hibernate.boot.spi.EffectiveMappingDefaults;
import org.hibernate.boot.spi.MappingDefaults;
import org.hibernate.internal.util.NullnessHelper;

public class RootMappingDefaults
implements EffectiveMappingDefaults {
    private final String catalog;
    private final String schema;
    private final boolean quoteIdentifiers;
    private final String packageName;
    private final boolean autoImport;
    private final EnumSet<CascadeType> cascadeTypes;
    private final AccessType propertyAccessType;
    private final String propertyAccessStrategyName;
    private final org.hibernate.cache.spi.access.AccessType cacheAccessType;
    private final boolean entityLaziness;
    private final boolean collectionLaziness;
    private final String idColumnName;
    private final String discriminatorColumnName;
    private final String tenantIdColumnName;

    public RootMappingDefaults(MappingDefaults mappingDefaults, PersistenceUnitMetadata persistenceUnitMetadata) {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = mappingDefaults::getImplicitCatalogName;
        supplierArray[1] = persistenceUnitMetadata::getDefaultCatalog;
        this.catalog = (String)NullnessHelper.coalesceSuppliedValues(supplierArray);
        Supplier[] supplierArray2 = new Supplier[2];
        supplierArray2[0] = mappingDefaults::getImplicitSchemaName;
        supplierArray2[1] = persistenceUnitMetadata::getDefaultSchema;
        this.schema = (String)NullnessHelper.coalesceSuppliedValues(supplierArray2);
        this.quoteIdentifiers = mappingDefaults.shouldImplicitlyQuoteIdentifiers() || persistenceUnitMetadata.useQuotedIdentifiers();
        this.packageName = mappingDefaults.getImplicitPackageName();
        this.autoImport = mappingDefaults.isAutoImportEnabled();
        this.cascadeTypes = persistenceUnitMetadata.getDefaultCascadeTypes();
        this.propertyAccessType = persistenceUnitMetadata.getAccessType();
        Supplier[] supplierArray3 = new Supplier[2];
        supplierArray3[0] = mappingDefaults::getImplicitPropertyAccessorName;
        supplierArray3[1] = persistenceUnitMetadata::getDefaultAccessStrategyName;
        this.propertyAccessStrategyName = (String)NullnessHelper.coalesceSuppliedValues(supplierArray3);
        this.cacheAccessType = mappingDefaults.getImplicitCacheAccessType();
        this.entityLaziness = mappingDefaults.areEntitiesImplicitlyLazy();
        this.collectionLaziness = mappingDefaults.areCollectionsImplicitlyLazy();
        this.idColumnName = NullnessHelper.coalesce(mappingDefaults.getImplicitIdColumnName(), "id");
        this.discriminatorColumnName = NullnessHelper.coalesce(mappingDefaults.getImplicitDiscriminatorColumnName(), "class");
        this.tenantIdColumnName = NullnessHelper.coalesce(mappingDefaults.getImplicitTenantIdColumnName(), "tenant_id");
    }

    @Override
    public String getDefaultCatalogName() {
        return this.catalog;
    }

    @Override
    public String getDefaultSchemaName() {
        return this.schema;
    }

    @Override
    public boolean isDefaultQuoteIdentifiers() {
        return this.quoteIdentifiers;
    }

    @Override
    public String getDefaultIdColumnName() {
        return this.idColumnName;
    }

    @Override
    public String getDefaultDiscriminatorColumnName() {
        return this.discriminatorColumnName;
    }

    @Override
    public String getDefaultTenantIdColumnName() {
        return this.tenantIdColumnName;
    }

    @Override
    public String getDefaultPackageName() {
        return this.packageName;
    }

    @Override
    public boolean isDefaultAutoImport() {
        return this.autoImport;
    }

    @Override
    public EnumSet<CascadeType> getDefaultCascadeTypes() {
        return this.cascadeTypes;
    }

    @Override
    public AccessType getDefaultPropertyAccessType() {
        return this.propertyAccessType;
    }

    @Override
    public String getDefaultAccessStrategyName() {
        return this.propertyAccessStrategyName;
    }

    @Override
    public boolean isDefaultEntityLaziness() {
        return this.entityLaziness;
    }

    @Override
    public boolean isDefaultCollectionLaziness() {
        return this.collectionLaziness;
    }

    @Override
    public org.hibernate.cache.spi.access.AccessType getDefaultCacheAccessType() {
        return this.cacheAccessType;
    }
}

