/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.jboss.logging.Logger;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.models.sessions.infinispan.entities.SingleUseObjectValueEntity;
import org.keycloak.models.sessions.infinispan.remote.transaction.SingleUseObjectTransaction;

public class RemoteInfinispanSingleUseObjectProvider
implements SingleUseObjectProvider {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    public static final SingleUseObjectValueEntity REVOKED_TOKEN_VALUE = new SingleUseObjectValueEntity(Collections.emptyMap());
    private final SingleUseObjectTransaction transaction;
    private final RevokeTokenConsumer revokeTokenConsumer;

    public RemoteInfinispanSingleUseObjectProvider(SingleUseObjectTransaction transaction, RevokeTokenConsumer revokeTokenConsumer) {
        this.transaction = Objects.requireNonNull(transaction);
        this.revokeTokenConsumer = Objects.requireNonNull(revokeTokenConsumer);
    }

    public void put(String key, long lifespanSeconds, Map<String, String> notes) {
        if (key.endsWith(".revoked")) {
            this.revokeToken(key, lifespanSeconds);
            return;
        }
        this.transaction.put(key, RemoteInfinispanSingleUseObjectProvider.wrap(notes), lifespanSeconds, TimeUnit.SECONDS);
    }

    public Map<String, String> get(String key) {
        return RemoteInfinispanSingleUseObjectProvider.unwrap((SingleUseObjectValueEntity)this.transaction.get(key));
    }

    public Map<String, String> remove(String key) {
        try {
            return RemoteInfinispanSingleUseObjectProvider.unwrap((SingleUseObjectValueEntity)this.withReturnValue().remove((Object)key));
        }
        catch (HotRodClientException re) {
            logger.debugf((Throwable)re, "Failed when removing code %s", (Object)key);
            return null;
        }
    }

    public boolean replace(String key, Map<String, String> notes) {
        return this.withReturnValue().replace((Object)key, (Object)RemoteInfinispanSingleUseObjectProvider.wrap(notes)) != null;
    }

    public boolean putIfAbsent(String key, long lifespanInSeconds) {
        try {
            return this.withReturnValue().putIfAbsent((Object)key, (Object)RemoteInfinispanSingleUseObjectProvider.wrap(null), lifespanInSeconds, TimeUnit.SECONDS) == null;
        }
        catch (HotRodClientException re) {
            logger.debugf((Throwable)re, "Failed when adding token %s", (Object)key);
            return false;
        }
    }

    public boolean contains(String key) {
        return this.transaction.getCache().containsKey((Object)key);
    }

    public void close() {
    }

    private RemoteCache<String, SingleUseObjectValueEntity> withReturnValue() {
        return this.transaction.getCache().withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE});
    }

    private void revokeToken(String key, long lifespanSeconds) {
        this.transaction.put(key, REVOKED_TOKEN_VALUE, lifespanSeconds, TimeUnit.SECONDS);
        String token = key.substring(0, key.length() - ".revoked".length());
        this.revokeTokenConsumer.onTokenRevoke(token, lifespanSeconds);
    }

    private static Map<String, String> unwrap(SingleUseObjectValueEntity entity) {
        return entity == null ? null : entity.getNotes();
    }

    private static SingleUseObjectValueEntity wrap(Map<String, String> notes) {
        return new SingleUseObjectValueEntity(notes);
    }

    public static interface RevokeTokenConsumer {
        public void onTokenRevoke(String var1, long var2);
    }
}

