/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteStreamGobbler
extends Thread {
    InputStream inStream;
    OutputStream outStream;
    int bufferSize = 4096;

    public ByteStreamGobbler(InputStream is, OutputStream out2) {
        this.inStream = new BufferedInputStream(is);
        this.outStream = new BufferedOutputStream(out2);
    }

    public ByteStreamGobbler(String name, InputStream is, OutputStream out2) {
        super(name);
        this.inStream = new BufferedInputStream(is);
        this.outStream = new BufferedOutputStream(out2);
    }

    public ByteStreamGobbler(String name, InputStream is, OutputStream out2, int bufferSize) {
        super(name);
        this.inStream = new BufferedInputStream(is);
        this.outStream = new BufferedOutputStream(out2);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Invalid buffer size " + bufferSize + ": must be larger than 0");
        }
        this.bufferSize = bufferSize;
    }

    public InputStream getInputStream() {
        return this.inStream;
    }

    public OutputStream getOutputStream() {
        return this.outStream;
    }

    public void run() {
        try {
            int bytesRead;
            byte[] b = new byte[this.bufferSize];
            while ((bytesRead = this.inStream.read(b)) >= 0) {
                if (bytesRead <= 0) continue;
                this.outStream.write(b, 0, bytesRead);
            }
            this.inStream.close();
        }
        catch (Exception ex) {
            System.out.println("Problem reading stream :" + this.inStream.getClass().getCanonicalName() + " " + ex);
            ex.printStackTrace();
        }
    }
}

