/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class ThresholdResultRequest
extends ActionRequest
implements ToXContentObject {
    private String adID;
    private String modelID;
    private double rcfScore;

    public ThresholdResultRequest(StreamInput in) throws IOException {
        super(in);
        this.adID = in.readString();
        this.modelID = in.readString();
        this.rcfScore = in.readDouble();
    }

    public ThresholdResultRequest(String adID, String modelID, double rcfScore) {
        this.adID = adID;
        this.modelID = modelID;
        this.rcfScore = rcfScore;
    }

    public double getRCFScore() {
        return this.rcfScore;
    }

    public String getAdID() {
        return this.adID;
    }

    public String getModelID() {
        return this.modelID;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.adID);
        out.writeString(this.modelID);
        out.writeDouble(this.rcfScore);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isEmpty((CharSequence)this.adID)) {
            validationException = ValidateActions.addValidationError((String)"AD ID is missing", validationException);
        }
        if (Strings.isEmpty((CharSequence)this.modelID)) {
            validationException = ValidateActions.addValidationError((String)"Model ID is missing", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("adID", this.adID);
        builder.field("model_id", this.modelID);
        builder.field("rCFScore", this.rcfScore);
        builder.endObject();
        return builder;
    }
}

