/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.summarization;

import com.amazon.randomcutforest.util.Weighted;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface ICluster<R> {
    public void reset();

    public double averageRadius();

    public double extentMeasure();

    public double getWeight();

    public void absorb(ICluster<R> var1, BiFunction<R, R, Double> var2);

    public double distance(R var1, BiFunction<R, R, Double> var2);

    public double distance(ICluster<R> var1, BiFunction<R, R, Double> var2);

    public List<Weighted<R>> getRepresentatives();

    default public R primaryRepresentative(BiFunction<R, R, Double> distance) {
        return (R)this.getRepresentatives().get((int)0).index;
    }

    default public List<Weighted<Integer>> getAssignedPoints() {
        return Collections.emptyList();
    }

    public double recompute(Function<Integer, R> var1, boolean var2, BiFunction<R, R, Double> var3);

    public void addPoint(int var1, float var2, double var3, R var5, BiFunction<R, R, Double> var6);
}

