/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.highlight.batch.processor;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.neuralsearch.highlight.batch.HighlightContext;
import org.opensearch.neuralsearch.highlight.batch.config.HighlightConfig;
import org.opensearch.neuralsearch.highlight.batch.config.HighlightContextBuilder;
import org.opensearch.neuralsearch.highlight.batch.utils.HighlightResultApplier;
import org.opensearch.neuralsearch.highlight.utils.HighlightConfigBuilder;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.neuralsearch.processor.highlight.SentenceHighlightingRequest;
import org.opensearch.neuralsearch.processor.util.ProcessorUtils;
import org.opensearch.neuralsearch.stats.events.EventStatName;
import org.opensearch.neuralsearch.stats.events.EventStatsManager;
import org.opensearch.search.SearchHit;
import org.opensearch.search.pipeline.PipelineProcessingContext;
import org.opensearch.search.pipeline.SearchResponseProcessor;
import org.opensearch.search.pipeline.SystemGeneratedProcessor;

public class SemanticHighlightingProcessor
implements SearchResponseProcessor,
SystemGeneratedProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(SemanticHighlightingProcessor.class);
    private final boolean ignoreFailure;
    private final MLCommonsClientAccessor mlClientAccessor;
    private final HighlightContextBuilder contextBuilder;
    private final String tag;
    private final String description;

    public SemanticHighlightingProcessor(boolean ignoreFailure, MLCommonsClientAccessor mlClientAccessor) {
        this.ignoreFailure = ignoreFailure;
        this.mlClientAccessor = mlClientAccessor;
        this.contextBuilder = new HighlightContextBuilder();
        this.tag = "semantic-highlighter";
        this.description = "System-generated semantic highlighting processor";
    }

    public void processResponseAsync(SearchRequest request, SearchResponse response, PipelineProcessingContext responseContext, ActionListener<SearchResponse> responseListener) {
        long startTime = System.currentTimeMillis();
        EventStatsManager.increment(EventStatName.SEMANTIC_HIGHLIGHTING_BATCH_REQUEST_COUNT);
        try {
            HighlightConfig config = HighlightConfigBuilder.buildFromSearchRequest(request, response);
            if (config.getValidationError() != null) {
                log.debug("Configuration extraction/validation failed: {}", (Object)config.getValidationError());
                responseListener.onResponse((Object)response);
                return;
            }
            if (!config.hasRequiredFields()) {
                log.debug("Missing required fields for semantic highlighting");
                responseListener.onResponse((Object)response);
                return;
            }
            if (!config.isBatchInference()) {
                log.debug("Non-batch inference should be handled by SemanticHighlighter directly");
                responseListener.onResponse((Object)response);
                return;
            }
            HighlightConfig enrichedConfig = config.withModelType(FunctionName.REMOTE);
            String batchValidationError = enrichedConfig.validateBatchInference();
            if (batchValidationError != null) {
                responseListener.onFailure((Exception)new IllegalArgumentException(batchValidationError));
                return;
            }
            if (!enrichedConfig.isValid()) {
                responseListener.onFailure((Exception)new IllegalArgumentException(enrichedConfig.getValidationError()));
                return;
            }
            this.executeBatchHighlighting(enrichedConfig, response, startTime, responseListener);
        }
        catch (Exception e) {
            log.error("Error in semantic highlighting processor", (Throwable)e);
            this.handleError(e, response, responseListener);
        }
    }

    private void executeBatchHighlighting(HighlightConfig config, SearchResponse response, long startTime, ActionListener<SearchResponse> responseListener) {
        HighlightContext context = this.contextBuilder.build(config, response, startTime);
        if (context.isEmpty()) {
            log.debug("No valid documents to highlight");
            responseListener.onResponse((Object)response);
            return;
        }
        HighlightResultApplier resultApplier = new HighlightResultApplier(config.getPreTag(), config.getPostTag());
        if (context.getRequests().size() <= config.getMaxBatchSize()) {
            this.processSingleBatch(context, config, resultApplier, responseListener);
        } else {
            this.processMultipleBatches(context, config, resultApplier, responseListener);
        }
    }

    private void processSingleBatch(HighlightContext context, HighlightConfig config, HighlightResultApplier resultApplier, ActionListener<SearchResponse> responseListener) {
        long batchStartTime = System.currentTimeMillis();
        this.mlClientAccessor.batchInferenceSentenceHighlighting(config.getModelId(), context.getRequests(), context.getModelType(), (ActionListener<List<List<Map<String, Object>>>>)ActionListener.wrap(batchResults -> {
            try {
                log.debug("Single batch inference completed: {} documents in {}ms", (Object)context.size(), (Object)(System.currentTimeMillis() - batchStartTime));
                resultApplier.applyBatchResults(context.getValidHits(), (List<List<Map<String, Object>>>)batchResults, context.getFieldName(), context.getPreTag(), context.getPostTag());
                this.completeProcessing(context, responseListener);
            }
            catch (Exception e) {
                this.handleError(e, context.getOriginalResponse(), responseListener);
            }
        }, error -> this.handleError((Exception)error, context.getOriginalResponse(), responseListener)));
    }

    private void processMultipleBatches(HighlightContext context, HighlightConfig config, HighlightResultApplier resultApplier, ActionListener<SearchResponse> responseListener) {
        BatchExecutor executor = new BatchExecutor(context, config, resultApplier, responseListener);
        executor.execute();
    }

    private void completeProcessing(HighlightContext context, ActionListener<SearchResponse> responseListener) {
        long totalTime = System.currentTimeMillis() - context.getStartTime();
        SearchResponse finalResponse = ProcessorUtils.updateResponseTookTime(context.getOriginalResponse(), totalTime);
        responseListener.onResponse((Object)finalResponse);
    }

    private void handleError(Exception e, SearchResponse response, ActionListener<SearchResponse> responseListener) {
        if (this.ignoreFailure) {
            log.warn("Semantic highlighting failed, returning original response", (Throwable)e);
            responseListener.onResponse((Object)response);
        } else {
            responseListener.onFailure(e);
        }
    }

    public SearchResponse processResponse(SearchRequest request, SearchResponse response) {
        throw new UnsupportedOperationException("Semantic highlighting processor requires async processing");
    }

    public String getType() {
        return "semantic_highlighting";
    }

    public String getTag() {
        return this.tag;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    public SystemGeneratedProcessor.ExecutionStage getExecutionStage() {
        return SystemGeneratedProcessor.ExecutionStage.POST_USER_DEFINED;
    }

    private class BatchExecutor {
        private final HighlightContext context;
        private final HighlightConfig config;
        private final HighlightResultApplier resultApplier;
        private final ActionListener<SearchResponse> responseListener;
        private final List<SentenceHighlightingRequest> allRequests;
        private final List<SearchHit> allValidHits;
        private int currentIndex = 0;

        BatchExecutor(HighlightContext context, HighlightConfig config, HighlightResultApplier resultApplier, ActionListener<SearchResponse> responseListener) {
            this.context = context;
            this.config = config;
            this.resultApplier = resultApplier;
            this.responseListener = responseListener;
            this.allRequests = context.getRequests();
            this.allValidHits = context.getValidHits();
        }

        void execute() {
            this.processNextBatch();
        }

        private void processNextBatch() {
            if (this.currentIndex >= this.allRequests.size()) {
                SemanticHighlightingProcessor.this.completeProcessing(this.context, this.responseListener);
                return;
            }
            int startIdx = this.currentIndex;
            int endIdx = Math.min(startIdx + this.config.getMaxBatchSize(), this.allRequests.size());
            int batchNumber = startIdx / this.config.getMaxBatchSize() + 1;
            int totalBatches = (this.allRequests.size() + this.config.getMaxBatchSize() - 1) / this.config.getMaxBatchSize();
            List<SentenceHighlightingRequest> batchRequests = this.allRequests.subList(startIdx, endIdx);
            log.debug("Processing batch {}/{}: documents {}-{}", (Object)batchNumber, (Object)totalBatches, (Object)(startIdx + 1), (Object)endIdx);
            long batchStartTime = System.currentTimeMillis();
            SemanticHighlightingProcessor.this.mlClientAccessor.batchInferenceSentenceHighlighting(this.config.getModelId(), batchRequests, this.context.getModelType(), (ActionListener<List<List<Map<String, Object>>>>)ActionListener.wrap(batchResults -> {
                try {
                    log.debug("Batch {}/{} completed: {} documents in {}ms", (Object)batchNumber, (Object)totalBatches, (Object)batchRequests.size(), (Object)(System.currentTimeMillis() - batchStartTime));
                    this.resultApplier.applyBatchResultsWithIndices(this.allValidHits, (List<List<Map<String, Object>>>)batchResults, startIdx, endIdx, this.context.getFieldName(), this.context.getPreTag(), this.context.getPostTag());
                    this.currentIndex = endIdx;
                    this.processNextBatch();
                }
                catch (Exception e) {
                    SemanticHighlightingProcessor.this.handleError(e, this.context.getOriginalResponse(), this.responseListener);
                }
            }, error -> SemanticHighlightingProcessor.this.handleError((Exception)error, this.context.getOriginalResponse(), this.responseListener)));
        }
    }
}

