/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nio;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import net.sourceforge.plantuml.nio.InputFile;
import net.sourceforge.plantuml.nio.InputFileZip;
import net.sourceforge.plantuml.nio.NFolder;

public final class NFolderZip
implements NFolder {
    private final File zipFile;
    private final Path pathInsideZip;

    public NFolderZip(File zipFile) {
        this(zipFile, Paths.get("", new String[0]));
    }

    private NFolderZip(File zipFile, Path currentPathInsideZip) {
        this.zipFile = Objects.requireNonNull(zipFile);
        this.pathInsideZip = Objects.requireNonNull(currentPathInsideZip).normalize();
    }

    @Override
    public InputFile getInputFile(Path nameOrPath) throws IOException {
        Objects.requireNonNull(nameOrPath);
        String entry = this.toZipEntryName(nameOrPath);
        return new InputFileZip(this.zipFile, entry);
    }

    @Override
    public NFolder getSubfolder(Path nameOrPath) throws IOException {
        Objects.requireNonNull(nameOrPath);
        String entry = this.toZipEntryName(nameOrPath);
        Path next = entry.isEmpty() ? Paths.get("", new String[0]) : Paths.get(entry, new String[0]);
        return new NFolderZip(this.zipFile, next);
    }

    public String toString() {
        String prefix = this.pathInsideZip.toString().replace('\\', '/');
        return this.zipFile.getName() + "!" + prefix;
    }

    private String toZipEntryName(Path child) {
        Path resolved = child.isAbsolute() ? child.normalize() : this.pathInsideZip.resolve(child).normalize();
        String s = resolved.toString().replace('\\', '/');
        while (s.startsWith("/")) {
            s = s.substring(1);
        }
        return s;
    }
}

