# This file has been autogenerated by the pywayland scanner

# Copyright © 2022 Andri Yngvason
# Copyright © 2024 Simon Ser
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlOutput
from .ext_image_capture_source_v1 import ExtImageCaptureSourceV1


class ExtOutputImageCaptureSourceManagerV1(Interface):
    """Image capture source manager for outputs

    A manager for creating image capture source objects for
    :class:`~pywayland.protocol.wayland.WlOutput` objects.
    """

    name = "ext_output_image_capture_source_manager_v1"
    version = 1


class ExtOutputImageCaptureSourceManagerV1Proxy(Proxy[ExtOutputImageCaptureSourceManagerV1]):
    interface = ExtOutputImageCaptureSourceManagerV1

    @ExtOutputImageCaptureSourceManagerV1.request(
        Argument(ArgumentType.NewId, interface=ExtImageCaptureSourceV1),
        Argument(ArgumentType.Object, interface=WlOutput),
    )
    def create_source(self, output: WlOutput) -> Proxy[ExtImageCaptureSourceV1]:
        """Create source object for output

        Creates a source object for an output. Images captured from this source
        will show the same content as the output. Some elements may be omitted,
        such as cursors and overlays that have been marked as transparent to
        capturing.

        :param output:
        :type output:
            :class:`~pywayland.protocol.wayland.WlOutput`
        :returns:
            :class:`~pywayland.protocol.ext_image_capture_source_v1.ExtImageCaptureSourceV1`
        """
        source = self._marshal_constructor(0, ExtImageCaptureSourceV1, output)
        return source

    @ExtOutputImageCaptureSourceManagerV1.request()
    def destroy(self) -> None:
        """Delete this object

        Destroys the manager. This request may be sent at any time by the
        client and objects created by the manager will remain valid after its
        destruction.
        """
        self._marshal(1)
        self._destroy()


class ExtOutputImageCaptureSourceManagerV1Resource(Resource):
    interface = ExtOutputImageCaptureSourceManagerV1


class ExtOutputImageCaptureSourceManagerV1Global(Global):
    interface = ExtOutputImageCaptureSourceManagerV1


ExtOutputImageCaptureSourceManagerV1._gen_c()
ExtOutputImageCaptureSourceManagerV1.proxy_class = ExtOutputImageCaptureSourceManagerV1Proxy
ExtOutputImageCaptureSourceManagerV1.resource_class = ExtOutputImageCaptureSourceManagerV1Resource
ExtOutputImageCaptureSourceManagerV1.global_class = ExtOutputImageCaptureSourceManagerV1Global
