/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bytes;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import java.nio.ByteOrder;

@ExportLibrary.Repeat(value={@ExportLibrary(value=PythonBufferAcquireLibrary.class), @ExportLibrary(value=PythonBufferAccessLibrary.class)})
public abstract class PBytesLike
extends PSequence {
    protected SequenceStorage store;

    public PBytesLike(Object cls, Shape instanceShape, byte[] bytes) {
        super(cls, instanceShape);
        this.store = new ByteSequenceStorage(bytes);
    }

    public PBytesLike(Object cls, Shape instanceShape, SequenceStorage store) {
        super(cls, instanceShape);
        assert (store instanceof ByteSequenceStorage || store instanceof NativeByteSequenceStorage);
        this.store = store;
    }

    @Override
    public final SequenceStorage getSequenceStorage() {
        return this.store;
    }

    @Override
    public void setSequenceStorage(SequenceStorage store) {
        assert (store instanceof ByteSequenceStorage || store instanceof NativeByteSequenceStorage);
        this.store = store;
    }

    @ExportMessage
    boolean hasBuffer() {
        return true;
    }

    @ExportMessage
    Object acquire(int flags) {
        return this;
    }

    @ExportMessage
    boolean isBuffer() {
        return true;
    }

    @ExportMessage
    int getBufferLength(@Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.getBufferLength(this.store);
    }

    @ExportMessage
    boolean hasInternalByteArray(@Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.hasInternalByteArray(this.store);
    }

    @ExportMessage
    byte[] getInternalByteArray(@Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.getInternalByteArray(this.store);
    }

    @ExportMessage
    byte readByte(int byteOffset, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readByte(this.store, byteOffset);
    }

    @ExportMessage
    short readShortByteOrder(int byteOffset, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readShortByteOrder(this.store, byteOffset, byteOrder);
    }

    @ExportMessage
    int readIntByteOrder(int byteOffset, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readIntByteOrder(this.store, byteOffset, byteOrder);
    }

    @ExportMessage
    long readLongByteOrder(int byteOffset, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readLongByteOrder(this.store, byteOffset, byteOrder);
    }

    @ExportMessage
    float readFloatByteOrder(int byteOffset, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readFloatByteOrder(this.store, byteOffset, byteOrder);
    }

    @ExportMessage
    double readDoubleByteOrder(int byteOffset, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readDoubleByteOrder(this.store, byteOffset, byteOrder);
    }

    @ExportMessage
    boolean isNative() {
        return this.store instanceof NativeByteSequenceStorage;
    }

    @ExportMessage
    Object getNativePointer(@Bind Node inliningTarget, @Cached PySequenceArrayWrapper.ToNativeStorageNode toNativeStorageNode) {
        NativeSequenceStorage newStorage = toNativeStorageNode.execute(inliningTarget, this.store, true);
        this.setSequenceStorage(newStorage);
        return newStorage.getPtr();
    }
}

