/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.object;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.List;

public class PythonObject
extends PythonAbstractObject {
    public static final byte CLASS_CHANGED_FLAG = 1;
    public static final byte HAS_SLOTS_BUT_NO_DICT_FLAG = 2;
    public static final byte HAS_NO_VALUE_PROPERTIES = 4;
    public static final byte HAS_MATERIALIZED_DICT = 8;
    public static final byte IS_STATIC_BASE = 16;
    private final Object initialPythonClass;

    public PythonObject(Object pythonClass, Shape instanceShape) {
        super(instanceShape);
        assert (pythonClass != null);
        assert (this.consistentStorage(pythonClass));
        this.initialPythonClass = pythonClass;
    }

    private boolean consistentStorage(Object pythonClass) {
        Object constantClass = HiddenAttr.ReadNode.executeUncached(this, HiddenAttr.CLASS, null);
        if (constantClass == null) {
            return true;
        }
        if (constantClass instanceof PythonBuiltinClass) {
            constantClass = ((PythonBuiltinClass)constantClass).getType();
        }
        if (constantClass instanceof PythonAbstractNativeObject && pythonClass instanceof PythonAbstractNativeObject) {
            return true;
        }
        return constantClass == (pythonClass instanceof PythonBuiltinClass ? ((PythonBuiltinClass)pythonClass).getType() : pythonClass);
    }

    public void setDict(Node inliningTarget, HiddenAttr.WriteNode writeNode, PDict dict) {
        writeNode.execute(inliningTarget, this, HiddenAttr.DICT, dict);
    }

    @NeverDefault
    public Object getInitialPythonClass() {
        return this.initialPythonClass;
    }

    @CompilerDirectives.TruffleBoundary
    public final Object getAttribute(TruffleString key) {
        return DynamicObjectLibrary.getUncached().getOrDefault((DynamicObject)this, (Object)key, (Object)PNone.NO_VALUE);
    }

    @CompilerDirectives.TruffleBoundary
    public void setAttribute(TruffleString name, Object value) {
        CompilerAsserts.neverPartOfCompilation();
        DynamicObjectLibrary.getUncached().put((DynamicObject)this, (Object)name, TruffleStringMigrationHelpers.assertNoJavaString(value));
    }

    @CompilerDirectives.TruffleBoundary
    public List<TruffleString> getAttributeNames() {
        ArrayList<TruffleString> keyList = new ArrayList<TruffleString>();
        for (Object o : this.getShape().getKeyList()) {
            if (!(o instanceof TruffleString) || DynamicObjectLibrary.getUncached().getOrDefault((DynamicObject)this, o, (Object)PNone.NO_VALUE) == PNone.NO_VALUE) continue;
            keyList.add((TruffleString)o);
        }
        return keyList;
    }

    @Override
    public int compareTo(Object o) {
        return this == o ? 0 : 1;
    }

    @Override
    public String toString() {
        String className = "unknown";
        Object storedPythonClass = HiddenAttr.ReadNode.executeUncached(this, HiddenAttr.CLASS, null);
        if (storedPythonClass instanceof PythonManagedClass) {
            className = ((PythonManagedClass)storedPythonClass).getQualName().toJavaStringUncached();
        } else if (storedPythonClass instanceof PythonBuiltinClassType) {
            className = ((PythonBuiltinClassType)((Object)storedPythonClass)).getName().toJavaStringUncached();
        } else if (PGuards.isNativeClass(storedPythonClass)) {
            className = "native";
        }
        return "<" + className + " object at 0x" + Integer.toHexString(this.hashCode()) + ">";
    }

    public static int getCallSiteInlineCacheMaxDepth() {
        return PythonOptions.getCallSiteInlineCacheMaxDepth();
    }
}

