/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.util;

public class ExpandableIntArray {
    private static final int DefaultGrowthIncrement = 100;
    private int[] array = null;
    private int nextEntry = 0;
    private int growthIncrement = 0;

    public ExpandableIntArray(int n2) {
        this.array = new int[n2];
        this.growthIncrement = n2;
    }

    public ExpandableIntArray() {
        this(100);
    }

    public void add(int n2) {
        if (this.nextEntry == this.array.length) {
            this.growArray();
        }
        this.array[this.nextEntry] = n2;
        ++this.nextEntry;
    }

    public int[] toArray() {
        int[] nArray = new int[this.nextEntry];
        if (this.nextEntry > 0) {
            System.arraycopy(this.array, 0, nArray, 0, this.nextEntry);
        }
        return nArray;
    }

    public int get(int n2) {
        if (n2 >= this.nextEntry || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        return this.array[n2];
    }

    public int searchFor(int n2) {
        int n3 = -1;
        for (int i10 = 0; i10 < this.nextEntry && n3 < 0; ++i10) {
            if (this.array[i10] != n2) continue;
            n3 = i10;
        }
        return n3;
    }

    public int size() {
        return this.nextEntry;
    }

    public void set(int n2, int n3) {
        this.array[n2] = n3;
    }

    private void growArray() {
        int[] nArray = new int[this.array.length + this.growthIncrement];
        System.arraycopy(this.array, 0, nArray, 0, this.array.length);
        this.array = nArray;
    }
}

